/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.fleets;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.fleets.PersonalFleetScript;
import com.fs.starfarer.api.impl.campaign.ids.People;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.missions.hub.MissionFleetAutoDespawn;
import com.fs.starfarer.api.loading.VariantSource;
import org.lwjgl.util.vector.Vector2f;

public class PersonalFleetHoracioCaden
extends PersonalFleetScript {
    public PersonalFleetHoracioCaden() {
        super(People.CADEN);
        this.setMinRespawnDelayDays(10.0f);
        this.setMaxRespawnDelayDays(20.0f);
    }

    public CampaignFleetAPI spawnFleet() {
        MarketAPI sindria = Global.getSector().getEconomy().getMarket("sindria");
        FleetCreatorMission m = new FleetCreatorMission(this.random);
        m.beginFleet();
        Vector2f loc = sindria.getLocationInHyperspace();
        m.triggerCreateFleet(HubMissionWithTriggers.FleetSize.HUGE, HubMissionWithTriggers.FleetQuality.VERY_HIGH, "lions_guard", "patrolLarge", loc);
        m.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.MORE, HubMissionWithTriggers.OfficerQuality.DEFAULT);
        m.triggerSetFleetCommander(this.getPerson());
        m.triggerSetFleetFaction("sindrian_diktat");
        m.triggerSetPatrol();
        m.triggerSetFleetMemoryValue("$sourceMarket", sindria);
        m.triggerFleetSetNoFactionInName();
        m.triggerFleetSetName("\u72ee\u5fc3\u536b\u961f\u5927\u65e0\u654c\u8230\u961f");
        m.triggerPatrolAllowTransponderOff();
        m.triggerFleetSetPatrolActionText("parading");
        m.triggerOrderFleetPatrol(sindria.getStarSystem());
        CampaignFleetAPI fleet = m.createFleet();
        fleet.removeScriptsOfClass(MissionFleetAutoDespawn.class);
        sindria.getContainingLocation().addEntity(fleet);
        fleet.setLocation(sindria.getPlanetEntity().getLocation().x, sindria.getPlanetEntity().getLocation().y);
        fleet.setFacing(this.random.nextFloat() * 360.0f);
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            if (!member.isCapital()) continue;
            member.setVariant(member.getVariant().clone(), false, false);
            member.getVariant().setSource(VariantSource.REFIT);
            member.getVariant().addTag("no_autofit");
            member.getVariant().addTag("consistent_weapon_drops");
        }
        return fleet;
    }

    public boolean canSpawnFleetNow() {
        MarketAPI sindria = Global.getSector().getEconomy().getMarket("sindria");
        if (sindria == null || sindria.hasCondition("decivilized")) {
            return false;
        }
        if (!sindria.hasIndustry("lionsguard")) {
            return false;
        }
        return sindria.getFactionId().equals("sindrian_diktat");
    }

    public boolean shouldScriptBeRemoved() {
        return false;
    }
}

