/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.fleets;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.FleetEventListener;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouteManager
implements FleetEventListener {
    public static final String KEY = "$core_routeManager";
    public static float IN_OUT_PHASE_DAYS = 3.0f;
    public static float IN_OUT_PHASE_FRACTION = 0.2f;
    public static float DAYS_SINCE_SEEN_BEFORE_DESPAWN_IF_FAR = 30.0f;
    public static float DAYS_SINCE_SEEN_BEFORE_DESPAWN_IF_CLOSE = 60.0f;
    public static float DESPAWN_DIST_LY_FAR = 4.0f;
    public static float DESPAWN_DIST_LY_CLOSE = 3.0f;
    public static float SPAWN_DIST_LY = 1.6f;
    protected List<RouteData> routes = new ArrayList<RouteData>();
    protected transient Map<String, List<RouteData>> sourceToRoute = new LinkedHashMap<String, List<RouteData>>();
    protected transient Map<LocationAPI, List<RouteData>> routesByLocation = null;

    public static RouteManager getInstance() {
        Object test = Global.getSector().getMemoryWithoutUpdate().get(KEY);
        if (test instanceof RouteManager) {
            return (RouteManager)test;
        }
        RouteManager manager = new RouteManager();
        Global.getSector().getMemoryWithoutUpdate().set(KEY, manager);
        return manager;
    }

    Object readResolve() {
        this.sourceToRoute = new LinkedHashMap<String, List<RouteData>>();
        for (RouteData route : this.routes) {
            this.addToMap(route);
        }
        return this;
    }

    public List<RouteData> getRoutesInLocation(LocationAPI location) {
        List<RouteData> list;
        if (this.routesByLocation == null) {
            this.routesByLocation = new LinkedHashMap<LocationAPI, List<RouteData>>();
            for (RouteData route : this.routes) {
                RouteSegment current = route.current;
                if (current == null) continue;
                LocationAPI loc = null;
                loc = current.from != null && current.to == null ? current.from.getContainingLocation() : (current.from == null && current.to != null ? current.to.getContainingLocation() : (current.from.getContainingLocation() == current.to.getContainingLocation() ? current.from.getContainingLocation() : (current.getLeaveProgress() < 1.0f ? current.from.getContainingLocation() : (current.getTransitProgress() < 1.0f ? Global.getSector().getHyperspace() : current.to.getContainingLocation()))));
                if (loc == null) continue;
                List<RouteData> list2 = this.routesByLocation.get(loc);
                if (list2 == null) {
                    list2 = new ArrayList<RouteData>();
                    this.routesByLocation.put(loc, list2);
                }
                list2.add(route);
            }
        }
        if ((list = this.routesByLocation.get(location)) == null) {
            list = new ArrayList<RouteData>();
        }
        return list;
    }

    public RouteData addRoute(String source, MarketAPI market, Long seed, OptionalFleetData extra, RouteFleetSpawner spawner) {
        return this.addRoute(source, market, seed, extra, spawner, null);
    }

    @Deprecated
    public void removeRote(RouteData route) {
        this.removeRoute(route);
    }

    public void removeRoute(RouteData route) {
        this.routes.remove(route);
        this.removeFromMap(route);
    }

    public RouteData addRoute(String source, MarketAPI market, Long seed, OptionalFleetData extra, RouteFleetSpawner spawner, Object custom) {
        this.routesByLocation = null;
        RouteData route = new RouteData(source, market, seed, extra);
        route.spawner = spawner;
        route.custom = custom;
        route.timestamp = Global.getSector().getClock().getTimestamp();
        this.routes.add(route);
        this.addToMap(route);
        return route;
    }

    public int getNumRoutesFor(String source) {
        if (!this.sourceToRoute.containsKey(source)) {
            return 0;
        }
        return this.sourceToRoute.get(source).size();
    }

    public void addToMap(RouteData route) {
        if (route.source == null) {
            return;
        }
        List<RouteData> forSource = this.getRoutesForSource(route.source);
        forSource.add(route);
    }

    public void removeFromMap(RouteData route) {
        this.routesByLocation = null;
        if (route.source == null) {
            return;
        }
        List<RouteData> forSource = this.getRoutesForSource(route.source);
        forSource.remove(route);
        if (forSource.isEmpty()) {
            this.sourceToRoute.remove(route.source);
        }
    }

    public List<RouteData> getRoutesForSource(String source) {
        List<RouteData> forSource = this.sourceToRoute.get(source);
        if (forSource == null) {
            forSource = new ArrayList<RouteData>();
            this.sourceToRoute.put(source, forSource);
        }
        return forSource;
    }

    public RouteData getRoute(String source, CampaignFleetAPI fleet) {
        List<RouteData> forSource = this.sourceToRoute.get(source);
        if (forSource == null) {
            forSource = new ArrayList<RouteData>();
            this.sourceToRoute.put(source, forSource);
        }
        for (RouteData data : forSource) {
            if (data.activeFleet != fleet) continue;
            return data;
        }
        return null;
    }

    public void advance(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        this.routesByLocation = null;
        this.advanceRoutes(days);
        this.spawnAndDespawn();
    }

    protected void spawnAndDespawn() {
        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        if (player == null) {
            return;
        }
        int add = 0;
        int sub = 0;
        for (RouteData data : new ArrayList<RouteData>(this.routes)) {
            SectorEntityToken.VisibilityLevel level;
            if (data.activeFleet != null && data.activeFleet.getContainingLocation() == player.getContainingLocation() && ((level = data.activeFleet.getVisibilityLevelToPlayerFleet()) == SectorEntityToken.VisibilityLevel.COMPOSITION_AND_FACTION_DETAILS || level == SectorEntityToken.VisibilityLevel.COMPOSITION_DETAILS) && data.activeFleet.wasMousedOverByPlayer().booleanValue()) {
                data.daysSinceSeenByPlayer = 0.0f;
            }
            if (this.shouldDespawn(data)) {
                data.spawner.reportAboutToBeDespawnedByRouteManager(data);
                data.activeFleet.despawn(CampaignEventListener.FleetDespawnReason.PLAYER_FAR_AWAY, null);
                if (data.activeFleet.getContainingLocation() != null) {
                    data.activeFleet.getContainingLocation().removeEntity(data.activeFleet);
                }
                data.activeFleet = null;
                ++sub;
                continue;
            }
            if (!this.shouldSpawn(data)) continue;
            data.activeFleet = data.spawner.spawnFleet(data);
            if (data.activeFleet != null) {
                data.activeFleet.addEventListener(this);
                ++add;
                continue;
            }
            data.expire();
        }
    }

    protected boolean shouldSpawn(RouteData data) {
        CampaignFleetAPI player;
        if (data.delay > 0.0f) {
            return false;
        }
        if (data.activeFleet != null) {
            return false;
        }
        Vector2f interpLoc = data.getInterpolatedHyperLocation();
        float distLY = Misc.getDistanceLY(interpLoc, (player = Global.getSector().getPlayerFleet()).getLocationInHyperspace());
        return distLY < SPAWN_DIST_LY;
    }

    public static boolean isPlayerInSpawnRange(SectorEntityToken from) {
        float distLY = Misc.getDistanceLY(from.getLocationInHyperspace(), Global.getSector().getPlayerFleet().getLocationInHyperspace());
        return distLY < SPAWN_DIST_LY;
    }

    protected boolean shouldDespawn(RouteData data) {
        if (data.activeFleet == null) {
            return false;
        }
        if (data.daysSinceSeenByPlayer < DAYS_SINCE_SEEN_BEFORE_DESPAWN_IF_FAR) {
            return false;
        }
        if (data.activeFleet.getBattle() != null) {
            return false;
        }
        if (data.activeFleet.isNoAutoDespawn().booleanValue()) {
            return false;
        }
        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        float distLY = Misc.getDistanceLY(data.activeFleet.getLocationInHyperspace(), player.getLocationInHyperspace());
        if (distLY > DESPAWN_DIST_LY_FAR) {
            return true;
        }
        return distLY > DESPAWN_DIST_LY_CLOSE && data.daysSinceSeenByPlayer > DAYS_SINCE_SEEN_BEFORE_DESPAWN_IF_CLOSE;
    }

    protected void advanceRoutes(float days) {
        Iterator<RouteData> iter = this.routes.iterator();
        while (iter.hasNext()) {
            boolean delay;
            RouteData route = iter.next();
            boolean bl = delay = route.delay > 0.0f;
            if (delay) {
                route.delay -= days;
                if (route.delay < 0.0f) {
                    route.delay = 0.0f;
                }
                if (route.delay > 0.0f) continue;
                if (route.spawner.shouldCancelRouteAfterDelayCheck(route)) {
                    iter.remove();
                    this.removeFromMap(route);
                    continue;
                }
                route.timestamp = Global.getSector().getClock().getTimestamp();
            }
            if (route.current == null && route.segments.isEmpty()) {
                iter.remove();
                this.removeFromMap(route);
                continue;
            }
            if (route.current == null) {
                route.current = route.segments.get(0);
            }
            route.current.elapsed += days;
            route.daysSinceSeenByPlayer += days;
            route.elapsed += days;
            if (route.getActiveFleet() != null || !(route.current.elapsed >= route.current.daysMax)) continue;
            int index = route.segments.indexOf(route.current);
            if (index < route.segments.size() - 1) {
                route.current = route.segments.get(index + 1);
                continue;
            }
            if (route.spawner.shouldRepeat(route)) {
                route.current = null;
                for (RouteSegment segment : route.segments) {
                    segment.elapsed = 0.0f;
                }
                continue;
            }
            this.removeFromMap(route);
            iter.remove();
        }
    }

    @Override
    public void reportFleetDespawnedToListener(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
        if (reason == CampaignEventListener.FleetDespawnReason.PLAYER_FAR_AWAY) {
            return;
        }
        boolean found = false;
        for (RouteData curr : this.routes) {
            if (curr.activeFleet == null || curr.activeFleet != fleet) continue;
            if (reason == CampaignEventListener.FleetDespawnReason.PLAYER_FAR_AWAY) break;
            this.routes.remove(curr);
            this.removeFromMap(curr);
            found = true;
            break;
        }
    }

    @Override
    public void reportBattleOccurred(CampaignFleetAPI fleet, CampaignFleetAPI primaryWinner, BattleAPI battle) {
    }

    public static class OptionalFleetData {
        public Float strength;
        public Float quality;
        public Float fp;
        public String factionId;
        public String fleetType;
        public Float damage;

        public OptionalFleetData() {
        }

        public OptionalFleetData(MarketAPI market) {
            this(market, market.getFactionId());
        }

        public OptionalFleetData(MarketAPI market, String factionId) {
            this.quality = Float.valueOf(Misc.getShipQuality(market, factionId));
            this.factionId = factionId;
        }

        public float getStrengthModifiedByDamage() {
            if (this.strength == null) {
                return 0.0f;
            }
            float str = this.strength.floatValue();
            if (this.damage != null) {
                str *= Math.max(0.0f, 1.0f - this.damage.floatValue());
            }
            return str;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RouteData {
        protected OptionalFleetData extra = null;
        protected float delay = 0.0f;
        protected String source;
        protected MarketAPI market;
        protected Long seed;
        protected long timestamp;
        protected List<RouteSegment> segments = new ArrayList<RouteSegment>();
        protected CampaignFleetAPI activeFleet = null;
        protected float daysSinceSeenByPlayer = 1000.0f;
        protected float elapsed = 0.0f;
        protected Object custom;
        protected RouteSegment current;
        protected RouteFleetSpawner spawner;

        public RouteData(String source, MarketAPI market, Long seed, OptionalFleetData extra) {
            this.source = source;
            this.market = market;
            this.seed = seed;
            this.extra = extra;
        }

        public OptionalFleetData getExtra() {
            return this.extra;
        }

        public void setExtra(OptionalFleetData extra) {
            this.extra = extra;
        }

        public MarketAPI getMarket() {
            return this.market;
        }

        public void goToAtLeastNext(RouteSegment from) {
            int index = this.segments.indexOf(this.current);
            int indexFrom = this.segments.indexOf(from);
            if (indexFrom < 0) {
                return;
            }
            if (indexFrom < index) {
                return;
            }
            if (indexFrom < this.segments.size() - 1) {
                this.current = this.segments.get(indexFrom + 1);
            } else {
                this.current.elapsed = this.current.daysMax;
            }
        }

        public void expire() {
            if (!this.segments.isEmpty()) {
                this.current = this.segments.get(this.segments.size() - 1);
            }
            if (this.current != null) {
                this.current.elapsed = this.current.daysMax;
            }
        }

        public Random getRandom(int level) {
            if (this.seed == null) {
                return new Random();
            }
            return Misc.getRandom(this.seed, level);
        }

        public String getFactionId() {
            if (this.extra == null || this.extra.factionId == null) {
                if (this.market != null) {
                    return this.market.getFactionId();
                }
                return null;
            }
            return this.extra.factionId;
        }

        public Float getQualityOverride() {
            if (this.extra == null) {
                return null;
            }
            return this.extra.quality;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public Random getRandom() {
            Random random = new Random();
            if (this.getSeed() != null) {
                random = new Random(this.getSeed());
            }
            return random;
        }

        public Long getSeed() {
            return this.seed;
        }

        public RouteSegment addSegment(RouteSegment segment) {
            if (this.segments.isEmpty()) {
                this.current = segment;
            }
            this.segments.add(segment);
            return segment;
        }

        public List<RouteSegment> getSegments() {
            return this.segments;
        }

        public void setCurrent(RouteSegment current) {
            this.current = current;
        }

        public CampaignFleetAPI getActiveFleet() {
            return this.activeFleet;
        }

        public float getDaysSinceSeenByPlayer() {
            return this.daysSinceSeenByPlayer;
        }

        public float getElapsed() {
            return this.elapsed;
        }

        public Object getCustom() {
            return this.custom;
        }

        public RouteSegment getCurrent() {
            return this.current;
        }

        public Integer getCurrentSegmentId() {
            if (this.current == null) {
                return 0;
            }
            return this.current.getId();
        }

        public int getCurrentIndex() {
            return this.segments.indexOf(this.current);
        }

        public RouteFleetSpawner getSpawner() {
            return this.spawner;
        }

        public String getSource() {
            return this.source;
        }

        public Vector2f getInterpolatedHyperLocation() {
            if (this.current == null) {
                return new Vector2f(1.0E8f, 0.0f);
            }
            if (this.current.isInSystem() || this.current.getContainingLocationTo() == null || this.current.to == null) {
                return this.current.from.getLocationInHyperspace();
            }
            float p = this.current.getTransitProgress();
            Vector2f from = this.current.getContainingLocationFrom().getLocation();
            if (this.current.getContainingLocationFrom().isHyperspace()) {
                from = this.current.getFrom().getLocation();
            }
            Vector2f to = this.current.getContainingLocationTo().getLocation();
            if (this.current.getContainingLocationTo().isHyperspace()) {
                to = this.current.to.getLocation();
            }
            Vector2f interpLoc = Misc.interpolateVector(from, to, p);
            return interpLoc;
        }

        public boolean isExpired() {
            return this.segments.indexOf(this.current) == this.segments.size() - 1 && this.current.elapsed >= this.current.daysMax;
        }

        public void setCustom(Object custom) {
            this.custom = custom;
        }

        public float getDelay() {
            return this.delay;
        }

        public void setDelay(float delay) {
            this.delay = delay;
        }
    }

    public static interface RouteFleetSpawner {
        public CampaignFleetAPI spawnFleet(RouteData var1);

        public boolean shouldCancelRouteAfterDelayCheck(RouteData var1);

        public boolean shouldRepeat(RouteData var1);

        public void reportAboutToBeDespawnedByRouteManager(RouteData var1);
    }

    public static class RouteSegment {
        public Integer id;
        public float elapsed = 0.0f;
        public float daysMax;
        public SectorEntityToken from;
        public SectorEntityToken to;
        public Object custom;

        public RouteSegment(Integer id, float daysMax, SectorEntityToken from) {
            this(id, daysMax, from, null, null);
        }

        public RouteSegment(float daysMax, SectorEntityToken from) {
            this(null, daysMax, from, null, null);
        }

        public RouteSegment(Integer id, float daysMax, SectorEntityToken from, Object custom) {
            this(id, daysMax, from, null, custom);
        }

        public RouteSegment(float daysMax, SectorEntityToken from, Object custom) {
            this(null, daysMax, from, null, custom);
        }

        public RouteSegment(Integer id, float daysMax, SectorEntityToken from, SectorEntityToken to) {
            this(id, daysMax, from, to, null);
        }

        public RouteSegment(Integer id, SectorEntityToken from, SectorEntityToken to) {
            this(id, 0.0f, from, to, null);
            if (from.getContainingLocation() != to.getContainingLocation()) {
                float dist = Misc.getDistance(from.getLocationInHyperspace(), to.getLocationInHyperspace());
                this.daysMax = dist / 1500.0f + IN_OUT_PHASE_DAYS * 2.0f;
            } else {
                float dist = Misc.getDistance(from.getLocation(), to.getLocation());
                this.daysMax = dist / 1500.0f;
            }
        }

        public RouteSegment(float daysMax, SectorEntityToken from, SectorEntityToken to) {
            this(null, daysMax, from, to, null);
        }

        public RouteSegment(Integer id, float daysMax, SectorEntityToken from, SectorEntityToken to, Object custom) {
            this.id = id;
            this.daysMax = daysMax;
            this.from = from;
            this.to = to;
            this.custom = custom;
        }

        public LocationAPI getCurrentContainingLocation() {
            LocationAPI loc = null;
            loc = this.from != null && this.to == null ? this.from.getContainingLocation() : (this.from == null && this.to != null ? this.to.getContainingLocation() : (this.from.getContainingLocation() == this.to.getContainingLocation() ? this.from.getContainingLocation() : (this.getLeaveProgress() < 1.0f ? this.from.getContainingLocation() : (this.getTransitProgress() < 1.0f ? Global.getSector().getHyperspace() : this.to.getContainingLocation()))));
            return loc;
        }

        public LocationAPI getContainingLocationFrom() {
            if (this.from == null) {
                return null;
            }
            return this.from.getContainingLocation();
        }

        public LocationAPI getContainingLocationTo() {
            if (this.to == null) {
                return null;
            }
            return this.to.getContainingLocation();
        }

        public boolean isTravel() {
            return this.to != null;
        }

        public boolean isInSystem() {
            if (this.to == null && this.from != null && this.from.getContainingLocation() != null && !this.from.getContainingLocation().isHyperspace()) {
                return true;
            }
            return !this.from.getContainingLocation().isHyperspace() && this.from.getContainingLocation() == this.to.getContainingLocation();
        }

        public boolean isFromSystemCenter() {
            return this.from != null && this.from.getContainingLocation() instanceof StarSystemAPI && ((StarSystemAPI)this.from.getContainingLocation()).getCenter() == this.from;
        }

        public boolean isToSystemCenter() {
            return this.to != null && this.to.getContainingLocation() instanceof StarSystemAPI && ((StarSystemAPI)this.to.getContainingLocation()).getCenter() == this.to;
        }

        public boolean hasLeaveSystemPhase() {
            if (this.isInSystem()) {
                return false;
            }
            if (this.isFromSystemCenter()) {
                return false;
            }
            return this.from == null || !this.from.getContainingLocation().isHyperspace();
        }

        public boolean hasEnterSystemPhase() {
            if (this.isInSystem()) {
                return false;
            }
            if (this.isToSystemCenter()) {
                return false;
            }
            return this.to == null || !this.to.getContainingLocation().isHyperspace();
        }

        public float getProgress() {
            if (this.daysMax <= 0.0f) {
                return 1.0f;
            }
            return this.elapsed / this.daysMax;
        }

        public float getEnterProgress() {
            float dur = Math.min(this.daysMax * IN_OUT_PHASE_FRACTION, IN_OUT_PHASE_DAYS);
            float f = 1.0f - Math.max(0.0f, this.daysMax - this.elapsed) / dur;
            if (f > 1.0f) {
                f = 1.0f;
            }
            if (f < 0.0f) {
                f = 0.0f;
            }
            return f;
        }

        public float getLeaveProgress() {
            float dur = Math.min(this.daysMax * IN_OUT_PHASE_FRACTION, IN_OUT_PHASE_DAYS);
            float f = this.elapsed / dur;
            if (f > 1.0f) {
                f = 1.0f;
            }
            if (f < 0.0f) {
                f = 0.0f;
            }
            return f;
        }

        public float getTransitProgress() {
            float f;
            float dur = Math.min(this.daysMax * IN_OUT_PHASE_FRACTION, IN_OUT_PHASE_DAYS);
            float max = this.daysMax;
            float e = this.elapsed;
            if (this.hasEnterSystemPhase()) {
                max -= dur;
            }
            if (this.hasLeaveSystemPhase()) {
                max -= dur;
                e -= dur;
            }
            if ((f = e / max) > 1.0f) {
                f = 1.0f;
            }
            if (f < 0.0f) {
                f = 0.0f;
            }
            return f;
        }

        public SectorEntityToken getDestination() {
            if (this.to != null) {
                return this.to;
            }
            return this.from;
        }

        public SectorEntityToken getFrom() {
            return this.from;
        }

        public int getId() {
            if (this.id == null) {
                return 0;
            }
            return this.id;
        }
    }
}

