/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.fleets.misc;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.fleets.misc.BaseMiscFleetCreatorPlugin;
import com.fs.starfarer.api.impl.campaign.fleets.misc.MiscFleetRouteManager;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.missions.hub.MissionFleetAutoDespawn;
import com.fs.starfarer.api.impl.campaign.shared.SharedData;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.Random;

public class MiscAcademyFleetCreator
extends BaseMiscFleetCreatorPlugin {
    public static String ACADEMY_FLEET_TYPE = "$academyFleetType";

    public float getFrequency() {
        return Global.getSettings().getFloat("miscFleetAcademyFrequency");
    }

    public int getMaxFleetsForThisCreator() {
        return Global.getSettings().getInt("miscFleetAcademyMaxFleets");
    }

    public static SectorEntityToken getAcademy() {
        StarSystemAPI system = Global.getSector().getStarSystem("Galatia");
        return system.getEntityById("station_galatia_academy");
    }

    public MiscFleetRouteManager.MiscRouteData createRouteParams(MiscFleetRouteManager manager, Random random) {
        MarketAPI from = this.pickSourceMarket(manager);
        SectorEntityToken to = MiscAcademyFleetCreator.getAcademy();
        if (to == null || to.getContainingLocation().hasTag("system_cut_off_from_hyper")) {
            return null;
        }
        MiscFleetRouteManager.MiscRouteData result = this.createData(from, to);
        return result;
    }

    public CampaignFleetAPI createFleet(MiscFleetRouteManager manager, RouteManager.RouteData route, Random random) {
        MiscFleetRouteManager.MiscRouteData data = (MiscFleetRouteManager.MiscRouteData)route.getCustom();
        FleetCreatorMission m = new FleetCreatorMission(random);
        m.beginFleet();
        m.triggerCreateFleet(HubMissionWithTriggers.FleetSize.MEDIUM, HubMissionWithTriggers.FleetQuality.LOWER, data.factionId, "academyFleet", data.from.getLocationInHyperspace());
        m.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.FC_ONLY, HubMissionWithTriggers.OfficerQuality.LOWER);
        m.triggerSetFleetSizeFraction(data.size * 0.5f * (0.5f + random.nextFloat() * 0.5f));
        m.triggerFleetSetNoFactionInName();
        m.triggerSetTraderFleet();
        m.triggerSetFleetComposition(0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        m.triggerSetFleetMemoryValue("$sourceMarket", data.from);
        m.triggerSetFleetMemoryValue("$academyFleet", true);
        WeightedRandomPicker<String> types = new WeightedRandomPicker<String>(random);
        types.add("supplies");
        types.add("students");
        types.add("visitors");
        m.triggerSetFleetMemoryValue(ACADEMY_FLEET_TYPE, types.pick());
        CampaignFleetAPI fleet = m.createFleet();
        fleet.removeScriptsOfClass(MissionFleetAutoDespawn.class);
        return fleet;
    }

    public MiscFleetRouteManager.MiscRouteData createData(MarketAPI from, SectorEntityToken to) {
        MiscFleetRouteManager.MiscRouteData data = new MiscFleetRouteManager.MiscRouteData(this.getId());
        data.from = from;
        data.to = to;
        data.factionId = from.getFaction().isHostileTo("independent") ? from.getFactionId() : "independent";
        data.smuggling = true;
        float sizeBasis = (float)from.getSize() / 8.0f;
        if ((sizeBasis *= 0.25f) < 0.05f) {
            sizeBasis = 0.05f;
        }
        if (sizeBasis > 0.25f) {
            sizeBasis = 0.25f;
        }
        data.size = sizeBasis;
        return data;
    }

    public MarketAPI pickSourceMarket(MiscFleetRouteManager manager) {
        WeightedRandomPicker<MarketAPI> markets = new WeightedRandomPicker<MarketAPI>(manager.getRandom());
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (market.isHidden() || !market.hasSpaceport() || market.getContainingLocation().hasTag("system_cut_off_from_hyper") || manager.getTimeout(this.getId()).contains(market.getId()) || SharedData.getData().getMarketsWithoutTradeFleetSpawn().contains(market.getId())) continue;
            float distLY = Misc.getDistanceToPlayerLY(market.getPrimaryEntity());
            float mult = 1.0f - Math.min(0.99f, distLY / 10.0f);
            if (market.getFaction().isHostileTo("independent")) {
                mult *= 0.2f;
            }
            markets.add(market, (float)market.getSize() * mult);
        }
        return (MarketAPI)markets.pick();
    }

    public void reportBattleOccurred(MiscFleetRouteManager manager, CampaignFleetAPI fleet, CampaignFleetAPI primaryWinner, BattleAPI battle) {
        RouteManager.RouteData route = RouteManager.getInstance().getRoute(manager.getRouteSourceId(), fleet);
        if (route == null || !(route.getCustom() instanceof MiscFleetRouteManager.MiscRouteData)) {
            return;
        }
        if (route.isExpired()) {
            return;
        }
        if (!battle.isPlayerInvolved()) {
            return;
        }
        if (battle.getNonPlayerSideSnapshot().contains(fleet)) {
            MiscFleetRouteManager.MiscRouteData miscRouteData = (MiscFleetRouteManager.MiscRouteData)route.getCustom();
        }
    }

    public String getStartingActionText(CampaignFleetAPI fleet, RouteManager.RouteSegment segment, MiscFleetRouteManager.MiscRouteData data) {
        String type = fleet.getMemoryWithoutUpdate().getString(ACADEMY_FLEET_TYPE);
        return "\u51c6\u5907\u524d\u5f80 Galatia \u5b66\u9662";
    }

    public String getEndingActionText(CampaignFleetAPI fleet, RouteManager.RouteSegment segment, MiscFleetRouteManager.MiscRouteData data) {
        return "\u4ece Galatia \u5b66\u9662\u8fd4\u56de";
    }

    public String getTravelToDestActionText(CampaignFleetAPI fleet, RouteManager.RouteSegment segment, MiscFleetRouteManager.MiscRouteData data) {
        return "\u524d\u5f80 Galatia \u5b66\u9662";
    }

    public String getTravelReturnActionText(CampaignFleetAPI fleet, RouteManager.RouteSegment segment, MiscFleetRouteManager.MiscRouteData data) {
        return "\u524d\u5f80 " + data.from.getName();
    }

    public String getAtDestUnloadActionText(CampaignFleetAPI fleet, RouteManager.RouteSegment segment, MiscFleetRouteManager.MiscRouteData data) {
        return "\u73af\u7ed5\u4e8e Galatia \u5b66\u9662";
    }

    public String getAtDestLoadActionText(CampaignFleetAPI fleet, RouteManager.RouteSegment segment, MiscFleetRouteManager.MiscRouteData data) {
        return "\u73af\u7ed5\u4e8e Galatia \u5b66\u9662";
    }
}

