/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.fleets.misc;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.fleets.misc.BaseMiscFleetCreatorPlugin;
import com.fs.starfarer.api.impl.campaign.fleets.misc.MiscFleetRouteManager;
import com.fs.starfarer.api.impl.campaign.missions.DelayedFleetEncounter;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.missions.hub.MissionFleetAutoDespawn;
import com.fs.starfarer.api.impl.campaign.shared.SharedData;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MiscPilgrimFleetCreator
extends BaseMiscFleetCreatorPlugin {
    public String SHRINE_LIST_KEY = "shrine_list_key";

    @Override
    public float getFrequency() {
        return Global.getSettings().getFloat("miscFleetPilgrimFrequency");
    }

    @Override
    public int getMaxFleetsForThisCreator() {
        return Global.getSettings().getInt("miscFleetPilgrimMaxFleets");
    }

    public List<SectorEntityToken> getShrines(MiscFleetRouteManager manager) {
        List<SectorEntityToken> shrines = (List<SectorEntityToken>)manager.getData().get(this.SHRINE_LIST_KEY);
        if (shrines == null) {
            shrines = Global.getSector().getEntitiesWithTag("luddic_shrine");
            manager.getData().put(this.SHRINE_LIST_KEY, shrines);
        }
        return shrines;
    }

    @Override
    public MiscFleetRouteManager.MiscRouteData createRouteParams(MiscFleetRouteManager manager, Random random) {
        MarketAPI from = this.pickSourceMarket(manager);
        if (from == null) {
            return null;
        }
        SectorEntityToken to = this.pickDestShrine(manager, from);
        if (to == null) {
            return null;
        }
        MiscFleetRouteManager.MiscRouteData result = this.createData(from, to);
        return result;
    }

    @Override
    public CampaignFleetAPI createFleet(MiscFleetRouteManager manager, RouteManager.RouteData route, Random random) {
        MiscFleetRouteManager.MiscRouteData data = (MiscFleetRouteManager.MiscRouteData)route.getCustom();
        FleetCreatorMission m = new FleetCreatorMission(random);
        m.beginFleet();
        m.triggerCreateFleet(HubMissionWithTriggers.FleetSize.MEDIUM, HubMissionWithTriggers.FleetQuality.LOWER, data.factionId, "shrinePilgrims", data.from.getLocationInHyperspace());
        m.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.FC_ONLY, HubMissionWithTriggers.OfficerQuality.LOWER);
        m.triggerSetFleetSizeFraction(data.size * 0.5f * (0.5f + random.nextFloat() * 0.5f));
        m.triggerFleetSetNoFactionInName();
        m.triggerSetTraderFleet();
        m.triggerSetFleetComposition(0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        m.triggerSetFleetMemoryValue("$sourceMarket", data.from);
        m.triggerSetFleetMemoryValue("$destShrine", data.to.getId());
        m.triggerSetFleetMemoryValue("$shrinePilgrimFleet", true);
        CampaignFleetAPI fleet = m.createFleet();
        fleet.removeScriptsOfClass(MissionFleetAutoDespawn.class);
        return fleet;
    }

    public MiscFleetRouteManager.MiscRouteData createData(MarketAPI from, SectorEntityToken to) {
        boolean realMarket;
        MiscFleetRouteManager.MiscRouteData data = new MiscFleetRouteManager.MiscRouteData(this.getId());
        data.from = from;
        data.to = to;
        data.factionId = from.getFaction().isHostileTo("luddic_church") ? "independent" : "luddic_church";
        MarketAPI market = to.getMarket();
        boolean bl = realMarket = market != null && !market.isPlanetConditionMarketOnly();
        if (realMarket && market.getFaction().isHostileTo(from.getFaction()) && market.getFaction().isHostileTo(data.factionId)) {
            data.smuggling = true;
        }
        float sizeBasis = realMarket ? (float)(market.getSize() + from.getSize()) : (float)from.getSize() * 0.5f;
        data.size = sizeBasis / 40.0f;
        return data;
    }

    public MarketAPI pickSourceMarket(MiscFleetRouteManager manager) {
        WeightedRandomPicker<MarketAPI> markets = new WeightedRandomPicker<MarketAPI>(manager.getRandom());
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (market.isHidden() || !market.hasSpaceport() || manager.getTimeout(this.getId()).contains(market.getId()) || market.getContainingLocation().hasTag("system_cut_off_from_hyper") || market.getFaction().isHostileTo("independent") && market.getFaction().isHostileTo("luddic_church") || SharedData.getData().getMarketsWithoutTradeFleetSpawn().contains(market.getId())) continue;
            float distLY = Misc.getDistanceToPlayerLY(market.getPrimaryEntity());
            float mult = 1.0f - Math.min(0.99f, distLY / 10.0f);
            String fid = market.getFactionId();
            if ("luddic_church".equals(fid) || "luddic_path".equals(fid) || "knights_of_ludd".equals(fid)) {
                mult *= 10.0f;
            }
            markets.add(market, (float)market.getSize() * mult);
        }
        return (MarketAPI)markets.pick();
    }

    public SectorEntityToken pickDestShrine(MiscFleetRouteManager manager, MarketAPI from) {
        if (from == null) {
            return null;
        }
        WeightedRandomPicker<SectorEntityToken> picker = new WeightedRandomPicker<SectorEntityToken>(manager.getRandom());
        for (SectorEntityToken shrine : new ArrayList<SectorEntityToken>(this.getShrines(manager))) {
            boolean realMarket;
            if (!shrine.isAlive() || shrine.getContainingLocation().hasTag("system_cut_off_from_hyper")) continue;
            MarketAPI market = shrine.getMarket();
            boolean bl = realMarket = market != null && !market.isPlanetConditionMarketOnly();
            if (realMarket && (market.hasCondition("decivilized") || market.getFaction().isHostileTo("independent") && market.getFaction().isHostileTo("luddic_church"))) continue;
            float mult = 1.0f;
            if (realMarket) {
                mult = 10.0f * (float)market.getSize();
            }
            picker.add(shrine, mult);
        }
        return (SectorEntityToken)picker.pick();
    }

    @Override
    public void reportBattleOccurred(MiscFleetRouteManager manager, CampaignFleetAPI fleet, CampaignFleetAPI primaryWinner, BattleAPI battle) {
        RouteManager.RouteData route = RouteManager.getInstance().getRoute(manager.getRouteSourceId(), fleet);
        if (route == null || !(route.getCustom() instanceof MiscFleetRouteManager.MiscRouteData)) {
            return;
        }
        if (route.isExpired()) {
            return;
        }
        if (!battle.isPlayerInvolved()) {
            return;
        }
        if (battle.getNonPlayerSideSnapshot().contains(fleet)) {
            MiscFleetRouteManager.MiscRouteData data = (MiscFleetRouteManager.MiscRouteData)route.getCustom();
            DelayedFleetEncounter e = new DelayedFleetEncounter(new Random(), "luddicPilgrims");
            e.setDelayShort();
            e.setLocationCoreOnly(true, "luddic_church");
            e.beginCreate();
            e.triggerCreateFleet(HubMissionWithTriggers.FleetSize.MEDIUM, HubMissionWithTriggers.FleetQuality.DEFAULT, "luddic_church", "patrolMedium", new Vector2f());
            e.triggerSetFleetSizeFraction(Math.min(1.0f, data.size * 3.0f));
            e.autoAdjustFleetTypeName();
            e.triggerSetPatrol();
            e.triggerSetStandardAggroInterceptFlags();
            e.triggerSetFleetGenericHailPermanent("PilgrimRevengeHail");
            e.endCreate();
        }
    }

    @Override
    public String getStartingActionText(CampaignFleetAPI fleet, RouteManager.RouteSegment segment, MiscFleetRouteManager.MiscRouteData data) {
        return "\u51c6\u5907\u642d\u8f7d\u524d\u53bb\u5723\u5730\u7684\u671d\u5723\u8005\u4eec\u524d\u5f80 " + data.to.getName();
    }

    @Override
    public String getEndingActionText(CampaignFleetAPI fleet, RouteManager.RouteSegment segment, MiscFleetRouteManager.MiscRouteData data) {
        return "\u6b63\u5728\u8ba9\u671d\u5723\u8005\u4e0b\u8239\u8fd4\u56de " + data.from.getName();
    }

    @Override
    public String getTravelToDestActionText(CampaignFleetAPI fleet, RouteManager.RouteSegment segment, MiscFleetRouteManager.MiscRouteData data) {
        return "\u5c06\u524d\u53bb\u5723\u5730\u7684\u671d\u5723\u8005\u4eec\u8fd0\u5f80 " + data.to.getName();
    }

    @Override
    public String getTravelReturnActionText(CampaignFleetAPI fleet, RouteManager.RouteSegment segment, MiscFleetRouteManager.MiscRouteData data) {
        return "\u6b63\u8f7d\u7740\u671d\u5723\u8005\u4eec\u8fd4\u56de " + data.from.getName();
    }

    @Override
    public String getAtDestUnloadActionText(CampaignFleetAPI fleet, RouteManager.RouteSegment segment, MiscFleetRouteManager.MiscRouteData data) {
        return "\u6b63\u5728\u8ba9\u524d\u53bb\u5723\u5730\u7684\u671d\u5723\u8005\u4eec\u4e0b\u8239\u524d\u5f80 " + data.to.getName();
    }

    @Override
    public String getAtDestLoadActionText(CampaignFleetAPI fleet, RouteManager.RouteSegment segment, MiscFleetRouteManager.MiscRouteData data) {
        return "\u6b63\u5728\u8ba9\u671d\u5723\u8005\u4eec\u4e0a\u8239\u51c6\u5907\u8fd4\u56de " + data.from.getName();
    }
}

