/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.ghosts;

import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.impl.campaign.ghosts.BaseGhostBehavior;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhost;
import com.fs.starfarer.api.util.Misc;
import org.lwjgl.util.vector.Vector2f;

public class GBCircle
extends BaseGhostBehavior {
    protected SectorEntityToken other;
    protected int maxBurn;
    protected float desiredRange;
    protected float circleDir;

    public GBCircle(SectorEntityToken other, float duration, int maxBurn, float desiredRange, float circleDir) {
        super(duration);
        this.other = other;
        this.maxBurn = maxBurn;
        this.desiredRange = desiredRange;
        this.circleDir = circleDir;
    }

    public void advance(float amount, SensorGhost ghost) {
        if (this.other.getContainingLocation() != ghost.getEntity().getContainingLocation() || !this.other.isAlive()) {
            this.end();
            return;
        }
        super.advance(amount, ghost);
        float dist = Misc.getDistance(ghost.getEntity(), this.other) - ghost.getEntity().getRadius() - this.other.getRadius();
        float dirToOther = Misc.getAngleInDegrees(ghost.getEntity().getLocation(), this.other.getLocation());
        float clockwiseDir = dirToOther + 90.0f;
        float bandRadius = this.desiredRange * 0.25f;
        float distOffset = dist - this.desiredRange;
        if (distOffset > bandRadius) {
            distOffset = bandRadius;
        }
        if (distOffset < -bandRadius) {
            distOffset = -bandRadius;
        }
        float angleOffset = distOffset / bandRadius * -60.0f;
        float useCircleDir = this.circleDir;
        if (Misc.isReversePolarity(this.other)) {
            useCircleDir = -useCircleDir;
        }
        if (useCircleDir == 0.0f) {
            float angleDiffCCW;
            float velDir = Misc.getAngleInDegrees(ghost.getEntity().getVelocity());
            float angleDiffCW = Misc.getAngleDiff(dirToOther + 90.0f, velDir);
            useCircleDir = angleDiffCW > (angleDiffCCW = Misc.getAngleDiff(dirToOther - 90.0f, velDir)) ? 1.0f : -1.0f;
        }
        float moveDir = clockwiseDir;
        if (useCircleDir > 0.0f) {
            moveDir += 180.0f;
            angleOffset = -angleOffset;
        }
        moveDir += angleOffset;
        moveDir = Misc.normalizeAngle(moveDir);
        Vector2f dest = Misc.getUnitVectorAtDegreeAngle(moveDir);
        dest.scale(10000.0f);
        Vector2f.add((Vector2f)dest, (Vector2f)ghost.getEntity().getLocation(), (Vector2f)dest);
        ghost.moveTo(dest, this.maxBurn);
    }
}

