/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.ghosts;

import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.impl.campaign.ghosts.BaseGhostBehavior;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhost;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import org.lwjgl.util.vector.Vector2f;

public class GBFollowClosely
extends BaseGhostBehavior {
    protected SectorEntityToken other;
    protected int maxBurn;
    protected float desiredRangeMin;
    protected float desiredRangeMax;
    protected IntervalUtil interval = new IntervalUtil(5.0f, 10.0f);
    protected float angleOffset = 0.0f;

    public GBFollowClosely(SectorEntityToken other, float duration, int maxBurn, float desiredRangeMin, float desiredRangeMax) {
        super(duration);
        this.other = other;
        this.maxBurn = maxBurn;
        this.desiredRangeMin = desiredRangeMin;
        this.desiredRangeMax = desiredRangeMax;
        this.interval.forceIntervalElapsed();
    }

    public void advance(float amount, SensorGhost ghost) {
        if (this.other.getContainingLocation() != ghost.getEntity().getContainingLocation() || !this.other.isAlive()) {
            this.end();
            return;
        }
        super.advance(amount, ghost);
        this.interval.advance(amount * 1.0f);
        if (this.interval.intervalElapsed()) {
            this.angleOffset = 60.0f - Misc.random.nextFloat() * 120.0f;
        }
        float dist = Misc.getDistance(ghost.getEntity(), this.other);
        if ((dist -= this.other.getRadius() + ghost.getEntity().getRadius()) > this.desiredRangeMax) {
            ghost.moveTo(this.other.getLocation(), new Vector2f(), this.maxBurn);
        } else if (dist < this.desiredRangeMin) {
            float angle = Misc.getAngleInDegrees(this.other.getLocation(), ghost.getEntity().getLocation());
            Vector2f dest = Misc.getUnitVectorAtDegreeAngle(angle += this.angleOffset);
            dest.scale(this.desiredRangeMin + (this.desiredRangeMax - this.desiredRangeMin) * 0.5f);
            Vector2f.add((Vector2f)this.other.getLocation(), (Vector2f)dest, (Vector2f)dest);
            ghost.moveTo(dest, new Vector2f(), this.maxBurn);
        } else if (this.other.getVelocity().length() > 10.0f) {
            int burn = (int)Misc.getBurnLevelForSpeed(this.other.getVelocity().length());
            if (burn < 1) {
                burn = 1;
            }
            Vector2f dest = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(this.other.getVelocity()) + this.angleOffset);
            dest.negate();
            dest.scale(this.desiredRangeMin + (this.desiredRangeMax - this.desiredRangeMin) * 0.5f);
            Vector2f.add((Vector2f)this.other.getLocation(), (Vector2f)dest, (Vector2f)dest);
            ghost.moveTo(dest, new Vector2f(), burn);
        }
    }
}

