/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.ghosts;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.impl.campaign.ghosts.BaseGhostBehavior;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhost;
import com.fs.starfarer.api.impl.campaign.velfield.SlipstreamTerrainPlugin2;
import com.fs.starfarer.api.util.Misc;
import org.lwjgl.util.vector.Vector2f;

public class GBFollowStream
extends BaseGhostBehavior {
    protected int maxBurn;
    protected SlipstreamTerrainPlugin2 plugin;
    protected float phase = 0.0f;
    protected float preferredYOff = -100.0f;
    protected boolean courseCorrecting = false;

    public GBFollowStream(float duration, int maxBurn, SlipstreamTerrainPlugin2 plugin) {
        super(duration);
        this.maxBurn = maxBurn;
        this.plugin = plugin;
        this.phase = Misc.random.nextFloat();
    }

    public void advance(float amount, SensorGhost ghost) {
        boolean veryCloseToPreferred;
        if (!ghost.getEntity().isInCurrentLocation()) {
            this.end();
            return;
        }
        super.advance(amount, ghost);
        float[] coords = this.plugin.getLengthAndWidthFractionWithinStream(ghost.getEntity().getLocation());
        if (coords == null) {
            this.end();
            return;
        }
        float distAlong = coords[0];
        float yOff = coords[1];
        if (this.preferredYOff < -10.0f) {
            this.preferredYOff = yOff;
        }
        float yOffDest = this.preferredYOff;
        boolean closeToPreferred = Math.abs(yOff - this.preferredYOff) < 0.25f;
        boolean bl = veryCloseToPreferred = Math.abs(yOff - this.preferredYOff) < 0.05f;
        if (!closeToPreferred) {
            this.courseCorrecting = true;
        }
        if (veryCloseToPreferred) {
            this.courseCorrecting = false;
        }
        if (!this.courseCorrecting) {
            yOffDest = yOff;
        }
        Vector2f p1 = this.plugin.getPointAt(distAlong, yOff);
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        float dist = Float.MAX_VALUE;
        if (pf != null) {
            dist = Misc.getDistance(ghost.getEntity(), pf);
        }
        if (pf != null && dist < 500.0f) {
            float angleDiff = Misc.getAngleDiff(Misc.getAngleInDegrees(ghost.getEntity().getVelocity()), Misc.getAngleInDegrees(ghost.getEntity().getLocation(), pf.getLocation()));
            coords = this.plugin.getLengthAndWidthFractionWithinStream(pf.getLocation());
            if (coords != null && angleDiff < 90.0f) {
                float yOffPlayer = coords[1];
                float test1 = yOffPlayer - 0.4f;
                float test2 = yOffPlayer + 0.4f;
                if (Math.abs(test1) > 0.67f) {
                    test1 = Math.signum(test1) * 0.67f;
                }
                if (Math.abs(test2) > 0.67f) {
                    test2 = Math.signum(test2) * 0.67f;
                }
                float diff1 = Math.abs(test1 - yOff);
                float diff2 = Math.abs(test2 - yOff);
                float diff3 = Math.abs(yOff - yOffPlayer);
                if (diff3 < 0.4f) {
                    yOffDest = diff1 < diff2 ? test1 : test2;
                }
            }
        }
        Vector2f p2 = this.plugin.getPointAt(distAlong + 200.0f, yOffDest);
        if (p1 == null || p2 == null) {
            this.end();
            return;
        }
        Vector2f dest = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(p1, p2));
        dest.scale(1000.0f);
        Vector2f.add((Vector2f)dest, (Vector2f)ghost.getEntity().getLocation(), (Vector2f)dest);
        ghost.moveTo(dest, new Vector2f(), this.maxBurn);
    }
}

