/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.ghosts;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.impl.campaign.ghosts.BaseGhostBehaviorInterrupt;
import com.fs.starfarer.api.impl.campaign.ghosts.GhostBehavior;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhost;
import com.fs.starfarer.api.impl.campaign.ghosts.SpeedReduction;
import com.fs.starfarer.api.loading.CampaignPingSpec;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;

public class GBIRemoraDrain
extends BaseGhostBehaviorInterrupt {
    protected SectorEntityToken target;
    protected float drainRange;
    protected IntervalUtil tracker = new IntervalUtil(5.0f, 10.0f);

    public GBIRemoraDrain(SectorEntityToken target, float drainRange) {
        super(0.0f);
        this.target = target;
        this.drainRange = drainRange;
    }

    public void advance(float amount, SensorGhost ghost, GhostBehavior behavior) {
        super.advance(amount, ghost, behavior);
        this.tracker.advance(amount);
        if (this.tracker.intervalElapsed()) {
            CustomCampaignEntityAPI entity = ghost.getEntity();
            CampaignPingSpec custom = new CampaignPingSpec();
            custom.setWidth(15.0f);
            custom.setRange(this.drainRange * 1.3f);
            custom.setDuration(0.5f);
            custom.setAlphaMult(1.0f);
            custom.setInFraction(0.1f);
            custom.setNum(1);
            custom.setColor(new Color(255, 100, 100, 255));
            Global.getSector().addPing((SectorEntityToken)entity, custom);
            if (ghost.getEntity().isInCurrentLocation()) {
                Global.getSoundPlayer().playSound("ghost_remora_hit", 1.0f, 1.0f, ghost.getEntity().getLocation(), ghost.getEntity().getVelocity());
            }
            ArrayList<CampaignFleetAPI> list = new ArrayList<CampaignFleetAPI>(entity.getContainingLocation().getFleets());
            list.addAll(entity.getContainingLocation().getCustomEntities());
            for (SectorEntityToken sectorEntityToken : list) {
                float dist;
                if (sectorEntityToken.hasTag("immune_to_remora_pulse") || !((dist = Misc.getDistance(entity, sectorEntityToken) - entity.getRadius() - sectorEntityToken.getRadius()) < this.drainRange)) continue;
                if (sectorEntityToken.isPlayerFleet()) {
                    sectorEntityToken.addFloatingText("\u9a71\u52a8\u529b\u573a\u5931\u6548\uff01", Misc.getNegativeHighlightColor(), 1.0f, true);
                }
                float mult = 0.5f + 0.5f * (1.0f - dist / this.drainRange);
                if (sectorEntityToken instanceof CampaignFleetAPI) {
                    mult *= 2.0f;
                }
                sectorEntityToken.addScript(new SpeedReduction(sectorEntityToken, 0.5f * mult, 0.5f));
            }
        }
    }
}

