/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.ghosts;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhost;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhostCreator;
import com.fs.starfarer.api.impl.campaign.ghosts.types.AbyssalDrifterGhostCreator;
import com.fs.starfarer.api.impl.campaign.ghosts.types.ChargerGhostCreator;
import com.fs.starfarer.api.impl.campaign.ghosts.types.EchoGhostCreator;
import com.fs.starfarer.api.impl.campaign.ghosts.types.EncounterTricksterGhostCreator;
import com.fs.starfarer.api.impl.campaign.ghosts.types.GuideGhostCreator;
import com.fs.starfarer.api.impl.campaign.ghosts.types.LeviathanCalfGhostCreator;
import com.fs.starfarer.api.impl.campaign.ghosts.types.LeviathanGhostCreator;
import com.fs.starfarer.api.impl.campaign.ghosts.types.MinnowGhostCreator;
import com.fs.starfarer.api.impl.campaign.ghosts.types.NoGhostCreator;
import com.fs.starfarer.api.impl.campaign.ghosts.types.RacerGhostCreator;
import com.fs.starfarer.api.impl.campaign.ghosts.types.RemnantGhostCreator;
import com.fs.starfarer.api.impl.campaign.ghosts.types.RemoraGhostCreator;
import com.fs.starfarer.api.impl.campaign.ghosts.types.ShipGhostCreator;
import com.fs.starfarer.api.impl.campaign.ghosts.types.StormTricksterGhostCreator;
import com.fs.starfarer.api.impl.campaign.ghosts.types.StormcallerGhostCreator;
import com.fs.starfarer.api.impl.campaign.ghosts.types.ZigguratGhostCreator;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.TimeoutTracker;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SensorGhostManager
implements EveryFrameScript {
    public static List<SensorGhostCreator> CREATORS = new ArrayList<SensorGhostCreator>();
    public static float GHOST_SPAWN_RATE_MULT;
    public static float GHOST_SPAWN_RATE_MULT_IN_ABYSS;
    public static float SB_ATTRACT_GHOSTS_PROBABILITY;
    public static float SB_FAILED_TO_ATTRACT_TIMEOUT_MULT;
    public static float MIN_SB_TIMEOUT;
    public static float MAX_SB_TIMEOUT;
    public static float MIN_FULL_GHOST_TIMEOUT_DAYS;
    public static float MAX_FULL_GHOST_TIMEOUT_DAYS;
    public static float MIN_SHORT_GHOST_TIMEOUT_DAYS;
    public static float MAX_SHORT_GHOST_TIMEOUT_DAYS;
    public static float FULL_TIMEOUT_TRIGGER_PROBABILITY;
    public static float MIN_FAILED_CREATOR_TIMEOUT_DAYS;
    public static float MAX_FAILED_CREATOR_TIMEOUT_DAYS;
    protected TimeoutTracker<String> perCreatorTimeouts = new TimeoutTracker();
    protected float timeoutRemaining = 0.0f;
    protected float sbTimeoutRemaining = 0.0f;
    protected Random random = new Random(Misc.genRandomSeed());
    protected List<SensorGhost> ghosts = new ArrayList<SensorGhost>();
    protected boolean spawnTriggeredBySensorBurst = false;

    static {
        CREATORS.add(new ChargerGhostCreator());
        CREATORS.add(new EchoGhostCreator());
        CREATORS.add(new EncounterTricksterGhostCreator());
        CREATORS.add(new GuideGhostCreator());
        CREATORS.add(new LeviathanGhostCreator());
        CREATORS.add(new LeviathanCalfGhostCreator());
        CREATORS.add(new MinnowGhostCreator());
        CREATORS.add(new NoGhostCreator());
        CREATORS.add(new RacerGhostCreator());
        CREATORS.add(new RemnantGhostCreator());
        CREATORS.add(new RemoraGhostCreator());
        CREATORS.add(new ShipGhostCreator());
        CREATORS.add(new StormcallerGhostCreator());
        CREATORS.add(new StormTricksterGhostCreator());
        CREATORS.add(new ZigguratGhostCreator());
        CREATORS.add(new AbyssalDrifterGhostCreator());
        GHOST_SPAWN_RATE_MULT = 0.75f;
        GHOST_SPAWN_RATE_MULT_IN_ABYSS = 3.0f;
        SB_ATTRACT_GHOSTS_PROBABILITY = 0.5f;
        SB_FAILED_TO_ATTRACT_TIMEOUT_MULT = 0.25f;
        MIN_SB_TIMEOUT = 5.0f;
        MAX_SB_TIMEOUT = 20.0f;
        MIN_FULL_GHOST_TIMEOUT_DAYS = 10.0f;
        MAX_FULL_GHOST_TIMEOUT_DAYS = 40.0f;
        MIN_SHORT_GHOST_TIMEOUT_DAYS = 0.0f;
        MAX_SHORT_GHOST_TIMEOUT_DAYS = 0.2f;
        FULL_TIMEOUT_TRIGGER_PROBABILITY = 0.95f;
        MIN_FAILED_CREATOR_TIMEOUT_DAYS = 0.8f;
        MAX_FAILED_CREATOR_TIMEOUT_DAYS = 1.2f;
    }

    public static SensorGhostManager getGhostManager() {
        String ghostManagerKey = "$ghostManager";
        SensorGhostManager manager = (SensorGhostManager)Global.getSector().getMemoryWithoutUpdate().get(ghostManagerKey);
        if (manager == null) {
            for (EveryFrameScript curr : Global.getSector().getScripts()) {
                if (!(curr instanceof SensorGhostManager)) continue;
                manager = (SensorGhostManager)curr;
                Global.getSector().getMemoryWithoutUpdate().set(ghostManagerKey, manager);
                break;
            }
        }
        return manager;
    }

    public static SensorGhost getGhostFor(SectorEntityToken entity) {
        SensorGhostManager manager = SensorGhostManager.getGhostManager();
        if (manager == null) {
            return null;
        }
        for (SensorGhost ghost : manager.ghosts) {
            if (ghost.getEntity() != entity) continue;
            return ghost;
        }
        return null;
    }

    @Override
    public void advance(float amount) {
        if (amount == 0.0f) {
            return;
        }
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        if (pf == null) {
            return;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        if (Misc.getAbyssalDepth(pf) >= 1.0f) {
            days *= GHOST_SPAWN_RATE_MULT_IN_ABYSS;
        }
        this.perCreatorTimeouts.advance(days);
        this.sbTimeoutRemaining -= days;
        if (this.sbTimeoutRemaining <= 0.0f) {
            this.sbTimeoutRemaining = 0.0f;
            this.checkSensorBursts();
        }
        this.timeoutRemaining -= days * GHOST_SPAWN_RATE_MULT;
        if (this.timeoutRemaining <= 0.0f) {
            this.spawnGhost();
            this.spawnTriggeredBySensorBurst = false;
        }
        Iterator<SensorGhost> iter = this.ghosts.iterator();
        while (iter.hasNext()) {
            SensorGhost curr = iter.next();
            curr.advance(amount);
            if (!curr.isDone()) continue;
            iter.remove();
        }
    }

    public boolean isSpawnTriggeredBySensorBurst() {
        return this.spawnTriggeredBySensorBurst;
    }

    public void checkSensorBursts() {
        if (!Global.getSector().getCurrentLocation().isHyperspace()) {
            return;
        }
        if (this.timeoutRemaining < 1.0f) {
            return;
        }
        if (Global.getSector().getMemoryWithoutUpdate().getBoolean("$sensorBurstJustUsed")) {
            if (this.random.nextFloat() > SB_ATTRACT_GHOSTS_PROBABILITY) {
                this.sbTimeoutRemaining = MIN_SB_TIMEOUT + (MAX_SB_TIMEOUT - MIN_SB_TIMEOUT) * this.random.nextFloat();
                this.sbTimeoutRemaining *= SB_FAILED_TO_ATTRACT_TIMEOUT_MULT;
                return;
            }
            CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
            float range = 2000.0f;
            for (CampaignFleetAPI fleet : Global.getSector().getCurrentLocation().getFleets()) {
                float dist = Misc.getDistance(fleet.getLocation(), pf.getLocation());
                if (dist > range || !fleet.getMemoryWithoutUpdate().getBoolean("$justDidSensorBurst")) continue;
                this.timeoutRemaining = 0.2f + 0.8f * this.random.nextFloat();
                this.spawnTriggeredBySensorBurst = true;
                this.sbTimeoutRemaining = MIN_SB_TIMEOUT + (MAX_SB_TIMEOUT - MIN_SB_TIMEOUT) * this.random.nextFloat();
                break;
            }
        }
    }

    public void spawnGhost() {
        SensorGhostCreator creator2;
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        boolean nearStream = Misc.isInsideSlipstream(pf.getLocation(), 1000.0f, pf.getContainingLocation());
        boolean inAbyss = Misc.isInAbyss(pf);
        WeightedRandomPicker<SensorGhostCreator> picker = new WeightedRandomPicker<SensorGhostCreator>(this.random);
        for (SensorGhostCreator creator2 : CREATORS) {
            if (this.perCreatorTimeouts.contains(creator2.getId()) || nearStream && !creator2.canSpawnWhilePlayerInOrNearSlipstream() || inAbyss && !creator2.canSpawnWhilePlayerInAbyss() || !inAbyss && !creator2.canSpawnWhilePlayerOutsideAbyss()) continue;
            float freq = creator2.getFrequency(this);
            picker.add(creator2, freq);
        }
        creator2 = (SensorGhostCreator)picker.pick();
        if (creator2 == null) {
            return;
        }
        boolean canSpawn = true;
        List<SensorGhost> ghosts = null;
        if (canSpawn) {
            ghosts = creator2.createGhost(this);
        }
        boolean anyFailed = false;
        if (ghosts != null) {
            for (SensorGhost curr : ghosts) {
                anyFailed |= curr.isCreationFailed();
                curr.setDespawnInAbyss(!creator2.canSpawnWhilePlayerInAbyss());
            }
        }
        if (!canSpawn) {
            anyFailed = true;
        }
        if (ghosts == null || ghosts.isEmpty() || anyFailed) {
            float timeout = MIN_FAILED_CREATOR_TIMEOUT_DAYS + this.random.nextFloat() * (MAX_FAILED_CREATOR_TIMEOUT_DAYS - MIN_FAILED_CREATOR_TIMEOUT_DAYS);
            this.perCreatorTimeouts.set(creator2.getId(), timeout);
        } else {
            this.ghosts.addAll(ghosts);
            this.timeoutRemaining = this.random.nextFloat() < FULL_TIMEOUT_TRIGGER_PROBABILITY ? MIN_FULL_GHOST_TIMEOUT_DAYS + this.random.nextFloat() * (MAX_FULL_GHOST_TIMEOUT_DAYS - MIN_FULL_GHOST_TIMEOUT_DAYS) : MIN_SHORT_GHOST_TIMEOUT_DAYS + this.random.nextFloat() * (MAX_SHORT_GHOST_TIMEOUT_DAYS - MIN_SHORT_GHOST_TIMEOUT_DAYS);
            this.perCreatorTimeouts.set(creator2.getId(), creator2.getTimeoutDaysOnSuccessfulCreate(this));
        }
    }

    public boolean hasGhostOfClass(Class<?> clazz) {
        for (SensorGhost ghost : this.ghosts) {
            if (!clazz.isInstance(ghost)) continue;
            return true;
        }
        return false;
    }

    public Random getRandom() {
        return this.random;
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }

    @Override
    public boolean isDone() {
        return false;
    }

    public List<SensorGhost> getGhosts() {
        return this.ghosts;
    }
}

