/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.ghosts.types;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.impl.campaign.ghosts.BaseSensorGhost;
import com.fs.starfarer.api.impl.campaign.ghosts.GBCircle;
import com.fs.starfarer.api.impl.campaign.ghosts.GBITowardsEntity;
import com.fs.starfarer.api.impl.campaign.ghosts.GBIntercept;
import com.fs.starfarer.api.impl.campaign.ghosts.GBLeadPlayerTo;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhostManager;
import java.util.Random;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class EncounterTricksterGhost
extends BaseSensorGhost {
    public EncounterTricksterGhost(SensorGhostManager manager, CampaignFleetAPI other, boolean guideToTarget) {
        super(manager, guideToTarget ? 40 : 20);
        Random random = manager.getRandom();
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        float circleRadius = this.genFloat(300.0f, 400.0f);
        this.initEntity(this.genLargeSensorProfile(), this.genSmallRadius());
        this.placeNearEntity(other, 0.0f, 0.0f);
        this.setDespawnRange(-1000.0f);
        if (guideToTarget) {
            SectorEntityToken e = pf.getContainingLocation().createToken(new Vector2f((ReadableVector2f)other.getLocation()));
            other.addAssignment(FleetAssignment.ORBIT_AGGRESSIVE, e, 10.0f + 20.0f * random.nextFloat(), "\u8c03\u67e5\u5f02\u5e38\u4fe1\u53f7");
            this.addBehavior(new GBIntercept(pf, 10.0f, 40, circleRadius + 500.0f, true));
            this.addBehavior(new GBCircle(pf, this.genDelay(2.0f), 40, circleRadius, 1.0f));
            this.addInterrupt(new GBITowardsEntity(this.genDelay(1.5f), pf, other));
            this.addBehavior(new GBLeadPlayerTo(20.0f, other, this.genFloat(500.0f, 600.0f), 25));
        } else {
            other.addAssignment(FleetAssignment.ORBIT_AGGRESSIVE, (SectorEntityToken)this.entity, 10.0f + 20.0f * random.nextFloat(), "\u8c03\u67e5\u5e7d\u7075\u4fe1\u53f7");
            this.addBehavior(new GBIntercept(pf, 10.0f, Math.round(other.getFleetData().getBurnLevel()) + 1, 100.0f, true));
        }
    }
}

