/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.ghosts.types;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.ghosts.BaseSensorGhostCreator;
import com.fs.starfarer.api.impl.campaign.ghosts.GhostFrequencies;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhost;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhostManager;
import com.fs.starfarer.api.impl.campaign.ghosts.types.GuideGhost;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuideGhostCreator
extends BaseSensorGhostCreator {
    public static float GUIDE_GHOST_RADIUS_LY = 5.0f;

    @Override
    public List<SensorGhost> createGhost(SensorGhostManager manager) {
        float distLY;
        if (!Global.getSector().getCurrentLocation().isHyperspace()) {
            return null;
        }
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        WeightedRandomPicker<SectorEntityToken> picker = new WeightedRandomPicker<SectorEntityToken>(manager.getRandom());
        LocationAPI hyper = Global.getSector().getHyperspace();
        for (SectorEntityToken curr : hyper.getEntitiesWithTag("neutrino_high")) {
            if (curr.isPlayerFleet() || (distLY = Misc.getDistanceLY(curr.getLocation(), pf.getLocationInHyperspace())) > GUIDE_GHOST_RADIUS_LY) continue;
            picker.add(curr, 1.0f);
        }
        for (StarSystemAPI system : Global.getSector().getStarSystems()) {
            distLY = Misc.getDistanceLY(system.getLocation(), pf.getLocationInHyperspace());
            if (distLY > GUIDE_GHOST_RADIUS_LY) continue;
            float score = 0.0f;
            for (SectorEntityToken curr : system.getEntitiesWithTag("neutrino_high")) {
                if (curr.hasTag("objective")) continue;
                if (score == 0.0f) {
                    score = 1.0f;
                }
                score += score;
            }
            if (!(score > 0.0f) || system.getHyperspaceAnchor() == null) continue;
            picker.add(system.getHyperspaceAnchor(), score);
        }
        for (SectorEntityToken item : new ArrayList(picker.getItems())) {
            if (!Misc.crossesAnySlipstream(Global.getSector().getHyperspace(), pf.getLocation(), item.getLocation())) continue;
            picker.remove(item);
        }
        SectorEntityToken target = (SectorEntityToken)picker.pick();
        if (target == null) {
            return null;
        }
        ArrayList<SensorGhost> result = new ArrayList<SensorGhost>();
        GuideGhost g = new GuideGhost(manager, target);
        if (g.isCreationFailed()) {
            return null;
        }
        result.add(g);
        return result;
    }

    @Override
    public float getFrequency(SensorGhostManager manager) {
        return GhostFrequencies.getGuideFrequency(manager);
    }
}

