/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.ghosts.types;

import com.fs.starfarer.api.Script;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.impl.campaign.DerelictShipEntityPlugin;
import com.fs.starfarer.api.impl.campaign.ghosts.BaseSensorGhost;
import com.fs.starfarer.api.impl.campaign.ghosts.GBCircle;
import com.fs.starfarer.api.impl.campaign.ghosts.GBIRunScript;
import com.fs.starfarer.api.impl.campaign.ghosts.GBIntercept;
import com.fs.starfarer.api.impl.campaign.ghosts.GBStayInPlace;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhostManager;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseThemeGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.SalvageSpecialAssigner;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.Random;
import org.lwjgl.util.vector.ReadableVector2f;

public class ShipGhost
extends BaseSensorGhost
implements Script {
    protected Random random;

    public ShipGhost(SensorGhostManager manager, CampaignFleetAPI fleet) {
        super(manager, 0);
        this.random = Misc.getRandom(manager.getRandom().nextLong(), 5);
        int maxBurn = 9 + this.random.nextInt(3);
        this.initEntity(this.genMediumSensorProfile(), this.genSmallRadius());
        if (!this.placeNearPlayer()) {
            this.setCreationFailed();
            return;
        }
        this.setDespawnRange(-1000.0f);
        float speed = Misc.getSpeedForBurnLevel(maxBurn);
        float accelMult = speed / Misc.getSpeedForBurnLevel(20.0f);
        if (accelMult < 0.1f) {
            accelMult = 0.1f;
        }
        this.setAccelMult(1.0f / accelMult);
        this.addBehavior(new GBIntercept(fleet, 5.0f + this.random.nextFloat() * 2.0f, maxBurn, 450.0f, true));
        this.addBehavior(new GBCircle(fleet, 0.3f + this.random.nextFloat() * 0.3f, maxBurn / 2, 300.0f, this.random.nextBoolean() ? 1.0f : -1.0f));
        this.addBehavior(new GBStayInPlace(0.1f));
        this.addInterrupt(new GBIRunScript(0.0f, this, true));
    }

    public void run() {
        WeightedRandomPicker<String> factions = SalvageSpecialAssigner.getNearbyFactions(this.random, this.entity.getLocationInHyperspace(), 15.0f, 10.0f, 10.0f);
        String faction = factions.pick();
        DerelictShipEntityPlugin.DerelictShipData params = DerelictShipEntityPlugin.createRandom(faction, null, this.random, DerelictShipEntityPlugin.getDefaultSModProb());
        if (params != null) {
            params.durationDays = 15.0f + 15.0f * this.random.nextFloat();
            CustomCampaignEntityAPI ship = (CustomCampaignEntityAPI)BaseThemeGenerator.addSalvageEntity(this.random, this.entity.getContainingLocation(), "wreck", "neutral", params);
            SalvageSpecialAssigner.assignSpecials(ship, false, this.random);
            ship.addTag("expires");
            ship.setDiscoverable(false);
            ship.setLocation(this.entity.getLocation().x, this.entity.getLocation().y);
            ship.getVelocity().set((ReadableVector2f)this.entity.getVelocity());
            ship.getMemoryWithoutUpdate().set("$fromGhost", true);
        }
    }
}

