/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.graid;

import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.graid.GroundRaidObjectivePlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.ui.IconGroupAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public abstract class BaseGroundRaidObjectivePluginImpl
implements GroundRaidObjectivePlugin {
    protected String id;
    protected MarketAPI market;
    protected Industry source;
    protected int marinesAssigned;
    protected int marinesRequired;
    protected String nameOverride;
    protected String assignedForcesColumnText;
    protected Color assignedForcesColumnColor = Misc.getNegativeHighlightColor();
    protected int quantityLooted;
    protected int xpGained;

    public BaseGroundRaidObjectivePluginImpl(MarketAPI market, String id) {
        this.market = market;
        this.id = id;
    }

    public abstract float getQuantity(int var1);

    public abstract int getValue(int var1);

    public int getCargoSpaceNeeded() {
        return 0;
    }

    public int getFuelSpaceNeeded() {
        return 0;
    }

    public CargoStackAPI getStackForIcon() {
        return null;
    }

    public String getIconName() {
        return null;
    }

    public void addIcons(IconGroupAPI iconGroup) {
    }

    public int getDeficitCaused() {
        return 0;
    }

    public String getDisruptedAlreadyString() {
        return "";
    }

    public Color getDisruptedAlreadyColor() {
        return Misc.getHighlightColor();
    }

    public int getDisruptionDaysSort(int marines) {
        return 0;
    }

    public String getDisruptionDaysString(int marines) {
        return "";
    }

    public Color getDisruptionDaysColor(int marines) {
        if (marines <= 0) {
            return Misc.getGrayColor();
        }
        return Misc.getHighlightColor();
    }

    public String getNameOverride() {
        return this.nameOverride;
    }

    public void setNameOverride(String nameOverride) {
        this.nameOverride = nameOverride;
    }

    public MarketCMD.RaidDangerLevel getDangerLevel() {
        return MarketCMD.RaidDangerLevel.MEDIUM;
    }

    public String getQuantityString(int marines) {
        return Misc.getWithDGS(this.getQuantity(Math.max(1, marines)));
    }

    public Color getQuantityColor(int marines) {
        if (marines <= 0) {
            return Misc.getGrayColor();
        }
        return Misc.getHighlightColor();
    }

    public String getValueString(int marines) {
        return Misc.getDGSCredits(this.getValue(Math.max(1, marines)));
    }

    public Color getValueColor(int marines) {
        if (marines <= 0) {
            return Misc.getGrayColor();
        }
        return Misc.getHighlightColor();
    }

    public float getValueSortValue() {
        float add = 1.0E8f;
        if (this.getMarinesAssigned() == 0) {
            add = 0.0f;
        }
        return (float)this.getValue(Math.max(1, this.getMarinesAssigned())) + add;
    }

    public int getMarinesAssigned() {
        return this.marinesAssigned;
    }

    public void setMarinesAssigned(int marines) {
        this.marinesAssigned = marines;
    }

    public int getMarinesRequired() {
        return this.marinesRequired;
    }

    public void setMarinesRequired(int marines) {
        if ((marines = Math.min(MarketCMD.MAX_MARINE_TOKENS, marines)) < 0) {
            marines = 0;
        }
        this.marinesRequired = marines;
    }

    public String getSourceString() {
        if (this.source != null) {
            return this.source.getCurrentName();
        }
        return "";
    }

    public Industry getSource() {
        return this.source;
    }

    public void setSource(Industry source) {
        this.source = source;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public MarketAPI getMarket() {
        return this.market;
    }

    public void setMarket(MarketAPI market) {
        this.market = market;
    }

    public String getCommodityIdForDeficitIcons() {
        return null;
    }

    public String getAssignedForcesColumnText() {
        return this.assignedForcesColumnText;
    }

    public void setAssignedForcesColumnText(String assignedForcesColumnText) {
        this.assignedForcesColumnText = assignedForcesColumnText;
    }

    public Color getAssignedForcesColumnColor() {
        return this.assignedForcesColumnColor;
    }

    public void setAssignedForcesColumnColor(Color assignedForcesColumnColor) {
        this.assignedForcesColumnColor = assignedForcesColumnColor;
    }

    public boolean hasTooltip() {
        return false;
    }

    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
    }

    public float getTooltipWidth() {
        return 500.0f;
    }

    public boolean isTooltipExpandable() {
        return false;
    }

    public int getQuantityLooted() {
        return this.quantityLooted;
    }

    public void setQuantityLooted(int quantityLooted) {
        this.quantityLooted = quantityLooted;
    }

    public int getXpGained() {
        return this.xpGained;
    }

    public void setXpGained(int xpGained) {
        this.xpGained = xpGained;
    }

    public boolean withContinueBeforeResult() {
        return false;
    }
}

