/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.graid;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MutableCommodityQuantity;
import com.fs.starfarer.api.impl.campaign.graid.BaseGroundRaidObjectivePluginImpl;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.Pair;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlueprintGroundRaidObjectivePluginImpl
extends BaseGroundRaidObjectivePluginImpl {
    public static float PROBABILITY_TO_DROP_BP_NOT_DROPPED_BEFORE = 0.8f;
    protected int bpUseScale = 0;
    protected CargoAPI looted = Global.getFactory().createCargo(true);

    public BlueprintGroundRaidObjectivePluginImpl(MarketAPI market) {
        super(market, "blueprints");
        this.setSource(this.computeSource());
    }

    @Override
    public void setSource(Industry source) {
        super.setSource(source);
        MarketCMD.RaidDangerLevel level = this.getDangerLevel();
        int marines = level.marineTokens;
        if (source != null) {
            marines = source.adjustMarineTokensToRaidItem(this.id, null, marines);
        }
        this.setMarinesRequired(marines);
    }

    @Override
    public int getProjectedCreditsValue() {
        return 0;
    }

    public CommoditySpecAPI getCommoditySpec() {
        return Global.getSettings().getCommoditySpec(this.id);
    }

    @Override
    public MarketCMD.RaidDangerLevel getDangerLevel() {
        MarketCMD.RaidDangerLevel level = this.getCommoditySpec().getBaseDanger();
        if (this.source != null) {
            level = this.source.adjustItemDangerLevel(this.id, null, level);
        }
        return level;
    }

    @Override
    public float getQuantitySortValue() {
        CommoditySpecAPI spec = this.getCommoditySpec();
        float add = 0.0f;
        if (spec != null) {
            add = spec.getOrder();
        }
        return 1.0E7f + add;
    }

    @Override
    public String getQuantityString(int marines) {
        Pair<Integer, Integer> q = this.getQuantityRange();
        return q.one + "-" + q.two;
    }

    @Override
    public String getValueString(int marines) {
        return "";
    }

    @Override
    public int getValue(int marines) {
        return 0;
    }

    public Pair<Integer, Integer> getQuantityRange() {
        Pair<Integer, Integer> q = new Pair<Integer, Integer>();
        int scale = this.bpUseScale - 995;
        if (scale <= 0) {
            q.one = 0;
            q.two = 0;
        } else if (scale <= 5) {
            q.one = 1;
            q.two = 2;
        } else if (scale <= 7) {
            q.one = 2;
            q.two = 3;
        } else {
            q.one = 3;
            q.two = 4;
        }
        return q;
    }

    @Override
    public float getQuantity(int marines) {
        return ((Integer)this.getQuantityRange().one).intValue();
    }

    public Industry computeSource() {
        Industry best = null;
        int score = 0;
        MarketCMD.RaidDangerLevel base = this.getCommoditySpec().getBaseDanger();
        for (Industry ind : this.market.getIndustries()) {
            if (!ind.getSpec().hasTag("uses_blueprints")) continue;
            int scale = 0;
            for (MutableCommodityQuantity q : ind.getAllSupply()) {
                scale = Math.max(scale, q.getQuantity().getModifiedInt());
            }
            for (MutableCommodityQuantity q : ind.getAllDemand()) {
                scale = Math.max(scale, q.getQuantity().getModifiedInt());
            }
            int currScore = scale;
            MarketCMD.RaidDangerLevel danger = ind.adjustItemDangerLevel("blueprints", null, base);
            if ((currScore += 1000 - danger.ordinal()) <= score) continue;
            score = currScore;
            best = ind;
        }
        this.bpUseScale = score;
        return best;
    }

    @Override
    public String getName() {
        return "\u84dd\u56fe";
    }

    @Override
    public CargoStackAPI getStackForIcon() {
        CargoStackAPI stack = Global.getFactory().createCargoStack(CargoAPI.CargoItemType.RESOURCES, "blueprints", null);
        return stack;
    }

    public Set<String> getDropped() {
        String key = "BlueprintGroundRaidObjectivePluginImpl_dropped";
        LinkedHashSet data = Global.getSector().getPersistentData().get(key);
        if (data == null) {
            data = new LinkedHashSet();
            Global.getSector().getPersistentData().put(key, data);
        }
        return data;
    }

    @Override
    public int performRaid(CargoAPI loot, Random random, float lootMult, TextPanelAPI text) {
        String id2;
        if (this.marinesAssigned <= 0) {
            return 0;
        }
        String ship = "MarketCMD_ship____";
        String weapon = "MarketCMD_weapon__";
        String fighter = "MarketCMD_fighter_";
        FactionAPI playerFaction = Global.getSector().getPlayerFaction();
        Set<String> droppedBefore = this.getDropped();
        WeightedRandomPicker<String> notDroppedBefore = new WeightedRandomPicker<String>(random);
        WeightedRandomPicker<String> other = new WeightedRandomPicker<String>(random);
        for (String id : this.market.getFaction().getKnownShips()) {
            if (Global.getSettings().getHullSpec(id).hasTag("no_bp_drop")) continue;
            id2 = String.valueOf(ship) + id;
            if (!playerFaction.knowsShip(id) && !droppedBefore.contains(id2)) {
                notDroppedBefore.add(id2, 1.0f);
                continue;
            }
            other.add(id2, 1.0f);
        }
        for (String id : this.market.getFaction().getKnownWeapons()) {
            if (Global.getSettings().getWeaponSpec(id).hasTag("no_bp_drop")) continue;
            id2 = String.valueOf(weapon) + id;
            if (!playerFaction.knowsWeapon(id) && !droppedBefore.contains(id2)) {
                notDroppedBefore.add(String.valueOf(weapon) + id, 1.0f);
                continue;
            }
            other.add(String.valueOf(weapon) + id, 1.0f);
        }
        for (String id : this.market.getFaction().getKnownFighters()) {
            if (Global.getSettings().getFighterWingSpec(id).hasTag("no_bp_drop")) continue;
            id2 = String.valueOf(fighter) + id;
            if (!playerFaction.knowsFighter(id) && !droppedBefore.contains(id2)) {
                notDroppedBefore.add(String.valueOf(fighter) + id, 1.0f);
                continue;
            }
            other.add(String.valueOf(fighter) + id, 1.0f);
        }
        this.looted.clear();
        Pair<Integer, Integer> q = this.getQuantityRange();
        int num = (Integer)q.one + random.nextInt((Integer)q.two - (Integer)q.one + 1);
        int i = 0;
        while (!(i >= num || notDroppedBefore.isEmpty() && other.isEmpty())) {
            String id = null;
            if (random.nextFloat() < PROBABILITY_TO_DROP_BP_NOT_DROPPED_BEFORE) {
                id = (String)notDroppedBefore.pickAndRemove();
            }
            if (id == null) {
                id = (String)other.pickAndRemove();
            }
            if (id != null) {
                String specId;
                droppedBefore.add(id);
                if (id.startsWith(ship)) {
                    specId = id.substring(ship.length());
                    this.looted.addSpecial(new SpecialItemData("ship_bp", specId), 1.0f);
                } else if (id.startsWith(weapon)) {
                    specId = id.substring(weapon.length());
                    this.looted.addSpecial(new SpecialItemData("weapon_bp", specId), 1.0f);
                } else if (id.startsWith(fighter)) {
                    specId = id.substring(fighter.length());
                    this.looted.addSpecial(new SpecialItemData("fighter_bp", specId), 1.0f);
                }
            }
            ++i;
        }
        int totalValue = 0;
        for (CargoStackAPI stack : this.looted.getStacksCopy()) {
            totalValue = (int)((float)totalValue + (float)stack.getBaseValuePerUnit() * stack.getSize());
        }
        loot.addAll(this.looted);
        this.xpGained = (int)((float)totalValue * 0.2f);
        return this.xpGained;
    }

    public CargoAPI getLooted() {
        return this.looted;
    }

    @Override
    public boolean hasTooltip() {
        return true;
    }

    @Override
    public void createTooltip(TooltipMakerAPI t, boolean expanded) {
        float opad = 10.0f;
        float pad = 3.0f;
        Color h = Misc.getHighlightColor();
        Color bad = Misc.getNegativeHighlightColor();
        Color good = Misc.getPositiveHighlightColor();
        t.addPara("\u84dd\u56fe\u88ab\u7528\u4e8e\u5728\u91cd\u5de5\u4e1a\u8bbe\u65bd\u4e2d\u751f\u4ea7\u661f\u8230\u8239\u4f53\uff0c\u98de\u8239\u6b66\u5668\u53ca\u6218\u673a LPC\u3002\u593a\u53d6\u51e0\u7387\u548c\u8be5\u6b96\u6c11\u5730\u5185\u6700\u5927\u7684\u84dd\u56fe\u4f7f\u7528\u8bbe\u65bd\u89c4\u6a21\u6210\u6b63\u6bd4\u3002", 0.0f);
        t.addPara("\u63a0\u593a\u800c\u6765\u7684\u84dd\u56fe\u4ef7\u503c\u53ef\u80fd\u4f1a\u76f8\u5dee\u5de8\u5927\u3002", opad);
    }
}

