/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.graid;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.econ.CommodityIconCounts;
import com.fs.starfarer.api.impl.campaign.econ.ShippingDisruption;
import com.fs.starfarer.api.impl.campaign.graid.BaseGroundRaidObjectivePluginImpl;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.loading.Description;
import com.fs.starfarer.api.ui.IconGroupAPI;
import com.fs.starfarer.api.ui.IconRenderMode;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Random;

public class CommodityGroundRaidObjectivePluginImpl
extends BaseGroundRaidObjectivePluginImpl {
    public static float ECON_IMPACT_MULT = 1.0f;
    public static float QUANTITY_MULT_NORMAL = 0.1f;
    public static float QUANTITY_MULT_NORMAL_FOR_DEFICIT = 1.0f;
    public static float QUANTITY_MULT_EXCESS = 1.0f;
    public static float QUANTITY_MULT_DEFICIT = -0.1f;
    public static float QUANTITY_MULT_OVERALL = 0.1f;
    protected CommodityOnMarketAPI com;
    private int deficitActuallyCaused;

    public CommodityGroundRaidObjectivePluginImpl(MarketAPI market, String commodityId) {
        super(market, commodityId);
        this.com = market.getCommodityData(commodityId);
        this.setSource(CommodityGroundRaidObjectivePluginImpl.computeCommoditySource(market, this.com));
    }

    public void addIcons(IconGroupAPI iconGroup) {
        CommoditySpecAPI spec = this.getCommoditySpec();
        if (spec == null) {
            return;
        }
        CommodityOnMarketAPI com = this.market.getCommodityData(this.id);
        CommodityIconCounts counts = new CommodityIconCounts(com);
        int deficit = counts.deficit;
        int available = Math.max(0, counts.available - counts.extra);
        int extra = counts.extra;
        if (available > 0) {
            if (counts.production >= counts.available) {
                Color c = Misc.interpolateColor(Misc.getPositiveHighlightColor(), Misc.zeroColor, 0.5f);
                iconGroup.addIconGroup(this.id, IconRenderMode.OUTLINE_CUSTOM, available, c);
            } else {
                iconGroup.addIconGroup(this.id, IconRenderMode.NORMAL, available, null);
            }
        }
        if (deficit > 0) {
            iconGroup.addIconGroup(this.id, IconRenderMode.RED, deficit, null);
        }
        if (extra > 0) {
            iconGroup.addIconGroup(this.id, IconRenderMode.GREEN, extra, null);
        }
    }

    public int getCargoSpaceNeeded() {
        CommoditySpecAPI spec = this.getCommoditySpec();
        if (!spec.isFuel() && !spec.isPersonnel()) {
            return (int)(spec.getCargoSpace() * this.getQuantity(this.getMarinesAssigned()));
        }
        return 0;
    }

    public int getFuelSpaceNeeded() {
        CommoditySpecAPI spec = this.getCommoditySpec();
        if (spec.isFuel()) {
            return (int)(spec.getCargoSpace() * this.getQuantity(this.getMarinesAssigned()));
        }
        return 0;
    }

    public int getProjectedCreditsValue() {
        CommoditySpecAPI spec = this.getCommoditySpec();
        return (int)(spec.getBasePrice() * this.getQuantity(this.getMarinesAssigned()));
    }

    public int getDeficitCaused() {
        float quantity = this.getQuantity(this.getMarinesAssigned(), true);
        int diff = Misc.computeEconUnitChangeFromTradeModChange(this.com, -((int)(quantity *= ECON_IMPACT_MULT)));
        if ((diff = -diff) < 0) {
            diff = 0;
        }
        if (diff == 0 && this.getProjectedCreditsValue() > 1000) {
            diff = 1;
        }
        return diff;
    }

    public CommoditySpecAPI getCommoditySpec() {
        return this.com.getCommodity();
    }

    public MarketCMD.RaidDangerLevel getDangerLevel() {
        MarketCMD.RaidDangerLevel danger = this.com.getCommodity().getBaseDanger();
        CommodityIconCounts counts = new CommodityIconCounts(this.com);
        if (counts.production >= counts.available) {
            danger = danger.prev();
        }
        if (counts.deficit > 0) {
            danger = danger.next();
        }
        if (counts.extra > 0) {
            danger = danger.prev();
        }
        if (this.source != null) {
            danger = this.source.adjustCommodityDangerLevel(this.id, danger);
        }
        return danger;
    }

    public float getQuantitySortValue() {
        return 0.0f + this.getQuantity(1);
    }

    public float getQuantity(int marines) {
        return this.getQuantity(marines, false);
    }

    public float getQuantity(int marines, boolean forDeficit) {
        float base = this.getBaseRaidQuantity(forDeficit);
        return base * (float)marines;
    }

    public int getValue(int marines) {
        return (int)(this.getQuantity(marines) * this.getCommoditySpec().getBasePrice());
    }

    public float getBaseRaidQuantity(boolean forDeficit) {
        float unit = this.com.getCommodity().getEconUnit();
        CommodityIconCounts counts = new CommodityIconCounts(this.com);
        float result = 0.0f;
        result = forDeficit ? (result += (float)Math.max(0, counts.available - counts.extra) * unit * QUANTITY_MULT_NORMAL_FOR_DEFICIT) : (result += (float)Math.max(0, counts.available - counts.extra) * unit * QUANTITY_MULT_NORMAL);
        result += (float)counts.extra * unit * QUANTITY_MULT_EXCESS;
        result += (float)counts.deficit * unit * QUANTITY_MULT_DEFICIT;
        result *= QUANTITY_MULT_OVERALL;
        if (result < 0.0f) {
            result = 0.0f;
        }
        return result;
    }

    public static Industry computeCommoditySource(MarketAPI market, CommodityOnMarketAPI com) {
        Industry best = null;
        int score = 0;
        int available = com.getAvailable();
        MarketCMD.RaidDangerLevel base = com.getCommodity().getBaseDanger();
        for (Industry ind : market.getIndustries()) {
            int supply = ind.getSupply(com.getId()).getQuantity().getModifiedInt();
            int metDemand = Math.min(available, ind.getDemand(com.getId()).getQuantity().getModifiedInt());
            int currScore = Math.max(supply, metDemand) * 1000;
            MarketCMD.RaidDangerLevel danger = ind.adjustCommodityDangerLevel(com.getId(), base);
            if ((currScore += 1000 - danger.ordinal()) <= score) continue;
            score = currScore;
            best = ind;
        }
        return best;
    }

    public String getName() {
        return this.com.getCommodity().getName();
    }

    public CargoStackAPI getStackForIcon() {
        CargoStackAPI stack = Global.getFactory().createCargoStack(CargoAPI.CargoItemType.RESOURCES, this.getId(), null);
        return stack;
    }

    public String getCommodityIdForDeficitIcons() {
        return this.com.getId();
    }

    public int performRaid(CargoAPI loot, Random random, float lootMult, TextPanelAPI text) {
        if (this.marinesAssigned <= 0) {
            return 0;
        }
        float base = this.getQuantity(this.marinesAssigned);
        base *= lootMult;
        float mult = 0.9f + random.nextFloat() * 0.2f;
        this.quantityLooted = (int)(base *= mult);
        if (this.quantityLooted < 1) {
            this.quantityLooted = 1;
        }
        loot.addCommodity(this.getId(), this.quantityLooted);
        this.deficitActuallyCaused = this.getDeficitCaused();
        if (this.deficitActuallyCaused > 0) {
            this.com.getAvailableStat().addTemporaryModFlat(ShippingDisruption.ACCESS_LOSS_DURATION, Misc.genUID(), "\u6700\u8fd1\u7684\u7a81\u88ad", -this.deficitActuallyCaused);
        }
        this.xpGained = (int)((float)this.quantityLooted * this.getCommoditySpec().getBasePrice() * 0.2f);
        return this.xpGained;
    }

    public int getDeficitActuallyCaused() {
        return this.deficitActuallyCaused;
    }

    public void setDeficitActuallyCaused(int deficitActuallyCaused) {
        this.deficitActuallyCaused = deficitActuallyCaused;
    }

    public boolean hasTooltip() {
        return true;
    }

    public void createTooltip(TooltipMakerAPI t, boolean expanded) {
        float opad = 10.0f;
        float pad = 3.0f;
        Color h = Misc.getHighlightColor();
        Color bad = Misc.getNegativeHighlightColor();
        Color good = Misc.getPositiveHighlightColor();
        Description desc = Global.getSettings().getDescription(this.id, Description.Type.RESOURCE);
        t.addPara(desc.getText1FirstPara(), 0.0f);
        t.addPara("\u57fa\u7840\u4ef7\u503c\uff1a%s \u6bcf\u5355\u4f4d", opad, h, Misc.getDGSCredits(this.com.getCommodity().getBasePrice()));
    }
}

