/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StoryPointActionDelegate;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.CommMessageAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.CommRelayEntityPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.CallEvent;
import com.fs.starfarer.api.impl.campaign.tutorial.TutorialMissionIntel;
import com.fs.starfarer.api.ui.ButtonAPI;
import com.fs.starfarer.api.ui.CustomPanelAPI;
import com.fs.starfarer.api.ui.IntelUIAPI;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseIntelPlugin
implements IntelInfoPlugin,
CallEvent.CallableEvent,
EveryFrameScript,
CommRelayEntityPlugin.CommSnifferReadableIntel {
    public static final String BULLET = "    - ";
    public static final String INDENT = "      ";
    public static String BUTTON_DELETE = "button_delete";
    protected Boolean important;
    protected Long timestamp;
    protected Boolean neverClicked = true;
    protected transient Object listInfoParam = null;
    protected Boolean ended = null;
    protected Boolean ending = null;
    protected Float endingTimeRemaining = null;
    protected SectorEntityToken postingLocation = null;
    protected Float postingRangeLY = null;
    protected Boolean hidden = null;
    protected Boolean forceAdd = null;

    @Override
    public void advance(float amount) {
        if (this.isEnded()) {
            return;
        }
        float \u5929 = Global.getSector().getClock().convertToDays(amount);
        if (this.isEnding()) {
            this.endingTimeRemaining = Float.valueOf(this.endingTimeRemaining.floatValue() - \u5929);
            if (this.endingTimeRemaining.floatValue() <= 0.0f) {
                this.ended = true;
                this.notifyEnded();
            }
            return;
        }
        this.advanceImpl(amount);
    }

    @Override
    public void notifyPlayerAboutToOpenIntelScreen() {
    }

    protected void advanceImpl(float amount) {
    }

    protected void notifyEnding() {
    }

    protected void notifyEnded() {
    }

    public void endImmediately() {
        this.endAfterDelay(0.0f);
    }

    public void endAfterDelay() {
        this.endAfterDelay(this.getBaseDaysAfterEnd());
    }

    public void endAfterDelay(float \u5929) {
        this.endingTimeRemaining = Float.valueOf(\u5929);
        boolean wasEnding = this.isEnding();
        this.ending = true;
        if (!wasEnding) {
            this.notifyEnding();
        }
        if (this.endingTimeRemaining.floatValue() <= 0.0f) {
            this.ended = true;
            this.notifyEnded();
        }
    }

    protected float getBaseDaysAfterEnd() {
        return 3.0f;
    }

    @Override
    public boolean isDone() {
        return this.isEnded();
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }

    @Override
    public boolean isEnding() {
        return this.ending != null && this.ending != false;
    }

    @Override
    public boolean isEnded() {
        return this.ended != null && this.ended != false;
    }

    public Object getListInfoParam() {
        return this.listInfoParam;
    }

    public void setListInfoParam(Object listInfoParam) {
        this.listInfoParam = listInfoParam;
    }

    public boolean isSendingUpdate() {
        return this.listInfoParam != null;
    }

    public void sendUpdate(Object listInfoParam, TextPanelAPI textPanel) {
        this.listInfoParam = listInfoParam;
        Global.getSector().getIntelManager().addIntelToTextPanel(this, textPanel);
        this.listInfoParam = null;
    }

    public void sendUpdateIfPlayerHasIntel(Object listInfoParam, TextPanelAPI textPanel) {
        if (textPanel == null) {
            this.sendUpdateIfPlayerHasIntel(listInfoParam, false);
        } else {
            this.sendUpdate(listInfoParam, textPanel);
        }
    }

    public void sendUpdateIfPlayerHasIntel(Object listInfoParam, boolean onlyIfImportant) {
        this.sendUpdateIfPlayerHasIntel(listInfoParam, onlyIfImportant, false);
    }

    public void sendUpdateIfPlayerHasIntel(Object listInfoParam, boolean onlyIfImportant, boolean sendIfHidden) {
        if (this.timestamp == null) {
            return;
        }
        if (onlyIfImportant && !this.isImportant()) {
            return;
        }
        if (!sendIfHidden && this.isHidden()) {
            return;
        }
        this.listInfoParam = listInfoParam;
        Global.getSector().getCampaignUI().addMessage(this, CommMessageAPI.MessageClickAction.INTEL_TAB, this);
        this.listInfoParam = null;
    }

    @Override
    public boolean canTurnImportantOff() {
        return true;
    }

    @Override
    public String getImportantIcon() {
        return null;
    }

    @Override
    public boolean hasImportantButton() {
        return true;
    }

    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        boolean isUpdate = this.getListInfoParam() != null;
        this.bullet(info);
        this.addBulletPoints(info, mode, isUpdate, tc, initPad);
        this.unindent(info);
    }

    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        if (this.getName() != null) {
            Color c = this.getTitleColor(mode);
            info.addPara(this.getName(), c, 0.0f);
        }
        this.addBulletPoints(info, mode);
    }

    protected String getName() {
        return null;
    }

    @Override
    public boolean hasSmallDescription() {
        return true;
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        info.addPara("Override .createSmallDescription()", Misc.getNegativeHighlightColor(), 0.0f);
    }

    @Override
    public boolean hasLargeDescription() {
        return false;
    }

    @Override
    public void createLargeDescription(CustomPanelAPI panel, float width, float height) {
        TooltipMakerAPI desc = panel.createUIElement(width, height, true);
        desc.addPara("Override .createLargeDescription()", Misc.getNegativeHighlightColor(), 0.0f);
        panel.addUIElement(desc).inTL(0.0f, 0.0f);
    }

    @Override
    public String getIcon() {
        return null;
    }

    @Override
    public Color getBackgroundGlowColor() {
        return null;
    }

    @Override
    public boolean shouldRemoveIntel() {
        if (this.timestamp == null && this.isEnding()) {
            return true;
        }
        return this.isEnded();
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        SectorEntityToken loc;
        LinkedHashSet<String> tags = new LinkedHashSet<String>();
        if (this.isImportant()) {
            tags.add("Important");
        }
        if (this.isNew()) {
            tags.add("New");
        }
        if (map != null && (loc = this.getMapLocation(map)) != null) {
            float max = Global.getSettings().getFloat("maxRelayRangeInHyperspace");
            float dist = Misc.getDistanceLY(loc.getLocationInHyperspace(), Global.getSector().getPlayerFleet().getLocationInHyperspace());
            if (dist <= max) {
                tags.add("Local");
            }
        }
        return tags;
    }

    @Override
    public boolean isImportant() {
        return this.important != null && this.important != false;
    }

    @Override
    public void setImportant(Boolean important) {
        this.important = important;
        if (this.important != null && !this.important.booleanValue()) {
            this.important = null;
        }
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return Global.getSector().getPlayerFaction();
    }

    @Override
    public boolean doesButtonHaveConfirmDialog(Object buttonId) {
        return buttonId == BUTTON_DELETE;
    }

    @Override
    public float getConfirmationPromptWidth(Object buttonId) {
        return 550.0f;
    }

    protected void createDeleteConfirmationPrompt(TooltipMakerAPI prompt) {
        prompt.addPara("\u4f60\u786e\u5b9a\u8981\u6c38\u4e45\u5220\u9664\u8be5\u65e5\u5fd7\u5417\uff1f", Misc.getTextColor(), 0.0f);
    }

    @Override
    public void createConfirmationPrompt(Object buttonId, TooltipMakerAPI prompt) {
        if (buttonId == BUTTON_DELETE) {
            this.createDeleteConfirmationPrompt(prompt);
        }
    }

    @Override
    public String getConfirmText(Object buttonId) {
        return "\u786e\u8ba4";
    }

    @Override
    public String getCancelText(Object buttonId) {
        return "\u53d6\u6d88";
    }

    protected void addDeleteButton(TooltipMakerAPI info, float width) {
        this.addDeleteButton(info, width, "\u5220\u9664\u8be5\u65e5\u5fd7");
    }

    protected void addDeleteButton(TooltipMakerAPI info, float width, String delete) {
        float opad = 10.0f;
        ButtonAPI button = info.addButton(delete, BUTTON_DELETE, this.getFactionForUIColors().getBaseUIColor(), this.getFactionForUIColors().getDarkUIColor(), (int)width, 20.0f, opad * 2.0f);
        button.setShortcut(34, true);
    }

    @Override
    public void buttonPressConfirmed(Object buttonId, IntelUIAPI ui) {
        if (buttonId == BUTTON_DELETE) {
            this.endImmediately();
            ui.recreateIntelUI();
            return;
        }
        ui.updateUIForItem(this);
    }

    @Override
    public void buttonPressCancelled(Object buttonId, IntelUIAPI ui) {
    }

    public boolean isPlayerVisible() {
        if (this.isHidden()) {
            return false;
        }
        if (this.isEnded()) {
            return false;
        }
        return this.timestamp != null;
    }

    @Override
    public Long getPlayerVisibleTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setPlayerVisibleTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public float getDaysSincePlayerVisible() {
        long ts = Global.getSector().getClock().getTimestamp();
        if (this.timestamp != null) {
            ts = this.timestamp;
        }
        return Global.getSector().getClock().getElapsedDaysSince(ts);
    }

    @Override
    public void reportPlayerClickedOn() {
        this.neverClicked = null;
    }

    @Override
    public boolean isNew() {
        Long ts = this.getPlayerVisibleTimestamp();
        if (ts == null) {
            ts = 0L;
        }
        float \u5929 = Global.getSector().getClock().getElapsedDaysSince(ts);
        return this.neverClicked != null && this.neverClicked != false && \u5929 < 5.0f;
    }

    @Override
    public void setNew(boolean isNew) {
        this.neverClicked = isNew ? Boolean.valueOf(true) : null;
    }

    @Override
    public IntelInfoPlugin.IntelSortTier getSortTier() {
        if (this.isEnding()) {
            return IntelInfoPlugin.IntelSortTier.TIER_COMPLETED;
        }
        return IntelInfoPlugin.IntelSortTier.TIER_3;
    }

    @Override
    public String getSortString() {
        return this.getName();
    }

    @Override
    public boolean autoAddCampaignMessage() {
        return !this.isHidden();
    }

    @Override
    public String getCommMessageSound() {
        if (this.isSendingUpdate()) {
            return BaseIntelPlugin.getSoundStandardUpdate();
        }
        return BaseIntelPlugin.getSoundStandardPosting();
    }

    @Override
    public boolean isHidden() {
        return TutorialMissionIntel.isTutorialInProgress() || this.hidden != null;
    }

    @Override
    public void setHidden(boolean hidden) {
        this.hidden = hidden ? Boolean.valueOf(hidden) : null;
    }

    @Override
    public void reportMadeVisibleToPlayer() {
    }

    protected float getCommRelayRange() {
        return Global.getSettings().getFloat("maxRelayRangeInHyperspace");
    }

    @Override
    public boolean canMakeVisibleToPlayer(boolean playerInRelayRange) {
        return this.canMakeVisible(playerInRelayRange, Global.getSector().getPlayerFleet().getContainingLocation(), Global.getSector().getPlayerFleet().getLocationInHyperspace(), false);
    }

    @Override
    public boolean canMakeVisibleToCommSniffer(boolean playerInRelayRange, SectorEntityToken relay) {
        return this.canMakeVisible(playerInRelayRange, relay.getContainingLocation(), relay.getLocationInHyperspace(), true);
    }

    public boolean canMakeVisible(boolean playerInRelayRange, LocationAPI conLoc, Vector2f hyperLoc, boolean commSniffer) {
        if (this.isEnding()) {
            return false;
        }
        if (this.postingLocation != null) {
            boolean sameLoc;
            float rangeLY = 0.0f;
            rangeLY = this.postingRangeLY != null ? this.postingRangeLY.floatValue() : this.getCommRelayRange();
            float commRange = 0.0f;
            if (this.postingLocation.isInHyperspace()) {
                commRange = this.getCommRelayRange();
                rangeLY = Math.max(rangeLY, commRange);
            }
            boolean bl = sameLoc = this.postingLocation.getContainingLocation() != null && this.postingLocation.getContainingLocation() == conLoc;
            if (rangeLY <= 0.0f && !sameLoc) {
                return false;
            }
            if (playerInRelayRange) {
                float dist = Misc.getDistanceLY(this.postingLocation.getLocationInHyperspace(), hyperLoc);
                return dist <= rangeLY;
            }
            if (this.postingLocation.isInHyperspace()) {
                float dist = Misc.getDistanceLY(this.postingLocation.getLocationInHyperspace(), hyperLoc);
                return dist < commRange && (!commSniffer || playerInRelayRange);
            }
            return sameLoc && (!commSniffer || playerInRelayRange);
        }
        return playerInRelayRange;
    }

    public SectorEntityToken getPostingLocation() {
        return this.postingLocation;
    }

    public void setPostingLocation(SectorEntityToken postingLocation) {
        this.postingLocation = postingLocation;
    }

    public Float getPostingRangeLY() {
        return this.postingRangeLY;
    }

    public void setPostingRangeLY(Float postingRangeLY) {
        this.setPostingRangeLY(postingRangeLY, false);
    }

    public void setPostingRangeLY(Float postingRangeLY, boolean ensureVisibleOutsideSystem) {
        if (ensureVisibleOutsideSystem) {
            if (postingRangeLY == null) {
                postingRangeLY = Float.valueOf(0.0f);
            }
            postingRangeLY = Float.valueOf(Math.max(postingRangeLY.floatValue(), this.getCommRelayRange()));
        }
        this.postingRangeLY = postingRangeLY;
    }

    @Override
    public void reportRemovedIntel() {
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        return null;
    }

    protected void bullet(TooltipMakerAPI info) {
        info.setBulletedListMode(BULLET);
        info.setTextWidthOverride(261.0f);
    }

    protected void indent(TooltipMakerAPI info) {
        info.setBulletedListMode(INDENT);
        info.setTextWidthOverride(261.0f);
    }

    protected void unindent(TooltipMakerAPI info) {
        info.setBulletedListMode(null);
        info.setTextWidthOverride(0.0f);
    }

    protected void addDays(TooltipMakerAPI info, String after, float \u5929) {
        this.addDays(info, after, \u5929, null);
    }

    protected void addDays(TooltipMakerAPI info, String after, float \u5929, Color c) {
        this.addDays(info, after, \u5929, c, 0.0f);
    }

    protected void addDays(TooltipMakerAPI info, String after, float \u5929, Color c, float pad) {
        String pre = "";
        if (info.getBulletedListPrefix() != null) {
            pre = "";
        }
        int d = Math.round(\u5929);
        String daysStr = "\u5929";
        if (d <= 1) {
            d = 1;
            daysStr = "\u5929";
        }
        if (c == null) {
            c = Misc.getGrayColor();
        }
        info.addPara(String.valueOf(pre) + "%s " + daysStr + " " + after, pad, c, Misc.getHighlightColor(), "" + d);
    }

    protected String getDays(float \u5929) {
        return "" + Math.round(\u5929);
    }

    public static String getDaysString(float \u5929) {
        int d = Math.round(\u5929);
        String daysStr = "\u5929";
        if (d == 1) {
            d = 1;
            daysStr = "\u5929";
        }
        return daysStr;
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    public Color getTitleColor(IntelInfoPlugin.ListInfoMode mode) {
        boolean isUpdate;
        boolean bl = isUpdate = this.getListInfoParam() != null;
        if (this.isEnding() && !isUpdate && mode != IntelInfoPlugin.ListInfoMode.IN_DESC) {
            return Misc.getGrayColor();
        }
        return Global.getSector().getPlayerFaction().getBaseUIColor();
    }

    protected Color getBulletColorForMode(IntelInfoPlugin.ListInfoMode mode) {
        Color tc = Misc.getTextColor();
        Color g = Misc.getGrayColor();
        switch (mode) {
            case INTEL: {
                return g;
            }
            case MAP_TOOLTIP: {
                return tc;
            }
            case IN_DESC: {
                return tc;
            }
            case MESSAGES: {
                return tc;
            }
        }
        return g;
    }

    @Override
    public boolean callEvent(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        return false;
    }

    public static String getSoundStandardPosting() {
        return "ui_intel_something_posted";
    }

    public static String getSoundStandardUpdate() {
        return "ui_intel_update";
    }

    public static String getSoundMajorPosting() {
        return "ui_intel_major_posted";
    }

    public static String getSoundColonyThreat() {
        return "colony_threat";
    }

    public static String getSoundLogUpdate() {
        return "ui_intel_log_update";
    }

    public static String getSoundMinorMessage() {
        return "ui_intel_minor_message";
    }

    @Override
    public List<IntelInfoPlugin.ArrowData> getArrowData(SectorMapAPI map) {
        return null;
    }

    @Override
    public float getTimeRemainingFraction() {
        return 0.0f;
    }

    public ButtonAPI addGenericButton(TooltipMakerAPI info, float width, String text, Object data) {
        return this.addGenericButton(info, width, this.getFactionForUIColors().getBaseUIColor(), this.getFactionForUIColors().getDarkUIColor(), text, data);
    }

    public ButtonAPI addGenericButton(TooltipMakerAPI info, float width, Color tc, Color bg, String text, Object data) {
        float opad = 10.0f;
        ButtonAPI button = info.addButton(text, data, tc, bg, (int)width, 20.0f, opad * 2.0f);
        return button;
    }

    @Override
    public boolean forceAddNextFrame() {
        return this.forceAdd != null;
    }

    @Override
    public void setForceAddNextFrame(boolean add) {
        this.forceAdd = add ? Boolean.valueOf(true) : null;
    }

    public static void addMarketToList(TooltipMakerAPI info, MarketAPI market, float pad) {
        BaseIntelPlugin.addMarketToList(info, market, pad, null);
    }

    public static void addMarketToList(TooltipMakerAPI info, MarketAPI market, float pad, Color tc) {
        if (tc == null) {
            tc = Misc.getTextColor();
        }
        String indent = INDENT;
        if (info.getBulletedListPrefix() != null) {
            indent = "";
        }
        LabelAPI label = info.addPara(String.valueOf(indent) + market.getName() + " (\u89c4\u6a21\u4e3a %s, %s \u6b96\u6c11\u5730)", pad, tc, market.getFaction().getBaseUIColor(), "" + market.getSize(), market.getFaction().getDisplayName());
        label.setHighlight("" + market.getSize(), market.getFaction().getDisplayName());
        label.setHighlightColors(Misc.getHighlightColor(), market.getFaction().getBaseUIColor());
    }

    public static void addMarketTable(TooltipMakerAPI info, Color base, Color dark, Color bright, List<MarketAPI> markets, float width, float pad) {
        Color h = Misc.getHighlightColor();
        FactionAPI f = Global.getSector().getPlayerFaction();
        info.beginTable(base, dark, bright, 20.0f, "\u6b96\u6c11\u5730", Float.valueOf(130.0f), "\u52bf\u529b", Float.valueOf(130.0f), "\u89c4\u6a21", Float.valueOf(width - 260.0f));
        for (MarketAPI market : markets) {
            info.addRow(market.getFaction().getBaseUIColor(), market.getName(), market.getFaction().getBaseUIColor(), market.getFaction().getDisplayName(), h, "" + market.getSize());
        }
        info.addTable("\u65e0", 0, pad);
        info.addSpacer(5.0f);
    }

    @Override
    public StoryPointActionDelegate getButtonStoryPointActionDelegate(Object buttonId) {
        return null;
    }

    @Override
    public void storyActionConfirmed(Object buttonId, IntelUIAPI ui) {
    }

    @Override
    public Color getCircleBorderColorOverride() {
        return null;
    }

    @Override
    public void tableRowClicked(IntelUIAPI ui, IntelInfoPlugin.TableRowClickData data) {
    }
}

