/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.ReputationActionResponsePlugin;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.ui.ButtonAPI;
import com.fs.starfarer.api.ui.IntelUIAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseMissionIntel
extends BaseIntelPlugin {
    public static String BUTTON_ACCEPT = "\u63a5\u53d7";
    public static String BUTTON_ABANDON = "\u653e\u5f03";
    protected IntervalUtil randomCancel = null;
    protected Float randomCancelProb = null;
    protected MissionResult missionResult;
    protected MissionState missionState = MissionState.POSTED;
    protected Float duration = null;
    protected float elapsedDays = 0.0f;

    protected void initRandomCancel() {
        this.initRandomCancel(0.5f);
    }

    protected void initRandomCancel(float prob) {
        this.randomCancel = new IntervalUtil(4.0f, 6.0f);
        this.randomCancelProb = Float.valueOf(prob);
    }

    protected void cancel() {
        this.setMissionState(MissionState.CANCELLED);
        this.missionResult = this.createCancelledResult();
        this.endMission();
        this.sendUpdateIfPlayerHasIntel((Object)this.missionResult, true);
    }

    @Override
    public void advanceImpl(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        if (this.isPosted()) {
            if (this.randomCancel != null) {
                this.randomCancel.advance(days);
                if (this.randomCancel.intervalElapsed() && (float)Math.random() < this.randomCancelProb.floatValue()) {
                    this.cancel();
                }
            }
            return;
        }
        this.elapsedDays += days;
        if (this.duration != null && this.duration.floatValue() - this.elapsedDays <= 0.0f) {
            this.setMissionState(MissionState.FAILED);
            this.missionResult = this.createTimeRanOutFailedResult();
            this.endMission();
            this.sendUpdateIfPlayerHasIntel((Object)this.missionResult, false);
            return;
        }
        this.advanceMission(amount);
    }

    @Override
    public float getTimeRemainingFraction() {
        if (!this.isAccepted() || this.duration == null) {
            return super.getTimeRemainingFraction();
        }
        float f = 1.0f - this.elapsedDays / this.duration.floatValue();
        return f;
    }

    public boolean isPosted() {
        return this.missionState == MissionState.POSTED;
    }

    public boolean isCancelled() {
        return this.missionState == MissionState.CANCELLED;
    }

    public boolean isFailed() {
        return this.missionState == MissionState.FAILED;
    }

    public boolean isCompleted() {
        return this.missionState == MissionState.COMPLETED;
    }

    public boolean isAccepted() {
        return this.missionState == MissionState.ACCEPTED;
    }

    public boolean isAbandoned() {
        return this.missionState == MissionState.ABANDONED;
    }

    public boolean canAbandonWithoutPenalty() {
        return this.elapsedDays < this.getNoPenaltyAbandonDays();
    }

    protected float getNoPenaltyAbandonDays() {
        return 1.0f;
    }

    @Override
    public String getImportantIcon() {
        if (this.isAccepted()) {
            return Global.getSettings().getSpriteName("intel", "important_accepted_mission");
        }
        return super.getImportantIcon();
    }

    public abstract void endMission();

    public abstract void advanceMission(float var1);

    public abstract void missionAccepted();

    protected abstract MissionResult createTimeRanOutFailedResult();

    protected abstract MissionResult createAbandonedResult(boolean var1);

    protected MissionResult createCancelledResult() {
        return new MissionResult();
    }

    protected String getMissionTypeNoun() {
        return "\u4efb\u52a1";
    }

    @Override
    public void buttonPressConfirmed(Object buttonId, IntelUIAPI ui) {
        if (buttonId == BUTTON_ACCEPT) {
            this.setImportant(true);
            this.setMissionState(MissionState.ACCEPTED);
            this.missionAccepted();
        } else if (buttonId == BUTTON_ABANDON) {
            this.setImportant(false);
            if (!this.canAbandonWithoutPenalty()) {
                this.setMissionState(MissionState.ABANDONED);
                this.missionResult = this.createAbandonedResult(true);
                this.endMission();
            } else {
                this.setMissionState(MissionState.ABANDONED);
                this.missionResult = this.createAbandonedResult(false);
                this.endMission();
            }
        }
        super.buttonPressConfirmed(buttonId, ui);
    }

    @Override
    public void createConfirmationPrompt(Object buttonId, TooltipMakerAPI prompt) {
        FactionAPI faction = this.getFactionForUIColors();
        if (buttonId == BUTTON_ACCEPT) {
            prompt.addPara("\u63a5\u53d7\u8be5 " + this.getMissionTypeNoun() + " \u4ee3\u8868\u7740\u4f60\u5df2\u7ecf\u4e0b\u5b9a\u51b3\u5fc3\u8981\u5b8c\u6210\u8fd9\u9879\u4f7f\u547d\uff0c" + "\u5982\u679c\u4e0d\u80fd\u5728\u89c4\u5b9a\u65f6\u95f4\u5185\u5b8c\u6210\uff0c\u5219\u4f1a\u964d\u4f4e\u4f60\u4e0e\u4efb\u52a1\u53d1\u5e03\u65b9\u4e4b\u95f4\u7684\u5173\u7cfb " + "- " + faction.getDisplayNameWithArticle() + ".", 0.0f, Misc.getTextColor(), faction.getBaseUIColor(), faction.getDisplayNameWithArticleWithoutArticle());
        } else if (buttonId == BUTTON_ABANDON) {
            if (this.canAbandonWithoutPenalty()) {
                prompt.addPara("\u7531\u4e8e\u8ddd\u63a5\u5230\u6b64\u4efb\u52a1\u624d\u8fc7\u53bb\u4e0d\u5230\u4e00\u5929\u7684\u65f6\u95f4\uff0c\u56e0\u6b64\u4f60\u5927\u53ef\u653e\u5f03\u8be5 " + this.getMissionTypeNoun() + " \u6765\u907f\u514d\u60e9\u7f5a\u3002", 0.0f);
            } else {
                prompt.addPara("\u4f60\u53ef\u4ee5\u653e\u5f03\u8be5 " + this.getMissionTypeNoun() + "\uff0c\u4f46\u5fc5\u5c06\u5f71\u54cd\u4f60\u4e0e\u4efb\u52a1\u53d1\u8d77\u65b9\u7684" + "\u5173\u7cfb - " + faction.getDisplayNameWithArticle() + ".", 0.0f, Misc.getTextColor(), faction.getBaseUIColor(), faction.getDisplayNameWithArticleWithoutArticle());
            }
        } else {
            super.createConfirmationPrompt(buttonId, prompt);
        }
    }

    @Override
    public boolean doesButtonHaveConfirmDialog(Object buttonId) {
        if (buttonId == BUTTON_ACCEPT || buttonId == BUTTON_ABANDON) {
            return true;
        }
        return super.doesButtonHaveConfirmDialog(buttonId);
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Missions");
        if (this.isAccepted() || this.isAbandoned() || this.isFailed() || this.isCompleted()) {
            tags.add("Accepted");
        }
        return tags;
    }

    protected void addGenericMissionState(TooltipMakerAPI info) {
        float opad = 10.0f;
        String noun = this.getMissionTypeNoun();
        if (this.isAccepted()) {
            info.addPara("\u4f60\u63a5\u53d7\u4e86\u8be5 " + noun + ".", opad);
        } else if (this.isFailed()) {
            info.addPara("\u4f60\u672a\u80fd\u5b8c\u6210\u8be5 " + noun + ".", opad);
        } else if (this.isCompleted()) {
            info.addPara("\u4f60\u5df2\u5b8c\u6210\u4e86\u8be5 " + noun + ".", opad);
        } else if (this.isCancelled()) {
            info.addPara("\u8be5 " + noun + " \u5df2\u88ab\u64a4\u9500\u3002", opad);
        } else if (this.isAbandoned()) {
            info.addPara("\u4f60\u653e\u5f03\u4e86\u8be5 " + noun + ".", opad);
        } else if (this.isPosted()) {
            info.addPara("\u8be5 " + noun + " \u4f1a\u5728\u4f60\u63a5\u53d7\u540e\u5927\u7ea6\u4e00\u4e2a\u5de5\u4f5c\u65e5\u5185\u6572\u5b9a\uff0c\u56e0\u6b64\u4f60\u5927\u53ef\u5728\u8fd9\u4e4b\u524d\u9009\u62e9\u653e\u5f03\uff0c\u4ee5\u89c4\u907f\u8fdd\u7ea6\u8d23\u4efb\u3002", Misc.getHighlightColor(), opad);
        }
    }

    public String getPostfixForState() {
        if (this.isEnding()) {
            if (this.isCompleted()) {
                return " - \u5b8c\u6210";
            }
            if (this.isFailed()) {
                return " - \u5931\u8d25";
            }
            if (this.isAbandoned()) {
                return " - \u653e\u5f03";
            }
            if (this.isCancelled()) {
                return " - \u64a4\u9500";
            }
            return " - \u7ed3\u675f";
        }
        return "";
    }

    protected void addAcceptOrAbandonButton(TooltipMakerAPI info, float width) {
        this.addAcceptOrAbandonButton(info, width, "\u63a5\u53d7", "\u653e\u5f03");
    }

    protected void addAcceptOrAbandonButton(TooltipMakerAPI info, float width, String accept, String abandon) {
        if (this.isPosted()) {
            this.addAcceptButton(info, width, accept);
        } else if (this.isAccepted()) {
            this.addAbandonButton(info, width, abandon);
        }
    }

    protected void addAcceptButton(TooltipMakerAPI info, float width) {
        this.addAcceptButton(info, width, "\u63a5\u53d7");
    }

    protected void addAcceptButton(TooltipMakerAPI info, float width, String accept) {
        float opad = 10.0f;
        ButtonAPI button = info.addButton(accept, BUTTON_ACCEPT, this.getFactionForUIColors().getBaseUIColor(), this.getFactionForUIColors().getDarkUIColor(), (int)width, 20.0f, opad * 2.0f);
        button.setShortcut(20, true);
    }

    protected void addAbandonButton(TooltipMakerAPI info, float width) {
        this.addAbandonButton(info, width, "\u653e\u5f03");
    }

    protected void addAbandonButton(TooltipMakerAPI info, float width, String abandon) {
        float opad = 10.0f;
        ButtonAPI button = info.addButton(abandon, BUTTON_ABANDON, this.getFactionForUIColors().getBaseUIColor(), this.getFactionForUIColors().getDarkUIColor(), (int)width, 20.0f, opad * 2.0f);
        button.setShortcut(22, true);
    }

    public MissionResult getMissionResult() {
        return this.missionResult;
    }

    public void setMissionResult(MissionResult missionResult) {
        this.missionResult = missionResult;
    }

    public MissionState getMissionState() {
        return this.missionState;
    }

    public void setMissionState(MissionState missionState) {
        this.missionState = missionState;
    }

    public Float getDuration() {
        return this.duration;
    }

    public void setDuration(Float duration) {
        this.duration = duration;
    }

    public float getElapsedDays() {
        return this.elapsedDays;
    }

    public void setElapsedDays(float elapsedDays) {
        this.elapsedDays = elapsedDays;
    }

    @Override
    public boolean shouldRemoveIntel() {
        if (this.timestamp == null && this.isEnding()) {
            return true;
        }
        return this.isEnded();
    }

    public static class MissionResult {
        public int payment;
        public ReputationActionResponsePlugin.ReputationAdjustmentResult rep1;
        public ReputationActionResponsePlugin.ReputationAdjustmentResult rep2;
        public Object custom;

        public MissionResult() {
        }

        public MissionResult(int payment, ReputationActionResponsePlugin.ReputationAdjustmentResult rep1) {
            this(payment, rep1, null);
        }

        public MissionResult(int payment, ReputationActionResponsePlugin.ReputationAdjustmentResult rep1, ReputationActionResponsePlugin.ReputationAdjustmentResult rep2) {
            this.payment = payment;
            this.rep1 = rep1;
            this.rep2 = rep2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MissionState {
        POSTED,
        CANCELLED,
        FAILED,
        ACCEPTED,
        ABANDONED,
        COMPLETED;

    }
}

