/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.intel.FactionHostilityManager;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Random;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactionHostilityIntel
extends BaseIntelPlugin {
    public static Logger log = Global.getLogger(FactionHostilityIntel.class);
    public static final float MIN_DAYS = 180.0f;
    public static final float CHECK_INTERVAL = 60.0f;
    public static final float END_PROB = 0.25f;
    protected FactionAPI one;
    protected FactionAPI two;
    protected String id;
    protected float daysUntilCheck;
    protected float initialRelationship;
    protected Random random = new Random();

    public FactionHostilityIntel(FactionAPI one, FactionAPI two) {
        FactionAPI temp = two;
        if (one.getDisplayName().compareTo(two.getDisplayName()) > 0) {
            two = one;
            one = temp;
        }
        this.one = one;
        this.two = two;
        this.id = FactionHostilityManager.getConflictId(one, two);
        log.info((Object)String.format("\u8fdb\u5165\u6218\u4e89\u72b6\u6001\uff1a%s <-> %s", one.getDisplayName(), two.getDisplayName()));
        this.initialRelationship = one.getRelationship(two.getId());
        one.setRelationship(two.getId(), RepLevel.HOSTILE);
        this.daysUntilCheck = 180.0f;
        Global.getSector().getIntelManager().addIntel(this);
    }

    public void endHostilties() {
        log.info((Object)String.format("\u7ed3\u675f\u6218\u4e89\u72b6\u6001\uff1a%s <-> %s", this.one.getDisplayName(), this.two.getDisplayName()));
        FactionHostilityManager.getInstance().notifyRecentlyEnded(this.id);
        this.one.setRelationship(this.two.getId(), this.initialRelationship);
        this.endAfterDelay();
        this.sendUpdateIfPlayerHasIntel(new Object(), false);
    }

    @Override
    protected void advanceImpl(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        this.daysUntilCheck -= days;
        if (this.daysUntilCheck <= 0.0f) {
            this.daysUntilCheck = 60.0f * (0.5f + 1.0f * this.random.nextFloat());
            if (this.random.nextFloat() < 0.25f) {
                this.endHostilties();
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public FactionAPI getOne() {
        return this.one;
    }

    public FactionAPI getTwo() {
        return this.two;
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        info.addPara(this.one.getDisplayName(), 0.0f, tc, this.one.getBaseUIColor(), this.one.getDisplayName());
        info.addPara(this.two.getDisplayName(), 0.0f, tc, this.two.getBaseUIColor(), this.two.getDisplayName());
        this.unindent(info);
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color c = this.getTitleColor(mode);
        float pad = 3.0f;
        float opad = 10.0f;
        info.addPara(this.getName(), c, 0.0f);
        this.addBulletPoints(info, mode);
    }

    @Override
    public String getSortString() {
        return "\u654c\u5bf9\u6d3b\u52a8";
    }

    @Override
    public String getName() {
        String base = "\u654c\u5bf9\u6d3b\u52a8";
        if (this.isEnding()) {
            if (this.isSendingUpdate()) {
                return String.valueOf(base) + " \u7ed3\u675f";
            }
            return String.valueOf(base) + " (\u7ed3\u675f) ";
        }
        return base;
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return Global.getSector().getPlayerFaction();
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        info.addImages(width, 128.0f, opad, opad, this.one.getCrest(), this.two.getCrest());
        if (this.isEnding()) {
            LabelAPI label = info.addPara("- " + this.one.getDisplayNameWithArticle() + " \u548c " + this.two.getDisplayNameWithArticle() + " \u53cc\u65b9\u538c\u5026\u4e86\u65f7\u65e5\u6301\u4e45\u7684\u62c9\u952f\u6218\uff0c\u800c\u5728\u6700\u8fd1\u9009\u62e9\u7b7e\u8ba2\u505c\u6218\u534f\u8bae\u4ee5\u7ec8\u6b62\u8fd9\u573a\u7eb7\u4e89\u3002", opad);
            label.setHighlight(this.one.getDisplayNameWithArticleWithoutArticle(), this.two.getDisplayNameWithArticleWithoutArticle());
            label.setHighlightColors(this.one.getBaseUIColor(), this.two.getBaseUIColor());
        } else {
            LabelAPI label = info.addPara("- " + this.one.getDisplayNameWithArticle() + " \u548c " + this.two.getDisplayNameWithArticle() + " \u4e4b\u95f4\u84c4\u52bf\u5df2\u4e45\u7684\u7d27\u5f20\u5c40\u52bf\uff0c\u7ec8\u4e8e\u6f14\u53d8\u6210\u4e86\u516c\u5f00\u4ea4\u6218\u3002", opad);
            label.setHighlight(this.one.getDisplayNameWithArticleWithoutArticle(), this.two.getDisplayNameWithArticleWithoutArticle());
            label.setHighlightColors(this.one.getBaseUIColor(), this.two.getBaseUIColor());
        }
    }

    @Override
    public String getIcon() {
        return Global.getSettings().getSpriteName("intel", "hostilities");
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("\u654c\u5bf9\u6d3b\u52a8");
        tags.add(this.one.getId());
        tags.add(this.two.getId());
        return tags;
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        return null;
    }
}

