/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.ReputationActionResponsePlugin;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.ids.People;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.intel.PerseanLeagueMembership;
import com.fs.starfarer.api.impl.campaign.intel.events.PerseanLeagueHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.missions.DelayedFleetEncounter;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Random;
import java.util.Set;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GensHannanMachinations
extends BaseIntelPlugin {
    public static String AGREED_TO_PAY_HOUSE_HANNAN_AGAIN = "$agreedToPayHouseHannanAgain";
    public static String MACHINATIONS_IN_EFFECT = "$houseHannanMachinationsInEffect";
    public static String KEY = "$plGHMachinations_ref";
    public static String UPDATE_PARAM_START = "update_param_start";
    public static String UPDATE_PARAM_MACHINATION = "update_param_machination";
    public static float PROB_ACTION_TAKEN = 0.5f;
    public static float PROB_BOUNTY_HUNTER = 0.25f;
    protected FactionAPI faction = null;
    protected IntervalUtil interval = new IntervalUtil(10.0f, 110.0f);
    protected Random random = new Random();
    protected int repDamageRemaining = 100;
    protected ReputationActionResponsePlugin.ReputationAdjustmentResult recent = null;
    protected boolean recentIsBountyHunter = false;
    protected long recentTimestamp = 0L;

    public static boolean isMachinationsInEffect() {
        return Global.getSector().getMemoryWithoutUpdate().getBoolean(MACHINATIONS_IN_EFFECT);
    }

    public static boolean isAgreedToPayHouseHannanAgain() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getBoolean(AGREED_TO_PAY_HOUSE_HANNAN_AGAIN);
    }

    public static void setAgreedToPayHouseHannanAgain(boolean value) {
        Global.getSector().getPlayerMemoryWithoutUpdate().set(AGREED_TO_PAY_HOUSE_HANNAN_AGAIN, value);
        if (!value) {
            Global.getSector().getPlayerMemoryWithoutUpdate().unset(AGREED_TO_PAY_HOUSE_HANNAN_AGAIN);
        }
    }

    public static boolean canRemakeDealWithHouseHannan() {
        return !GensHannanMachinations.isAgreedToPayHouseHannanAgain() && PerseanLeagueMembership.isLeagueMember() && GensHannanMachinations.isMachinationsInEffect() && !PerseanLeagueMembership.isPayingHouseHannan();
    }

    public static GensHannanMachinations get() {
        return (GensHannanMachinations)Global.getSector().getMemoryWithoutUpdate().get(KEY);
    }

    public GensHannanMachinations(InteractionDialogAPI dialog) {
        if (GensHannanMachinations.get() != null) {
            return;
        }
        this.faction = Global.getSector().getFaction("persean");
        this.setImportant(true);
        TextPanelAPI text = null;
        if (dialog != null) {
            text = dialog.getTextPanel();
        }
        Global.getSector().addScript(this);
        Global.getSector().getMemoryWithoutUpdate().set(KEY, this);
        Global.getSector().getMemoryWithoutUpdate().set(MACHINATIONS_IN_EFFECT, true);
        Global.getSector().getIntelManager().addIntel(this, true);
        this.sendUpdateIfPlayerHasIntel((Object)dialog, text);
    }

    @Override
    protected void advanceImpl(float amount) {
        super.advanceImpl(amount);
        if (this.isEnded() || this.isEnding()) {
            return;
        }
        float \u5929 = Misc.getDays(amount);
        this.interval.advance(\u5929);
        if (!this.interval.intervalElapsed()) {
            return;
        }
        if (PerseanLeagueHostileActivityFactor.getKazeron(false) == null) {
            this.setImportant(false);
            this.endAfterDelay();
            return;
        }
        if (this.random.nextFloat() > PROB_ACTION_TAKEN) {
            return;
        }
        if (GensHannanMachinations.isAgreedToPayHouseHannanAgain() && this.random.nextFloat() < PROB_BOUNTY_HUNTER) {
            this.sendBountyHunter();
            return;
        }
        int repLoss = 5 + this.random.nextInt(11);
        repLoss = Math.min(repLoss, this.repDamageRemaining);
        RepLevel limit = RepLevel.NEUTRAL;
        if (GensHannanMachinations.isAgreedToPayHouseHannanAgain()) {
            limit = RepLevel.VENGEFUL;
        }
        ReputationActionResponsePlugin.ReputationAdjustmentResult result = Misc.adjustRep("persean", (float)repLoss * -0.01f, limit, null, false, false);
        if ((repLoss = Math.min(repLoss, Math.abs(Math.round(result.delta * 100.0f)))) > 0) {
            this.repDamageRemaining -= Math.abs(repLoss);
            this.recent = result;
            this.recentTimestamp = Global.getSector().getClock().getTimestamp();
            this.recentIsBountyHunter = false;
            this.sendUpdateIfPlayerHasIntel((Object)UPDATE_PARAM_MACHINATION, false);
        }
        if ((float)this.repDamageRemaining <= 0.0f) {
            this.setImportant(false);
            this.endAfterDelay();
        }
    }

    protected void sendBountyHunter() {
        this.recent = new ReputationActionResponsePlugin.ReputationAdjustmentResult(0.0f);
        this.recentTimestamp = Global.getSector().getClock().getTimestamp();
        this.recentIsBountyHunter = true;
        DelayedFleetEncounter e = new DelayedFleetEncounter(this.random, "GensHannanMachinations");
        e.setDelayShort();
        e.setLocationInnerSector(true, "independent");
        e.beginCreate();
        e.triggerCreateFleet(HubMissionWithTriggers.FleetSize.HUGE, HubMissionWithTriggers.FleetQuality.SMOD_1, "persean", "mercBountyHunter", new Vector2f());
        e.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.MORE, HubMissionWithTriggers.OfficerQuality.HIGHER);
        e.triggerSetFleetFaction("independent");
        e.triggerMakeNoRepImpact();
        e.triggerSetStandardAggroInterceptFlags();
        e.triggerMakeFleetIgnoreOtherFleets();
        e.triggerSetFleetGenericHailPermanent("GensHannanMachinationsHail");
        e.endCreate();
        this.sendUpdateIfPlayerHasIntel((Object)UPDATE_PARAM_MACHINATION, false);
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
        Global.getSector().getMemoryWithoutUpdate().unset(KEY);
        Global.getSector().getMemoryWithoutUpdate().unset(MACHINATIONS_IN_EFFECT);
    }

    @Override
    protected void notifyEnded() {
        Global.getSector().removeScript(this);
        super.notifyEnded();
    }

    protected Object readResolve() {
        return this;
    }

    public String getBaseName() {
        return "Hannan \u6c0f\u65cf \u7684\u4f5c\u4e3a";
    }

    @Override
    public String getName() {
        String postfix = "";
        return String.valueOf(this.getBaseName()) + postfix;
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return this.faction;
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        boolean isUpdate;
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        boolean bl = isUpdate = this.getListInfoParam() != null;
        if (this.recent != null) {
            int \u5929 = (int)Global.getSector().getClock().getElapsedDaysSince(this.recentTimestamp);
            if ((float)\u5929 > 60.0f) {
                this.recentTimestamp = 0L;
                this.recent = null;
                this.recentIsBountyHunter = false;
            } else if (this.recentIsBountyHunter) {
                info.addPara("\u4e00\u961f\u8d4f\u91d1\u730e\u4eba\u6700\u8fd1\u5df2\u88ab\u96c7\u4f63\u4ee5\u6b7c\u706d\u4f60", tc, initPad);
            } else {
                CoreReputationPlugin.addAdjustmentMessage(this.recent.delta, this.faction, null, null, null, info, tc, isUpdate, initPad);
                if (!isUpdate) {
                    String daysStr = \u5929 == 1 ? "\u5929" : "\u5929";
                    info.addPara("%s " + daysStr + "\u524d", 0.0f, tc, h, "" + \u5929);
                }
            }
        }
        this.unindent(info);
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        info.addImage(this.getFaction().getLogo(), width, 128.0f, opad);
        info.addPara("\u4f60\u8fdd\u80cc\u4e86\u4e0e Hannan \u6c0f\u65cf \u7684\u534f\u8bae\uff0c\u4ed6\u4eec\u5c06\u5728\u6697\u5904\u635f\u5bb3\u4f60\u4e0e \u82f1\u4ed9\u5ea7\u8054\u76df \u7684\u5173\u7cfb\uff0c\u751a\u81f3\u53ef\u80fd\u5bfc\u81f4\u66f4\u7cdf\u7684\u4e8b\u4ef6\u53d1\u751f\u3002", opad, this.getFaction().getBaseUIColor(), "\u82f1\u4ed9\u5ea7\u8054\u76df");
        if (this.isEnding() || this.isEnded()) {
            info.addPara("\u4f60\u7684\u6d88\u606f\u6765\u6e90\u8868\u660e\uff0cHannan \u6c0f\u65cf \u76ee\u524d\u4e0d\u592a\u53ef\u80fd\u91c7\u53d6\u8fdb\u4e00\u6b65\u884c\u52a8\u3002", opad);
        } else {
            PersonAPI person;
            info.addPara("\u4e5f\u8bb8\u5728\u4ee5\u540e\uff0c\u8fd9\u9879\u4e8b\u52a1\u5c06\u4e0d\u518d\u91cd\u8981\uff0c\u4f46\u5c31\u76ee\u524d\u800c\u8a00\uff0c\u4ed6\u4eec\u7684\u7279\u5de5\u5c06\u4ee5\u96be\u80fd\u53ef\u8d35\u7684\u6fc0\u60c5\u4e0e\u8c28\u614e\u6765\u7834\u574f\u4f60\u7684\u58f0\u8a89\u3002", opad);
            if (GensHannanMachinations.isAgreedToPayHouseHannanAgain()) {
                info.addPara("\u5df2\u7ecf\u6ca1\u6709\u4efb\u4f55\u548c\u89e3\u7684\u53ef\u80fd\uff0c\u8be5\u6253\u5f00\u5929\u7a97\u8bf4\u4eae\u8bdd\u4e86\u3002\u4f60\u5c06\u53ef\u80fd \u4e0e\u82f1\u4ed9\u5ea7\u8054\u76df\u516c\u5f00\u654c\u5bf9 \uff0c\u4ed6\u4eec\u4e5f\u53ef\u80fd\u96c7\u4f63\u5168\u526f\u6b66\u88c5\u7684 \u8d4f\u91d1\u730e\u4eba \u88ad\u51fb\u4f60\u3002", opad, Misc.getNegativeHighlightColor(), "\u4e0e\u82f1\u4ed9\u5ea7\u8054\u76df\u516c\u5f00\u654c\u5bf9", "\u8d4f\u91d1\u730e\u4eba");
            } else if (!GensHannanMachinations.canRemakeDealWithHouseHannan()) {
                info.addPara("\u4f60\u88ab\u8ba4\u4e3a\u4e0d\u503c\u5f97\u4fe1\u4efb\uff0c\u56e0\u6b64\u65e0\u6cd5\u518d\u6b21\u4e0e Hannan \u6c0f\u65cf \u6c9f\u901a\uff0c\u4e14\u88ab\u4f5c\u4e3a\u6740\u9e21\u5106\u7334\u7684\u4f8b\u5b50\u3002", opad);
            } else if (this.getMapLocation(null) != null && (person = People.getPerson(People.REYNARD_HANNAN)) != null) {
                TooltipMakerAPI sub = info.beginImageWithText(person.getPortraitSprite(), 64.0f);
                sub.addPara("\u4f60\u53ef\u4ee5\u524d\u5f80 Kazeron \u4e0e Reynard Hannan \u8c08\u5224 \u4ee5\u7ed3\u675f\u8fd9\u4e00\u5207\u3002", 0.0f, h, "\u4e0e Reynard Hannan \u8c08\u5224");
                info.addImageWithText(opad);
            }
        }
        if (this.recent != null) {
            info.addSectionHeading("\u8fd1\u671f\u4e8b\u4ef6", this.getFaction().getBaseUIColor(), this.getFaction().getDarkUIColor(), Alignment.MID, opad);
            this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
        }
    }

    @Override
    public String getIcon() {
        return this.faction.getCrest();
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add(this.faction.getId());
        return tags;
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        MarketAPI kazeron = PerseanLeagueHostileActivityFactor.getKazeron(false);
        if (kazeron != null) {
            return kazeron.getPrimaryEntity();
        }
        return null;
    }

    public FactionAPI getFaction() {
        return this.faction;
    }

    public void endMachinations(TextPanelAPI text) {
        if (!this.isEnded() && !this.isEnding()) {
            this.setImportant(false);
            this.endImmediately();
        }
    }
}

