/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.intel.events.LuddicChurchHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.rulecmd.HA_CMD;
import com.fs.starfarer.api.ui.ButtonAPI;
import com.fs.starfarer.api.ui.IntelUIAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuddicChurchImmigrationDeal
extends BaseIntelPlugin {
    public static float REP_FOR_BREAKING_DEAL = 0.25f;
    public static String KEY = "$luddicChurchDeal_ref";
    public static String BUTTON_END = "End";
    public static String UPDATE_PARAM_ACCEPTED = "update_param_accepted";
    protected FactionAPI faction = Global.getSector().getFaction("luddic_church");
    protected AgreementEndingType endType = null;

    public static LuddicChurchImmigrationDeal get() {
        return (LuddicChurchImmigrationDeal)Global.getSector().getMemoryWithoutUpdate().get(KEY);
    }

    public LuddicChurchImmigrationDeal(InteractionDialogAPI dialog) {
        this.setImportant(true);
        LuddicChurchHostileActivityFactor.setMadeDeal(true);
        TextPanelAPI text = null;
        if (dialog != null) {
            text = dialog.getTextPanel();
        }
        Global.getSector().getMemoryWithoutUpdate().set(KEY, this);
        Global.getSector().getIntelManager().addIntel(this, true);
        this.sendUpdate(UPDATE_PARAM_ACCEPTED, text);
        HA_CMD.avertOrEndKOLTakeoverAsNecessary();
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
        LuddicChurchHostileActivityFactor.setMadeDeal(false);
        Global.getSector().getMemoryWithoutUpdate().unset(KEY);
    }

    @Override
    protected void notifyEnded() {
        super.notifyEnded();
    }

    protected Object readResolve() {
        return this;
    }

    public String getBaseName() {
        return "\u5362\u5fb7\u6559\u4f1a\u79fb\u6c11\u7ba1\u5236";
    }

    public String getAcceptedPostfix() {
        return "Accepted";
    }

    public String getBrokenPostfix() {
        return "\u5df2\u7ed3\u675f";
    }

    @Override
    public String getName() {
        String postfix = "";
        if (this.isEnding() && this.endType != null) {
            switch (this.endType) {
                case BROKEN: {
                    postfix = " - " + this.getBrokenPostfix();
                }
            }
        }
        if (this.isSendingUpdate() && this.getListInfoParam() == UPDATE_PARAM_ACCEPTED) {
            postfix = " - " + this.getAcceptedPostfix();
        }
        return String.valueOf(this.getBaseName()) + postfix;
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return this.faction;
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        boolean isUpdate = this.getListInfoParam() != null;
        this.unindent(info);
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        info.addImage(this.getFaction().getLogo(), width, 128.0f, opad);
        if (this.isEnding() || this.isEnded()) {
            info.addPara("\u4f60\u4e0d\u518d\u9075\u5b88\u4e0e\u5362\u5fb7\u6559\u4f1a\u7684\u534f\u8bae\u3002", opad);
            return;
        }
        info.addPara("\u4f60\u5df2\u4e0e \u5362\u5fb7\u6559\u4f1a \u8fbe\u6210\u534f\u8bae\uff0c\u4e0d\u518d\u4ece\u4ed6\u4eec\u7684\u4e16\u754c\u5927\u91cf\u63a5\u6536\u79fb\u6c11\u3002\u800c\u76f8\u5e94\u5730\uff0c\u5362\u5fb7\u9a91\u58eb\u56e2 \u7684 \"\u4fdd\u62a4\u8005\" \u8230\u961f\u5c06\u4e0d\u518d\u4e8e\u4f60\u7684\u9886\u5730\u9644\u8fd1\u884c\u52a8\u3002", opad, this.faction.getBaseUIColor(), "\u5362\u5fb7\u6559\u4f1a", "\u5362\u5fb7\u9a91\u58eb\u56e2");
        info.addPara("\u4f60\u53ef\u4ee5\u7ec8\u6b62\u8fd9\u9879\u534f\u8bae\uff0c\u4f46\u5728\u4f5c\u51fa\u8fd9\u79cd\u80cc\u4fe1\u5f03\u4e49\u7684\u884c\u4e3a\u4e4b\u540e\uff0c\u5c31\u4e0d\u53ef\u80fd\u91cd\u65b0\u7b7e\u8ba2\u7c7b\u4f3c\u7684\u534f\u8bae\u3002", opad);
        ButtonAPI button = info.addButton("\u4e2d\u6b62\u534f\u8bae", BUTTON_END, this.getFactionForUIColors().getBaseUIColor(), this.getFactionForUIColors().getDarkUIColor(), (int)width, 20.0f, opad * 1.0f);
        button.setShortcut(22, true);
    }

    @Override
    public String getIcon() {
        return this.faction.getCrest();
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Agreements");
        tags.add(this.faction.getId());
        return tags;
    }

    @Override
    public String getImportantIcon() {
        return Global.getSettings().getSpriteName("intel", "important_accepted_mission");
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        return null;
    }

    public FactionAPI getFaction() {
        return this.faction;
    }

    public void endAgreement(AgreementEndingType type, InteractionDialogAPI dialog) {
        if (!this.isEnded() && !this.isEnding()) {
            this.endType = type;
            this.setImportant(false);
            this.endImmediately();
            if (dialog != null) {
                this.sendUpdate(new Object(), dialog.getTextPanel());
            }
            if (type == AgreementEndingType.BROKEN) {
                LuddicChurchHostileActivityFactor.setBrokeDeal(true);
                Misc.incrUntrustwortyCount();
                TextPanelAPI text = dialog == null ? null : dialog.getTextPanel();
                Misc.adjustRep("luddic_church", -REP_FOR_BREAKING_DEAL, text);
            }
        }
    }

    @Override
    public void buttonPressConfirmed(Object buttonId, IntelUIAPI ui) {
        if (buttonId == BUTTON_END) {
            this.endAgreement(AgreementEndingType.BROKEN, null);
        }
        super.buttonPressConfirmed(buttonId, ui);
    }

    @Override
    public void createConfirmationPrompt(Object buttonId, TooltipMakerAPI prompt) {
        if (buttonId == BUTTON_END) {
            prompt.addPara("\u4f60\u53ef\u4ee5\u7ec8\u6b62\u8fd9\u9879\u534f\u8bae\uff0c\u4f46\u8fd9\u5c06\u635f\u4f24\u4f60\u4e0e %s \u7684\u5173\u7cfb\uff0c\u4e14\u5728\u4f5c\u51fa\u8fd9\u79cd\u80cc\u4fe1\u5f03\u4e49\u7684\u884c\u4e3a\u4e4b\u540e\uff0c\u5c31\u4e0d\u53ef\u80fd\u91cd\u65b0\u7b7e\u8ba2\u7c7b\u4f3c\u7684\u534f\u8bae\u3002", 0.0f, this.faction.getBaseUIColor(), this.faction.getDisplayName());
        }
    }

    @Override
    public boolean doesButtonHaveConfirmDialog(Object buttonId) {
        if (buttonId == BUTTON_END) {
            return true;
        }
        return super.doesButtonHaveConfirmDialog(buttonId);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AgreementEndingType {
        BROKEN;

    }
}

