/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MonthlyReport;
import com.fs.starfarer.api.campaign.listeners.CommissionEndedListener;
import com.fs.starfarer.api.campaign.listeners.EconomyTickListener;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.People;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.intel.FactionCommissionIntel;
import com.fs.starfarer.api.impl.campaign.intel.GensHannanMachinations;
import com.fs.starfarer.api.impl.campaign.intel.contacts.ContactIntel;
import com.fs.starfarer.api.impl.campaign.rulecmd.HA_CMD;
import com.fs.starfarer.api.impl.campaign.shared.SharedData;
import com.fs.starfarer.api.ui.ButtonAPI;
import com.fs.starfarer.api.ui.IntelUIAPI;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerseanLeagueMembership
extends BaseIntelPlugin
implements EconomyTickListener,
CommissionEndedListener {
    public static int TIMES_LEFT_LEAGUE_FOR_NO_REJOIN = 2;
    public static final String PL_MEMBERSHIP_GOOD_DEAL = "$hasGoodPLMembershipDeal";
    public static final String PAYING_HOUSE_HANNAN = "$payingHouseHannan";
    public static final String LEFT_LEAGUE_WHEN_GOOD_DEAL = "$leftLeagueWhenGoodDeal";
    public static final String IS_LEAGUE_MEMBER = "$isLeagueMember";
    public static final String NUM_TIMES_LEFT_LEAGUE = "$numTimesLeftLeague";
    public static final String DEFEATED_BLOCKADE = "$defeatedLeagueBlockade";
    public static final String DEFEATED_PUN_EX = "$defeatedLeaguePunEx";
    public static String KEY = "$plMembership_ref";
    public static String BUTTON_END = "End";
    public static String BUTTON_RENEGE_HANNAN = "Renege Hannan";
    public static String UPDATE_PARAM_ACCEPTED = "update_param_accepted";
    protected FactionAPI faction = Global.getSector().getFaction("persean");
    protected AgreementEndingType endType = null;

    public static int getNumTimesLeftLeague() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getInt(NUM_TIMES_LEFT_LEAGUE);
    }

    public static void incrLeftLeagueCount() {
        int count = PerseanLeagueMembership.getNumTimesLeftLeague();
        Global.getSector().getPlayerMemoryWithoutUpdate().set(NUM_TIMES_LEFT_LEAGUE, count + 1);
    }

    public static boolean isDefeatedBlockadeOrPunEx() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getBoolean(DEFEATED_BLOCKADE) || Global.getSector().getPlayerMemoryWithoutUpdate().getBoolean(DEFEATED_PUN_EX);
    }

    public static void setDefeatedBlockade(boolean value) {
        Global.getSector().getPlayerMemoryWithoutUpdate().set(DEFEATED_BLOCKADE, value);
        if (!value) {
            Global.getSector().getPlayerMemoryWithoutUpdate().unset(DEFEATED_BLOCKADE);
        }
    }

    public static void setDefeatedPunEx(boolean value) {
        Global.getSector().getPlayerMemoryWithoutUpdate().set(DEFEATED_PUN_EX, value);
        if (!value) {
            Global.getSector().getPlayerMemoryWithoutUpdate().unset(DEFEATED_PUN_EX);
        }
    }

    public static boolean isGoodDeal() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getBoolean(PL_MEMBERSHIP_GOOD_DEAL);
    }

    public static boolean isPayingHouseHannan() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getBoolean(PAYING_HOUSE_HANNAN);
    }

    public static void setPayingHouseHannan(boolean value) {
        Global.getSector().getPlayerMemoryWithoutUpdate().set(PAYING_HOUSE_HANNAN, value);
        if (!value) {
            Global.getSector().getPlayerMemoryWithoutUpdate().unset(PAYING_HOUSE_HANNAN);
        }
    }

    public static boolean isLeftLeagueWhenGoodDeal() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getBoolean(LEFT_LEAGUE_WHEN_GOOD_DEAL);
    }

    public static void setLeftLeagueWhenGoodDeal(boolean value) {
        Global.getSector().getPlayerMemoryWithoutUpdate().set(LEFT_LEAGUE_WHEN_GOOD_DEAL, value);
        if (!value) {
            Global.getSector().getPlayerMemoryWithoutUpdate().unset(LEFT_LEAGUE_WHEN_GOOD_DEAL);
        }
    }

    public static boolean isLeagueMember() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getBoolean(IS_LEAGUE_MEMBER);
    }

    public static void setLeagueMember(boolean member) {
        Global.getSector().getPlayerMemoryWithoutUpdate().set(IS_LEAGUE_MEMBER, member);
    }

    public static PerseanLeagueMembership get() {
        return (PerseanLeagueMembership)Global.getSector().getMemoryWithoutUpdate().get(KEY);
    }

    public PerseanLeagueMembership(InteractionDialogAPI dialog) {
        this.setImportant(true);
        PerseanLeagueMembership.setLeagueMember(true);
        Global.getSector().getPlayerFaction().setSecondaryColorOverride(this.getFaction().getBaseUIColor());
        Global.getSector().getPlayerFaction().setSecondaryColorSegmentsOverride(8);
        TextPanelAPI text = null;
        if (dialog != null) {
            text = dialog.getTextPanel();
        }
        Global.getSector().getListenerManager().addListener(this);
        Global.getSector().getMemoryWithoutUpdate().set(KEY, this);
        Global.getSector().getIntelManager().addIntel(this, true);
        RepLevel level = this.faction.getRelToPlayer().getLevel();
        if (!level.isAtWorst(RepLevel.NEUTRAL)) {
            Misc.adjustRep("persean", 2.0f, RepLevel.NEUTRAL, text);
        }
        this.sendUpdate(UPDATE_PARAM_ACCEPTED, text);
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
        PerseanLeagueMembership.setLeagueMember(false);
        PerseanLeagueMembership.setLeftLeagueWhenGoodDeal(PerseanLeagueMembership.isGoodDeal());
        PerseanLeagueMembership.stopPayingHouseHannan(false, null);
        Global.getSector().getMemoryWithoutUpdate().unset(KEY);
        Global.getSector().getListenerManager().removeListener(this);
    }

    @Override
    protected void notifyEnded() {
        super.notifyEnded();
    }

    protected Object readResolve() {
        return this;
    }

    public String getBaseName() {
        return "\u82f1\u4ed9\u5ea7\u8054\u76df\u6210\u5458";
    }

    public String getAcceptedPostfix() {
        return "\u5df2\u63a5\u53d7";
    }

    public String getBrokenPostfix() {
        return "\u5df2\u5e9f\u9664";
    }

    public String getEndedPostfix() {
        return "\u5df2\u7ed3\u675f";
    }

    public String getExpiredPostfix() {
        return "\u5df2\u5931\u6548";
    }

    @Override
    public String getName() {
        String postfix = "";
        if (this.isEnding() && this.endType != null) {
            switch (this.endType) {
                case BROKEN: {
                    postfix = " - " + this.getBrokenPostfix();
                    break;
                }
                case ENDED: {
                    postfix = " - " + this.getEndedPostfix();
                    break;
                }
                case EXPIRED: {
                    postfix = " - " + this.getExpiredPostfix();
                }
            }
        }
        if (this.isSendingUpdate() && this.getListInfoParam() == UPDATE_PARAM_ACCEPTED) {
            postfix = " - " + this.getAcceptedPostfix();
        }
        return String.valueOf(this.getBaseName()) + postfix;
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return this.faction;
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        boolean isUpdate = this.getListInfoParam() != null;
        int perMonth = this.computeCreditsPerMonth();
        if (perMonth != 0 && !this.isEnded() && !this.isEnding()) {
            Color c = perMonth > 0 ? h : Misc.getNegativeHighlightColor();
            info.addPara("%s \u6bcf\u6708", initPad, tc, c, Misc.getDGSCredits(perMonth));
        }
        this.unindent(info);
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        ButtonAPI button;
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        Color c = this.faction.getBaseUIColor();
        info.addImage(this.getFaction().getLogo(), width, 128.0f, opad);
        if (this.isEnding() || this.isEnded()) {
            info.addPara("\u4f60\u4e0d\u518d\u662f \u82f1\u4ed9\u5ea7\u8054\u76df \u7684\u4e00\u5458\u3002", opad, c, "\u82f1\u4ed9\u5ea7\u8054\u76df");
            return;
        }
        if (PerseanLeagueMembership.isGoodDeal()) {
            info.addPara("\u4f60\u5904\u4e8e\u5f3a\u52bf\u5730\u4f4d\uff0c\u5e76\u901a\u8fc7\u8c08\u5224\u8fbe\u6210\u4e86\u4e00\u9879\u4f18\u5f85\u5f0f\u6210\u5458\u534f\u8bae\u3002\u82f1\u4ed9\u5ea7\u8054\u76df\u5c06\u5728\u661f\u9645\u653f\u6cbb\u4e0a\u652f\u6301\u4f60\uff0c\u4f8b\u5982\uff0c\u9738\u4e3b\u5c06\u65e0\u6cd5\u5408\u7406\u5730\u5728\u4f60\u9886\u5730\u5185\u8fdb\u884c AI \u5ba1\u67e5\u6d3b\u52a8\u3002", opad, c, "\u82f1\u4ed9\u5ea7\u8054\u76df");
            if (PerseanLeagueMembership.isPayingHouseHannan()) {
                info.addPara("\u534f\u8bae\u7684\u5185\u5bb9\u5305\u62ec\u4e86\u5bf9 Hannan \u6c0f\u65cf \u8fdb\u884c\u79c1\u4eba\u6350\u8d60\u7684\u6761\u4f8b\uff0c\u4f5c\u4e3a\u4fc3\u8fdb\u534f\u8bae\u7684\u5fc5\u8981\u8d39\u7528\u3002", opad);
                this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
                button = info.addButton("\u505c\u6b62\u652f\u4ed8\u8d39\u7528", BUTTON_RENEGE_HANNAN, this.getFactionForUIColors().getBaseUIColor(), this.getFactionForUIColors().getDarkUIColor(), (int)width, 20.0f, opad * 1.0f);
                button.setShortcut(34, true);
                info.addSpacer(opad);
            }
        } else {
            info.addPara("\u4f60\u52a0\u5165\u4e86\u82f1\u4ed9\u5ea7\u8054\u76df\uff0c\u5c3d\u7ba1\u6709\u4f20\u8a00\u8bf4\u4f60\u8fd9\u6837\u505a\u53ea\u662f\u4e3a\u4e86\u907f\u514d\u9a9a\u6270\uff0c\u800c\u4f60\u7684\u4f1a\u8d39\u53ea\u4e0d\u8fc7\u662f\u4fdd\u62a4\u8d39\u3002\u5373\u4f7f\u5982\u6b64\uff0c\u82f1\u4ed9\u5ea7\u8054\u76df\u4ecd\u5c06\u5728\u661f\u9645\u653f\u6cbb\u4e0a\u652f\u6301\u4f60\uff0c\u4f8b\u5982\uff0c\u9738\u4e3b\u5c06\u65e0\u6cd5\u5408\u7406\u5730\u5728\u4f60\u9886\u5730\u5185\u8fdb\u884c AI \u5ba1\u67e5\u6d3b\u52a8\u3002", opad, c, "\u82f1\u4ed9\u5ea7\u8054\u76df");
        }
        info.addPara("\u4f60\u7684\u82f1\u4ed9\u5ea7\u8054\u76df\u6210\u5458\u8eab\u4efd\u5efa\u7acb\u4e8e\u4e00\u4efd\u82f1\u4ed9\u5ea7\u8054\u76df\u96c7\u4f63\u534f\u8bae\u4e0a\u3002\u5982\u679c\u4f60\u89e3\u9664\u96c7\u4f63\u534f\u8bae\uff0c\u6216\u8005\u56e0\u4efb\u4f55\u5176\u4ed6\u539f\u56e0\u4f7f\u4e4b\u88ab\u5e9f\u9664\uff0c\u4f60\u7684\u6210\u5458\u8eab\u4efd\u4e5f\u5c06\u968f\u4e4b\u7ec8\u6b62\u3002", opad);
        if (this.computeCreditsPerMonth() != 0 && !PerseanLeagueMembership.isPayingHouseHannan()) {
            info.addPara("\u4f60\u9700\u8981\u4e3a\u82f1\u4ed9\u5ea7\u8054\u76df\u652f\u4ed8\u4f1a\u8d39\u3002", opad);
            this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
        }
        button = info.addButton("\u9000\u51fa\u82f1\u4ed9\u5ea7\u8054\u76df", BUTTON_END, this.getFactionForUIColors().getBaseUIColor(), this.getFactionForUIColors().getDarkUIColor(), (int)width, 20.0f, opad * 1.0f);
        button.setShortcut(22, true);
    }

    @Override
    public String getIcon() {
        return this.faction.getCrest();
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Agreements");
        tags.add(this.faction.getId());
        return tags;
    }

    @Override
    public String getImportantIcon() {
        return Global.getSettings().getSpriteName("intel", "important_accepted_mission");
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        return null;
    }

    @Override
    public void reportEconomyMonthEnd() {
    }

    @Override
    public void reportEconomyTick(int iterIndex) {
        int credits = PerseanLeagueMembership.computeCreditsPerTick();
        if (credits != 0) {
            MonthlyReport.FDNode node = this.getMonthlyReportNode();
            if (credits > 0) {
                node.income += (float)credits;
            } else if (credits < 0) {
                node.upkeep -= (float)credits;
            }
        }
    }

    public MonthlyReport.FDNode getMonthlyReportNode() {
        MonthlyReport report = SharedData.getData().getCurrentReport();
        MonthlyReport.FDNode marketsNode = report.getNode(MonthlyReport.OUTPOSTS);
        if (marketsNode.name == null) {
            marketsNode.name = "\u6b96\u6c11\u5730";
            marketsNode.custom = MonthlyReport.OUTPOSTS;
            marketsNode.tooltipCreator = report.getMonthlyReportTooltip();
        }
        MonthlyReport.FDNode paymentNode = report.getNode(marketsNode, "persean_league_membership");
        paymentNode.name = "\u82f1\u4ed9\u5ea7\u8054\u76df\u6210\u5458\u8d39\u7528";
        paymentNode.icon = this.faction.getCrest();
        if (paymentNode.tooltipCreator == null) {
            paymentNode.tooltipCreator = new TooltipMakerAPI.TooltipCreator(){

                public boolean isTooltipExpandable(Object tooltipParam) {
                    return false;
                }

                public float getTooltipWidth(Object tooltipParam) {
                    return 450.0f;
                }

                public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                    tooltip.addPara("\u4e3a\u4fdd\u6301\u4f60\u82f1\u4ed9\u5ea7\u8054\u76df\u6210\u5458\u8eab\u4efd\u6240\u9700\u7684\u6708\u5ea6\u5f00\u652f\u3002", 0.0f);
                }
            };
        }
        return paymentNode;
    }

    public int computeCreditsPerMonth() {
        int perTick = PerseanLeagueMembership.computeCreditsPerTick();
        float numIter = Global.getSettings().getFloat("economyIterPerMonth");
        return (int)((float)perTick * numIter);
    }

    public static int computeCreditsPerTick() {
        float numIter = Global.getSettings().getFloat("economyIterPerMonth");
        float f = 1.0f / numIter;
        int payment = 0;
        float feeFraction = Global.getSettings().getFloat("perseanLeagueFeeFraction");
        if (PerseanLeagueMembership.isGoodDeal()) {
            feeFraction = 0.0f;
        }
        if (PerseanLeagueMembership.isPayingHouseHannan()) {
            feeFraction += Global.getSettings().getFloat("houseHannanFeeFraction");
        }
        for (MarketAPI market : Misc.getPlayerMarkets(false)) {
            payment = (int)((float)payment + (float)((int)(market.getGrossIncome() * f)) * feeFraction);
        }
        return -payment;
    }

    public FactionAPI getFaction() {
        return this.faction;
    }

    public void endMembership(AgreementEndingType type, InteractionDialogAPI dialog) {
        if (!this.isEnded() && !this.isEnding()) {
            boolean baseMembership = !PerseanLeagueMembership.isGoodDeal();
            this.endType = type;
            this.setImportant(false);
            this.endImmediately();
            PerseanLeagueMembership.incrLeftLeagueCount();
            Global.getSector().getPlayerFaction().setSecondaryColorOverride(null);
            Global.getSector().getPlayerFaction().setSecondaryColorSegmentsOverride(0);
            if (dialog != null) {
                this.sendUpdate(new Object(), dialog.getTextPanel());
            }
            if (baseMembership) {
                HA_CMD.sendPerseanLeaguePunitiveExpedition(dialog);
            }
        }
    }

    public static void stopPayingHouseHannan(boolean trustBroken, InteractionDialogAPI dialog) {
        if (PerseanLeagueMembership.isPayingHouseHannan()) {
            PersonAPI reynard;
            TextPanelAPI text = null;
            if (dialog != null) {
                text = dialog.getTextPanel();
            }
            if ((reynard = People.getPerson(People.REYNARD_HANNAN)) != null) {
                Misc.adjustRep(reynard, -0.5f, text);
                ContactIntel.removeContact(reynard, dialog);
            }
            PerseanLeagueMembership.setPayingHouseHannan(false);
            new GensHannanMachinations(dialog);
            if (trustBroken) {
                Misc.incrUntrustwortyCount();
            }
        }
    }

    @Override
    public void buttonPressConfirmed(Object buttonId, IntelUIAPI ui) {
        if (buttonId == BUTTON_END) {
            this.endMembership(AgreementEndingType.ENDED, null);
        } else if (buttonId == BUTTON_RENEGE_HANNAN) {
            PerseanLeagueMembership.stopPayingHouseHannan(true, null);
        }
        super.buttonPressConfirmed(buttonId, ui);
    }

    @Override
    public void createConfirmationPrompt(Object buttonId, TooltipMakerAPI prompt) {
        FactionAPI faction = this.getFactionForUIColors();
        if (buttonId == BUTTON_END) {
            if (PerseanLeagueMembership.isGoodDeal()) {
                String extra = "";
                LabelAPI label = prompt.addPara("\u4f60\u5904\u4e8e\u5f3a\u52bf\u5730\u4f4d\uff0c\u5e76\u901a\u8fc7\u8c08\u5224\u8fbe\u6210\u4e86\u4e00\u9879\u4f18\u5f85\u5f0f\u6210\u5458\u534f\u8bae\u3002\u5982\u679c\u4f60\u9009\u62e9\u9000\u51fa\uff0c\u90a3\u4e48\u4f60\u5c06 \u65e0\u6cd5\u91cd\u65b0\u52a0\u5165 \uff0c\u4f46 " + faction.getDisplayNameWithArticle() + " \u5927\u6982\u4e0d\u6562" + "\u518d\u6b21\u516c\u5f00\u9a9a\u6270\u4f60\u3002" + extra, 0.0f, Misc.getTextColor(), faction.getBaseUIColor(), faction.getDisplayNameWithArticleWithoutArticle());
                label.setHighlightColors(Misc.getNegativeHighlightColor(), faction.getBaseUIColor());
                label.setHighlight("\u65e0\u6cd5\u91cd\u65b0\u52a0\u5165", faction.getDisplayNameWithArticleWithoutArticle());
                if (PerseanLeagueMembership.isPayingHouseHannan()) {
                    prompt.addPara("\u7136\u800c\uff0cHannan \u6c0f\u65cf\u53ef\u80fd\u56e0\u4f60\u505c\u6b62\u4ed8\u8d39 \u800c\u88ab\u6fc0\u6012 \u3002", 10.0f, Misc.getNegativeHighlightColor(), "\u800c\u88ab\u6fc0\u6012");
                }
            } else {
                String extra = "";
                boolean canRejoin = PerseanLeagueMembership.getNumTimesLeftLeague() < TIMES_LEFT_LEAGUE_FOR_NO_REJOIN - 1;
                float rejoinPad = 10.0f;
                if (HA_CMD.canSendPerseanLeaguePunitiveExpedition()) {
                    LabelAPI label = prompt.addPara("\u5982\u679c\u4f60\u9009\u62e9\u9000\u51fa\uff0c" + faction.getDisplayNameWithArticle() + " \u5c06" + "\u4ee5 \u6781\u7aef\u884c\u52a8 \u9488\u5bf9\u4f60\u7684\u6b96\u6c11\u5730\u3002" + extra, 0.0f);
                    label.setHighlightColors(faction.getBaseUIColor(), Misc.getNegativeHighlightColor());
                    label.setHighlight(faction.getDisplayNameWithArticleWithoutArticle(), "\u6781\u7aef\u884c\u52a8");
                } else if (canRejoin) {
                    prompt.addPara("\u5982\u679c\u4f60\u9009\u62e9\u9000\u51fa\uff0c" + faction.getDisplayNameWithArticle() + " \u5c06" + "\u5728\u4e00\u6bb5\u65f6\u95f4\u540e\u5f00\u59cb\u9a9a\u6270\u4f60\u3002", 0.0f, Misc.getTextColor(), faction.getBaseUIColor(), faction.getDisplayNameWithArticleWithoutArticle());
                } else {
                    rejoinPad = 0.0f;
                }
                if (!canRejoin) {
                    prompt.addPara("\u7531\u4e8e\u4f60\u80cc\u4fe1\u5f03\u4e49\u7684\u8fc7\u5f80\uff0c\u4f60\u4ee5\u540e\u53ef\u80fd\u5c06 \u65e0\u6cd5\u518d\u52a0\u5165 \u82f1\u4ed9\u5ea7\u8054\u76df\u3002", rejoinPad, Misc.getNegativeHighlightColor(), "\u65e0\u6cd5\u518d\u52a0\u5165");
                }
            }
        } else if (buttonId == BUTTON_RENEGE_HANNAN) {
            prompt.addPara("\u7136\u800c\uff0cHannan \u6c0f\u65cf\u5c06\u88ab\u6fc0\u6012 \u3002\u867d\u7136\u4ed6\u4eec\u53ef\u80fd\u65e0\u6cd5\u5c06\u4f60\u4ece\u82f1\u4ed9\u5ea7\u8054\u76df\u4e2d\u76f4\u63a5\u9664\u540d\uff0c\u4f46\u4ed6\u4eec\u5f88\u53ef\u80fd\u5229\u7528\u5176\u5de8\u5927\u7684\u5f71\u54cd\u529b \u6301\u7eed\u5730\u6bc1\u574f\u4f60\u7684\u540d\u8a89 \u3002", 0.0f, Misc.getNegativeHighlightColor(), "\u6301\u7eed\u5730\u6bc1\u574f\u4f60\u7684\u540d\u8a89");
            prompt.addPara("\u4f60\u4e5f\u5c06 \u5931\u53bb Reynard Hannan \u8054\u7edc\u4eba\u3002", 10.0f, Misc.getNegativeHighlightColor(), "\u5931\u53bb Reynard Hannan");
        }
    }

    @Override
    public boolean doesButtonHaveConfirmDialog(Object buttonId) {
        if (buttonId == BUTTON_END || buttonId == BUTTON_RENEGE_HANNAN) {
            return true;
        }
        return super.doesButtonHaveConfirmDialog(buttonId);
    }

    @Override
    public void reportCommissionEnded(FactionCommissionIntel intel) {
        if (intel.getFaction().getId().equals("persean")) {
            this.endMembership(AgreementEndingType.BROKEN, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AgreementEndingType {
        EXPIRED,
        BROKEN,
        ENDED;

    }
}

