/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.ReputationActionResponsePlugin;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.FleetEventListener;
import com.fs.starfarer.api.characters.FullName;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.events.OfficerManagerEvent;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV3;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParamsV3;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.intel.PersonBountyManager;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseManager;
import com.fs.starfarer.api.impl.campaign.procgen.Constellation;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BreadcrumbSpecial;
import com.fs.starfarer.api.impl.campaign.shared.PersonBountyEventData;
import com.fs.starfarer.api.impl.campaign.shared.SharedData;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersonBountyIntel
extends BaseIntelPlugin
implements EveryFrameScript,
FleetEventListener {
    public static Logger log = Global.getLogger(PersonBountyIntel.class);
    public static float MAX_DURATION = 90.0f;
    public static float MAX_TIME_BASED_ADDED_LEVEL = 3.0f;
    private float elapsedDays = 0.0f;
    private float duration = MAX_DURATION;
    private float bountyCredits = 0.0f;
    private FactionAPI faction;
    private PersonAPI person;
    private CampaignFleetAPI fleet;
    private FleetMemberAPI flagship;
    private BountyType bountyType;
    private SectorEntityToken hideoutLocation = null;
    private int level = 0;
    protected BountyResult result = null;

    public float getElapsedDays() {
        return this.elapsedDays;
    }

    public void setElapsedDays(float elapsedDays) {
        this.elapsedDays = elapsedDays;
    }

    public static PersonBountyEventData getSharedData() {
        return SharedData.getData().getPersonBountyEventData();
    }

    public PersonBountyIntel() {
        this.pickLevel();
        this.pickFaction();
        if (this.isDone()) {
            return;
        }
        this.initBountyAmount();
        this.pickHideoutLocation();
        if (this.isDone()) {
            return;
        }
        this.pickBountyType();
        if (this.bountyType == BountyType.DESERTER) {
            this.bountyCredits *= 1.5f;
        }
        this.initPerson();
        if (this.isDone()) {
            return;
        }
        this.spawnFleet();
        if (this.isDone()) {
            return;
        }
        log.info((Object)String.format("\u6b64\u8d4f\u91d1\u5956\u91d1\u662f\u7531 [%s] \u9488\u5bf9 %s \u53d1\u5e03", this.faction.getDisplayName(), this.person.getName().getFullName()));
        Global.getSector().getIntelManager().queueIntel(this);
    }

    @Override
    public void reportMadeVisibleToPlayer() {
        if (!this.isEnding() && !this.isEnded()) {
            this.duration = Math.max(this.duration * 0.5f, Math.min(this.duration * 2.0f, MAX_DURATION));
        }
    }

    protected void pickLevel() {
        int add;
        int base = PersonBountyIntel.getSharedData().getLevel();
        float timeFactor = (PirateBaseManager.getInstance().getDaysSinceStart() - 180.0f) / 730.0f;
        if (timeFactor < 0.0f) {
            timeFactor = 0.0f;
        }
        if (timeFactor > 1.0f) {
            timeFactor = 1.0f;
        }
        if ((base += (add = Math.round(MAX_TIME_BASED_ADDED_LEVEL * timeFactor))) > 10) {
            base = 10;
        }
        boolean hasLow = false;
        boolean hasHigh = false;
        for (EveryFrameScript s : PersonBountyManager.getInstance().getActive()) {
            PersonBountyIntel bounty = (PersonBountyIntel)s;
            int curr = bounty.getLevel();
            if (curr < base || curr == 0) {
                hasLow = true;
            }
            if (curr <= base) continue;
            hasHigh = true;
        }
        this.level = base;
        if (!hasLow) {
            this.level = 0;
        } else if (!hasHigh) {
            this.level += new Random().nextInt(3) + 2;
        }
        if (this.level < 0) {
            this.level = 0;
        }
    }

    public int getLevel() {
        return this.level;
    }

    protected void pickHideoutLocation() {
        WeightedRandomPicker<StarSystemAPI> systemPicker = new WeightedRandomPicker<StarSystemAPI>();
        for (StarSystemAPI system : Global.getSector().getStarSystems()) {
            float f = 0.0f;
            if (system.hasPulsar()) continue;
            if (system.hasTag("theme_misc_skip")) {
                f = 1.0f;
            } else if (system.hasTag("theme_misc")) {
                f = 3.0f;
            } else if (system.hasTag("theme_remnant_no_fleets")) {
                f = 3.0f;
            } else if (system.hasTag("theme_ruins")) {
                f = 5.0f;
            } else if (system.hasTag("theme_remnant_destroyed")) {
                f = 3.0f;
            } else if (system.hasTag("theme_core_unpopulated")) {
                f = 1.0f;
            }
            for (MarketAPI market : Misc.getMarketsInLocation(system)) {
                if (market.isHidden()) continue;
                f = 0.0f;
                break;
            }
            float distToPlayer = Misc.getDistanceToPlayerLY(system.getLocation());
            float noSpawnRange = Global.getSettings().getFloat("personBountyNoSpawnRangeAroundPlayerLY");
            if (distToPlayer < noSpawnRange) {
                f = 0.0f;
            }
            if (f <= 0.0f) continue;
            float weight = system.getPlanets().size();
            for (PlanetAPI planet : system.getPlanets()) {
                if (planet.isStar() || planet.getMarket() == null) continue;
                float h = planet.getMarket().getHazardValue();
                if (h <= 0.0f) {
                    weight += 5.0f;
                    continue;
                }
                if (h <= 0.25f) {
                    weight += 3.0f;
                    continue;
                }
                if (!(h <= 0.5f)) continue;
                weight += 1.0f;
            }
            float dist = system.getLocation().length();
            float distMult = Math.max(0.0f, 50000.0f - dist);
            systemPicker.add(system, weight * f * distMult);
        }
        StarSystemAPI system2 = (StarSystemAPI)systemPicker.pick();
        if (system2 != null) {
            WeightedRandomPicker<SectorEntityToken> picker = new WeightedRandomPicker<SectorEntityToken>();
            for (SectorEntityToken sectorEntityToken : system2.getPlanets()) {
                if (sectorEntityToken.isStar() || sectorEntityToken.getMarket() != null && !sectorEntityToken.getMarket().isPlanetConditionMarketOnly()) continue;
                picker.add(sectorEntityToken);
            }
            this.hideoutLocation = (SectorEntityToken)picker.pick();
        }
        if (this.hideoutLocation == null) {
            this.endImmediately();
        }
    }

    private void pickFaction() {
        MarketAPI market2;
        FactionAPI player = Global.getSector().getPlayerFaction();
        String commFacId = Misc.getCommissionFactionId();
        boolean forceCommissionFaction = true;
        if (commFacId != null && PersonBountyIntel.getSharedData().isParticipating(commFacId)) {
            for (EveryFrameScript s : PersonBountyManager.getInstance().getActive()) {
                PersonBountyIntel bounty = (PersonBountyIntel)s;
                if (bounty.faction == null || !bounty.faction.getId().equals(commFacId)) continue;
                forceCommissionFaction = false;
            }
        } else {
            forceCommissionFaction = false;
        }
        WeightedRandomPicker<MarketAPI> picker = new WeightedRandomPicker<MarketAPI>();
        for (MarketAPI market2 : Global.getSector().getEconomy().getMarketsCopy()) {
            if (!PersonBountyIntel.getSharedData().isParticipating(market2.getFactionId()) || market2.getSize() < 3 || market2.isHidden() || market2.getFaction().isPlayerFaction()) continue;
            float weight = market2.getSize();
            if (market2.hasIndustry("patrolhq")) {
                weight *= 1.5f;
            }
            if (market2.hasIndustry("militarybase")) {
                weight *= 3.0f;
            }
            if (market2.hasIndustry("highcommand")) {
                weight *= 5.0f;
            }
            if (market2.getFaction() != null) {
                if (forceCommissionFaction && !market2.getFaction().getId().equals(commFacId)) continue;
                if (market2.getFaction().isHostileTo(player)) {
                    weight *= 0.5f;
                }
            }
            if (!(weight > 0.0f)) continue;
            picker.add(market2, weight);
        }
        if (picker.isEmpty()) {
            this.endImmediately();
            return;
        }
        market2 = (MarketAPI)picker.pick();
        this.faction = market2.getFaction();
    }

    private void initBountyAmount() {
        float highStabilityMult = 1.0f;
        float base = Global.getSettings().getFloat("basePersonBounty");
        float perLevel = Global.getSettings().getFloat("personBountyPerLevel");
        float random = perLevel * (float)((int)(Math.random() * 15.0)) / 15.0f;
        this.bountyCredits = (int)((base + perLevel * (float)this.level + random) * highStabilityMult);
    }

    private void initPerson() {
        String factionId = "pirates";
        if (this.bountyType == BountyType.DESERTER) {
            factionId = this.faction.getId();
        }
        int personLevel = (int)(5.0f + (float)this.level * 1.5f);
        this.person = OfficerManagerEvent.createOfficer(Global.getSector().getFaction(factionId), personLevel, false);
        if (this.level >= 7) {
            this.person.setRankId(Ranks.SPACE_ADMIRAL);
        } else {
            this.person.setRankId(Ranks.SPACE_CAPTAIN);
        }
    }

    private void pickBountyType() {
        WeightedRandomPicker<BountyType> picker = new WeightedRandomPicker<BountyType>();
        picker.add(BountyType.PIRATE, 10.0f);
        if (this.level >= 4) {
            picker.add(BountyType.DESERTER, 30.0f);
        }
        this.bountyType = (BountyType)((Object)picker.pick());
    }

    @Override
    protected void advanceImpl(float amount) {
        float \u5929 = Global.getSector().getClock().convertToDays(amount);
        this.elapsedDays += \u5929;
        if (this.elapsedDays >= this.duration && !this.isDone()) {
            boolean canEnd;
            boolean bl = canEnd = this.fleet == null || !this.fleet.isInCurrentLocation();
            if (canEnd) {
                log.info((Object)String.format("\u7ed3\u675f\u8d4f\u91d1 %s \u7531\u4e8e %s", this.person.getName().getFullName(), this.faction.getDisplayName()));
                this.result = new BountyResult(BountyResultType.END_TIME, 0, null);
                this.sendUpdateIfPlayerHasIntel((Object)this.result, true);
                this.cleanUpFleetAndEndIfNecessary();
                return;
            }
        }
        if (this.fleet == null) {
            return;
        }
        if (this.fleet.isInCurrentLocation() && !this.fleet.getFaction().getId().equals("pirates")) {
            this.fleet.setFaction("pirates", true);
        } else if (!this.fleet.isInCurrentLocation() && !this.fleet.getFaction().getId().equals("neutral")) {
            this.fleet.setFaction("neutral", true);
        }
        if (this.fleet.getFlagship() == null || this.fleet.getFlagship().getCaptain() != this.person) {
            this.result = new BountyResult(BountyResultType.END_OTHER, 0, null);
            boolean current = this.fleet.isInCurrentLocation();
            this.sendUpdateIfPlayerHasIntel((Object)this.result, !current);
            this.cleanUpFleetAndEndIfNecessary();
            return;
        }
    }

    @Override
    public float getTimeRemainingFraction() {
        float f = 1.0f - this.elapsedDays / this.duration;
        return f;
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
        this.cleanUpFleetAndEndIfNecessary();
    }

    protected void cleanUpFleetAndEndIfNecessary() {
        if (this.fleet != null) {
            Misc.makeUnimportant(this.fleet, "pbe");
            this.fleet.clearAssignments();
            if (this.hideoutLocation != null) {
                this.fleet.getAI().addAssignment(FleetAssignment.GO_TO_LOCATION_AND_DESPAWN, this.hideoutLocation, 1000000.0f, null);
            } else {
                this.fleet.despawn();
            }
            this.fleet = null;
        }
        if (!this.isEnding() && !this.isEnded()) {
            this.endAfterDelay();
        }
    }

    protected boolean willPay() {
        return true;
    }

    protected boolean willRepIncrease() {
        return true;
    }

    @Override
    public void reportBattleOccurred(CampaignFleetAPI fleet, CampaignFleetAPI primaryWinner, BattleAPI battle) {
        boolean playerInvolved;
        if (this.isDone() || this.result != null) {
            return;
        }
        float distToPlayer = Misc.getDistance(fleet, Global.getSector().getPlayerFleet());
        boolean bl = playerInvolved = battle.isPlayerInvolved() || fleet.isInCurrentLocation() && distToPlayer < 2000.0f;
        if (battle.isInvolved(fleet) && !playerInvolved && (fleet.getFlagship() == null || fleet.getFlagship().getCaptain() != this.person)) {
            fleet.setCommander(fleet.getFaction().createRandomPerson());
            this.result = new BountyResult(BountyResultType.END_OTHER, 0, null);
            this.sendUpdateIfPlayerHasIntel((Object)this.result, true);
            this.cleanUpFleetAndEndIfNecessary();
            return;
        }
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        if (!playerInvolved || !battle.isInvolved(fleet) || battle.onPlayerSide(fleet)) {
            return;
        }
        if (fleet.getFlagship() != null && fleet.getFlagship().getCaptain() == this.person) {
            return;
        }
        int payment = (int)this.bountyCredits;
        if (payment <= 0) {
            this.result = new BountyResult(BountyResultType.END_OTHER, 0, null);
            this.sendUpdateIfPlayerHasIntel((Object)this.result, true);
            this.cleanUpFleetAndEndIfNecessary();
            return;
        }
        if (this.willPay()) {
            log.info((Object)String.format("\u652f\u4ed8\u5956\u91d1 %d \u6765\u81ea [%s] ", payment, this.faction.getDisplayName()));
            playerFleet.getCargo().getCredits().add(payment);
            ReputationActionResponsePlugin.ReputationAdjustmentResult rep = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.PERSON_BOUNTY_REWARD, null, null, null, true, false), this.faction.getId());
            this.result = new BountyResult(BountyResultType.END_PLAYER_BOUNTY, payment, rep);
            this.sendUpdateIfPlayerHasIntel((Object)this.result, false);
        } else if (this.willRepIncrease()) {
            log.info((Object)String.format("\u4e0d\u652f\u4ed8\u8d4f\u91d1\u4f46\u6539\u5584\u9635\u8425\u5173\u7cfb [%s] ", this.faction.getDisplayName()));
            ReputationActionResponsePlugin.ReputationAdjustmentResult rep = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.PERSON_BOUNTY_REWARD, null, null, null, true, false), this.faction.getId());
            this.result = new BountyResult(BountyResultType.END_PLAYER_NO_BOUNTY, payment, rep);
            this.sendUpdateIfPlayerHasIntel((Object)this.result, false);
        } else {
            log.info((Object)String.format("\u4e0d\u652f\u4ed8\u8d4f\u91d1\u6216\u6539\u5584\u9635\u8425\u5173\u7cfb [%s] ", this.faction.getDisplayName()));
            this.result = new BountyResult(BountyResultType.END_PLAYER_NO_REWARD, 0, null);
            this.sendUpdateIfPlayerHasIntel((Object)this.result, false);
        }
        PersonBountyIntel.getSharedData().reportSuccess();
        this.cleanUpFleetAndEndIfNecessary();
    }

    @Override
    public void reportFleetDespawnedToListener(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
        if (this.isDone() || this.result != null) {
            return;
        }
        if (this.fleet == fleet) {
            fleet.setCommander(fleet.getFaction().createRandomPerson());
            this.result = new BountyResult(BountyResultType.END_OTHER, 0, null);
            this.sendUpdateIfPlayerHasIntel((Object)this.result, true);
            this.cleanUpFleetAndEndIfNecessary();
        }
    }

    private void spawnFleet() {
        FactionAPI faction;
        float maxFp;
        float qf;
        String fleetFactionId = "pirates";
        if (this.bountyType == BountyType.DESERTER) {
            fleetFactionId = this.faction.getId();
        }
        if ((qf = (float)this.level / 10.0f) > 1.0f) {
            qf = 1.0f;
        }
        String fleetName = "";
        fleetName = String.valueOf(this.person.getName().getLast()) + " \u7684" + " \u8230\u961f";
        float fp = (float)(5 + this.level * 5) * 5.0f;
        fp *= 0.75f + (float)Math.random() * 0.25f;
        if (this.level >= 7) {
            fp += 20.0f;
        }
        if (this.level >= 8) {
            fp += 30.0f;
        }
        if (this.level >= 9) {
            fp += 50.0f;
        }
        if (this.level >= 10) {
            fp += 50.0f;
        }
        if (fp > (maxFp = (faction = Global.getSector().getFaction(fleetFactionId)).getApproximateMaxFPPerFleet(FactionAPI.ShipPickMode.PRIORITY_THEN_ALL) * 1.1f)) {
            fp = maxFp;
        }
        FleetParamsV3 params = new FleetParamsV3(null, this.hideoutLocation.getLocationInHyperspace(), fleetFactionId, Float.valueOf(qf + 0.2f), "personBounty", fp, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        params.ignoreMarketFleetSizeMult = true;
        this.fleet = FleetFactoryV3.createFleet(params);
        if (this.fleet == null || this.fleet.isEmpty()) {
            this.endImmediately();
            return;
        }
        this.fleet.setCommander(this.person);
        this.fleet.getFlagship().setCaptain(this.person);
        FleetFactoryV3.addCommanderSkills(this.person, this.fleet, null);
        Misc.makeImportant(this.fleet, "pbe", this.duration + 20.0f);
        this.fleet.getMemoryWithoutUpdate().set("$isPirate", true);
        this.fleet.getMemoryWithoutUpdate().set("$core_fleetNoMilitaryResponse", true);
        this.fleet.setNoFactionInName(true);
        this.fleet.setFaction("neutral", true);
        this.fleet.setName(fleetName);
        this.fleet.addEventListener(this);
        LocationAPI location = this.hideoutLocation.getContainingLocation();
        location.addEntity(this.fleet);
        this.fleet.setLocation(this.hideoutLocation.getLocation().x - 500.0f, this.hideoutLocation.getLocation().y + 500.0f);
        this.fleet.getAI().addAssignment(FleetAssignment.ORBIT_AGGRESSIVE, this.hideoutLocation, 1000000.0f, null);
        this.flagship = this.fleet.getFlagship();
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        boolean isUpdate;
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        boolean bl = isUpdate = this.getListInfoParam() != null;
        if (this.result == null) {
            if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
                info.addPara("%s \u5956\u52b1", initPad, tc, h, Misc.getDGSCredits(this.bountyCredits));
                int \u5929 = (int)(this.duration - this.elapsedDays);
                if (\u5929 <= 1) {
                    \u5929 = 1;
                }
                this.addDays(info, "\u671f\u9650", \u5929, tc);
            } else {
                info.addPara("\u53d1\u5e03\u65b9\uff1a{" + this.faction.getDisplayName(), initPad, tc, this.faction.getBaseUIColor(), this.faction.getDisplayName());
                if (!this.isEnding()) {
                    int \u5929 = (int)(this.duration - this.elapsedDays);
                    String daysStr = "\u5929";
                    if (\u5929 <= 1) {
                        \u5929 = 1;
                        daysStr = "\u5929";
                    }
                    info.addPara("%s \u5956\u52b1\uff0c%s " + daysStr + "\u671f\u9650", 0.0f, tc, h, Misc.getDGSCredits(this.bountyCredits), "" + \u5929);
                }
            }
            this.unindent(info);
            return;
        }
        switch (this.result.type) {
            case END_PLAYER_BOUNTY: {
                info.addPara("%s \u5df2\u6536\u5230", initPad, tc, h, Misc.getDGSCredits(this.result.payment));
                CoreReputationPlugin.addAdjustmentMessage(this.result.rep.delta, this.faction, null, null, null, info, tc, isUpdate, 0.0f);
                break;
            }
            case END_PLAYER_NO_BOUNTY: {
                CoreReputationPlugin.addAdjustmentMessage(this.result.rep.delta, this.faction, null, null, null, info, tc, isUpdate, 0.0f);
                break;
            }
            case END_PLAYER_NO_REWARD: {
                CoreReputationPlugin.addAdjustmentMessage(this.result.rep.delta, this.faction, null, null, null, info, tc, isUpdate, 0.0f);
                break;
            }
            case END_TIME: {
                break;
            }
        }
        this.unindent(info);
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color c = this.getTitleColor(mode);
        float pad = 3.0f;
        float opad = 10.0f;
        info.addPara(this.getName(), c, 0.0f);
        this.addBulletPoints(info, mode);
    }

    @Override
    public String getSortString() {
        return "\u4e2a\u4eba\u8d4f\u91d1";
    }

    @Override
    public String getName() {
        String n = this.person.getName().getFullName();
        if (this.result != null) {
            switch (this.result.type) {
                case END_PLAYER_BOUNTY: 
                case END_PLAYER_NO_BOUNTY: 
                case END_PLAYER_NO_REWARD: {
                    return "\u8d4f\u91d1\u5b8c\u6210 - " + n;
                }
                case END_OTHER: 
                case END_TIME: {
                    return "\u8d4f\u91d1\u7ed3\u675f - " + n;
                }
            }
        }
        return "\u4e2a\u4eba\u8d4f\u91d1 - " + n;
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return this.faction;
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        info.addImage(this.person.getPortraitSprite(), width, 128.0f, opad);
        String type = "\u8fd9\u540d\u81ed\u540d\u662d\u8457\u7684\u6d77\u76d7 \u53d1\u5e03\u4e86\u8d4f\u91d1";
        if (this.bountyType == BountyType.DESERTER) {
            type = "\u8fd9\u540d\u9003\u5175 \u53d1\u5e03\u4e86\u8d4f\u91d1";
        }
        String has = this.faction.getDisplayNameHasOrHave();
        info.addPara(String.valueOf(Misc.ucFirst(this.faction.getDisplayNameWithArticle())) + " " + has + "\u5411 " + this.person.getName().getFullName() + ", " + type + "\uff0c\u5e76\u8981\u6c42\u5bf9\u5176\u65bd\u4ee5\u6b63\u4e49\u5236\u88c1\u3002", opad, this.faction.getBaseUIColor(), this.faction.getDisplayNameWithArticleWithoutArticle());
        if (this.result != null) {
            if (this.result.type == BountyResultType.END_PLAYER_BOUNTY) {
                info.addPara("\u4f60\u5df2\u7ecf\u6210\u529f\u5b8c\u6210\u4e86\u8fd9\u7b14\u8d4f\u91d1\u3002", opad);
            } else if (this.result.type == BountyResultType.END_PLAYER_NO_BOUNTY) {
                info.addPara("\u5c3d\u7ba1\u4f60\u5df2\u7ecf\u6210\u529f\u5b8c\u6210\u4e86\u8fd9\u7b14\u8d4f\u91d1\uff0c\u4f46\u9274\u4e8e\u4f60\u548c\u8d4f\u91d1\u53d1\u5e03\u65b9\u4e4b\u95f4\u7684\u7cdf\u7cd5\u5173\u7cfb\uff0c\u5c06\u4e0d\u4f1a\u5f97\u5230\u4efb\u4f55\u661f\u5e01\u5956\u52b1 " + Misc.ucFirst(this.faction.getDisplayNameWithArticle()) + ".", opad, this.faction.getBaseUIColor(), this.faction.getDisplayNameWithArticleWithoutArticle());
            } else if (this.result.type == BountyResultType.END_PLAYER_NO_REWARD) {
                info.addPara("\u5c3d\u7ba1\u4f60\u5df2\u7ecf\u6210\u529f\u5b8c\u6210\u4e86\u8fd9\u7b14\u8d4f\u91d1\uff0c\u4f46\u9274\u4e8e\u4f60\u548c\u8d4f\u91d1\u53d1\u5e03\u65b9\u4e4b\u95f4\u7684\u7cdf\u7cd5\u5173\u7cfb\uff0c\u5c06\u4e0d\u4f1a\u5f97\u5230\u4efb\u4f55\u5956\u52b1 " + Misc.ucFirst(this.faction.getDisplayNameWithArticle()) + ".", opad, this.faction.getBaseUIColor(), this.faction.getDisplayNameWithArticleWithoutArticle());
            } else {
                info.addPara("\u8be5 \u8d4f\u91d1 \u5df2\u88ab\u64a4\u9500\u3002", opad);
            }
        }
        this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
        if (this.result == null) {
            if (this.hideoutLocation != null) {
                SectorEntityToken fake = this.hideoutLocation.getContainingLocation().createToken(0.0f, 0.0f);
                fake.setOrbit(Global.getFactory().createCircularOrbit(this.hideoutLocation, 0.0f, 1000.0f, 100.0f));
                String loc = BreadcrumbSpecial.getLocatedString(fake);
                loc = loc.replaceAll("\u73af\u7ed5\u4e8e", "\u9690\u85cf\u4e8e");
                loc = loc.replaceAll("\u4f4d\u4e8e", "\u9690\u85cf\u5728");
                String sheIs = "\u5979";
                if (this.person.getGender() == FullName.Gender.MALE) {
                    sheIs = "\u4ed6";
                }
                info.addPara(String.valueOf(sheIs) + " \u636e\u4f20\u73b0 " + loc + ".", opad);
            }
            int cols = 7;
            float iconSize = width / (float)cols;
            if (DebugFlags.PERSON_BOUNTY_DEBUG_INFO) {
                boolean deflate = false;
                if (!this.fleet.isInflated()) {
                    this.fleet.setFaction("pirates", true);
                    this.fleet.inflateIfNeeded();
                    deflate = true;
                }
                String \u5979\u7684 = "\u5979\u7684";
                if (this.person.getGender() == FullName.Gender.MALE) {
                    \u5979\u7684 = "\u4ed6\u7684";
                }
                info.addPara("\u8d4f\u91d1\u516c\u544a\u4e2d\u8fd8\u5305\u542b\u4e86\u4e00\u4e9b " + \u5979\u7684 + " command. (DEBUG: full info)", opad);
                info.addShipList(cols, 3, iconSize, this.getFactionForUIColors().getBaseUIColor(), this.fleet.getMembersWithFightersCopy(), opad);
                info.addPara("level: " + this.level, 3.0f);
                info.addPara("type: " + this.bountyType.name(), 3.0f);
                if (deflate) {
                    this.fleet.deflate();
                }
            } else {
                boolean deflate = false;
                if (!this.fleet.isInflated()) {
                    this.fleet.setFaction("pirates", true);
                    this.fleet.inflateIfNeeded();
                    deflate = true;
                }
                ArrayList<FleetMemberAPI> list = new ArrayList<FleetMemberAPI>();
                Random random = new Random(this.person.getNameString().hashCode() * 170000);
                List<FleetMemberAPI> members = this.fleet.getFleetData().getMembersListCopy();
                int max = 7;
                for (FleetMemberAPI member : members) {
                    if (list.size() >= max) break;
                    if (member.isFighterWing()) continue;
                    float prob = (float)member.getFleetPointCost() / 20.0f;
                    prob += (float)max / (float)members.size();
                    if (member.isFlagship()) {
                        prob = 1.0f;
                    }
                    if (random.nextFloat() > prob) continue;
                    FleetMemberAPI copy = Global.getFactory().createFleetMember(FleetMemberType.SHIP, member.getVariant());
                    if (member.isFlagship()) {
                        copy.setCaptain(this.person);
                    }
                    list.add(copy);
                }
                if (!list.isEmpty()) {
                    String \u5979\u7684 = "\u5979\u7684";
                    if (this.person.getGender() == FullName.Gender.MALE) {
                        \u5979\u7684 = "\u4ed6\u7684";
                    }
                    info.addPara("\u8d4f\u91d1\u516c\u544a\u4e2d\u8fd8\u5305\u542b\u4e86\u90e8\u5206" + \u5979\u7684 + "\u8230\u961f\u60c5\u62a5\u3002", opad);
                    info.addShipList(cols, 1, iconSize, this.getFactionForUIColors().getBaseUIColor(), list, opad);
                    int num = members.size() - list.size();
                    num = Math.round((float)num * (1.0f + random.nextFloat() * 0.5f));
                    num = num < 5 ? 0 : (num < 10 ? 5 : (num < 20 ? 10 : 20));
                    if (num > 1) {
                        info.addPara("\u636e\u6089\uff0c\u8be5\u8230\u961f\u53ef\u80fd\u8fd8\u5b58\u5728\u8d85\u8fc7 %s \u8258\u6218\u529b\u4e0d\u4e00\u7684\u8230\u8239\u3002", opad, h, "" + num);
                    } else {
                        info.addPara("\u636e\u6089\uff0c\u8be5\u8230\u961f\u53ef\u80fd\u8fd8\u5305\u542b\u5176\u4ed6\u51e0\u8258\u6218\u529b\u4e0d\u4e00\u7684\u8230\u8239\u3002", opad);
                    }
                }
                if (deflate) {
                    this.fleet.deflate();
                }
            }
        }
    }

    @Override
    public String getIcon() {
        return this.person.getPortraitSprite();
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Bounties");
        tags.add(this.faction.getId());
        return tags;
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        Constellation c = this.hideoutLocation.getConstellation();
        SectorEntityToken entity = null;
        if (c != null && map != null) {
            entity = map.getConstellationLabelEntity(c);
        }
        if (entity == null) {
            entity = this.hideoutLocation;
        }
        return entity;
    }

    public PersonAPI getPerson() {
        return this.person;
    }

    public CampaignFleetAPI getFleet() {
        return this.fleet;
    }

    public float getDuration() {
        return this.duration;
    }

    public void setDuration(float duration) {
        this.duration = duration;
    }

    public float getBountyCredits() {
        return this.bountyCredits;
    }

    public void setBountyCredits(float bountyCredits) {
        this.bountyCredits = bountyCredits;
    }

    public BountyType getBountyType() {
        return this.bountyType;
    }

    public void setBountyType(BountyType bountyType) {
        this.bountyType = bountyType;
    }

    public FactionAPI getFaction() {
        return this.faction;
    }

    public FleetMemberAPI getFlagship() {
        return this.flagship;
    }

    public SectorEntityToken getHideoutLocation() {
        return this.hideoutLocation;
    }

    public BountyResult getResult() {
        return this.result;
    }

    public static class BountyResult {
        public BountyResultType type;
        public int payment;
        public ReputationActionResponsePlugin.ReputationAdjustmentResult rep;

        public BountyResult(BountyResultType type, int payment, ReputationActionResponsePlugin.ReputationAdjustmentResult rep) {
            this.type = type;
            this.payment = payment;
            this.rep = rep;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BountyResultType {
        END_PLAYER_BOUNTY,
        END_PLAYER_NO_BOUNTY,
        END_PLAYER_NO_REWARD,
        END_OTHER,
        END_TIME;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BountyType {
        PIRATE,
        DESERTER;

    }
}

