/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.StoryPointActionDelegate;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.impl.campaign.events.OfficerManagerEvent;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.ids.Sounds;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.SetStoryOption;
import com.fs.starfarer.api.ui.ButtonAPI;
import com.fs.starfarer.api.ui.IntelUIAPI;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PromoteOfficerIntel
extends BaseIntelPlugin {
    public static String BUTTON_PROMOTE = "button_promote";
    public static String BUTTON_DELETE = "button_delete";
    public static float DURATION = 180.0f;
    protected PersonAPI person;

    public PromoteOfficerIntel(TextPanelAPI text) {
        if (Global.getSector().getPlayerFleet().getCargo().getCrew() <= 0) {
            this.endImmediately();
            return;
        }
        this.person = OfficerManagerEvent.createOfficer(Global.getSector().getFaction("player"), 1, OfficerManagerEvent.SkillPickPreference.ANY, true, null, false, false, -1, null);
        this.person.setPortraitSprite(OfficerManagerEvent.pickPortraitPreferNonDuplicate(this.person.getFaction(), this.person.getGender()));
        if (text != null) {
            text.addPara(this.getDescText());
        }
        this.setImportant(true);
    }

    @Override
    public boolean shouldRemoveIntel() {
        if (Global.getSector().getPlayerFleet().getCargo().getCrew() <= 0) {
            return true;
        }
        float days = this.getDaysSincePlayerVisible();
        return this.isEnded() || days >= DURATION;
    }

    @Override
    public String getName() {
        return "\u519b\u5b98\u664b\u5347\u5019\u9009\u4eba";
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color c = this.getTitleColor(mode);
        info.addPara(this.getName(), c, 0.0f);
        this.addBulletPoints(info, mode);
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = this.getBulletColorForMode(mode);
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        String pName = Misc.lcFirst(Misc.getPersonalityName(this.person));
        this.bullet(info);
        MutableCharacterStatsAPI stats = this.person.getStats();
        for (String skillId : Global.getSettings().getSortedSkillIds()) {
            int level = (int)stats.getSkillLevel(skillId);
            if (level <= 0) continue;
            SkillSpecAPI spec = Global.getSettings().getSkillSpec(skillId);
            String skillName = spec.getName();
            if (level > 1) {
                skillName = String.valueOf(skillName) + " (\u7cbe\u82f1) ";
            }
            info.addPara("\u6280\u80fd\uff1a" + skillName, initPad, tc, h, skillName);
            initPad = 0.0f;
        }
        info.addPara("\u6027\u683c\uff1a%s", initPad, tc, h, pName);
        this.unindent(info);
    }

    public String getDescText() {
        String themselves = "\u4ed6";
        if (this.person.isFemale()) {
            themselves = "\u5979";
        }
        return "\u4e0b\u7ea7\u519b\u5b98 " + this.person.getNameString() + "\uff0c\u56e0" + themselves + "\u6700\u8fd1\u8868\u73b0\u7a81\u51fa\uff0c" + "\u6240\u4ee5 \u53ef\u4ee5\u8003\u8651 \u5c06\u5176\u664b\u5347\u6210 \u6b63\u5f0f\u519b\u5b98\u3002";
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        String pName = Misc.getPersonalityName(this.person);
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        info.addImage(this.person.getPortraitSprite(), width, 128.0f, opad);
        info.addPara(this.getDescText(), tc, opad);
        this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
        info.addPara(this.person.getPersonalityAPI().getDescription(), opad);
        float days = DURATION - this.getDaysSincePlayerVisible();
        info.addPara("\u8be5\u673a\u4f1a\u8fd8\u5269 %s " + PromoteOfficerIntel.getDaysString(days) + ".", opad, tc, h, this.getDays(days));
        int max = Misc.getMaxOfficers(Global.getSector().getPlayerFleet());
        int curr = Misc.getNumNonMercOfficers(Global.getSector().getPlayerFleet());
        Color hNum = h;
        if (curr > max) {
            hNum = Misc.getNegativeHighlightColor();
        }
        LabelAPI label = info.addPara("\u4f60\u9ebe\u4e0b\u7684\u519b\u5b98\uff1a%s %s %s", opad, tc, h, "" + curr, "/", "" + max);
        label.setHighlightColors(hNum, h, h);
        Color color = Misc.getStoryOptionColor();
        Color dark = Misc.getStoryDarkColor();
        ButtonAPI button = this.addGenericButton(info, width, color, dark, "\u664b\u5347\u6210\u6b63\u5f0f\u519b\u5b98", BUTTON_PROMOTE);
        button.setShortcut(20, true);
        info.addSpacer(-10.0f);
        this.addDeleteButton(info, width, "\u6682\u4e0d\u8003\u8651");
        if (curr >= max) {
            button.setEnabled(false);
        }
    }

    @Override
    protected void createDeleteConfirmationPrompt(TooltipMakerAPI prompt) {
        prompt.addPara("\u4f60\u786e\u5b9a\u5417\uff1f\u6b64\u64cd\u4f5c\u5c06\u65e0\u6cd5\u64a4\u6d88\u3002", Misc.getTextColor(), 0.0f);
    }

    @Override
    public void storyActionConfirmed(Object buttonId, IntelUIAPI ui) {
        if (buttonId == BUTTON_PROMOTE) {
            this.endImmediately();
            ui.recreateIntelUI();
        }
    }

    @Override
    public StoryPointActionDelegate getButtonStoryPointActionDelegate(Object buttonId) {
        if (buttonId == BUTTON_PROMOTE) {
            SetStoryOption.StoryOptionParams params = new SetStoryOption.StoryOptionParams(null, 1, "promoteCrewMember", Sounds.STORY_POINT_SPEND_LEADERSHIP, "\u5c06\u6709\u524d\u9014\u7684\u4e0b\u7ea7\u519b\u5b98\u664b\u5347\u6210\u6b63\u5f0f\u519b\u5b98");
            return new SetStoryOption.BaseOptionStoryPointActionDelegate(null, params){

                public void confirm() {
                    CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
                    playerFleet.getCargo().removeCrew(1);
                    playerFleet.getFleetData().addOfficer(PromoteOfficerIntel.this.person);
                    PromoteOfficerIntel.this.person.setPostId(Ranks.POST_OFFICER);
                }

                public String getTitle() {
                    return null;
                }

                public void createDescription(TooltipMakerAPI info) {
                    info.setParaInsigniaLarge();
                    super.createDescription(info);
                }
            };
        }
        return null;
    }

    @Override
    public String getIcon() {
        return this.person.getPortraitSprite();
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Fleet log");
        return tags;
    }

    @Override
    public String getCommMessageSound() {
        return super.getCommMessageSound();
    }
}

