/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.MonthlyReport;
import com.fs.starfarer.api.campaign.listeners.EconomyTickListener;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.intel.events.SindrianDiktatHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.rulecmd.HA_CMD;
import com.fs.starfarer.api.impl.campaign.shared.SharedData;
import com.fs.starfarer.api.ui.ButtonAPI;
import com.fs.starfarer.api.ui.IntelUIAPI;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SindrianDiktatFuelDeal
extends BaseIntelPlugin
implements EconomyTickListener {
    public static float REP_FOR_BREAKING_DEAL = 0.5f;
    public static String KEY = "$sindrianDiktatDeal_ref";
    public static String BUTTON_END = "End";
    public static String UPDATE_PARAM_ACCEPTED = "update_param_accepted";
    protected FactionAPI faction = Global.getSector().getFaction("sindrian_diktat");
    protected AgreementEndingType endType = null;

    public static SindrianDiktatFuelDeal get() {
        return (SindrianDiktatFuelDeal)Global.getSector().getMemoryWithoutUpdate().get(KEY);
    }

    public SindrianDiktatFuelDeal(InteractionDialogAPI dialog) {
        this.setImportant(true);
        SindrianDiktatHostileActivityFactor.setMadeDeal(true);
        TextPanelAPI text = null;
        if (dialog != null) {
            text = dialog.getTextPanel();
        }
        Global.getSector().getListenerManager().addListener(this);
        Global.getSector().getMemoryWithoutUpdate().set(KEY, this);
        Global.getSector().getIntelManager().addIntel(this, true);
        this.sendUpdate(UPDATE_PARAM_ACCEPTED, text);
        HA_CMD.avertOrEndDiktatAttackAsNecessary();
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
        SindrianDiktatHostileActivityFactor.setMadeDeal(false);
        Global.getSector().getListenerManager().removeListener(this);
        Global.getSector().getMemoryWithoutUpdate().unset(KEY);
    }

    @Override
    protected void notifyEnded() {
        super.notifyEnded();
    }

    protected Object readResolve() {
        return this;
    }

    public String getBaseName() {
        return "\u8f9b\u8fbe\u5f3a\u6743\u71c3\u6599\u6761\u7ea6";
    }

    public String getAcceptedPostfix() {
        return "\u5df2\u63a5\u53d7";
    }

    public String getBrokenPostfix() {
        return "\u5df2\u7ed3\u675f";
    }

    @Override
    public String getName() {
        String postfix = "";
        if (this.isEnding() && this.endType != null) {
            switch (this.endType) {
                case BROKEN: {
                    postfix = " - " + this.getBrokenPostfix();
                }
            }
        }
        if (this.isSendingUpdate() && this.getListInfoParam() == UPDATE_PARAM_ACCEPTED) {
            postfix = " - " + this.getAcceptedPostfix();
        }
        return String.valueOf(this.getBaseName()) + postfix;
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return this.faction;
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        boolean isUpdate = this.getListInfoParam() != null;
        this.unindent(info);
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        info.addImage(this.getFaction().getLogo(), width, 128.0f, opad);
        if (this.isEnding() || this.isEnded()) {
            info.addPara("\u4f60\u4e0d\u518d\u9075\u5b88\u4e0e\u8f9b\u8fbe\u5f3a\u6743\u7684\u534f\u8bae\u3002", opad);
            return;
        }
        float feeFraction = Global.getSettings().getFloat("diktatFuelFeeFraction");
        LabelAPI label = info.addPara("\u4f60\u5df2\u4e0e\u8f9b\u8fbe\u5f3a\u6743\u8fbe\u6210\u534f\u8bae\uff0c\u652f\u4ed8\u4f60\u71c3\u6599\u51fa\u53e3\u6536\u5165\u7684 %s \u4f5c\u4e3a\u81ea\u9002\u5e94\u5f0f\u8d54\u6b3e\u3002\u800c\u76f8\u5e94\u5730\uff0c\u8f9b\u8fbe\u5f3a\u6743\u5c06\u4e0d\u518d\u5bf9\u4f60\u7684\u71c3\u6599\u751f\u4ea7\u8bbe\u65bd\u8fdb\u884c\u8f68\u9053\u8f70\u70b8\u3002", opad, h, Math.round(feeFraction * 100.0f) + "%");
        label.setHighlight("\u8f9b\u8fbe\u5f3a\u6743", Math.round(feeFraction * 100.0f) + "%");
        label.setHighlightColors(this.faction.getBaseUIColor(), h);
        info.addPara("\u4f60\u53ef\u4ee5\u7ec8\u6b62\u8fd9\u9879\u534f\u8bae\uff0c\u4f46\u5728\u4f5c\u51fa\u8fd9\u79cd\u80cc\u4fe1\u5f03\u4e49\u7684\u884c\u4e3a\u4e4b\u540e\uff0c\u5c31\u4e0d\u53ef\u80fd\u91cd\u65b0\u7b7e\u8ba2\u7c7b\u4f3c\u7684\u534f\u8bae\u3002", opad);
        ButtonAPI button = info.addButton("\u4e2d\u6b62\u534f\u8bae", BUTTON_END, this.getFactionForUIColors().getBaseUIColor(), this.getFactionForUIColors().getDarkUIColor(), (int)width, 20.0f, opad * 1.0f);
        button.setShortcut(22, true);
    }

    @Override
    public String getIcon() {
        return this.faction.getCrest();
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Agreements");
        tags.add(this.faction.getId());
        return tags;
    }

    @Override
    public String getImportantIcon() {
        return Global.getSettings().getSpriteName("intel", "important_accepted_mission");
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        return null;
    }

    public FactionAPI getFaction() {
        return this.faction;
    }

    public void endAgreement(AgreementEndingType type, InteractionDialogAPI dialog) {
        if (!this.isEnded() && !this.isEnding()) {
            this.endType = type;
            this.setImportant(false);
            this.endImmediately();
            if (dialog != null) {
                this.sendUpdate(new Object(), dialog.getTextPanel());
            }
            if (type == AgreementEndingType.BROKEN) {
                SindrianDiktatHostileActivityFactor.setBrokeDeal(true);
                TextPanelAPI text = dialog == null ? null : dialog.getTextPanel();
                Misc.adjustRep("sindrian_diktat", -REP_FOR_BREAKING_DEAL, text);
            }
        }
    }

    @Override
    public void buttonPressConfirmed(Object buttonId, IntelUIAPI ui) {
        if (buttonId == BUTTON_END) {
            this.endAgreement(AgreementEndingType.BROKEN, null);
        }
        super.buttonPressConfirmed(buttonId, ui);
    }

    @Override
    public void createConfirmationPrompt(Object buttonId, TooltipMakerAPI prompt) {
        if (buttonId == BUTTON_END) {
            prompt.addPara("\u534f\u8bae\u5185\u7684\u5404\u9879\u6761\u6b3e\u582a\u79f0\u7e41\u91cd\uff0c\u56e0\u6b64\u5355\u65b9\u9762\u8fdd\u53cd\u6b64\u534f\u8bae\u4e5f\u4e0d\u4f1a\u4f60\u5728\u661f\u57df\u89c1\u7684\u540d\u8a89\u58f0\u8a89\uff0c\u4f46 \u8f9b\u8fbe\u5f3a\u6743 \u663e\u7136\u4f1a\u5bf9\u6b64\u62b1\u6709\u610f\u89c1\u3002", 0.0f, this.faction.getBaseUIColor(), this.faction.getDisplayName());
        }
    }

    @Override
    public boolean doesButtonHaveConfirmDialog(Object buttonId) {
        if (buttonId == BUTTON_END) {
            return true;
        }
        return super.doesButtonHaveConfirmDialog(buttonId);
    }

    @Override
    public void reportEconomyMonthEnd() {
    }

    @Override
    public void reportEconomyTick(int iterIndex) {
        int numIter = Global.getSettings().getInt("economyIterPerMonth");
        if (iterIndex != numIter - 1) {
            return;
        }
        float feeFraction = Global.getSettings().getFloat("diktatFuelFeeFraction");
        MonthlyReport report = SharedData.getData().getCurrentReport();
        MonthlyReport.FDNode marketsNode = report.getNode(MonthlyReport.OUTPOSTS);
        if (marketsNode == null) {
            return;
        }
        float exportIncome = this.computeFuelExportIncome(marketsNode);
        int credits = (int)(exportIncome * feeFraction);
        if (credits <= 0) {
            return;
        }
        MonthlyReport.FDNode node = this.getMonthlyReportNode();
        node.upkeep += (float)credits;
    }

    public float computeFuelExportIncome(MonthlyReport.FDNode curr) {
        CommodityOnMarketAPI com;
        float total = 0.0f;
        if (curr.custom instanceof CommodityOnMarketAPI && (com = (CommodityOnMarketAPI)curr.custom).isFuel()) {
            total += curr.income;
        }
        for (MonthlyReport.FDNode child : curr.getChildren().values()) {
            total += this.computeFuelExportIncome(child);
        }
        return total;
    }

    public MonthlyReport.FDNode getMonthlyReportNode() {
        MonthlyReport report = SharedData.getData().getCurrentReport();
        MonthlyReport.FDNode marketsNode = report.getNode(MonthlyReport.OUTPOSTS);
        if (marketsNode.name == null) {
            marketsNode.name = "\u6b96\u6c11\u5730";
            marketsNode.custom = MonthlyReport.OUTPOSTS;
            marketsNode.tooltipCreator = report.getMonthlyReportTooltip();
        }
        MonthlyReport.FDNode paymentNode = report.getNode(marketsNode, "diktat_fuel_fees");
        paymentNode.name = "\u8f9b\u8fbe\u5f3a\u6743\u71c3\u6599\u6761\u7ea6\u8d54\u6b3e";
        paymentNode.icon = this.faction.getCrest();
        if (paymentNode.tooltipCreator == null) {
            paymentNode.tooltipCreator = new TooltipMakerAPI.TooltipCreator(){

                public boolean isTooltipExpandable(Object tooltipParam) {
                    return false;
                }

                public float getTooltipWidth(Object tooltipParam) {
                    return 450.0f;
                }

                public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                    tooltip.addPara("\u5411 \u8f9b\u8fbe\u5f3a\u6743 \u652f\u4ed8\u7684\u8d54\u6b3e\uff0c\u4ee5\u786e\u4fdd\u5176\u4e0d\u4f1a\u7528\u7269\u7406\u65b9\u5f0f\u5e72\u6d89\u4f60\u7684\u71c3\u6599\u751f\u4ea7\u751f\u610f\u3002", 0.0f);
                }
            };
        }
        return paymentNode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AgreementEndingType {
        BROKEN;

    }
}

