/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.EconomyAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.ui.ButtonAPI;
import com.fs.starfarer.api.ui.IntelUIAPI;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriTachyonDeal
extends BaseIntelPlugin
implements EconomyAPI.EconomyUpdateListener {
    public static final String HAS_TRI_TACH_DEAL = "$hasTriTachDeal";
    public static final String BROKE_TRI_TACH_DEAL = "$brokeTriTachDeal";
    public static float REP_FOR_BREAKING_DEAL = 0.5f;
    public static float MARKET_SIZE_TO_ACCESSIBILITY = 0.01f;
    public static String KEY = "$triTachDeal_ref";
    public static String BUTTON_END = "End";
    public static String UPDATE_PARAM_ACCEPTED = "update_param_accepted";
    protected FactionAPI faction = Global.getSector().getFaction("tritachyon");
    protected AgreementEndingType endType = null;
    public static String ACCESS_MOD_ID = "ttDeal_access";

    public static boolean hasDeal() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getBoolean(HAS_TRI_TACH_DEAL);
    }

    public static void setHasDeal(boolean deal) {
        Global.getSector().getPlayerMemoryWithoutUpdate().set(HAS_TRI_TACH_DEAL, deal);
    }

    public static boolean brokeDeal() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getBoolean(BROKE_TRI_TACH_DEAL);
    }

    public static void setBrokeDeal(boolean broke) {
        Global.getSector().getPlayerMemoryWithoutUpdate().set(BROKE_TRI_TACH_DEAL, broke);
    }

    public static TriTachyonDeal get() {
        return (TriTachyonDeal)Global.getSector().getMemoryWithoutUpdate().get(KEY);
    }

    public TriTachyonDeal(InteractionDialogAPI dialog) {
        this.setImportant(true);
        TriTachyonDeal.setHasDeal(true);
        TextPanelAPI text = null;
        if (dialog != null) {
            text = dialog.getTextPanel();
        }
        Global.getSector().getEconomy().addUpdateListener(this);
        Global.getSector().getMemoryWithoutUpdate().set(KEY, this);
        Global.getSector().getIntelManager().addIntel(this, true);
        this.economyUpdated();
        this.sendUpdate(UPDATE_PARAM_ACCEPTED, text);
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
        TriTachyonDeal.setHasDeal(false);
        Global.getSector().getMemoryWithoutUpdate().unset(KEY);
        Global.getSector().getEconomy().removeUpdateListener(this);
        this.unapplyAccessModifier();
    }

    @Override
    protected void notifyEnded() {
        super.notifyEnded();
    }

    protected Object readResolve() {
        return this;
    }

    public String getBaseName() {
        return "\u901f\u5b50\u79d1\u6218\u7565\u5408\u4f5c\u4f19\u4f34";
    }

    public String getAcceptedPostfix() {
        return "Accepted";
    }

    public String getBrokenPostfix() {
        return "\u5df2\u89e3\u6563";
    }

    @Override
    public String getName() {
        String postfix = "";
        if (this.isEnding() && this.endType != null) {
            switch (this.endType) {
                case BROKEN: {
                    postfix = " - " + this.getBrokenPostfix();
                }
            }
        }
        if (this.isSendingUpdate() && this.getListInfoParam() == UPDATE_PARAM_ACCEPTED) {
            postfix = " - " + this.getAcceptedPostfix();
        }
        return String.valueOf(this.getBaseName()) + postfix;
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return this.faction;
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    protected float computeColonySize(String factionId) {
        float size = 0.0f;
        for (MarketAPI curr : Global.getSector().getEconomy().getMarketsCopy()) {
            if (!factionId.equals(curr.getFactionId()) || curr.hasCondition("decivilized")) continue;
            size += (float)curr.getSize();
        }
        return size;
    }

    protected float computeAccessibilityBonusPlayer() {
        float size = this.computeColonySize("tritachyon");
        return size * MARKET_SIZE_TO_ACCESSIBILITY;
    }

    protected float computeAccessibilityBonusTriTach() {
        float size = this.computeColonySize("player");
        return size * MARKET_SIZE_TO_ACCESSIBILITY;
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        boolean isUpdate = this.getListInfoParam() != null;
        int accessPlayer = Math.round(this.computeAccessibilityBonusPlayer() * 100.0f);
        int accessTriTach = Math.round(this.computeAccessibilityBonusTriTach() * 100.0f);
        if (!this.isEnded() && !this.isEnding()) {
            String fName = Global.getSector().getPlayerFaction().getDisplayName();
            LabelAPI label = info.addPara(String.valueOf(fName) + " \u6b96\u6c11\u5730 %s \u6d41\u901a\u6027", initPad, tc, h, "+" + accessPlayer + "%");
            label.setHighlight(fName, "+" + accessPlayer + "%");
            label.setHighlightColors(Misc.getBasePlayerColor(), h);
            initPad = 0.0f;
            fName = this.faction.getDisplayName();
            label = info.addPara(String.valueOf(fName) + " \u6b96\u6c11\u5730 %s \u6d41\u901a\u6027", initPad, tc, h, "+" + accessTriTach + "%");
            label.setHighlight(fName, "+" + accessTriTach + "%");
            label.setHighlightColors(this.faction.getBaseUIColor(), h);
        }
        this.unindent(info);
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        info.addImage(this.getFaction().getLogo(), width, 128.0f, opad);
        if (this.isEnding() || this.isEnded()) {
            info.addPara("\u4f60\u4e0e \u901f\u5b50\u79d1\u6280 \u7684\u534f\u8bae\u4e0d\u518d\u751f\u6548\u3002", opad);
            return;
        }
        info.addPara("\u4e0e %s \u5efa\u7acb\u5408\u4f5c\u5173\u7cfb\uff0c\u8ba9\u4f60\u80fd\u591f\u501f\u52a9\u53cc\u65b9\u5171\u5efa\u7684\u8054\u5408\u5e02\u573a\u5b9e\u73b0\u4e92\u60e0\u4e92\u5229\u3002", opad, this.faction.getBaseUIColor(), this.faction.getDisplayNameLong());
        this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
        info.addPara("\u83b7\u5f97\u7684\u6d41\u901a\u6027\u589e\u76ca\u53d6\u51b3\u4e8e\u53e6\u4e00\u4f4d\u4f19\u4f34\u7684\u603b\u6b96\u6c11\u5730\u89c4\u6a21\u3002", opad);
        info.addPara("\u8be5\u5408\u540c\u63aa\u8f9e\u8c28\u614e\uff0c\u5373\u4f7f\u53cc\u65b9\u9677\u5165\u516c\u5f00\u654c\u5bf9\u72b6\u6001\u4e5f\u5c06\u7ee7\u7eed\u751f\u6548\uff0c\u4ece\u6cd5\u5f8b\u89d2\u5ea6\u6765\u770b\uff0c\u5b83\u5177\u6709\u6c38\u4e45\u7ea6\u675f\u529b\u3002", opad);
        info.addPara("\u4f60\u5f53\u7136\u53ef\u4ee5\u7ec8\u6b62\u6218\u7565\u5408\u4f5c\u5173\u7cfb\uff0c\u4f46\u5728\u4f5c\u51fa\u8fd9\u79cd\u7f3a\u4e4f\u5408\u7ea6\u7cbe\u795e\u7684\u884c\u4e3a\u4e4b\u540e\uff0c\u5c31\u4e0d\u53ef\u80fd\u91cd\u65b0\u5efa\u7acb\u7c7b\u4f3c\u7684\u5173\u7cfb\u3002", opad);
        ButtonAPI button = info.addButton("\u7ec8\u6b62\u6218\u7565\u5408\u4f5c\u5173\u7cfb", BUTTON_END, this.getFactionForUIColors().getBaseUIColor(), this.getFactionForUIColors().getDarkUIColor(), (int)width, 20.0f, opad * 1.0f);
        button.setShortcut(22, true);
    }

    @Override
    public String getIcon() {
        return this.faction.getCrest();
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Agreements");
        tags.add(this.faction.getId());
        return tags;
    }

    @Override
    public String getImportantIcon() {
        return Global.getSettings().getSpriteName("intel", "important_accepted_mission");
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        return null;
    }

    public FactionAPI getFaction() {
        return this.faction;
    }

    public void endAgreement(AgreementEndingType type, InteractionDialogAPI dialog) {
        if (!this.isEnded() && !this.isEnding()) {
            this.endType = type;
            this.setImportant(false);
            this.endImmediately();
            if (dialog != null) {
                this.sendUpdate(new Object(), dialog.getTextPanel());
            }
            if (type == AgreementEndingType.BROKEN) {
                TriTachyonDeal.setBrokeDeal(true);
                Misc.incrUntrustwortyCount();
                TextPanelAPI text = dialog == null ? null : dialog.getTextPanel();
                Misc.adjustRep("tritachyon", -REP_FOR_BREAKING_DEAL, text);
            }
        }
    }

    @Override
    public void buttonPressConfirmed(Object buttonId, IntelUIAPI ui) {
        if (buttonId == BUTTON_END) {
            this.endAgreement(AgreementEndingType.BROKEN, null);
        }
        super.buttonPressConfirmed(buttonId, ui);
    }

    @Override
    public void createConfirmationPrompt(Object buttonId, TooltipMakerAPI prompt) {
        if (buttonId == BUTTON_END) {
            prompt.addPara("\u4f60\u53ef\u4ee5\u7ec8\u6b62\u6218\u7565\u5408\u4f5c\u5173\u7cfb\uff0c\u4f46\u8fd9\u5c06\u635f\u4f24\u4f60\u4e0e %s \u7684\u5173\u7cfb\uff0c\u4e14\u5728\u4f5c\u51fa\u8fd9\u79cd\u7f3a\u4e4f\u5408\u7ea6\u7cbe\u795e\u7684\u884c\u4e3a\u4e4b\u540e\uff0c\u5c31\u4e0d\u53ef\u80fd\u91cd\u65b0\u5efa\u7acb\u7c7b\u4f3c\u7684\u5173\u7cfb\u3002", 0.0f, this.faction.getBaseUIColor(), this.faction.getDisplayName());
        }
    }

    @Override
    public boolean doesButtonHaveConfirmDialog(Object buttonId) {
        if (buttonId == BUTTON_END) {
            return true;
        }
        return super.doesButtonHaveConfirmDialog(buttonId);
    }

    @Override
    public void commodityUpdated(String commodityId) {
    }

    @Override
    public void economyUpdated() {
        float player = this.computeAccessibilityBonusPlayer();
        float triTach = this.computeAccessibilityBonusTriTach();
        String descPlayer = "\u6218\u7565\u5408\u4f5c\u4f19\u4f34\u5173\u7cfb " + this.faction.getDisplayName();
        String descTriTach = "\u6218\u7565\u5408\u4f5c\u4f19\u4f34\u5173\u7cfb " + Global.getSector().getPlayerFaction().getDisplayName();
        for (MarketAPI curr : Global.getSector().getEconomy().getMarketsCopy()) {
            float mod = 0.0f;
            String desc = null;
            if ("tritachyon".equals(curr.getFactionId())) {
                mod = triTach;
                desc = descTriTach;
            } else if ("player".equals(curr.getFactionId())) {
                mod = player;
                desc = descPlayer;
            }
            if (mod != 0.0f) {
                curr.getAccessibilityMod().modifyFlat(ACCESS_MOD_ID, mod, desc);
                continue;
            }
            curr.getAccessibilityMod().unmodifyFlat(ACCESS_MOD_ID);
        }
    }

    public void unapplyAccessModifier() {
        for (MarketAPI curr : Global.getSector().getEconomy().getMarketsCopy()) {
            curr.getAccessibilityMod().unmodifyFlat(ACCESS_MOD_ID);
        }
    }

    @Override
    public boolean isEconomyListenerExpired() {
        return this.isEnding() || this.isEnded();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AgreementEndingType {
        BROKEN;

    }
}

