/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events;

import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseIndustry;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.BaseGetCommodityBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.contacts.ContactIntel;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class CorruptPLClerkSuppliesBarEvent
extends BaseGetCommodityBarEvent {
    public boolean shouldShowAtMarket(MarketAPI market) {
        if (!super.shouldShowAtMarket(market)) {
            return false;
        }
        this.regen(market);
        if (!market.getFactionId().equals("persean")) {
            return false;
        }
        if (market.getId().equals("kazeron")) {
            return false;
        }
        if (market.getStabilityValue() > 7.0f) {
            return false;
        }
        return market.hasSpaceport();
    }

    protected String getCommodityId() {
        return "supplies";
    }

    protected void doExtraConfirmActions() {
        ContactIntel.addPotentialContact(this.person, this.market, this.text);
    }

    protected void adjustPerson(PersonAPI person) {
        super.adjustPerson(person);
        person.setImportanceAndVoice(this.pickLowImportance(), this.random);
        person.addTag("trade");
    }

    protected String getPersonPost() {
        return Ranks.POST_SUPPLY_MANAGER;
    }

    protected String getPersonFaction() {
        return "persean";
    }

    protected String getPersonRank() {
        return Ranks.CITIZEN;
    }

    protected int computeQuantity() {
        int quantity = 30 + 10 * this.random.nextInt(4);
        CommodityOnMarketAPI com = this.market.getCommodityData(this.commodity);
        int size = com.getAvailable();
        if (size < 1) {
            size = 1;
        }
        quantity = (int)((float)quantity * Math.max(1.0f, BaseIndustry.getSizeMult(size) - 2.0f));
        return quantity;
    }

    protected float getPriceMult() {
        return 0.75f;
    }

    protected String getPrompt() {
        return "\u4e00\u540d\u8eab\u7740\u6e2f\u52a1\u5c40\u5236\u670d\u7684" + this.getManOrWoman() + " \u6b63\u5c0f\u5fc3\u7ffc\u7ffc\u5730\u8bd5\u56fe\u5f15\u8d77\u4f60\u7684\u6ce8\u610f\u3002";
    }

    protected String getOptionText() {
        return "\u548c\u8fd9\u540d\u6e2f\u52a1\u5c40\u5b98\u5458\u8c08\u8c08";
    }

    protected String getMainText() {
        return "\u6e2f\u52a1\u5458\u5fae\u7b11\u7740\u8868\u793a\u60f3\u8bf7\u4f60\u559d\u4e00\u676f\uff0c\u4f60\u7ed9\u4e86\u4ed6\u4e00\u4e2a\u9762\u5b50\uff0c\u5750\u5728\u4e86\u4ed6\u65c1\u8fb9\u3002\"\u6ca1\u9519\uff0c\u6211\u770b\u8fc7\u4f60\u7684\u8d27\u7269\u6e05\u5355\u3002\" \u4ed6\u8bf4\uff0c\"\u800c\u6211\u89c9\u5f97\u8fd9\u91cc\u6709\u4e00\u4e2a\u4f60\u53ef\u80fd\u611f\u5174\u8da3\u7684\u673a\u4f1a\u3002\"" + Misc.ucFirst(this.getHeOrShe()) + "\u8c28\u614e\u73af\u987e\u56db\u5468\uff0c\u5e76\u9762\u9732\u72e1\u8bd8\u3002" + "\u4e25\u683c\u6765\u8bf4\uff0c\u6211\u4eec\u559c\u6b22\u5c06\u5b83\u79f0\u4e3a\uff1a" + "shall we say, exercise personal judgment.\"\n\n" + "\u6e2f\u52a1\u5458\u8be6\u7ec6\u5730\u4e3a\u4f60\u8bb2\u8ff0\u4e86\u8fd9\u513f\u7684\u8d27\u7269\u4e22\u5931\uff0c\u662f\u591a\u4e48\u4e00\u4ef6\u4e60\u4ee5\u4e3a\u5e38\u7684\u4e8b\u60c5\uff0c" + "\u5373\u4f7f\u6570\u91cf\u60ca\u4eba\uff0c\u6bd4\u5982 %s \u5355\u4f4d\u7684\u8865\u7ed9\u4e5f\u53ef\u80fd\u4f1a \"\u968f\u65f6\u5931\u8e2a\"\u3002" + "\"\u5f53\u7136\uff0c\u8fd9\u53ea\u662f\u4e13\u95e8\u4e3a\u90a3\u4e9b\u6765\u81ea Kazeron \u8054\u5408\u4f01\u4e1a\u7684\u5bcc\u6709\u6df7\u86cb\u800c\u8bbe\u8ba1\u7684\uff0c" + "\u6bd5\u7adf\u4ed6\u4eec\u80af\u5b9a\u4f1a\u518d\u6b21\u5149\u987e\u516c\u5f00\u5e02\u573a\u5e76\u8d2d\u4e70\u8db3\u591f\u591a\u7684\u66ff\u4ee3\u54c1\u3002" + Misc.ucFirst(this.getHeOrShe()) + "\u987f\u4e86\u987f\uff0c\u8fc5\u901f\u5c06" + this.getHisOrHer() + "\u624b\u4e2d\u7684\u5564\u9152\u4e00\u996e\u800c\u5c3d\uff0c\u5e76\u63d0\u51fa\u6761\u4ef6\uff0c\u6bcf\u4ef6\u81f3\u5c11 %s}\uff0c\u4ee5\u4f5c\u4e3a" + this.getHeOrShe() + "\u7684\u4ecb\u7ecd\u8d39\u3002";
    }

    protected String[] getMainTextTokens() {
        return new String[]{Misc.getWithDGS(this.quantity), Misc.getDGSCredits(this.unitPrice)};
    }

    protected Color[] getMainTextColors() {
        return new Color[]{Misc.getHighlightColor(), Misc.getHighlightColor()};
    }

    protected String getConfirmText() {
        return "\u63a5\u53d7\u63d0\u8bae\uff0c\u5e76\u5c06 " + Misc.getDGSCredits(this.unitPrice * this.quantity) + " \u6c47\u5165\u5176\u79c1\u4eba\u8d26\u6237\u5185";
    }

    protected String getCancelText() {
        return "\u62d2\u7edd\u63d0\u8bae\uff0c\u5e76\u89e3\u91ca\u8bf4\u4f60\u4e0d\u60f3\u63d2\u624b\u8054\u76df\u4e8b\u52a1";
    }

    protected String getAcceptText() {
        return "\u4f60\u79bb\u5f00\u9152\u5427\uff0c\u5728\u4f60\u7684 TriPad \u4e0a\u627e\u5230\u4e86\u672c\u5730\u6e2f\u52a1\u5c40\u53d1\u9001\u7684\u4e00\u6761\u63d0\u9192\u4fe1\u606f\u3002\u4fe1\u606f\u663e\u793a\u4f60\u5728 12 \u53f7\u8d27\u4ed3\u91cc\u9057\u7559\u4e86 %s \u5355\u4f4d\u8865\u7ed9\uff0c\u5e76\u4e14\u5728\u4e0b\u4e00\u4e2a\u73ed\u6b21\u7ed3\u675f\u524d\u8fd9\u4e2a\u8d27\u4ed3\u9700\u8981\u88ab\u6e05\u7a7a\u3002";
    }

    protected String[] getAcceptTextTokens() {
        return new String[]{Misc.getWithDGS(this.quantity)};
    }

    protected Color[] getAcceptTextColors() {
        return new Color[]{Misc.getHighlightColor()};
    }
}

