/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.ids.Sounds;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.BaseGetCommodityBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.DeliveryMissionIntel;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.SetStoryOption;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Random;

public class DeliveryBarEvent
extends BaseGetCommodityBarEvent {
    public static String KEY_FAILED_RECENTLY = "$core_dmi_failedRecently";
    public static String KEY_SAW_DELIVERY_EVENT_RECENTLY = "$core_dmi_sawRecently";
    public static String KEY_ACCEPTED_AT_THIS_MARKET_RECENTLY = "$core_dmi_acceptedAtThisMarket";
    public static float PROB_HIGHER_CAPACITY = 0.25f;
    public static float FAILED_RECENTLY_DURATION = 365.0f;
    public static float SAW_RECENTLY_DURATION = 180.0f;
    public static float ACCEPTED_AT_THIS_MARKET_DURATION = 90.0f;
    public static float PROB_TO_SHOW = 0.5f;
    protected MarketAPI destination;
    protected int reward;
    protected int escrow;
    protected float duration;
    protected FactionAPI faction;
    protected int playerCargoCap = 0;
    protected int playerFuelCap = 0;
    protected DestinationData data;

    public boolean shouldShowAtMarket(MarketAPI market) {
        if (!super.shouldShowAtMarket(market)) {
            return false;
        }
        if (market.getFactionId().equals("pirates")) {
            return false;
        }
        if (market.getFactionId().equals("luddic_path")) {
            return false;
        }
        if (market.getMemoryWithoutUpdate().getBoolean(KEY_ACCEPTED_AT_THIS_MARKET_RECENTLY)) {
            return false;
        }
        this.regen(market);
        if (this.destination == null) {
            return false;
        }
        if (this.escrow > 0 && market.isPlayerOwned()) {
            return false;
        }
        if (Global.getSector().getMemoryWithoutUpdate().getBoolean(KEY_SAW_DELIVERY_EVENT_RECENTLY) && this.shownAt != market && this.random.nextFloat() > PROB_TO_SHOW) {
            return false;
        }
        Global.getSector().getMemoryWithoutUpdate().set(KEY_SAW_DELIVERY_EVENT_RECENTLY, true, SAW_RECENTLY_DURATION);
        return true;
    }

    protected void regen(MarketAPI market) {
        if (this.market != market) {
            this.playerCargoCap = 0;
            this.playerFuelCap = 0;
        }
        this.market = market;
        this.random = new Random(this.seed + (long)market.getId().hashCode());
        this.computeData(market);
        if (this.destination != null) {
            this.person = this.createPerson();
        }
    }

    protected void computeData(MarketAPI market) {
        float mult;
        float base;
        this.data = null;
        this.destination = null;
        this.reward = 0;
        this.duration = 0.0f;
        this.faction = null;
        this.quantity = 0;
        this.commodity = null;
        ArrayList<CommodityOnMarketAPI> commodities = new ArrayList<CommodityOnMarketAPI>();
        for (CommodityOnMarketAPI com : market.getCommoditiesCopy()) {
            if (com.isNonEcon() || com.isMeta() || com.isPersonnel() || com.isIllegal() || com.getAvailable() <= 0 || com.getMaxSupply() <= 0) continue;
            commodities.add(com);
        }
        ArrayList<DestinationData> potential = new ArrayList<DestinationData>();
        float maxScore = 0.0f;
        float maxDist = 0.0f;
        for (MarketAPI other : Global.getSector().getEconomy().getMarketsCopy()) {
            if (other == market || other.isHidden() || other.isInvalidMissionTarget() || other.getEconGroup() == null && market.getEconGroup() != null || other.getEconGroup() != null && !other.getEconGroup().equals(market.getEconGroup()) || other.getStarSystem() == null) continue;
            for (CommodityOnMarketAPI com : commodities) {
                CommodityOnMarketAPI otherCom = other.getCommodityData(com.getDemandClass());
                if (otherCom.getMaxDemand() <= 0) continue;
                DestinationData data = new DestinationData(market, other, com, otherCom);
                if (data.illegal) continue;
                if (data.score > maxScore) {
                    maxScore = data.score;
                }
                if (data.distLY > maxDist) {
                    maxDist = data.distLY;
                }
                potential.add(data);
            }
        }
        if (maxDist > 10.0f) {
            maxDist = 10.0f;
        }
        WeightedRandomPicker<DestinationData> picker = new WeightedRandomPicker<DestinationData>(this.random);
        int i = 0;
        while (i < potential.size()) {
            DestinationData d = (DestinationData)potential.get(i);
            if (d.score > maxScore * 0.5f && d.distLY > maxDist * 0.5f) {
                picker.add(d, d.score * d.score * d.score);
            }
            ++i;
        }
        DestinationData pick = (DestinationData)picker.pick();
        if (pick == null) {
            return;
        }
        this.destination = pick.dest;
        this.duration = pick.distLY * 5.0f + 50.0f;
        this.duration = (int)this.duration / 10 * 10;
        CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
        this.quantity = (int)cargo.getMaxCapacity();
        if (pick.com.isFuel()) {
            this.quantity = (int)cargo.getMaxFuel();
        }
        if (this.random.nextFloat() < PROB_HIGHER_CAPACITY) {
            this.quantity = this.quantity = (int)((float)this.quantity * (1.0f + this.random.nextFloat() * 3.0f));
        }
        if (pick.com.isFuel()) {
            if (this.playerFuelCap == 0) {
                this.playerFuelCap = this.quantity;
            } else {
                this.quantity = this.playerFuelCap;
            }
        } else if (this.playerCargoCap == 0) {
            this.playerCargoCap = this.quantity;
        } else {
            this.quantity = this.playerCargoCap;
        }
        this.quantity = (int)((float)this.quantity * (0.5f + 0.25f * this.random.nextFloat()));
        this.quantity = (int)((float)this.quantity * Math.min(1.0f, 200.0f / pick.comFrom.getCommodity().getBasePrice()));
        int limit = (int)((float)pick.comFrom.getAvailable() * pick.comFrom.getCommodity().getEconUnit());
        limit = (int)((float)limit * (0.75f + 0.5f * this.random.nextFloat()));
        if (this.quantity > limit) {
            this.quantity = limit;
        }
        if (this.quantity > 10000) {
            this.quantity = this.quantity / 1000 * 1000;
        } else if (this.quantity > 100) {
            this.quantity = this.quantity / 10 * 10;
        } else if (this.quantity > 10) {
            this.quantity = this.quantity / 10 * 10;
        }
        if (this.quantity < 10) {
            this.quantity = 10;
        }
        if ((float)this.quantity * (base = pick.comFrom.getMarket().getSupplyPrice(pick.comFrom.getId(), 1.0, true)) < 4000.0f) {
            base = Math.min(100, 4000 / this.quantity);
        }
        float minBase = 100.0f - 50.0f * Math.min(1.0f, (float)this.quantity / 500.0f);
        if (base < (minBase = (base + minBase) * 0.75f)) {
            base = minBase;
        }
        if ((mult = pick.score / 30.0f) < 0.75f) {
            mult = 0.75f;
        }
        this.reward = (int)(base * mult * (float)this.quantity);
        this.reward = this.reward / 1000 * 1000;
        if (this.reward < 4000) {
            this.reward = 4000;
        }
        if (Global.getSector().getMemoryWithoutUpdate().getBoolean(KEY_FAILED_RECENTLY)) {
            this.escrow = (int)((float)this.quantity * pick.comFrom.getCommodity().getBasePrice());
        }
        if (market.getFaction() == pick.dest.getFaction()) {
            this.faction = market.getFaction();
        } else {
            this.faction = Global.getSector().getFaction("independent");
            if (this.faction == null) {
                this.faction = market.getFaction();
            }
        }
        this.commodity = pick.comFrom.getId();
        this.data = pick;
    }

    protected int getNegotiatedAmount() {
        return (int)((float)this.reward * 1.5f);
    }

    protected void addStoryOption() {
        String id = "negotiate_id";
        this.options.addOption("\u5c1d\u8bd5\u63d0\u9ad8\u8fd0\u8d39", id);
        SetStoryOption.StoryOptionParams params = new SetStoryOption.StoryOptionParams(id, 1, "negotiateDeliveryFee", Sounds.STORY_POINT_SPEND_INDUSTRY, "\u7ecf\u534f\u5546\u63d0\u9ad8\u4e86\u8fd0\u8d39 - " + this.data.comFrom.getCommodity().getLowerCaseName() + " \u8fd0\u9001\u81f3 " + this.data.dest.getName());
        SetStoryOption.set(this.dialog, params, new SetStoryOption.BaseOptionStoryPointActionDelegate(this.dialog, params){

            public void confirm() {
                super.confirm();
                DeliveryBarEvent.this.reward = DeliveryBarEvent.this.getNegotiatedAmount();
                this.dialog.getTextPanel().addPara(DeliveryBarEvent.this.getNegotiatedText());
                OptionPanelAPI options = this.dialog.getOptionPanel();
                options.clearOptions();
                options.addOption("\u7ee7\u7eed", "confirm");
            }

            public String getTitle() {
                return null;
            }

            public void createDescription(TooltipMakerAPI info) {
                float opad = 10.0f;
                info.addSpacer(-opad);
                info.setParaInsigniaLarge();
                info.addPara("\u4f60\u53ef\u4ee5\u5c1d\u8bd5\u5c06 %s \u8fd0\u8d39\u52a0\u4ef7\u81f3 %s.", 0.0f, Misc.getHighlightColor(), Misc.getDGSCredits(DeliveryBarEvent.this.reward), Misc.getDGSCredits(DeliveryBarEvent.this.getNegotiatedAmount()));
                info.addSpacer(opad * 2.0f);
                this.addActionCostSection(info);
            }
        });
    }

    protected boolean canAccept() {
        if (this.escrow <= 0) {
            return true;
        }
        float credits = Global.getSector().getPlayerFleet().getCargo().getCredits().get();
        boolean canAfford = credits >= (float)this.escrow;
        return canAfford;
    }

    protected void doStandardConfirmActions() {
        CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
        TextPanelAPI text = this.dialog.getTextPanel();
        cargo.addCommodity(this.commodity, this.quantity);
        AddRemoveCommodity.addCommodityGainText(this.commodity, this.quantity, text);
        if (this.escrow > 0) {
            cargo.getCredits().subtract(this.escrow);
            AddRemoveCommodity.addCreditsLossText(this.escrow, text);
        }
        this.createIntel();
    }

    protected void createIntel() {
        DeliveryMissionIntel intel = new DeliveryMissionIntel(this, this.dialog);
        this.market.getMemoryWithoutUpdate().set(KEY_ACCEPTED_AT_THIS_MARKET_RECENTLY, true, ACCEPTED_AT_THIS_MARKET_DURATION * (0.75f + this.random.nextFloat() * 0.5f));
    }

    protected void adjustPerson(PersonAPI person) {
        super.adjustPerson(person);
        person.setImportanceAndVoice(this.pickImportance(), this.random);
        person.addTag("trade");
    }

    protected String getPersonFaction() {
        return this.faction.getId();
    }

    protected String getPersonRank() {
        return Ranks.CITIZEN;
    }

    protected String getPersonPost() {
        return this.pickOne(Ranks.POST_TRADER, Ranks.POST_COMMODITIES_AGENT, Ranks.POST_MERCHANT, Ranks.POST_INVESTOR);
    }

    protected float getPriceMult() {
        return 0.0f;
    }

    protected String getPrompt() {
        if (this.faction.getId().equals("independent")) {
            return "\u5728\u4e00\u5904\u4e0d\u8d77\u773c\u7684\u89d2\u843d\u65c1\uff0c\u4e00\u540d" + this.getManOrWoman() + "\u6b63\u805a\u7cbe\u4f1a\u795e\u7684\u770b\u7740" + this.getHisOrHer() + "\u7684 TriPad.";
        }
        return "\u5728\u4e00\u5904\u4e0d\u8d77\u773c\u7684\u89d2\u843d\u65c1\uff0c\u4e00\u540d" + this.getManOrWoman() + " (\u80f8\u524d\u4f69\u6234\u6709 " + this.faction.getPersonNamePrefixAOrAn() + " " + this.faction.getPersonNamePrefix() + " \u5fbd\u7ae0) " + "\u6b63\u805a\u7cbe\u4f1a\u795e\u7684\u770b\u7740" + this.getHisOrHer() + "\u7684 TriPad.";
    }

    protected String getOptionText() {
        return "\u4f60\u5411\u90a3\u540d" + this.getManOrWoman() + "\u70b9\u5934\u793a\u610f\uff0c\u5e76\u8d70\u5230" + this.getHisOrHer() + "\u7684\u684c\u5b50\u65c1";
    }

    protected String getMainText() {
        int cap;
        String str = "";
        if (this.market.isPlayerOwned()) {
            String \u5148\u751f = "\u5148\u751f";
            if (Global.getSector().getPlayerPerson().isFemale()) {
                \u5148\u751f = "\u5973\u58eb";
            }
            str = "\"\u54e6\uff01\u662f\u60a8\uff0c" + \u5148\u751f + "!\", " + this.getHeOrShe() + "\u5174\u594b\u5730\u60ca\u547c\u9053\u3002\u5728" + this.getHisOrHer() + "\u6062\u590d\u51b7\u9759\u540e\uff0c" + this.getHeOrShe() + "\u51d1\u8fc7\u8eab\u5b50\u5e76\u7ee7\u7eed\u8bf4\u9053\uff0c\"\u6211\u4eec\u9047\u5230\u4e86\u4e00\u4e9b\u540e\u52e4\u65b9\u9762\u7684\u95ee\u9898\uff0c" + "\u53ef\u80fd\u9700\u8981\u60a8\u4eb2\u81ea\u53bb\u5904\u7406\u3002" + "\u6709 %s \u5355\u4f4d\u7684 " + this.data.comFrom.getCommodity().getLowerCaseName() + " \u6025\u9700\u4ea4\u4ed8" + "\u7ed9 %s" + "\uff0c\u5176\u5177\u4f53\u4f4d\u7f6e\u5728 " + this.data.dest.getStarSystem().getNameWithLowercaseType() + "\u3002";
            str = this.data.fromHasPA || this.data.hasPA ? String.valueOf(str) + "\u4f46\u6700\u8fd1\u7684\u6d77\u76d7\u6d3b\u52a8\u4f7f\u5f97\u8be5\u76ee\u6807\u96be\u4ee5\u5b9e\u73b0\uff0c\u5e38\u89c4\u7684\u8d38\u6613\u8230\u961f\u65e0\u6cd5\u80dc\u4efb\u8fd9\u4e00\u4efb\u52a1\u3002\"" : (this.data.fromHasCells || this.data.hasCells ? String.valueOf(str) + "\u4f46\u6700\u8fd1\u8086\u63a0\u7684\u5362\u5fb7\u5de6\u5f84\u4f7f\u5f97\u8be5\u76ee\u6807\u96be\u4ee5\u5b9e\u73b0\uff0c\u5e38\u89c4\u7684\u8d38\u6613\u8230\u961f\u65e0\u6cd5\u80dc\u4efb\u8fd9\u4e00\u4efb\u52a1\u3002\"" : String.valueOf(str) + "\u4f46\u662f\uff0c\u597d\u5427\uff0c\u4f60\u77e5\u9053\u90a3\u4e9b\u8d38\u6613\u8230\u961f\u7684\u8230\u957f\u90fd\u662f\u4e9b\u4ec0\u4e48\u6837\u7684\u4eba\u3002\u6211\u4eec\u548c\u4ed6\u4eec\u5728\u5371\u9669\u6d25\u8d34\u65b9\u9762\u4ea7\u751f\u4e86\u4e00\u4e9b\u5206\u6b67\uff0c\u8fd9\u8ba9\u6211\u4eec\u73b0\u5728\u7684\u5904\u5883\u975e\u5e38\u5c34\u5c2c\u3002\"");
        } else {
            str = "\u7ecf\u8fc7\u7b80\u77ed\u4ecb\u7ecd\u540e\uff0c" + this.getHeOrShe() + " \u7acb\u5373\u76f4\u5954\u4e3b\u9898\u3002\n\n" + "\"\u6211\u6709 %s \u5355\u4f4d\u7684 " + this.data.comFrom.getCommodity().getLowerCaseName() + " \u6025\u9700\u4ea4\u4ed8" + "\u7ed9 %s" + "\uff0c\u5176\u5177\u4f53\u4f4d\u7f6e\u5728 " + this.data.dest.getStarSystem().getNameWithLowercaseType() + "\u3002";
            str = this.data.fromHasPA || this.data.hasPA ? String.valueOf(str) + "\u9644\u8fd1\u7684\u6d77\u76d7\u6d3b\u52a8\u8ba9\u8fd9\u6b21\u8fd0\u8f93\u4efb\u52a1\u53d8\u5f97\u5f02\u5e38\u8270\u96be\uff0c\u4f46\u4f60\u770b\u8d77\u6765\u5e94\u8be5\u80fd\u80dc\u4efb\u8fd9\u9879\u4efb\u52a1\u3002\"" : (this.data.fromHasCells || this.data.hasCells ? String.valueOf(str) + "\u9644\u8fd1\u7684\u5362\u5fb7\u5de6\u5f84\u6d3b\u52a8\u8ba9\u8fd9\u6b21\u8fd0\u8f93\u4efb\u52a1\u53d8\u5f97\u5f02\u5e38\u8270\u96be\uff0c\u4f46\u4f60\u770b\u8d77\u6765\u5e94\u8be5\u80fd\u5904\u7406\u8fd9\u4e9b\u9ebb\u70e6\u3002\"" : String.valueOf(str) + "\u7531\u4e8e\u6211\u4eec\u548c\u6b63\u89c4\u7684\u8d27\u8fd0\u516c\u53f8\u53d1\u751f\u4e86\u4e00\u4e9b\u7ea0\u7eb7\uff0c\u8fd9\u4f7f\u5f97\u6211\u4eec\u9677\u5165\u4e24\u96be\u4e4b\u4e2d\u3002\u4f46\u5982\u679c\u6709\u4f60\u8fd9\u6837\u7684\u4eba\u6765\u5e2e\u5fd9\uff0c\u8fd9\u79cd\u5dee\u4e8b\u5e94\u8be5\u8f7b\u800c\u6613\u4e3e\u3002\"");
        }
        String where = "\u5176\u5177\u4f53\u4f4d\u7f6e\u5728\u8d85\u7a7a\u95f4\u5185\uff0c";
        if (this.data.dest.getStarSystem() != null) {
            where = "\u5176\u5177\u4f53\u4f4d\u7f6e\u5728 " + this.data.dest.getStarSystem().getNameWithLowercaseType();
        }
        str = String.valueOf(str) + "\n\n\u4f60\u60f3\u8d77\u6765 " + this.data.dest.getName() + " \u5982\u4eca\u5728 %s \u7684\u63a7\u5236\u4e4b\u4e0b\uff0c" + where + "\u3002";
        CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
        str = this.data.comFrom.isFuel() ? ((cap = cargo.getFreeFuelSpace()) > 1 ? String.valueOf(str) + " \u4f60\u7684\u8230\u961f\u8fd8\u80fd\u50a8\u5b58 %s \u5355\u4f4d\u7684\u71c3\u6599\u3002" : String.valueOf(str) + "%s\u4f60\u7684\u8230\u961f\u6cb9\u7f50\u5df2\u7ecf\u6ee1\u4e86\u3002") : ((cap = (int)cargo.getSpaceLeft()) > 1 ? String.valueOf(str) + " \u4f60\u7684\u8230\u961f\u8fd8\u80fd\u50a8\u5b58 %s \u5355\u4f4d\u7684\u8d27\u7269\u3002" : String.valueOf(str) + "%s\u4f60\u7684\u8230\u961f\u8d27\u8231\u5df2\u7ecf\u6ee1\u4e86\u3002");
        str = this.market.isPlayerOwned() ? String.valueOf(str) + "\n\n" + Misc.ucFirst(this.getHeOrShe()) + "\u770b\u7740" + this.getHisOrHer() + "\u7684 TriPad \u8bf4\u9053\uff1a" + "\"\u5ba2\u6237\u5c06\u652f\u4ed8 %s \u4f5c\u4e3a\u62a5\u916c\uff0c\u4f46\u4f60\u5fc5\u987b\u5728 %s \u5929\u5185\u5b8c\u6210\u4ea4\u4ed8\u3002\u4f60\u613f\u610f\u63a5\u53d7\u5417\uff1f\"" : (this.escrow > 0 ? String.valueOf(str) + "\n\n" + Misc.ucFirst(this.getHeOrShe()) + "\u770b\u7740" + this.getHisOrHer() + "\u7684 TriPad \u8bf4\u9053\uff1a" + "\"\u62a5\u916c\u4e3a %s}\uff0c\u5728 %s \u5929\u5185\u4ea4\u8d27\u65f6\u4ed8\u6b3e\u3002\u6b64\u5916\u4f60\u8fd8\u987b" + "\u652f\u4ed8 %s \u5230\u6258\u7ba1\u8d26\u6237\u5185\uff0c\u522b\u62c5\u5fc3\uff0c" + "\u8fd9\u4e9b\u4fdd\u8bc1\u91d1\u4f1a\u5728\u4f60\u5b8c\u6210\u4ea4\u4ed8\u540e\u9000\u8fd8\uff0c" + "\u8fd9\u4ec5\u4ec5\u53ea\u662f\u6807\u51c6\u7684\u4fdd\u9669\u7a0b\u5e8f\u800c\u5df2\uff0c\u4f60\u660e\u767d\u4e86\u4e48\uff1f\"" : String.valueOf(str) + "\n\n" + Misc.ucFirst(this.getHeOrShe()) + "\u770b\u7740" + this.getHisOrHer() + "\u7684 TriPad \u8bf4\u9053\uff1a" + "\"\u62a5\u916c %s}\uff0c\u5728 %s \u5929\u5185\u4ea4\u8d27\u65f6\u4ed8\u6b3e\u3002\u4f60\u613f\u610f\u4e48\uff1f\"");
        return str;
    }

    protected String[] getMainTextTokens() {
        CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
        int cap = 0;
        cap = this.data.comFrom.isFuel() ? cargo.getFreeFuelSpace() : (int)cargo.getSpaceLeft();
        return new String[]{Misc.getWithDGS(this.quantity), this.data.dest.getName(), this.data.dest.getFaction().getPersonNamePrefix(), cap > 1 ? Misc.getWithDGS(cap) : " ", Misc.getDGSCredits(this.reward), Misc.getWithDGS(this.duration), Misc.getDGSCredits(this.escrow)};
    }

    protected Color[] getMainTextColors() {
        return new Color[]{Misc.getHighlightColor(), Misc.getTextColor(), this.data.dest.getFaction().getBaseUIColor(), Misc.getHighlightColor(), Misc.getHighlightColor(), Misc.getHighlightColor(), Misc.getHighlightColor()};
    }

    protected String getConfirmText() {
        if (this.market.isPlayerOwned()) {
            return "\u540c\u610f\u5e76\u63a5\u53d7\u8fd9\u4efd\u5408\u540c";
        }
        return "\u63a5\u53d7\u8fd0\u8f93\u5408\u540c";
    }

    protected String getNegotiatedText() {
        return "\"\u4f60\u53ef\u771f\u4f1a\u8ba8\u4ef7\u8fd8\u4ef7\uff0c\u597d\u5427\uff0c\u4e00\u8a00\u4e3a\u5b9a\u3002\"" + Misc.ucFirst(this.getHeOrShe()) + "\u5e76\u6ca1\u8868\u73b0\u51fa\u4e0d\u6ee1\u3002" + "\u770b\u6765\u6700\u521d\u62a5\u4ef7\u5e94\u8be5\u504f\u4f4e\u4e86\u3002";
    }

    protected String getCancelText() {
        if (this.market.isPlayerOwned()) {
            return "\u62d2\u7edd\uff0c\u5e76\u89e3\u91ca\u4f60\u8fd8\u6709\u5176\u4ed6\u8981\u52a1\u9700\u8981\u5904\u7406";
        }
        return "\u62d2\u7edd\u8fd9\u4efd\u5de5\u4f5c\uff0c\u5e76\u89e3\u91ca\u8bf4\u4f60\u8fd8\u6709\u5176\u4ed6\u8ba1\u5212";
    }

    protected String getAcceptText() {
        return "\u4f60\u6536\u5230\u4e86\u8fdb\u5165\u6e2f\u53e3\u4ed3\u5e93\u7684\u6388\u6743\u4ee3\u7801\uff0c\u73b0\u5728\u53ef\u8054\u7cfb\u4f60\u7684\u519b\u9700\u5b98\uff0c\u5e76\u5f00\u59cb\u88c5\u8f7d\u8d27\u7269\u3002";
    }

    public MarketAPI getDestination() {
        return this.destination;
    }

    public int getReward() {
        return this.reward;
    }

    public float getDuration() {
        return this.duration;
    }

    public FactionAPI getFaction() {
        return this.faction;
    }

    public DestinationData getData() {
        return this.data;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public int getEscrow() {
        return this.escrow;
    }

    protected boolean showCargoCap() {
        return false;
    }

    protected void showTotalAndOptions() {
        super.showTotalAndOptions();
        String icon = Global.getSettings().getCommoditySpec(this.commodity).getIconName();
        String text = null;
        LinkedHashSet<String> tags = new LinkedHashSet<String>();
        tags.add("Missions");
        this.dialog.getVisualPanel().showMapMarker(this.getDestination().getPrimaryEntity(), "\u76ee\u7684\u5730\uff1a" + this.getDestination().getName(), this.getDestination().getFaction().getBaseUIColor(), true, icon, text, tags);
    }

    public static class DestinationData {
        public MarketAPI dest;
        public CommodityOnMarketAPI comFrom;
        public CommodityOnMarketAPI com;
        public float distLY;
        public boolean fromHasPA = false;
        public boolean fromHasCells = false;
        public boolean hasPA = false;
        public boolean hasCells = false;
        public boolean illegal = false;
        public float score = 0.0f;

        public DestinationData(MarketAPI from, MarketAPI dest, CommodityOnMarketAPI comFrom, CommodityOnMarketAPI comDest) {
            this.dest = dest;
            this.comFrom = comFrom;
            this.com = comDest;
            this.distLY = Misc.getDistanceLY(from.getLocationInHyperspace(), dest.getLocationInHyperspace());
            this.fromHasPA = from.hasCondition("pirate_activity");
            this.fromHasCells = from.hasCondition("pather_cells");
            this.hasPA = dest.hasCondition("pirate_activity");
            this.hasCells = dest.hasCondition("pather_cells");
            this.illegal = dest.isIllegal(this.com.getId());
            this.score += Math.min(this.distLY, 10.0f);
            if (this.fromHasPA) {
                this.score += 10.0f;
            }
            if (this.fromHasCells) {
                this.score += 5.0f;
            }
            if (this.hasPA) {
                this.score += 10.0f;
            }
            if (this.hasCells) {
                this.score += 5.0f;
            }
        }
    }
}

