/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.ReputationActionResponsePlugin;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.intel.BaseMissionIntel;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.DeliveryBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.DeliveryFailureConsequences;
import com.fs.starfarer.api.impl.campaign.intel.contacts.ContactIntel;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.shared.PlayerTradeDataForSubmarket;
import com.fs.starfarer.api.impl.campaign.shared.SharedData;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeliveryMissionIntel
extends BaseMissionIntel {
    public static float PROB_PIRATE_ENCOUNTER = 0.5f;
    public static float PROB_CONSEQUENCES = 0.75f;
    public static float PROB_CONSEQUENCES_ESCROW = 0.25f;
    public static Logger log = Global.getLogger(DeliveryMissionIntel.class);
    protected DeliveryBarEvent event;

    public DeliveryMissionIntel(DeliveryBarEvent event, InteractionDialogAPI dialog) {
        this.event = event;
        this.setDuration(Float.valueOf(event.getDuration()));
        Global.getSector().getIntelManager().addIntel(this, false, dialog == null ? null : dialog.getTextPanel());
        this.setImportant(true);
        this.setMissionState(BaseMissionIntel.MissionState.ACCEPTED);
        this.missionAccepted();
        Global.getSector().addScript(this);
    }

    @Override
    public void missionAccepted() {
        Misc.makeImportant(this.event.getDestination().getPrimaryEntity(), "deliveryEvent");
    }

    public DeliveryBarEvent getEvent() {
        return this.event;
    }

    @Override
    public void advanceMission(float amount) {
        if (!this.event.getDestination().isInEconomy()) {
            this.setMissionResult(new BaseMissionIntel.MissionResult(0, null, null));
            this.setMissionState(BaseMissionIntel.MissionState.FAILED);
            this.endMission();
        }
    }

    public void performDelivery(InteractionDialogAPI dialog) {
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        CargoAPI cargo = playerFleet.getCargo();
        cargo.removeItems(CargoAPI.CargoItemType.RESOURCES, this.event.getCommodityId(), this.event.getQuantity());
        cargo.getCredits().add(this.event.getReward() + this.event.getEscrow());
        this.applyTradeValueImpact(this.event.getReward());
        AddRemoveCommodity.addCommodityLossText(this.event.getCommodityId(), this.event.getQuantity(), dialog.getTextPanel());
        if (this.event.getEscrow() > 0) {
            AddRemoveCommodity.addCreditsGainText(this.event.getEscrow(), dialog.getTextPanel());
        }
        AddRemoveCommodity.addCreditsGainText(this.event.getReward(), dialog.getTextPanel());
        float repAmount = 0.01f * (float)this.event.getReward() / 10000.0f;
        if (repAmount < 0.01f) {
            repAmount = 0.01f;
        }
        if (repAmount > 0.05f) {
            repAmount = 0.05f;
        }
        CoreReputationPlugin.MissionCompletionRep completionRep = new CoreReputationPlugin.MissionCompletionRep(repAmount, RepLevel.COOPERATIVE, -repAmount, RepLevel.INHOSPITABLE);
        ReputationActionResponsePlugin.ReputationAdjustmentResult rep = null;
        rep = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.MISSION_SUCCESS, (Object)completionRep, null, dialog.getTextPanel(), true, true), this.getFactionForUIColors().getId());
        this.setMissionResult(new BaseMissionIntel.MissionResult(this.event.getReward() + this.event.getEscrow(), rep, null));
        this.setMissionState(BaseMissionIntel.MissionState.COMPLETED);
        this.endMission();
        ContactIntel.addPotentialContact(this.event.getPerson(), this.event.getMarket(), dialog.getTextPanel());
    }

    public boolean hasEnough() {
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        CargoAPI cargo = playerFleet.getCargo();
        return cargo.getCommodityQuantity(this.event.getCommodityId()) >= (float)this.event.getQuantity();
    }

    protected void applyTradeValueImpact(float totalReward) {
        FactionAPI faction = this.getFactionForUIColors();
        MarketAPI market = this.event.getDestination();
        boolean illegal = market.isIllegal(this.event.getCommodityId());
        SubmarketAPI submarket = null;
        for (SubmarketAPI curr : market.getSubmarketsCopy()) {
            if (!curr.getPlugin().isParticipatesInEconomy()) continue;
            if (illegal && curr.getPlugin().isBlackMarket()) {
                submarket = curr;
                break;
            }
            if (illegal || !curr.getPlugin().isOpenMarket()) continue;
            submarket = curr;
            break;
        }
        if (submarket == null) {
            return;
        }
        PlayerTradeDataForSubmarket tradeData = SharedData.getData().getPlayerActivityTracker().getPlayerTradeData(submarket);
        CargoStackAPI stack = Global.getFactory().createCargoStack(CargoAPI.CargoItemType.RESOURCES, this.event.getCommodityId(), null);
        stack.setSize(this.event.getQuantity());
        tradeData.addToTrackedPlayerSold(stack, totalReward);
        Misc.affectAvailabilityWithinReason(this.getCommodity(), this.event.getQuantity());
    }

    @Override
    public void endMission() {
        if (this.event.getMarket() == null) {
            this.endAfterDelay();
            return;
        }
        Misc.makeUnimportant(this.event.getDestination().getPrimaryEntity(), "deliveryEvent");
        if (!this.event.getMarket().isPlayerOwned() && (this.isFailed() || this.isAbandoned())) {
            Global.getSector().getMemoryWithoutUpdate().set(DeliveryBarEvent.KEY_FAILED_RECENTLY, true, DeliveryBarEvent.FAILED_RECENTLY_DURATION * (0.75f + (float)Math.random() * 0.5f));
            float p = PROB_CONSEQUENCES;
            if (this.event.getEscrow() > 0) {
                p = PROB_CONSEQUENCES_ESCROW;
            }
            if ((float)Math.random() < p || DebugFlags.BAR_DEBUG) {
                Global.getSector().addScript(new DeliveryFailureConsequences(this));
            }
        }
        this.endAfterDelay();
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        boolean isUpdate = this.getListInfoParam() != null;
        FactionAPI faction = this.getFactionForUIColors();
        if (isUpdate) {
            if (this.isFailed() || this.isCancelled()) {
                return;
            }
            if (this.isCompleted() && this.missionResult != null) {
                if (this.missionResult.payment > 0) {
                    info.addPara("%s \u5df2\u6536\u5230", initPad, tc, h, Misc.getDGSCredits(this.missionResult.payment));
                }
                if (this.missionResult.rep1 != null && this.missionResult.rep1.delta != 0.0f) {
                    CoreReputationPlugin.addAdjustmentMessage(this.missionResult.rep1.delta, faction, null, null, null, info, tc, isUpdate, 0.0f);
                }
            }
        } else if (this.missionResult != null) {
            if (this.missionResult.payment > 0) {
                info.addPara("%s \u5df2\u6536\u5230", initPad, tc, h, Misc.getDGSCredits(this.missionResult.payment));
                initPad = 0.0f;
            }
            if (this.missionResult.rep1 != null && this.missionResult.rep1.delta != 0.0f) {
                CoreReputationPlugin.addAdjustmentMessage(this.missionResult.rep1.delta, faction, null, null, null, info, tc, isUpdate, initPad);
                initPad = 0.0f;
            }
        } else {
            if (mode != IntelInfoPlugin.ListInfoMode.IN_DESC) {
                info.addPara("\u53d1\u5e03\u65b9\uff1a{" + faction.getDisplayName(), initPad, tc, faction.getBaseUIColor(), faction.getDisplayName());
                initPad = 0.0f;
            }
            LabelAPI label = info.addPara("\u5c06 %s \u5355\u4f4d \u8fd0\u9001\u81f3 " + this.event.getDestination().getName(), initPad, tc, h, "" + this.event.getQuantity());
            label.setHighlight("" + this.event.getQuantity(), this.event.getDestination().getName());
            label.setHighlightColors(h, this.event.getDestination().getFaction().getBaseUIColor());
            info.addPara("%s \u5956\u52b1", 0.0f, tc, h, Misc.getDGSCredits(this.event.getReward()));
            if (this.event.getEscrow() > 0) {
                info.addPara("%s \u4f5c\u4e3a\u672c\u6b21\u8fd0\u8f93\u7684\u4fdd\u8bc1\u91d1", 0.0f, tc, h, Misc.getDGSCredits(this.event.getEscrow()));
            }
            this.addDays(info, "\u671f\u9650", this.duration.floatValue() - this.elapsedDays, tc, 0.0f);
        }
        this.unindent(info);
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color c = this.getTitleColor(mode);
        float pad = 3.0f;
        float opad = 10.0f;
        info.addPara(this.getName(), c, 0.0f);
        this.addBulletPoints(info, mode);
    }

    @Override
    public String getSortString() {
        return "\u8fd0\u8f93";
    }

    @Override
    public String getName() {
        if (this.isAccepted() || this.isPosted()) {
            return "\u8fd0\u8f93 - " + this.getCommodity().getCommodity().getName();
        }
        return "\u8fd0\u8f93 " + this.getPostfixForState();
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return this.event.getFaction();
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    protected CommodityOnMarketAPI getCommodity() {
        return this.event.getDestination().getCommodityData(this.event.getCommodityId());
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        FactionAPI faction = this.getFactionForUIColors();
        boolean illegal = this.event.getDestination().isIllegal(this.event.getCommodityId());
        CommodityOnMarketAPI com = this.getCommodity();
        MarketAPI market = this.event.getDestination();
        info.addImages(width, 80.0f, opad, opad * 2.0f, com.getCommodity().getIconName(), faction.getCrest(), market.getFaction().getCrest());
        String post = "";
        if ("pirates".equals(faction.getId())) {
            post = "-affiliated";
        }
        String start = "\u4f60";
        if (!this.isPosted() && !this.isAccepted()) {
            start = "\u4f60\u66fe ";
        }
        if (this.event.getMarket() == null) {
            return;
        }
        LabelAPI label = info.addPara(String.valueOf(start) + " \u63a5\u53d7\u4e86 " + faction.getPersonNamePrefixAOrAn() + " " + faction.getPersonNamePrefix() + post + " \u7684\u5408\u540c\uff0c\u5c06 " + com.getCommodity().getLowerCaseName() + " \u4ece " + this.event.getMarket().getName() + " \u8fd0\u8f93\u5230 " + market.getName() + ", " + "\u800c\u6b64\u5904\u5982\u4eca\u5728 " + market.getFaction().getPersonNamePrefix() + " \u7684\u63a7\u5236\u4e4b\u4e0b\u3002", opad, faction.getBaseUIColor(), String.valueOf(faction.getPersonNamePrefix()) + post);
        label.setHighlight(String.valueOf(faction.getPersonNamePrefix()) + post, market.getFaction().getPersonNamePrefix());
        label.setHighlightColors(faction.getBaseUIColor(), market.getFaction().getBaseUIColor());
        if (this.isPosted() || this.isAccepted()) {
            this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
            info.addPara("\u5982\u9700\u4ea4\u8d27\uff0c\u8981\u4e48\u5728 " + market.getName() + " \u7684\u6e2f\u53e3\u516c\u5f00\u505c\u9760\uff0c" + "\u8981\u4e48\u5728\u4e0d\u5f15\u8d77\u9644\u8fd1\u5de1\u903b\u961f\u7684\u6ce8\u610f\u4e0b\u533f\u8e2a\u505c\u9760\u3002", opad);
            this.addAcceptOrAbandonButton(info, width);
        } else {
            if (this.isFailed() && !market.isInEconomy()) {
                info.addPara("\u672c\u5408\u540c\u65e0\u6cd5\u5c65\u884c\uff0c\u56e0\u4e3a " + market.getName() + " \u5f53\u5c40\u7684\u653f\u6743\u5df2\u88ab\u74e6\u89e3\u3002", opad);
            } else {
                this.addGenericMissionState(info);
            }
            this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
        }
    }

    @Override
    public String getIcon() {
        return this.getCommodity().getCommodity().getIconName();
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Trade");
        tags.add(this.getFactionForUIColors().getId());
        return tags;
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        return this.event.getDestination().getPrimaryEntity();
    }

    @Override
    protected String getMissionTypeNoun() {
        return "\u5408\u540c";
    }

    @Override
    protected BaseMissionIntel.MissionResult createAbandonedResult(boolean withPenalty) {
        if (withPenalty) {
            float repAmount = 0.01f * (float)this.event.getReward() / 10000.0f;
            if (repAmount < 0.01f) {
                repAmount = 0.01f;
            }
            if (repAmount > 0.05f) {
                repAmount = 0.05f;
            }
            CoreReputationPlugin.MissionCompletionRep completionRep = new CoreReputationPlugin.MissionCompletionRep(repAmount, RepLevel.WELCOMING, -repAmount, RepLevel.INHOSPITABLE);
            ReputationActionResponsePlugin.ReputationAdjustmentResult rep = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.MISSION_FAILURE, (Object)completionRep, null, null, true, false), this.getFactionForUIColors().getId());
            return new BaseMissionIntel.MissionResult(0, rep, null);
        }
        return new BaseMissionIntel.MissionResult();
    }

    @Override
    public boolean canAbandonWithoutPenalty() {
        return false;
    }

    @Override
    protected BaseMissionIntel.MissionResult createTimeRanOutFailedResult() {
        return this.createAbandonedResult(true);
    }

    public MarketAPI getDestination() {
        return this.event.getDestination();
    }
}

