/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events;

import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.BaseGetCommodityBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.contacts.ContactIntel;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class DiktatLobsterBarEvent
extends BaseGetCommodityBarEvent {
    public boolean shouldShowAtMarket(MarketAPI market) {
        if (!super.shouldShowAtMarket(market)) {
            return false;
        }
        this.regen(market);
        return market.getFactionId().equals("sindrian_diktat");
    }

    protected void doExtraConfirmActions() {
        ContactIntel.addPotentialContact(this.person, this.market, this.text);
    }

    protected void adjustPerson(PersonAPI person) {
        super.adjustPerson(person);
        person.setImportanceAndVoice(this.pickMediumImportance(), this.random);
        person.addTag("military");
    }

    protected String getPersonPost() {
        return Ranks.POST_AGENT;
    }

    protected String getCommodityId() {
        return "lobster";
    }

    protected String getPersonFaction() {
        return "sindrian_diktat";
    }

    protected String getPersonRank() {
        return Ranks.GROUND_CAPTAIN;
    }

    protected int computeQuantity() {
        int quantity = 50 + 50 * this.random.nextInt(4);
        return quantity;
    }

    protected float getPriceMult() {
        return 0.75f;
    }

    protected String getPrompt() {
        return "\u4e00\u540d\u6ee1\u8138\u559c\u8272\u7684\u5b89\u5168\u90e8\u519b\u5b98\u6b63\u5174\u594b\u5730\u5411\u65c1\u8fb9\u7684\u9152\u5ba2\u6bd4\u5212\u7740\u4ec0\u4e48\u3002";
    }

    protected String getOptionText() {
        return "\u4e0d\u52a8\u58f0\u8272\u5730\u9760\u8fd1\u8fd9\u540d\u5b89\u5168\u90e8\u519b\u5b98\uff0c\u770b\u770b\u4ed6\u4eec\u5728\u9ad8\u5174\u4ec0\u4e48";
    }

    protected String getMainText() {
        String heOrShe = this.getHeOrShe();
        String himOrHer = this.getHimOrHer();
        String hisOrHer = this.getHisOrHer();
        return "\"\u90a3\u5565\uff1f\u4eca\u5929\u6709\u4e2a\u5343\u8f7d\u96be\u9022\u7684\u597d\u673a\u4f1a\u843d\u5728\u4e86\u6211\u7684\u5934\u4e0a\u3002\u800c\u4e14\u4f60\u4e5f\u6709\u4efd\uff0c\u597d\u5f97\u5f88\uff01\" " + heOrShe + "\u5982\u738b\u8005\u822c\u5f20\u5f00\u4e86" + hisOrHer + "\u53cc\u81c2" + "\uff0c\u4eff\u4f5b\u8981\u7ed9\u4f60\u6bd4\u5212\u8fd9\u597d\u673a\u4f1a\u5230\u5e95\u6709\u591a\u5927\uff0c\u5dee\u70b9\u5c31\u6ca1\u628a\u65c1\u8fb9\u4eba\u7684\u9152\u7ed9\u78b0\u6d12\u4e86\u3002" + "\n\n" + "\u4e8e\u662f\u4e4e\uff0c\u4f60\u53c8\u542c\u5230\u4e86\u4e00\u4e2a\u8ba9\u4eba\u8033\u6735\u8d77\u8327\u7684\u8d44\u4ea7\u7f5a\u6ca1\u6545\u4e8b" + "\u7f5a\u6ca1\u5bf9\u8c61\u81ea\u7136\u662f\u90a3\u4e9b '\u4e0d\u5fe0\u5206\u5b50\u4eec'\u3002\n\n" + "\"\u5176\u5b9e\u8fd9\u5bf9...\u4f60\u61c2\u7684\u90a3\u4e9b\u5bb6\u4f19\u6765\u8bf4\u4e5f\u4e0d\u7b97\u4ec0\u4e48\u5927\u9ebb\u70e6\uff0c\u5bf9\u5427\uff1f" + "\u4f46\u4ed6\u4eec\u4e00\u76f4\u575a\u6301\u8981\u6c42\u5bf9\u6b64\u575a\u51b3\u6253\u51fb\uff0c\u5e38\u6293\u4e0d\u61c8...\u5f53\u7136\uff0c\u6211\u4e5f\u5c31\u4e0d\u4ecb\u610f\u4ece\u8fd9\u4efd\u5de5\u4f5c\u91cc\u635e\u70b9\u597d\u5904\u4e86\u3002\"";
    }

    protected String getMainText2() {
        String heOrShe = this.getHeOrShe();
        String himOrHer = this.getHimOrHer();
        String hisOrHer = this.getHisOrHer();
        return "\u5982\u679c\u628a\u4f60\u542c\u5230\u4e8b\u505a\u4e2a\u6c47\u603b\u7684\u8bdd\uff0c\u90a3\u5c31\u662f\u7b2c\u56db\u533a\u5baa\u5175\u961f\u7684\u8bc1\u7269\u67dc\u3001\u7ef4\u4fee\u8f66\u95f4\uff0c\u5c31\u8fde\u597d\u51e0\u95f4\u5ba1\u8baf\u5ba4\u91cc\u90fd\u585e\u6ee1\u4e86\u4e00\u7bb1\u7bb1\u7684\u51b0\u9c9c\u84dd\u9f99\u867e\uff0c\u603b\u5171\u5c06\u8fd1 %s \u5355\u4f4d\u3002\u6ca1\u9519\uff0c\u519b\u5b98\u4eec\u987f\u987f\u90fd\u5403\u5f97\u50cf\u7687\u5ba4\u5927\u9910\u4e00\u6837\u4e30\u76db\uff0c\u4f46\u6bcf\u4e2a\u4eba\u4e5f\u5c31\u5403\u5f97\u4e0b\u90a3\u4e48\u591a\u70b9\u4e1c\u897f\u3002\u800c\u73b0\u5728\u5982\u679c\u4e0d\u6362\u7535\u6c60\u7684\u8bdd\uff0c\u5236\u51b7\u5668\u5c31\u6ca1\u6cd5\u518d\u9876\u4e00\u5468\u4e86\u3002\n\n" + Misc.ucFirst(heOrShe) + "\u548c\u4f60\u5546\u8ba8\u4e4b\u540e\uff0c" + "\u6572\u5b9a\u5927\u6982\u53ea\u8981 %s \u5c31\u80fd\u8ba9\u7b2c\u56db\u533a\u7684\u6307\u6325\u5b98\u548c\u4f60\u5728\u8fd9\u7ed3\u4ea4\u5230\u7684\u65b0\u670b\u53cb\u6ee1\u610f\u4ea4\u8d27\u3002" + "\u7136\u540e\u6240\u6709\u7684\u8d27\u7269\u90fd\u4f1a\u76f4\u63a5\u8f6c\u5230\u4f60\u7684\u8d27\u8231\u91cc\uff0c\u4e0d\u7528\u7406\u4f1a\u5173\u7a0e\u3002\n\n" + "\"\u600e\u4e48\u6837\uff0c\u60a8\u613f\u610f\u5e2e\u52a9\u6211\u4eec\u7ef4\u6301\u8fd9\u513f\u7684\u6cd5\u5f8b\u4e0e\u79e9\u5e8f\u5417\uff1f\"";
    }

    protected String[] getMainText2Tokens() {
        return new String[]{Misc.getWithDGS(this.quantity), Misc.getDGSCredits(this.unitPrice * this.quantity)};
    }

    protected Color[] getMainText2Colors() {
        return new Color[]{Misc.getHighlightColor(), Misc.getHighlightColor()};
    }

    protected String getConfirmText() {
        return "\u63a5\u53d7\u63d0\u8bae\uff0c\u5e76\u5c06 " + Misc.getDGSCredits(this.unitPrice * this.quantity) + " \u6c47\u5165\u5176\u79c1\u4eba\u8d26\u6237\u5185";
    }

    protected String getCancelText() {
        return "\u4ee5\u5bf9\u6d77\u9c9c\u8fc7\u654f\u4e3a\u7531\uff0c\u62d2\u7edd\u4e86\u8be5\u63d0\u8bae";
    }

    protected String getAcceptText() {
        return null;
    }

    protected String[] getAcceptTextTokens() {
        return new String[0];
    }

    protected Color[] getAcceptTextColors() {
        return new Color[0];
    }
}

