/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events;

import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseIndustry;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.BaseGetCommodityBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.contacts.ContactIntel;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class LuddicCraftBarEvent
extends BaseGetCommodityBarEvent {
    public boolean shouldShowAtMarket(MarketAPI market) {
        if (!super.shouldShowAtMarket(market)) {
            return false;
        }
        this.regen(market);
        if (!market.getFactionId().equals("luddic_church") && !market.getFactionId().equals("luddic_path")) {
            return false;
        }
        if (market.getStabilityValue() < 4.0f) {
            return false;
        }
        CommodityOnMarketAPI com = market.getCommodityData(this.commodity);
        if (com.getMaxSupply() <= 0) {
            return false;
        }
        return com.getAvailable() >= com.getMaxDemand();
    }

    protected String getCommodityId() {
        return "domestic_goods";
    }

    protected void doExtraConfirmActions() {
        ContactIntel.addPotentialContact(this.person, this.market, this.text);
    }

    protected void adjustPerson(PersonAPI person) {
        super.adjustPerson(person);
        person.setImportanceAndVoice(this.pickMediumImportance(), this.random);
        person.addTag("trade");
    }

    protected String getPersonPost() {
        return Ranks.POST_GUILDMASTER;
    }

    protected String getPersonFaction() {
        return "luddic_church";
    }

    protected String getPersonRank() {
        return Ranks.CITIZEN;
    }

    protected int computeQuantity() {
        int quantity = 30 + 10 * this.random.nextInt(4);
        CommodityOnMarketAPI com = this.market.getCommodityData(this.commodity);
        int size = Math.min(com.getAvailable(), com.getMaxSupply());
        if (size < 1) {
            size = 1;
        }
        quantity = (int)((float)quantity * Math.max(1.0f, BaseIndustry.getSizeMult(size) - 2.0f));
        return quantity;
    }

    protected float getPriceMult() {
        return 0.75f;
    }

    protected String getPrompt() {
        return "\u4e00\u540d\u770b\u8d77\u6765\u9887\u4e3a\u58ee\u5b9e\u7684" + this.getManOrWoman() + "\u6b63\u5750\u5728\u89d2\u843d\u8fb9\u7684\u684c\u5b50\u65c1\uff0c\u684c\u4e0a\u5219\u653e\u7740\u4e00\u987f\u521a\u5403\u5b8c\u7684\u6b8b\u7fb9\u5269\u996d\uff0c" + "\u9152\u5427\u867d\u7136\u660f\u6697\uff0c\u4f46\u4f60\u4ecd\u80fd\u770b\u6e05\u5176\u8eab\u7740\u7684\u5de5\u4f5c\u670d\u867d\u7136\u6709\u4e9b\u7834\u65e7\u4f46\u526a\u88c1\u8003\u7a76\uff0c\u4e14\u80f8\u524d\u8fd8\u4f69\u6234\u6709\u5de5\u827a\u884c\u4f1a\u7684\u5fbd\u7ae0\u3002";
    }

    protected String getOptionText() {
        return "\u4f60\u72b9\u8c6b\u4e86\u4e00\u9635\uff0c\u5e76\u8d70\u5411\u8fd9\u540d" + this.getManOrWoman();
    }

    protected String getMainText() {
        String heOrShe = this.getHeOrShe();
        String himOrHer = this.getHimOrHer();
        return "\u4f60\u4e3a" + himOrHer + "\u70b9\u4e86\u676f\u5564\u9152\uff0c\u7136\u540e\u804a\u4e86\u8d77\u6765\u3002" + Misc.ucFirst(heOrShe) + "\u539f\u6765\u662f\u8fd9\u4e00\u5730\u533a\u5de5\u827a\u884c\u4f1a\u7684\u4f1a\u957f\uff0c" + "\u4e14\u6700\u8fd1\u9047\u5230\u4e86\u4e9b\u9ebb\u70e6\u3002\"\u6211\u4eec\u7684\u796d\u53f8\u5927\u4eba\uff0c" + "\u5176\u601d\u60f3... \u592a\u8fc7\u8ff7\u604b\u7cbe\u795e\u4e0a\u7684\u6170\u85c9\uff0c\u800c\u5ffd\u7565\u4e86\u73b0\u5b9e\u4e16\u754c\u7684\u672c\u8d28\u3002\"" + Misc.ucFirst(heOrShe) + "\u62ac\u8d77\u5934\u770b\u7740\u6ee1\u8138\u7591\u60d1\u7684\u4f60\uff0c\u89e3\u91ca\u9053\uff1a" + this.market.getName() + " \u4eba\u624b\u4e0d\u591f\uff0c\u5e76\u4e14\u5de5\u4f5c\u8fc7\u91cf\u3002\"\u5362\u5fb7\u5728\u4e0a\uff0c\u8bf7\u539f\u8c05\u6211\uff0c\u4f46\u7977\u544a\u53ef\u4e0d\u80fd\u62b5\u8d26\u5355\u3002\"\n\n" + Misc.ucFirst(heOrShe) + "\u8fdb\u4e00\u6b65\u89e3\u91ca\uff0c\"\u6211\u4eec\u8fd9\u91cc\u6709 %s \u5355\u4f4d\u7684\u65e5\u7528\u54c1\u6b63\u79ef\u538b\u5728\u5de5\u4f1a\u4ed3\u5e93\u91cc\uff0c" + "\u5982\u679c\u5b83\u4eec\u80fd\u4ee5\u6bcf\u4e2a %s \u7684\u4f4e\u4ef7\u6084\u7136\u51fa\u552e\uff0c\u5c31\u6ca1\u4eba\u4f1a\u5728\u610f\u90a3\u53ef\u601c\u7684\u5173\u7a0e\u4e86\uff0c" + "\u56e0\u4e3a\u8fd9\u53ea\u4e0d\u8fc7\u662f\u4e00\u79cd\u6148\u5584\u884c\u4e3a\u3002";
    }

    protected String[] getMainTextTokens() {
        return new String[]{Misc.getWithDGS(this.quantity), Misc.getDGSCredits(this.unitPrice)};
    }

    protected Color[] getMainTextColors() {
        return new Color[]{Misc.getHighlightColor(), Misc.getHighlightColor()};
    }

    protected String getConfirmText() {
        return "\u63a5\u53d7\u4ea4\u6613\uff0c\u5e76\u5c06 " + Misc.getDGSCredits(this.unitPrice * this.quantity) + " \u8f6c\u5165\u5de5\u4f1a\u8d26\u6237";
    }

    protected String getCancelText() {
        return "\u62d2\u7edd\u4ea4\u6613\uff0c\"\u6bd5\u7adf\uff0c\u8010\u5fc3\u662f\u4e00\u79cd\u7f8e\u5fb7\"";
    }

    protected String getAcceptText() {
        return "\"\u611f\u8c22\u5929\u610f\u628a\u4f60\u9001\u5230\u6211\u7684\u8eab\u8fb9\uff01\" \u516c\u4f1a\u4f1a\u957f\u62cd\u4e86\u62cd\u4f60\u7684\u540e\u80cc\uff0c\u7b11\u5bb9\u6ee1\u9762\u5730\u5927\u58f0\u8bf4\u9053\u3002\u5f88\u5feb\uff0c\u4f60\u7684\u8d27\u4ed3\u7edf\u8ba1\u5217\u8868\u4e0a\u591a\u4e86 %s \u4e2a \"\u4ece\u6df1\u7a7a\u6253\u635e\u56de\u6765\u7684\" \u7684\u65e5\u7528\u54c1\u3002";
    }

    protected String[] getAcceptTextTokens() {
        return new String[]{Misc.getWithDGS(this.quantity)};
    }

    protected Color[] getAcceptTextColors() {
        return new Color[]{Misc.getHighlightColor()};
    }
}

