/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events;

import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseIndustry;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.BaseGetCommodityBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.contacts.ContactIntel;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class LuddicFarmerBarEvent
extends BaseGetCommodityBarEvent {
    public boolean shouldShowAtMarket(MarketAPI market) {
        if (!super.shouldShowAtMarket(market)) {
            return false;
        }
        this.regen(market);
        if (!market.getFactionId().equals("luddic_church") && !market.getFactionId().equals("luddic_path")) {
            return false;
        }
        if (market.getStabilityValue() < 4.0f) {
            return false;
        }
        CommodityOnMarketAPI com = market.getCommodityData(this.commodity);
        if (com.getMaxSupply() <= 0) {
            return false;
        }
        return com.getAvailable() >= com.getMaxDemand();
    }

    protected String getCommodityId() {
        return "food";
    }

    protected void doExtraConfirmActions() {
        ContactIntel.addPotentialContact(this.person, this.market, this.text);
    }

    protected void adjustPerson(PersonAPI person) {
        super.adjustPerson(person);
        person.setImportanceAndVoice(this.pickLowImportance(), this.random);
        person.addTag("trade");
    }

    protected String getPersonPost() {
        return Ranks.POST_COMMUNE_LEADER;
    }

    protected String getPersonFaction() {
        return "luddic_church";
    }

    protected String getPersonRank() {
        return Ranks.CITIZEN;
    }

    protected int computeQuantity() {
        int quantity = 50 + 10 * this.random.nextInt(6);
        CommodityOnMarketAPI com = this.market.getCommodityData(this.commodity);
        int size = Math.min(com.getAvailable(), com.getMaxSupply());
        if (size < 1) {
            size = 1;
        }
        quantity = (int)((float)quantity * Math.max(1.0f, BaseIndustry.getSizeMult(size) - 2.0f));
        return quantity;
    }

    protected float getPriceMult() {
        return 0.75f;
    }

    protected String getPrompt() {
        return "\u4e00\u540d\u9971\u7ecf\u98ce\u971c\u7684" + this.getManOrWoman() + "\u6b63\u5750\u5728\u4e0d\u8d77\u773c\u7684\u684c\u5b50\u65c1\u559d\u7740\u4e00\u5c0f\u676f\u5564\u9152\u3002" + "\u5176\u8eab\u7740\u7684\u5de5\u4f5c\u670d\u867d\u7136\u6709\u4e9b\u7834\u65e7\u4f46\u526a\u88c1\u8003\u7a76\uff0c\u4e14\u80f8\u524d\u8fd8\u5370\u6709\u519c\u4e1a\u516c\u793e\u7684\u6807\u5fd7\u3002";
    }

    protected String getOptionText() {
        return "\u4f60\u8d70\u5411\u8fd9\u540d" + this.getManOrWoman();
    }

    protected String getMainText() {
        String heOrShe = this.getHeOrShe();
        return String.valueOf(Misc.ucFirst(heOrShe)) + "\u539f\u6765\u662f\u4e00\u540d\u519c\u4e1a\u516c\u793e\u7684\u4f1a\u957f" + ", " + heOrShe + "\u6765\"\u5c0f\u9547\"\u7684\u76ee\u7684\u662f\u4e3a\u5176\u4ea7\u54c1\u627e\u5230\u5408\u9002\u7684\u7ecf\u9500\u5546\uff0c" + Misc.ucFirst(heOrShe) + "\u5982\u4eca\u6709 %s \u5355\u4f4d\u7684\u98df\u7269\u6025\u9700\u51fa\u552e\uff0c\u5982\u679c\u73b0\u5728\u5168\u90e8\u8d2d\u4e70\uff0c" + "\u5c31\u80fd\u4ee5\u6bcf\u5355\u4f4d %s \u7684\u4f4e\u4ef7\u51fa\u552e\u7ed9\u4f60\u3002" + "\u5ffd\u7136\uff0c" + heOrShe + "\u5411\u4f60\u7728\u4e86\u7728\u773c\uff0c\u5e76\u7b11\u9053\uff1a\"\u4f5c\u4e3a\u8654\u8bda\u7684\u4fe1\u5f92\uff0c\u6211\u4eec\u4e0d\u9700\u8981\u4e3a\u6559\u4f1a\u7684\u5173\u7a0e\u800c\u70e6\u607c\u3002\"";
    }

    protected String[] getMainTextTokens() {
        return new String[]{Misc.getWithDGS(this.quantity), Misc.getDGSCredits(this.unitPrice)};
    }

    protected Color[] getMainTextColors() {
        return new Color[]{Misc.getHighlightColor(), Misc.getHighlightColor()};
    }

    protected String getConfirmText() {
        return "\u4f60\u4e0e\u5176\u63e1\u624b\uff0c\u5e76\u4ee5\u4ea4\u6362\u5b89\u5168\u901a\u8baf\u5bc6\u94a5\u7684\u65b9\u5f0f\u63a5\u53d7\u672c\u6b21\u4ea4\u6613";
    }

    protected String getCancelText() {
        return "\u62d2\u7edd\u8fd9\u7b14\u4ea4\u6613\uff0c\u5e76\u611f\u8c22" + this.getHimOrHer() + "\u7684\u63d0\u8bae";
    }

    protected String getAcceptText() {
        return "\u4f60\u4e0e\u8fd9\u540d\u519c\u573a\u4e3b\u4e00\u540c\u524d\u5f80" + this.market.getName() + "\u90ca\u533a\u4e00\u5904\u50fb\u9759\u7684\u4ed3\u5e93\u63d0\u53d6\u8d27\u7269\uff0c" + "\u968f\u540e\u4f60\u5c06\u8be6\u7ec6\u4fe1\u606f\u4f20\u9012\u7ed9\u4f60\u7684\u519b\u9700\u5b98\u5e76\u4ea4\u7531\u4ed6\u6765\u5904\u7406\u3002";
    }

    protected String[] getAcceptTextTokens() {
        return new String[0];
    }

    protected Color[] getAcceptTextColors() {
        return new Color[0];
    }
}

