/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.FullName;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.impl.campaign.events.OfficerManagerEvent;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.ids.Sounds;
import com.fs.starfarer.api.impl.campaign.intel.bar.PortsideBarData;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.BaseBarEventWithPerson;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathBaseIntel;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathCellsIntel;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseIntel;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.SetStoryOption;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuddicPathBaseBarEvent
extends BaseBarEventWithPerson {
    public static int COST = 10000;
    protected LuddicPathBaseIntel intel;

    @Override
    public boolean isAlwaysShow() {
        return true;
    }

    public LuddicPathBaseBarEvent(LuddicPathBaseIntel intel) {
        this.intel = intel;
    }

    @Override
    public boolean shouldShowAtMarket(MarketAPI market) {
        for (LuddicPathCellsIntel cell : LuddicPathCellsIntel.getCellsForBase(this.intel, true)) {
            if (cell.isSleeper() || cell.getSleeperTimeout() > 0.0f || cell.getMarket() != market) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldRemoveEvent() {
        return this.intel.isEnding() || this.intel.isEnded() || this.intel.isPlayerVisible();
    }

    @Override
    protected void regen(MarketAPI market) {
        if (this.market == market) {
            return;
        }
        super.regen(market);
    }

    @Override
    protected PersonAPI createPerson() {
        FactionAPI faction = Global.getSector().getFaction("luddic_path");
        int level = 1;
        PersonAPI person = OfficerManagerEvent.createOfficer(faction, level, OfficerManagerEvent.SkillPickPreference.NO_ENERGY_YES_BALLISTIC_YES_MISSILE_YES_DEFENSE, true, null, true, false, 0, this.random);
        return person;
    }

    @Override
    public void addPromptAndOption(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        super.addPromptAndOption(dialog, memoryMap);
        this.regen(dialog.getInteractionTarget().getMarket());
        TextPanelAPI text = dialog.getTextPanel();
        text.addPara("\u4e00\u540d\u5750\u5728\u5427\u53f0\u5bf9\u9762\u6709\u7740\u9192\u76ee\u5de6\u5f84\u7eb9\u8eab\u7684" + this.getManOrWoman() + "\u6b63\u76ee\u4e0d\u8f6c\u775b\u5730\u76ef\u7740\u4f60\uff0c" + "\u800c" + this.getHisOrHer() + "\u7684\u773c\u775b\u91cc\u5219\u95ea\u70c1\u7740\u7edd\u671b\u7684\u5149\u8292\u3002");
        dialog.getOptionPanel().addOption("\u548c\u5176\u5bf9\u89c6\u8bb8\u4e45\u540e\uff0c\u4f60\u4eec\u4fe9\u4e0d\u52a8\u58f0\u8272\u5730\u5411\u9152\u5427\u540e\u5df7\u8d70\u53bb", this, null);
    }

    @Override
    public void init(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        super.init(dialog, memoryMap);
        this.done = false;
        dialog.getVisualPanel().showPersonInfo(this.person, true);
        this.optionSelected(null, (Object)OptionId.INIT);
    }

    @Override
    public void optionSelected(String optionText, Object optionData) {
        if (!(optionData instanceof OptionId)) {
            return;
        }
        OptionId option = (OptionId)((Object)optionData);
        OptionPanelAPI options = this.dialog.getOptionPanel();
        TextPanelAPI text = this.dialog.getTextPanel();
        options.clearOptions();
        CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
        int credits = (int)cargo.getCredits().get();
        Color h = Misc.getHighlightColor();
        Color n = Misc.getNegativeHighlightColor();
        switch (option) {
            case INIT: {
                text.addPara("\u5728\u5df7\u5185\u6b65\u884c\u4e86\u7ea6\u4e00\u5206\u949f\u540e\uff0c\u524d\u65b9\u7684\u5de6\u5f84\u4fe1\u5f92\u505c\u4e0b\u4e86\u811a\u6b65\u3002");
                text.addPara("\"\u6211\u77e5\u9053\u4f60\u662f\u8c01\u3002\" " + this.getHeOrShe() + "\u8f6c\u8fc7\u8eab\u5e76\u6253\u65ad\u4e86\u4f60\u7684\u81ea\u6211\u4ecb\u7ecd\uff1a" + "\"\u6211\u73b0\u5728\u53ea\u80fd\u7948\u7977\u4ed6\u4eec\u5e76\u672a\u53d1\u73b0\u6211\u5728\u505a\u4e9b\u4ec0\u4e48... \u597d\u5427\uff0c\u4e3a\u4e86\u6d3b\u8fc7\u4eca\u665a\uff0c" + "\u5982\u679c\u4f60\u80fd\u5e2e\u6211\u641e\u5230\u4e00\u4e2a\u65b0\u7684\u8eab\u4efd\u82af\u7247\u6765\u8ba9\u6211\u9003\u79bb\u6b64\u5904\uff0c" + "\u90a3\u6211\u5c31\u5411\u4f60\u900f\u9732\u6b63\u5728\u4e3a\u8be5\u6b96\u6c11\u5730\u63d0\u4f9b\u7269\u8d44\u652f\u6301\u7684\u5de6\u5f84\u57fa\u5730\u4f4d\u7f6e\u3002\"");
                boolean canAccept = COST <= credits;
                LabelAPI label = text.addPara("\u4f60\u4f30\u8ba1\u9700\u82b1\u8d39 %s \u624d\u80fd\u5e2e" + this.getHeOrShe() + "\u4ece\u9ed1\u5e02\u90a3\u641e\u5230\u4e00\u5f20\u65b0\u7684\u8eab\u4efd\u82af\u7247\uff0c\u800c\u4f60\u5f53\u524d\u6709 %s \u53ef\u7528\u3002", h, Misc.getDGSCredits(COST), Misc.getDGSCredits(credits));
                label.setHighlightColors(canAccept ? h : n, h);
                label.setHighlight(Misc.getDGSCredits(COST), Misc.getDGSCredits(credits));
                options.addOption("\u7b54\u5e94" + this.getHisOrHer() + "\u7684\u8bf7\u6c42", (Object)OptionId.AGREE);
                if (!canAccept) {
                    options.setEnabled((Object)OptionId.AGREE, false);
                    options.setTooltip((Object)OptionId.AGREE, "\u6ca1\u6709\u8db3\u591f\u7684\u661f\u5e01\u3002");
                }
                this.addStoryOption();
                options.addOption("\u5efa\u8bae" + this.getHeOrShe() + "\u81ea\u5df1\u6765\u5904\u7406" + this.getHisOrHer() + "\u7684\u95ee\u9898", (Object)OptionId.REJECT);
                break;
            }
            case AGREE: {
                text.addPara("\u4f60\u540c\u610f\u4e86\u8fd9\u540d" + this.getManOrWoman() + "\u7684\u8bf7\u6c42\uff0c\u5e76\u5b89\u6392\u5c5e\u4e0b\u529e\u7406\u6b64\u4e8b\u3002");
                cargo.getCredits().subtract(COST);
                AddRemoveCommodity.addCreditsLossText(COST, this.dialog.getTextPanel());
                this.done = true;
                this.intel.makeKnown();
                this.intel.sendUpdate(PirateBaseIntel.DISCOVERED_PARAM, text);
                PortsideBarData.getInstance().removeEvent(this);
                options.addOption("\u7ee7\u7eed", (Object)OptionId.LEAVE);
                break;
            }
            case REJECT: {
                text.addPara("\u4f60\u8f6c\u8fc7\u8eab\uff0c\u5e76\u5927\u6b65\u8d70\u5165\u9152\u5427\u3002");
                options.addOption("\u7ee7\u7eed", (Object)OptionId.LEAVE);
                break;
            }
            case LEAVE: {
                this.noContinue = true;
                this.done = true;
            }
        }
    }

    protected void addStoryOption() {
        String id = "join_id";
        this.options.addOption("\u63d0\u51fa\u8ba9" + this.getHimOrHer() + "\u52a0\u5165\u4f60\u7684\u8230\u961f", id);
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        int num = Misc.getNumNonMercOfficers(playerFleet);
        int max = Misc.getMaxOfficers(playerFleet);
        if (num >= max) {
            this.options.setEnabled(id, false);
            this.options.setTooltip(id, "\u519b\u5b98\u4eba\u6570\u5df2\u8fbe\u5230\u4e0a\u9650\u3002");
        }
        SetStoryOption.StoryOptionParams params = new SetStoryOption.StoryOptionParams(id, 1, "patherJoinFleet", Sounds.STORY_POINT_SPEND_LEADERSHIP, "\u5141\u8bb8 " + this.person.getNameString() + " \u8fd9\u4f4d\u5de6\u5f84\u53db\u9003\u8005\u52a0\u5165\u4f60\u7684\u8230\u961f");
        SetStoryOption.set(this.dialog, params, new SetStoryOption.BaseOptionStoryPointActionDelegate(this.dialog, params){

            public void confirm() {
                super.confirm();
                LuddicPathBaseBarEvent.this.text.addPara(String.valueOf(Misc.ucFirst(LuddicPathBaseBarEvent.this.getHeOrShe())) + "\u5c3d\u7ba1\u4e00\u5f00\u59cb\u5e76\u4e0d\u4fe1\u4efb\u4f60\uff0c" + "\u4f46" + LuddicPathBaseBarEvent.this.getHeOrShe() + "\u5f00\u59cb\u610f\u8bc6\u5230\u4f60\u662f\u8ba4\u771f\u7684\u65f6\u5019\uff0c\u5c31\u7acb\u523b\u8f6c\u4e3a\u60ca\u8bb6\u4e0e\u611f\u6fc0\u3002");
                CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
                playerFleet.getFleetData().addOfficer(LuddicPathBaseBarEvent.this.getPerson());
                LuddicPathBaseBarEvent.this.getPerson().setPostId(Ranks.POST_OFFICER);
                AddRemoveCommodity.addOfficerGainText(LuddicPathBaseBarEvent.this.getPerson(), this.dialog.getTextPanel());
                LuddicPathBaseBarEvent.this.done = true;
                LuddicPathBaseBarEvent.this.intel.makeKnown();
                LuddicPathBaseBarEvent.this.intel.sendUpdate(PirateBaseIntel.DISCOVERED_PARAM, LuddicPathBaseBarEvent.this.text);
                PortsideBarData.getInstance().removeEvent(LuddicPathBaseBarEvent.this);
                LuddicPathBaseBarEvent.this.options.addOption("\u7ee7\u7eed", (Object)OptionId.LEAVE);
                OptionPanelAPI options = this.dialog.getOptionPanel();
                options.clearOptions();
                options.addOption("\u7ee7\u7eed", (Object)OptionId.LEAVE);
            }

            public String getTitle() {
                return "\u6536\u7559\u5de6\u5f84\u53db\u9003\u8005";
            }

            public void createDescription(TooltipMakerAPI info) {
                float opad = 10.0f;
                info.addSpacer(-opad);
                MutableCharacterStatsAPI stats = LuddicPathBaseBarEvent.this.person.getStats();
                TooltipMakerAPI text = info;
                Color hl = Misc.getHighlightColor();
                Color red = Misc.getNegativeHighlightColor();
                text.addPara("\u4f60\u51b3\u5b9a\u8ba9 " + LuddicPathBaseBarEvent.this.person.getNameString() + " \u8fd9\u4f4d\u5de6\u5f84\u53db\u9003\u8005\u52a0\u5165\u4f60\u7684\u8230\u961f\u3002", opad);
                text.addPara("\u7b49\u7ea7\uff1a%s", opad, hl, "" + stats.getLevel());
                for (String skillId : Global.getSettings().getSortedSkillIds()) {
                    int level = (int)stats.getSkillLevel(skillId);
                    if (level <= 0) continue;
                    SkillSpecAPI spec = Global.getSettings().getSkillSpec(skillId);
                    String skillName = spec.getName();
                    if (spec.isAptitudeEffect()) {
                        skillName = String.valueOf(skillName) + " \u5929\u8d4b";
                    }
                    if (level <= 1) {
                        text.addPara(skillName, opad);
                        continue;
                    }
                    text.addPara(String.valueOf(skillName) + " (\u7cbe\u82f1) ", opad);
                }
                String personality = Misc.lcFirst(LuddicPathBaseBarEvent.this.person.getPersonalityAPI().getDisplayName());
                text.addPara("\u6027\u683c\uff1a%s", opad, Misc.getHighlightColor(), personality);
                text.addPara(LuddicPathBaseBarEvent.this.person.getPersonalityAPI().getDescription(), opad);
                info.addSpacer(opad * 2.0f);
                this.addActionCostSection(info);
            }
        });
    }

    @Override
    protected String getPersonFaction() {
        return "luddic_path";
    }

    @Override
    protected String getPersonRank() {
        return Ranks.CITIZEN;
    }

    @Override
    protected String getPersonPost() {
        return Ranks.CITIZEN;
    }

    @Override
    protected String getPersonPortrait() {
        return null;
    }

    @Override
    protected FullName.Gender getPersonGender() {
        return FullName.Gender.ANY;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OptionId {
        INIT,
        AGREE,
        HIRE,
        HIRE_CONTINUE,
        REJECT,
        LEAVE;

    }
}

