/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.PersonImportance;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.FullName;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.intel.bar.PortsideBarData;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.BaseBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseIntel;
import com.fs.starfarer.api.impl.campaign.intel.contacts.ContactIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.PirateBasePirateActivityCause2;
import com.fs.starfarer.api.util.Misc;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PirateBaseRumorBarEvent
extends BaseBarEvent {
    protected PirateBaseIntel intel;
    protected long seed;
    protected transient boolean done = false;
    protected transient FullName.Gender gender;
    protected transient PersonAPI person;

    @Override
    public boolean isAlwaysShow() {
        return true;
    }

    public PirateBaseRumorBarEvent(PirateBaseIntel intel) {
        this.intel = intel;
        this.seed = Misc.random.nextLong();
    }

    @Override
    public boolean shouldShowAtMarket(MarketAPI market) {
        HostileActivityEventIntel ha;
        if (this.intel.getTarget() == market.getContainingLocation()) {
            return true;
        }
        if (market.isPlayerOwned() && (ha = HostileActivityEventIntel.get()) != null) {
            return PirateBasePirateActivityCause2.getBaseIntel(market.getStarSystem()) == this.intel;
        }
        return false;
    }

    @Override
    public boolean shouldRemoveEvent() {
        return this.intel.isEnding() || this.intel.isEnded() || this.intel.isPlayerVisible();
    }

    @Override
    public void addPromptAndOption(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        super.addPromptAndOption(dialog, memoryMap);
        Random random = new Random(this.seed + (long)dialog.getInteractionTarget().getMarket().getId().hashCode());
        this.gender = FullName.Gender.MALE;
        if (random.nextFloat() > 0.5f) {
            this.gender = FullName.Gender.FEMALE;
        }
        this.person = Global.getSector().getFaction("pirates").createRandomPerson(this.gender, random);
        this.person.setPostId(Ranks.POST_MINORCRIMINAL);
        this.person.setImportanceAndVoice(PersonImportance.VERY_LOW, random);
        this.person.addTag("underworld");
        String himOrHer = "\u4ed6";
        if (this.gender == FullName.Gender.FEMALE) {
            himOrHer = "\u5979";
        }
        TextPanelAPI text = dialog.getTextPanel();
        text.addPara("\u9152\u5427\u4e00\u5904\u4e0d\u8d77\u773c\u7684\u89d2\u843d\u91cc\u5750\u7740\u4e00\u540d\u5934\u53d1\u82b1\u767d\u559d\u7740\u5ec9\u4ef7\u70c8\u9152\u7684\u8001\u5bb6\u4f19\u3002");
        dialog.getOptionPanel().addOption("\u4f60\u4ece\u9152\u4fdd\u90a3\u63a5\u8fc7\u4e24\u676f\u52a0\u51b0\u7684\u5a01\u58eb\u5fcc\uff0c\u5e76\u5c06\u4e00\u676f\u653e\u5728" + himOrHer + "\u7684\u9762\u524d\u3002", this);
    }

    @Override
    public void init(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        super.init(dialog, memoryMap);
        String himOrHerSelf = "\u4ed6";
        if (this.gender == FullName.Gender.FEMALE) {
            himOrHerSelf = "\u5979";
        }
        TextPanelAPI text = dialog.getTextPanel();
        text.addPara("\u8fd9\u676f\u5a01\u58eb\u5fcc\u6ca1\u6709\u8ba9\u4f60\u5931\u671b\uff0c\u559d\u5f97\u534a\u9189\u7684" + himOrHerSelf + "\u7ec8\u7a76\u8fd8\u662f\u8bf4\u51fa\u4e86\u4e9b\u6709\u4ef7\u503c\u7684\u60c5\u62a5\u3002");
        dialog.getVisualPanel().showPersonInfo(this.person, true);
        this.done = true;
        this.intel.makeKnown();
        this.intel.sendUpdate(PirateBaseIntel.DISCOVERED_PARAM, text);
        PortsideBarData.getInstance().removeEvent(this);
        ContactIntel.addPotentialContact(this.person, dialog.getInteractionTarget().getMarket(), text);
    }

    @Override
    public void optionSelected(String optionText, Object optionData) {
    }

    @Override
    public boolean isDialogFinished() {
        return this.done;
    }

    protected boolean showCargoCap() {
        return false;
    }
}

