/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.FullName;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.BarEventManager;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.BaseBarEventWithPerson;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.PlanetaryShieldIntel;
import com.fs.starfarer.api.impl.campaign.procgen.themes.MiscellaneousThemeGenerator;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.LinkedHashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanetaryShieldBarEvent
extends BaseBarEventWithPerson {
    protected PersonAPI pilot;
    protected MarketAPI pilotMarket = null;

    public static PlanetAPI getTargetPlanet() {
        return (PlanetAPI)Global.getSector().getMemoryWithoutUpdate().get(MiscellaneousThemeGenerator.PLANETARY_SHIELD_PLANET_KEY);
    }

    @Override
    public boolean shouldShowAtMarket(MarketAPI market) {
        if (!super.shouldShowAtMarket(market)) {
            return false;
        }
        if (market.getFactionId().equals("luddic_church") || market.getFactionId().equals("luddic_path")) {
            return false;
        }
        if (PlanetaryShieldBarEvent.getTargetPlanet() == null) {
            return false;
        }
        if (Global.getSector().getIntelManager().hasIntelOfClass(PlanetaryShieldIntel.class)) {
            return false;
        }
        return Global.getSector().getPlayerStats().getLevel() >= 10 || DebugFlags.BAR_DEBUG;
    }

    @Override
    protected void regen(MarketAPI market) {
        if (this.market == market) {
            return;
        }
        super.regen(market);
        if (this.person.getGender() == FullName.Gender.MALE) {
            this.person.setPortraitSprite(Global.getSettings().getSpriteName("intel", "old_spacer_male"));
        } else {
            this.person.setPortraitSprite(Global.getSettings().getSpriteName("intel", "old_spacer_female"));
        }
        this.pilot = Global.getSector().getFaction("independent").createRandomPerson(this.random);
        this.pilot.setRankId(Ranks.PILOT);
        this.pilot.setPostId(Ranks.POST_CITIZEN);
        WeightedRandomPicker<MarketAPI> picker = new WeightedRandomPicker<MarketAPI>(this.random);
        for (MarketAPI curr : Global.getSector().getEconomy().getMarketsInGroup(null)) {
            if (curr == market || curr.isPlayerOwned() || curr.isHidden() || curr.isInvalidMissionTarget() || curr.getStabilityValue() <= 0.0f) continue;
            float w = curr.getSize();
            if (curr.isFreePort()) {
                w += 10.0f;
            }
            picker.add(curr, w);
        }
        if (picker.isEmpty()) {
            picker.add(market, 1.0f);
        }
        this.pilotMarket = (MarketAPI)picker.pick();
    }

    @Override
    public void addPromptAndOption(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        super.addPromptAndOption(dialog, memoryMap);
        this.regen(dialog.getInteractionTarget().getMarket());
        TextPanelAPI text = dialog.getTextPanel();
        text.addPara("\u4e00\u540d\u957f\u76f8\u7c97\u65f7\u7684\u9000\u4f0d\u8001\u5175\uff0c\u4f3c\u4e4e\u6b63\u7528\u4e00\u5bf9\u6cdb\u7740\u7ea2\u5149\u7684\u4eff\u751f\u773c\u76ee\u4e0d\u8f6c\u775b\u5730\u76ef\u7740\u4f60\uff0c\u800c\u8fd9\u51b0\u51b7\u7684\u76ee\u5149\u5219\u8ba9\u4f60\u611f\u5230\u6709\u4e9b\u4e0d\u9002\u3002");
        dialog.getOptionPanel().addOption("\u4f60\u5411\u8fd9\u540d\u8001\u5175\u8d70\u53bb\uff0c\u5e76\u8bd5\u7740\u95ee" + this.getHeOrShe() + "\u7a76\u7adf\u5728\u770b\u4e9b\u4ec0\u4e48", this, null);
    }

    @Override
    public void init(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        super.init(dialog, memoryMap);
        this.done = false;
        dialog.getVisualPanel().showPersonInfo(this.person, true);
        this.optionSelected(null, (Object)OptionId.INIT);
    }

    @Override
    public void optionSelected(String optionText, Object optionData) {
        if (!(optionData instanceof OptionId)) {
            return;
        }
        OptionId option = (OptionId)((Object)optionData);
        OptionPanelAPI options = this.dialog.getOptionPanel();
        TextPanelAPI text = this.dialog.getTextPanel();
        options.clearOptions();
        switch (option) {
            case INIT: {
                text.addPara("\"\u6ca1\u4ec0\u4e48\uff0c\u6211\u53ea\u662f\u5728\u8bfb\u6211\u7684\u65b0\u90ae\u4ef6\u3002\" " + this.getHeOrShe() + "\u4f4e\u58f0\u5486\u54ee\u7740\u56de\u8bdd\uff0c\u53c8\u5927\u7b11\u8d77\u6765\uff0c\u5e76\u6572\u4e86\u6572" + this.getHisOrHer() + "\u7684\u592a\u9633\u7a74\u3002" + "\"\u6211\u5e94\u8be5\u6c38\u8fdc\u90fd\u4e60\u60ef\u4e0d\u4e86\u8fd9\u4e9b\u65b0\u5947\u73a9\u610f\u3002\"");
                options.addOption("\u4e3a\u4e86\u8868\u793a\u6b49\u610f\uff0c\u4e3a" + this.getHimOrHer() + "\u70b9\u4e00\u676f\u996e\u6599", (Object)OptionId.APOLOGIZE);
                options.addOption("\u5efa\u8bae" + this.getHeOrShe() + "\u53bb\u9605\u8bfb\u4f7f\u7528\u624b\u518c\uff0c\u5e76\u8f6c\u8eab\u79bb\u5f00", (Object)OptionId.LEAVE);
                break;
            }
            case APOLOGIZE: {
                text.addPara("\u968f\u7740\u684c\u4e0a\u7684\u7a7a\u676f\u4e0d\u65ad\u589e\u591a\uff0c\u8fd9\u4f4d\u8001\u5b87\u5b99\u6c11\u7ec8\u7a76\u6253\u5f00\u4e86\u8bdd\u5323\u5b50\u3002" + Misc.ucFirst(this.getHeOrShe()) + "\u8bb2\u8ff0\u4e86\u8eab\u4e0a\u65e7\u4f24\u75a4\u7684\u6765\u5386\uff0c\u5305\u62ec\u90a3" + this.getHisOrHer() + "\u53d7\u635f\u7684\u53cc\u773c\u3002\n\n\"\u90a3\u6b21\u4efb\u52a1\u4e2d\u53ea\u6709\u4e24\u540d\u5e78\u5b58\u8005\uff0c\u6211\u548c\u90a3\u4e2a\u98de\u884c\u5458\u3002" + "\u771f\u662f\u4e24\u4e2a\u5e78\u8fd0\u7684\u5bb6\u4f19\u3002\" \u800c\u8fd9\u4e00\u5207\u7684\u7f18\u7531\u90fd\u5f97\u4ece" + this.getHeOrShe() + "\u88ab\u96c7\u5165\u4e00\u652f\u6253\u635e\u961f\u8bf4\u8d77\uff0c" + "\u5982\u5f80\u5e38\u4e00\u6837\uff0c\u4ed6\u4eec\u7edd\u5927\u6570\u65f6\u95f4\u90fd\u7a7f\u68ad\u4e8e\u6838\u5fc3\u661f\u533a\u5468\u8fb9\u7684\u8352\u5e9f\u661f\u7cfb\u91cc\u3002" + "\u8d77\u521d\u6536\u83b7\u9887\u4e30\uff0c\u9047\u5230\u7684\u6d77\u76d7\u4e5f\u5f80\u5f80\u88ab\u5316\u9669\u4e3a\u5937\u3002" + "\n\n\u7136\u540e\u519b\u5b98\u4eec\u5728\u6570\u636e\u7f13\u5b58\u4e2d\u53d1\u73b0\u4e86\u4e00\u4e9b\u65b0\u4e1c\u897f\u3002" + "\u968f\u540e\uff0c\u8230\u961f\u6beb\u65e0\u5f81\u5146\u5730\u7a81\u7136\u79bb\u5f00\u4e86\u5bcc\u6709\u7684\u5c0f\u884c\u661f\u5e26\uff0c\u5e76\u76f4\u63a5\u8fdb\u5165\u4e86\u8fde\u63a5\u8d85\u7a7a\u95f4\u7684\u8df3\u8dc3\u70b9\uff0c" + "\u7531\u4e8e\u6ca1\u6709\u9884\u5148\u901a\u77e5\uff0c\u4e0d\u4ec5\u8ba9\u8239\u5458\u4eec\u60f6\u6050\u4e0d\u5b89\uff0c\u4e5f\u8ba9\u4e00\u4e9b\u4e0d\u5409\u7684\u8c23\u8a00\u6d41\u4f20\u5f00\u6765\u3002" + "\u5728\u7981\u53d7\u4e86\u4e24\u80a1\u8d85\u7a7a\u95f4\u98ce\u66b4\u540e\uff0c\u4ed6\u4eec\u7ec8\u4e8e\u5230\u8fbe\u4e86\u4e00\u5904\u9065\u8fdc\u7684\u672a\u77e5\u661f\u7cfb\u3002");
                options.addOption("\u7ee7\u7eed", (Object)OptionId.CONTINUE_1);
                break;
            }
            case CONTINUE_1: {
                text.addPara("\u5728\u90a3\u91cc\u4ed6\u4eec\u53d1\u73b0\u4e86\u4e00\u9897\u95ea\u8000\u7684\u7ea2\u8272\u884c\u661f\u3002\"\u8fd9\u7edd\u5bf9\u4e0d\u662f\u81ea\u7136\u5f62\u6210\uff0c\u4e0d\u7ba1\u662f\u5f62\u72b6\uff0c\u89d2\u5ea6\uff0c\u4ee5\u53ca\u5149\u7ebf\u7684\u6298\u5c04\u90fd\u5982\u540c\u7b49\u79bb\u5b50\u4f53\u822c\u7eda\u70c2\u3002\u5f53\u65f6\u7684\u6211\u751a\u81f3\u6000\u7591\u8fd9\u4e00\u5207\u90fd\u662f\u5e7b\u89c9\uff0c\u4f46\u5b83\u5c31\u5728\u90a3\uff0c\u5982\u6b64\u771f\u5b9e...\" " + this.getHeOrShe() + "\u538b\u4f4e\u58f0\u97f3\uff0c\"\u6211\u66fe\u89c1\u8fc7\u661f\u95e8\uff0c\u5f53\u7136\uff0c\u8fd8\u6709\u5176\u4ed6\u5404\u79cd\u5404\u6837\u968f\u4fbf\u4f60\u4e3e\u4f8b\u7684\u5de8\u578b\u8f68\u9053\u5de5\u7a0b\uff0c\u4f46\u6211" + "\u4ece\u672a\u6ca1\u89c1\u8fc7\u54ea\u4e2a\u7531 \u4eba\u4e4b\u9886 \u6240\u5236\u9020\u7684\u4e1c\u897f\u80fd\u8ba9\u6574\u9897\u884c\u661f\u53d1\u51fa\u90a3\u6837\u7684\u5149\u8292\u3002" + "\u6211\u7684\u610f\u601d\u662f\uff0c\u548c\u6b66\u5668\u65e0\u5173\u7684\u4e1c\u897f\u7edd\u5bf9\u4e0d\u4f1a\u90a3\u6837\u3002\"");
                options.addOption("\u7ee7\u7eed", (Object)OptionId.CONTINUE_2);
                break;
            }
            case CONTINUE_2: {
                text.addPara("\"\u5f53\u6211\u4eec\u8fd8\u5728\u76ee\u77aa\u53e3\u5446\u7684\u65f6\u5019\uff0c\u63a5\u8fd1\u544a\u8b66\u8f70\u7136\u54cd\u8d77\uff0c\u628a\u6211\u4eec\u90fd\u9001\u5230\u4e86\u6218\u6597\u5c97\u4f4d\u4e0a\uff01\" " + this.getHeOrShe() + "\u7ee7\u7eed\u89e3\u91ca\uff0c\u654c\u610f\u8230\u8239\u5feb\u901f\u5730\u5411\u6253\u635e\u8230\u961f\u6251\u6765\uff0c\u5b83\u4eec\u642d\u8f7d\u4e86\u7075\u6d3b" + "\u533f\u8e2a\u7684\u79d1\u6280\u3002\u5b83\u4eec\u8fd8\u88c5\u914d\u4e86\u540c\u7b49\u5148\u8fdb\u7684\u6b66\u5668\uff0c\u4e14" + "\u6beb\u4e0d\u7559\u60c5\u3002\"\u5b83\u4eec\u4e0d\u662f\u6d77\u76d7\uff0c\u4e5f\u4e0d\u662f\u653f\u5e9c\u519b\u3002\" \u6b64\u65f6" + this.getHisOrHer() + "\u5e76\u672a\u663e\u793a\u51fa\u8bb2\u6545\u4e8b\u7684\u6fc0\u60c5\uff0c\"\u5362\u5fb7\u5728\u4e0a\uff0c\u6211\u6562\u6253\u5305\u7968\uff0c\u5b83\u4eec\u6839\u672c\u5c31\u4e0d\u662f\u4eba\u7c7b\u3002\"");
                text.addPara("\u53ea\u6709" + this.getHeOrShe() + "\u548c\u4e00\u4f4d\u98de\u884c\u5458\u6210\u529f\u4e58\u5750\u9003\u751f\u8231\u9003\u79bb\uff0c" + "\u4f46\u8fd9\u8be5\u6b7b\u7684\u9003\u751f\u8231\u5374\u5728\u9014\u4e2d\u53d1\u751f\u4e86\u4e00\u4e2a \"\u5f88\u5e38\u89c1\" \u7684\u6545\u969c\u3002\"\u5947\u8ff9\u4e0d\u5728\u4e8e\u6211" + "\u5982\u4f55\u4fee\u597d\u4e86\u5b83\uff0c\u800c\u5728\u4e8e\u5b83\u65ad\u7535\u540e\uff0c\u6210\u529f\u89e3\u51bb\uff0c\u5e76\u8ba9\u6211" + "\u6d3b\u4e86\u4e0b\u6765\uff0c\u5982\u679c\u4f60\u7ba1\u6211\u8fd9\u6837\u53eb\u6d3b\u4e0b\u6765\u7684\u8bdd\u3002\" ");
                options.addOption("\"\u90a3\u4e2a\u6709\u7ea2\u8272\u884c\u661f\u7684\u661f\u7cfb\u5728\u54ea\uff1f\"", (Object)OptionId.WHERE_WAS_SYSTEM);
                break;
            }
            case WHERE_WAS_SYSTEM: {
                text.addPara("\u4f60\u7528\u53c8\u4e0a\u4e86\u4e00\u676f\u76f8\u540c\u996e\u6599\u7684\u65b9\u5f0f\u5f3a\u8c03\u7740\u4f60\u5bf9\u5b83\u7684\u5f3a\u70c8\u5174\u8da3\u3002" + Misc.ucFirst(this.getHeOrShe()) + "\u6447\u4e86\u6447" + this.getHisOrHer() + "\u7684\u5934\uff0c\"\u8230\u957f\u554a\uff0c" + "\u6211\u53ef\u4e0d\u5e0c\u671b\u6211\u7684\u547d\u8fd0\u518d\u6b21\u843d\u5230\u4f60\u6216\u4efb\u4f55\u4eba\u7684\u8eab\u4e0a\uff0c\u518d\u8bf4\uff0c\u6211\u4e5f\u4e0d\u77e5\u9053...\" \u4e00\u9635\u6c89\u9ed8\uff0c\u7136\u540e\uff0c" + "\"" + this.pilot.getNameString() + " \u5e94\u8be5\u66f4\u6e05\u695a\u4e9b \u2014\u2014 \u90a3\u662f\u90a3\u4f4d\u98de\u884c\u5458\u7684\u540d\u5b57\u3002\" " + this.getHeOrShe() + "\u7ec8\u4e8e\u8fd8\u662f\u8bf4\u51fa\u4e86\u5b9e\u60c5\u3002");
                text.addPara("\u8fd9\u4f4d\u8001\u5b87\u5b99\u6c11\u544a\u8bc9\u4f60 " + this.pilot.getName().getFirst() + " \u6ca1\u6709" + "\u9893\u5e9f\u5730\u50cf" + this.getHimOrHerself() + "\u4e00\u6837\uff0c\u800c\u662f\u627e\u4e86\u4efd\u4f53\u9762\u7684\u5de5\u4f5c" + "\u4e14\u73b0\u5728\u6b63\u8fc7\u7740\u95f2\u9002\u7684\u534a\u9000\u4f11\u751f\u6d3b\u4e8e " + this.pilotMarket.getOnOrAt() + " " + this.pilotMarket.getName() + "\u3002" + "\"\u6211\u8ba4\u4e3a\u6709\u4e9b\u4eba\u5e94\u8be5\u5929\u751f\u5c31\u4e0d\u9002\u5408" + "\u4f7f\u7528\u7d27\u6025\u51b7\u51bb\u8231\uff0c\u56e0\u4e3a\u6211\u89c9\u5f97\u6211\u90a3\u66fe\u88ab\u51b0\u51bb\u8fc7\u7684\u8111\u5b50\u5230\u73b0\u5728\u90fd\u8fd8\u6ca1\u6709\u878d\u5316\u3002\"");
                String icon = Global.getSettings().getSpriteName("intel", "red_planet");
                LinkedHashSet<String> tags = new LinkedHashSet<String>();
                tags.add("Missions");
                this.dialog.getVisualPanel().showMapMarker(this.pilotMarket.getPrimaryEntity(), "\u76ee\u7684\u5730\uff1a" + this.pilotMarket.getName(), this.pilotMarket.getFaction().getBaseUIColor(), true, icon, null, tags);
                options.addOption("\u7ee7\u7eed", (Object)OptionId.CONTINUE_3);
                break;
            }
            case CONTINUE_3: {
                text.addPara("\u4f60\u8003\u8651\u7740\u524d\u5f80 " + this.pilotMarket.getName() + " \u770b\u770b\u662f\u5426\u80fd\u5f97\u5230\u90a3\u7684\u786e\u5207\u4f4d\u7f6e\uff0c" + "\u5e76\u4eb2\u773c\u76ee\u7779\u90a3\u9897\u795e\u79d8\u884c\u661f\u6240\u5305\u542b\u7684\u672a\u77e5\u6280\u672f\u3002\u6b64\u65f6\u56de\u8fc7\u795e\u7684\u4f60\u624d\u610f\u8bc6\u5230\uff0c\u9762\u524d\u7684\u8001\u5b87\u5b99\u6c11" + "\u65e9\u5df2\u5728" + this.getHisOrHer() + "\u7684\u5ea7\u4f4d\u4e0a\u6c89\u6c89\u7761\u53bb\uff0c\u90a3\u4eff\u751f\u773c\u5df2\u7ecf\u8fdb\u5165\u4e86\u6697\u6de1\u7684\u5f85\u673a\u6a21\u5f0f\u3002");
                BarEventManager.getInstance().notifyWasInteractedWith(this);
                this.addIntel();
                options.addOption("\u4e0d\u53bb\u6253\u6270\u8fd9\u540d\u8001\u5b87\u5b99\u6c11\uff0c\u8ba9" + this.getHisOrHer() + "\u597d\u597d\u4f11\u606f", (Object)OptionId.LEAVE);
                break;
            }
            case LEAVE: {
                this.noContinue = true;
                this.done = true;
            }
        }
    }

    protected void addIntel() {
        PlanetaryShieldIntel intel;
        CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
        TextPanelAPI text = this.dialog.getTextPanel();
        PlanetAPI planet = PlanetaryShieldBarEvent.getTargetPlanet();
        boolean success = false;
        if (planet != null && !(intel = new PlanetaryShieldIntel(planet, this)).isDone()) {
            Global.getSector().getIntelManager().addIntel(intel, false, text);
            success = true;
        }
        if (!success) {
            text.addPara("\u4e34\u8d70\u524d\uff0c\u4f60\u4ecd\u5bf9\u8fd9\u4e2a\u6545\u4e8b\u610f\u72b9\u672a\u5c3d\uff0c\u4f46\u5f88\u5feb\u4f60\u5c31\u660e\u767d\uff0c\u7ee7\u7eed\u4e0b\u53bb\u5c06\u6beb\u65e0\u610f\u4e49\u3002");
        }
    }

    @Override
    protected String getPersonFaction() {
        return "independent";
    }

    @Override
    protected String getPersonRank() {
        return Ranks.SPACE_SAILOR;
    }

    @Override
    protected String getPersonPost() {
        return Ranks.CITIZEN;
    }

    @Override
    protected String getPersonPortrait() {
        return null;
    }

    @Override
    protected FullName.Gender getPersonGender() {
        return FullName.Gender.ANY;
    }

    public PersonAPI getPilot() {
        return this.pilot;
    }

    public MarketAPI getPilotMarket() {
        return this.pilotMarket;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OptionId {
        INIT,
        APOLOGIZE,
        CONTINUE_1,
        CONTINUE_2,
        WHERE_WAS_SYSTEM,
        CONTINUE_3,
        LEAVE;

    }
}

