/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.PersonImportance;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseIndustry;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.BaseGetCommodityBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.contacts.ContactIntel;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;

public class QuartermasterCargoSwapBarEvent
extends BaseGetCommodityBarEvent {
    protected int playerGiveQuantity = 0;
    protected String playerGiveCommodity = null;

    public boolean shouldShowAtMarket(MarketAPI market) {
        if (!super.shouldShowAtMarket(market)) {
            return false;
        }
        this.regen(market);
        if (this.commodity == null) {
            return false;
        }
        if (!market.getFactionId().equals("hegemony")) {
            return false;
        }
        boolean hasMilitaryBase = false;
        for (Industry ind : market.getIndustries()) {
            if (!ind.getSpec().hasTag("military") && !ind.getSpec().hasTag("command")) continue;
            hasMilitaryBase = true;
            break;
        }
        return hasMilitaryBase;
    }

    protected String getCommodityId() {
        String[] possible = new String[]{"hand_weapons", "heavy_machinery", "supplies", "fuel", "rare_metals", "metals"};
        ArrayList<String> playerHas = new ArrayList<String>();
        ArrayList<String> playerNotHas = new ArrayList<String>();
        CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
        float value = this.getValue();
        String[] stringArray = possible;
        int n = possible.length;
        int n2 = 0;
        while (n2 < n) {
            CommoditySpecAPI spec;
            int num;
            String c = stringArray[n2];
            int q = (int)cargo.getQuantity(CargoAPI.CargoItemType.RESOURCES, c);
            if (q >= (num = (int)(value / (spec = Global.getSettings().getCommoditySpec(c)).getBasePrice()))) {
                playerHas.add(c);
            } else if (q < num) {
                playerNotHas.add(c);
            }
            ++n2;
        }
        if (playerHas.isEmpty() || playerNotHas.isEmpty()) {
            return null;
        }
        WeightedRandomPicker<String> take = new WeightedRandomPicker<String>(this.random);
        take.addAll(playerNotHas);
        WeightedRandomPicker<String> give = new WeightedRandomPicker<String>(this.random);
        give.addAll(playerHas);
        String pick = (String)take.pick();
        this.playerGiveCommodity = (String)give.pick();
        CommoditySpecAPI spec = Global.getSettings().getCommoditySpec(this.playerGiveCommodity);
        int num = (int)(value / spec.getBasePrice());
        this.playerGiveQuantity = (int)((float)num * 0.33f);
        if (this.playerGiveQuantity <= 0) {
            return null;
        }
        return pick;
    }

    protected PersonAPI createPerson() {
        PersonAPI person2;
        for (PersonAPI person2 : this.market.getPeopleCopy()) {
            if (!Ranks.POST_SUPPLY_OFFICER.equals(person2.getPostId())) continue;
            this.adjustPerson(person2);
            return person2;
        }
        person2 = Global.getSector().getFaction(this.getPersonFaction()).createRandomPerson(this.random);
        person2.setRankId(this.getPersonRank());
        person2.setPostId(this.getPersonRank());
        this.adjustPerson(person2);
        return person2;
    }

    protected void adjustPerson(PersonAPI person) {
        super.adjustPerson(person);
        person.setImportanceAndVoice(PersonImportance.MEDIUM, this.random);
        person.addTag("military");
    }

    protected String getPersonFaction() {
        return "hegemony";
    }

    protected String getPersonRank() {
        return Ranks.SPACE_COMMANDER;
    }

    protected String getPersonPost() {
        return Ranks.POST_SUPPLY_OFFICER;
    }

    protected float getValue() {
        float value = (float)(1000 + 100 * this.random.nextInt(6)) * BaseIndustry.getSizeMult(this.market.getSize());
        return value;
    }

    protected int computeQuantity() {
        String c = this.commodity;
        CommoditySpecAPI spec = Global.getSettings().getCommoditySpec(c);
        int num = (int)(this.getValue() / spec.getBasePrice());
        return num;
    }

    protected float getPriceMult() {
        return 0.0f;
    }

    protected String getPrompt() {
        return "\u5750\u5728\u9152\u5427\u663e\u773c\u4f4d\u7f6e\u5e76\u559d\u7740\u95f7\u9152\u7684\u5bb6\u4f19\u5e76\u4e0d\u662f\u522b\u4eba\uff0c\u6b63\u662f\u8be5\u7a7a\u95f4\u7ad9\u7684\u519b\u9700\u5b98\u3002";
    }

    protected String getOptionText() {
        return "\u4f60\u5411\u8fd9\u540d\u519b\u9700\u5b98\u8d70\u53bb\uff0c\u5e76\u8bf7\u4e86" + this.getHimOrHer() + "\u4e00\u676f\u5564\u9152";
    }

    protected String getMainText() {
        CommoditySpecAPI take = Global.getSettings().getCommoditySpec(this.commodity);
        CommoditySpecAPI give = Global.getSettings().getCommoditySpec(this.playerGiveCommodity);
        CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
        int qty = (int)cargo.getQuantity(CargoAPI.CargoItemType.RESOURCES, give.getId());
        String \u5355\u4f4d = "\u5355\u4f4d";
        if (qty == 1) {
            \u5355\u4f4d = "\u5355\u4f4d";
        }
        return "\u4f60\u6ca1\u6709\u611f\u5230\u4e1d\u6beb\u610f\u5916\uff0c\u8fd9\u540d\u519b\u9700\u5b98\u5c45\u7136\u82b1\u4e86\u6570\u5206\u949f\u7684\u65f6\u95f4\u624d\u5c06" + this.getHisOrHer() + "\u7684\u8865\u7ed9\u9700\u6c42\u662f\u5982\u4f55\u88ab\u6df7\u6dc6\u7684\u7cdf\u7cd5\u4e8b\u5b9e\u5ba3\u6cc4\u5b8c\u6bd5\uff0c\u539f\u56e0\u662f" + this.getHeOrShe() + "\u8981\u7684\u4e0d\u662f\u8fd9 %s \u5355\u4f4d\u7684 " + take.getLowerCaseName() + " \u800c\u662f %s \u5355\u4f4d\u7684 " + give.getLowerCaseName() + "\u3002\"\u5373\u4fbf\u662f\u90a3\u4e9b\u5de6\u5f84\u75af\u5b50\u7684\u81ea\u7206\u8fd0\u8f93\u961f\uff0c" + "\u5728\u8230\u961f\u8865\u7ed9\u65b9\u9762\u7684\u80fd\u529b\u90fd\u6bd4\u8fd9\u4e9b\u767d\u75f4\u8981\u505a\u5f97\u66f4\u597d\uff01\" " + this.getHeOrShe() + "\u65e0\u6bd4\u6124\u6012\u7684\u5c06" + this.getHisOrHer() + "\u624b\u4e2d\u7684\u5564\u9152\u4e00\u996e\u800c\u5c3d\uff0c\u7136\u540e" + "\u7830\u7684\u4e00\u58f0\u628a\u676f\u5b50\u653e\u4e0b\u3002\n\n" + "\u4f60\u62e5\u6709 %s " + \u5355\u4f4d + "\u7684" + give.getLowerCaseName() + "\u3002";
    }

    protected String[] getMainTextTokens() {
        CommoditySpecAPI give = Global.getSettings().getCommoditySpec(this.playerGiveCommodity);
        CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
        int qty = (int)cargo.getQuantity(CargoAPI.CargoItemType.RESOURCES, give.getId());
        return new String[]{Misc.getWithDGS(this.quantity), Misc.getWithDGS(this.playerGiveQuantity), Misc.getWithDGS(qty)};
    }

    protected Color[] getMainTextColors() {
        return new Color[]{Misc.getHighlightColor(), Misc.getHighlightColor(), Misc.getHighlightColor()};
    }

    protected String getConfirmText() {
        CommoditySpecAPI take = Global.getSettings().getCommoditySpec(this.commodity);
        CommoditySpecAPI give = Global.getSettings().getCommoditySpec(this.playerGiveCommodity);
        return "\u7528 " + this.playerGiveQuantity + " " + give.getLowerCaseName() + " " + "\u4ea4\u6362 " + this.quantity + " " + take.getLowerCaseName() + "\uff0c\u6765\u5e2e\u52a9" + this.getHimOrHer();
    }

    protected String getCancelText() {
        return "\u4f60\u8038\u4e86\u8038\u80a9\uff0c\u9664\u4e86\u5bf9\u6b64\u8868\u793a\u540c\u60c5\u4ee5\u5916\uff0c\u4ec0\u4e48\u4e5f\u6ca1\u505a";
    }

    protected String getAcceptText() {
        CommoditySpecAPI take = Global.getSettings().getCommoditySpec(this.commodity);
        CommoditySpecAPI give = Global.getSettings().getCommoditySpec(this.playerGiveCommodity);
        return "\u4f60\u5f53\u5373\u4e0e\u8fd9\u540d\u519b\u9700\u5b98\u4ea4\u6362\u4e86\u901a\u8baf ID\uff0c\u7b2c\u4e8c\u5929" + this.getHeOrShe() + "\u5c31\u4e0e\u4f60\u4e00\u540c\u524d\u5f80\u5f53\u5730\u6e2f\u53e3\u7ba1\u7406\u5c40\u4e00\u8d77\u5904\u7406\u8fd9\u4ef6\u4e8b\u60c5\uff0c\u5e76\u5b89\u6392\u4e86\u6700\u5feb\u7684\u8d27\u7269\u8fd0\u8f93\uff0c" + "\u7528\u4f60 %s \u5355\u4f4d\u7684 " + give.getLowerCaseName() + " \u4ea4\u6362" + " %s \u5355\u4f4d\u7684 " + take.getLowerCaseName() + "\u3002\u4e4b\u540e\uff0c" + "\u4f60\u5c31\u6536\u5230\u90a3\u540d\u519b\u9700\u5b98\u53d1\u6765\u7684\u611f\u8c22\u77ed\u8baf\u3002";
    }

    protected String[] getAcceptTextTokens() {
        return new String[]{Misc.getWithDGS(this.playerGiveQuantity), Misc.getWithDGS(this.quantity)};
    }

    protected Color[] getAcceptTextColors() {
        return new Color[]{Misc.getHighlightColor(), Misc.getHighlightColor()};
    }

    protected void doExtraConfirmActions() {
        CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
        cargo.removeCommodity(this.playerGiveCommodity, this.playerGiveQuantity);
        TextPanelAPI text = this.dialog.getTextPanel();
        AddRemoveCommodity.addCommodityLossText(this.playerGiveCommodity, this.playerGiveQuantity, text);
        CoreReputationPlugin.CustomRepImpact impact = new CoreReputationPlugin.CustomRepImpact();
        impact.delta = 0.1f;
        Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, null, text, true, true), this.person);
        impact = new CoreReputationPlugin.CustomRepImpact();
        impact.delta = 0.03f;
        Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, null, text, true, true), this.person.getFaction().getId());
        ContactIntel.addPotentialContact(this.person, this.market, text);
    }

    protected String getDeclineText() {
        return "\u4f60\u8f6c\u8fc7\u8eab\u4e0e\u8865\u7ed9\u5904\u7684\u5b98\u5458\u4eec\u559d\u4e0a\u4e00\u676f\u540e\uff0c\u6447\u6447\u6643\u6643\u7684\u5411\u9152\u5427\u95e8\u53e3\u8d70\u53bb\u3002";
    }
}

