/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.PersonImportance;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.ids.Sounds;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.BaseGetCommodityBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.TriTachLoanIntel;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.SetStoryOption;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class TriTachLoanBarEvent
extends BaseGetCommodityBarEvent {
    public static int REPAYMENT_DAYS = 400;
    protected int loanAmount;
    protected int repaymentAmount;
    protected int repaymentDays;

    public boolean shouldShowAtMarket(MarketAPI market) {
        if (!super.shouldShowAtMarket(market)) {
            return false;
        }
        if (!market.getFactionId().equals("tritachyon")) {
            return false;
        }
        if (market.getStabilityValue() < 4.0f) {
            return false;
        }
        return !Global.getSector().getFaction("tritachyon").getRelToPlayer().isAtBest(RepLevel.HOSTILE);
    }

    protected void regen(MarketAPI market) {
        if (this.market == market) {
            return;
        }
        super.regen(market);
        this.loanAmount = 200000 + this.random.nextInt(6) * 10000;
        this.repaymentAmount = (int)((float)this.loanAmount * 1.5f);
        this.repaymentDays = REPAYMENT_DAYS;
    }

    protected void doStandardConfirmActions() {
        CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
        cargo.getCredits().add(this.loanAmount);
        TextPanelAPI text = this.dialog.getTextPanel();
        AddRemoveCommodity.addCreditsGainText(this.loanAmount, text);
        this.createIntel();
    }

    protected int getNegotiatedAmount() {
        return this.repaymentAmount - (int)((float)(this.repaymentAmount - this.loanAmount) * 0.5f);
    }

    protected void addStoryOption() {
        String id = "negotiate_id";
        this.options.addOption("\u534f\u5546\u964d\u4f4e\u8d37\u6b3e\u5229\u7387", id);
        SetStoryOption.StoryOptionParams params = new SetStoryOption.StoryOptionParams(id, 1, "negotiateLoanRate", Sounds.STORY_POINT_SPEND_TECHNOLOGY, "\u4ece\u901f\u5b50\u6295\u8d44\u8005\u90a3\u534f\u5546\u5e76\u964d\u4f4e\u4e86 " + Misc.getDGSCredits(this.loanAmount) + " \u7684\u8d37\u6b3e\u5229\u7387");
        SetStoryOption.set(this.dialog, params, new SetStoryOption.BaseOptionStoryPointActionDelegate(this.dialog, params){

            public void confirm() {
                super.confirm();
                TriTachLoanBarEvent.this.repaymentAmount = TriTachLoanBarEvent.this.getNegotiatedAmount();
                this.dialog.getTextPanel().addPara(TriTachLoanBarEvent.this.getNegotiatedText());
                OptionPanelAPI options = this.dialog.getOptionPanel();
                options.clearOptions();
                options.addOption("\u7ee7\u7eed", "confirm");
            }

            public String getTitle() {
                return null;
            }

            public void createDescription(TooltipMakerAPI info) {
                float opad = 10.0f;
                info.setParaInsigniaLarge();
                info.addSpacer(-opad * 1.0f);
                info.addPara("\u8d37\u6b3e\u91d1\u989d\u4e3a %s.", 0.0f, Misc.getHighlightColor(), Misc.getDGSCredits(TriTachLoanBarEvent.this.loanAmount));
                info.addPara("\u4f60\u5c1d\u8bd5\u5c06\u8fd8\u6b3e\u91d1\u989d\u4ece %s \u964d\u81f3 %s.", opad, Misc.getHighlightColor(), Misc.getDGSCredits(TriTachLoanBarEvent.this.repaymentAmount), Misc.getDGSCredits(TriTachLoanBarEvent.this.getNegotiatedAmount()));
                info.addSpacer(opad * 2.0f);
                this.addActionCostSection(info);
            }
        });
    }

    public void optionSelected(String optionText, Object optionData) {
        super.optionSelected(optionText, optionData);
    }

    protected void createIntel() {
        TriTachLoanIntel intel = new TriTachLoanIntel(this, this.market);
        Global.getSector().getIntelManager().addIntel(intel, false, this.dialog.getTextPanel());
    }

    protected String getPersonFaction() {
        return "tritachyon";
    }

    protected String getPersonRank() {
        return Ranks.CITIZEN;
    }

    protected void adjustPerson(PersonAPI person) {
        super.adjustPerson(person);
        person.setImportanceAndVoice(PersonImportance.MEDIUM, this.random);
        person.addTag("trade");
    }

    protected String getPersonPost() {
        return Ranks.POST_EXECUTIVE;
    }

    protected float getPriceMult() {
        return 0.0f;
    }

    protected String getPrompt() {
        return "\u4e00\u540d\u901f\u5b50\u9ad8\u7ba1\u6b63\u5750\u5728\u4e00\u5f20\u4e00\u5c18\u4e0d\u67d3\u7684\u684c\u5b50\u524d\uff0c\u555c\u996e\u7740\u770b\u8d77\u6765\u975e\u5e38\u6602\u8d35\u7684\u9e21\u5c3e\u9152";
    }

    protected String getOptionText() {
        return "\u4f60\u8d70\u5411\u8fd9\u540d" + this.getManOrWoman() + ", \u5728\u7ecf\u8fc7\u7b80\u77ed\u7684\u81ea\u6211\u4ecb\u7ecd\u540e\uff0c\u4f60\u5c1d\u8bd5\u7740\u8be2\u95ee\u8d77 \u901f\u5b50\u79d1\u6280 \u6700\u8fd1\u63a8\u51fa\u7684\u4fe1\u7528\u8d37\u6b3e";
    }

    protected String getMainText() {
        return "\u8fd9\u540d\u8863\u7740\u5149\u9c9c\u7684\u5e74\u8f7b\u901f\u5b50\u9ad8\u7ba1\u6c89\u9ed8\u7684\u770b\u4e86\u4f60\u4e00\u773c\uff0c\u4e0d\u7d27\u4e0d\u6162\u7684\u5c06" + this.getHeOrShe() + "\u624b\u4e2d\u7cbe\u81f4\u800c\u6602\u8d35\u9e21\u5c3e\u9152\u653e\u5728\u4e86\u684c\u4e0a\uff0c\u5e76\u7f13\u58f0\u8bf4\u9053\uff1a\"\u6211\u53ea\u662f\u4e2a\u4e0d\u8d77\u773c\u7684\u4e1a\u52a1\u7edf\u8ba1\u5458\uff0c" + "\u4e0d\u8fc7\u6211\u975e\u5e38\u6b23\u8d4f\u4f60\u7684\u53d1\u5c55\u6f5c\u529b\uff0c\u8fd9\u662f\u4e00\u5f20\u5185\u542b %s \u7684\u4fe1\u7528\u82af\u7247...\"" + "\u4f60\u4e0d\u52a8\u58f0\u8272\u7684\u76ef\u7740\u8fd9\u5f20\u6de1\u84dd\u8272\u5c0f\u5361\u7247\uff0c\u5e76\u7b49\u5f85\u5176\u4e0b\u6587\u3002\"\u4f46\u4f60\u5fc5\u987b\u8fd8\u6211 %s}\uff0c\u5728\u4e4b\u540e\u7684 %s \u5929\u5185\uff01\u5982\u679c\u4f60\u6ca1\u6709\u8fd9\u4e48\u505a...\" " + this.getHeOrShe() + "\u6446\u51fa\u4e00\u526f\u4e8e\u5fc3\u4e0d\u5fcd\u7684\u8868\u60c5\u3002\"\u90a3\u6211\u5c31\u53ea\u597d\u6bc1\u6389\u4f60\u5728\u901f\u5b50\u79d1\u6280\u5185\u7684\u58f0\u8a89\uff0c\u600e\u4e48\u6837\uff1f\"";
    }

    protected String[] getMainTextTokens() {
        return new String[]{Misc.getDGSCredits(this.loanAmount), Misc.getDGSCredits(this.repaymentAmount), "" + this.repaymentDays};
    }

    protected Color[] getMainTextColors() {
        return new Color[]{Misc.getHighlightColor(), Misc.getHighlightColor(), Misc.getHighlightColor()};
    }

    protected String getConfirmText() {
        return "\u63a5\u53d7\u63d0\u8bae\uff0c\u5e76\u4e3a\u5176\u70b9\u4e86\u676f\u540c\u6837\u6602\u8d35\u7684\u9e21\u5c3e\u9152\u4ee5\u793a\u5e86\u795d";
    }

    protected String getCancelText() {
        return "\u59d4\u5a49\u62d2\u7edd\uff0c\u5e76\u89e3\u91ca\u81ea\u5df1\u53ea\u662f\u6765\"\u4ea4\u4e2a\u670b\u53cb\"";
    }

    protected String getNegotiatedText() {
        return "\u5f53\u4f60\u5f00\u59cb\u7528\u590d\u6742\u4e14\u4e13\u4e1a\u7684\u53e3\u543b\u4fee\u6539\u521a\u63d0\u8bae\u7684\u6761\u6b3e\u65f6\uff0c\u8fd9\u540d" + this.getManOrWoman() + "\u6807\u5fd7\u6027\u7684\u5fae\u7b11\u4e5f\u968f\u4e4b\u51bb\u7ed3\u3002" + "\u5f88\u5feb\u4f60\u654f\u9510\u7684\u89c9\u5bdf\u5230\uff0c\u5728\u4f60\u8bf4\u8bdd\u7684\u65f6\u5019\uff0c" + this.getHisOrHer() + "\u7684\u773c\u775b\u4e5f\u968f\u4e4b\u5728\u5176\u89c6\u89c9\u6570\u636e\u754c\u9762\u4e0a\u5feb\u901f\u79fb\u52a8\uff0c\u663e\u7136" + this.getHeOrShe() + "\u4f3c\u4e4e\u88ab\u4f60\u7684\u806a\u660e\u624d\u667a\u5f04\u5f97\u6709\u4e9b\u4e0d\u77e5\u6240\u63aa\uff0c" + "\u5e76\u518d\u4e5f\u65e0\u6cd5\u6062\u590d\u901f\u5b50\u516c\u53f8\u90a3\u6807\u5fd7\u6027\u7684\u6251\u514b\u8138\u4e86\u3002\u7b49\u5230\u5927\u5bb6\u4e00\u81f4\u8ba4\u4e3a\u5f53\u524d\u7684\u8fd8\u6b3e\u989d\u8db3\u4ee5\u4f7f\u53cc\u65b9\u53d7\u76ca\u5e76\u51c6\u5907\u4e3e\u676f\u5e86\u795d\u65f6\uff0c" + "\u61f5\u61c2\u7684\u6295\u8d44\u8005\u5374\u731b\u7136\u53d1\u73b0" + this.getHisOrHer() + "\u9762\u524d\u7684\u9152\u676f\u65e9\u5df2\u7a7a\u7a7a\u5982\u4e5f\u3002\u800c\u89c9\u5bdf\u5230\u6c14\u6c1b\u5c34\u5c2c\u7684" + this.getHeOrShe() + "\u7acb\u523b\u5927\u58f0\u53eb\u6765\u4e86\u4e00\u676f\u65b0\u7684\u3002";
    }

    protected String getAcceptText() {
        return "\u4f60\u548c\u901f\u5b50\u79d1\u6280\u98ce\u9669\u6295\u8d44\u4eba\u4ea4\u6362\u4e86\u901a\u4fe1\u79d8\u94a5\uff0c\u7acb\u523b\u6536\u5230\u4e86\u8f6c\u8d26\uff0c\u6ee1\u8f7d\u661f\u5e01\u79bb\u5f00\u4e86\u6d3d\u8c08\u5ba4\u3002\u8bb8\u591a\u4f7f\u7528\u8fd9\u7b14\u65b0\u8d22\u4ea7\u7684\u8ba1\u5212\u5728\u4f60\u8111\u5b50\u91cc\u98de\u65cb \u2014\u2014 \u4f60\u627f\u8ba4\u4e5f\u53ef\u80fd\u662f\u6709\u4e9b\u9152\u52b2\u4e0a\u5934\u3002";
    }

    public int getLoanAmount() {
        return this.loanAmount;
    }

    public void setLoanAmount(int loanAmount) {
        this.loanAmount = loanAmount;
    }

    public int getRepaymentAmount() {
        return this.repaymentAmount;
    }

    public void setRepaymentAmount(int repaymentAmount) {
        this.repaymentAmount = repaymentAmount;
    }

    public int getRepaymentDays() {
        return this.repaymentDays;
    }

    public void setRepaymentDays(int repaymentDays) {
        this.repaymentDays = repaymentDays;
    }

    protected boolean showCargoCap() {
        return false;
    }
}

