/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.AbilityPlugin;
import com.fs.starfarer.api.characters.FullName;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.fleets.AutoDespawnScript;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV3;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParamsV3;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.TriTachLoanIntel;
import com.fs.starfarer.api.util.Misc;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class TriTachLoanIncentiveScript
implements EveryFrameScript {
    protected float delayDays;
    protected boolean sentFleet;
    protected FullName.Gender gender;
    protected long seed;
    protected StarSystemAPI systemPlayerIsIn = null;
    protected float daysInSystem = 0.0f;

    public TriTachLoanIncentiveScript(TriTachLoanIntel intel) {
        this.gender = intel.getEvent().getPerson().getGender();
        this.seed = Misc.genRandomSeed();
        this.delayDays = 200.0f + (float)Math.random() * 100.0f;
        if (DebugFlags.BAR_DEBUG) {
            this.delayDays = 0.0f;
        }
    }

    public void advance(float amount) {
        if (this.sentFleet) {
            return;
        }
        float days = Misc.getDays(amount);
        this.delayDays -= days;
        if (this.delayDays > 0.0f) {
            return;
        }
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        float distFromCore = playerFleet.getLocationInHyperspace().length();
        if (distFromCore > 30000.0f) {
            this.daysInSystem = 0.0f;
            this.systemPlayerIsIn = null;
            return;
        }
        if (!(playerFleet.getContainingLocation() instanceof StarSystemAPI)) {
            float dist;
            if ((this.daysInSystem > 7.0f || DebugFlags.BAR_DEBUG) && this.systemPlayerIsIn != null && (dist = Misc.getDistance(this.systemPlayerIsIn.getLocation(), playerFleet.getLocationInHyperspace())) < 3000.0f) {
                this.sendFleet();
            }
            this.daysInSystem = 0.0f;
            this.systemPlayerIsIn = null;
            return;
        }
        this.systemPlayerIsIn = (StarSystemAPI)playerFleet.getContainingLocation();
        this.daysInSystem += days;
    }

    protected void sendFleet() {
        if (this.sentFleet) {
            return;
        }
        this.sentFleet = true;
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        CampaignFleetAPI hunter = this.createBountyHunter();
        if (hunter != null) {
            Global.getSector().getHyperspace().addEntity(hunter);
            Vector2f hunterLoc = Misc.getPointAtRadius(playerFleet.getLocationInHyperspace(), 500.0f);
            hunter.setLocation(hunterLoc.x, hunterLoc.y);
            hunter.getAI().addAssignmentAtStart(FleetAssignment.INTERCEPT, playerFleet, 1000.0f, null);
            Misc.giveStandardReturnToSourceAssignments(hunter, false);
            hunter.getMemoryWithoutUpdate().set("$ttli_bountyHunter", true);
        }
    }

    protected CampaignFleetAPI createBountyHunter() {
        float pts = 200.0f;
        FleetParamsV3 params = new FleetParamsV3(null, Global.getSector().getPlayerFleet().getLocationInHyperspace(), "tritachyon", Float.valueOf(1.0f), "mercBountyHunter", pts, 0.0f, pts * 0.1f, 0.0f, 0.0f, 0.0f, 0.0f);
        params.officerNumberBonus = 4;
        params.officerLevelBonus = 3;
        params.doctrineOverride = Global.getSector().getFaction("tritachyon").getDoctrine().clone();
        params.doctrineOverride.setWarships(3);
        params.doctrineOverride.setPhaseShips(3);
        params.doctrineOverride.setCarriers(1);
        params.random = new Random(this.seed);
        CampaignFleetAPI fleet = FleetFactoryV3.createFleet(params);
        if (fleet.isEmpty()) {
            fleet = null;
        }
        if (fleet != null) {
            fleet.setFaction("independent", true);
            Misc.makeLowRepImpact(fleet, "ttli");
            fleet.addScript(new AutoDespawnScript(fleet));
            MemoryAPI memory = fleet.getMemoryWithoutUpdate();
            memory.set("$cfai_makeHostile", true);
            String hisOrHer = "\u4ed6";
            if (this.gender == FullName.Gender.FEMALE) {
                hisOrHer = "\u5979";
            }
            memory.set("$ttli_hisOrHer", hisOrHer);
            AbilityPlugin eb = fleet.getAbility("emergency_burn");
            if (eb != null) {
                eb.activate();
            }
        }
        return fleet;
    }

    public boolean isDone() {
        return this.sentFleet;
    }

    public boolean runWhilePaused() {
        return false;
    }
}

