/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events.historian;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.listeners.ExtraSalvageShownListener;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.BaseHistorianOffer;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.FighterBlueprintOffer;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.HistorianData;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.ShipBlueprintOffer;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.SpecialItemOffer;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.WeaponBlueprintOffer;
import com.fs.starfarer.api.impl.campaign.missions.DelayedFleetEncounter;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BaseSalvageSpecial;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BreadcrumbSpecial;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Set;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseHistorianOfferWithLocation
extends BaseHistorianOffer
implements ExtraSalvageShownListener {
    private SectorEntityToken entity;

    public BaseHistorianOfferWithLocation(SectorEntityToken entity) {
        this.entity = entity;
    }

    @Override
    public void init(InteractionDialogAPI dialog) {
        super.init(dialog);
        this.setDone(true);
        this.setRemove(true);
        this.setEndConversationOnReturning(true);
        Global.getSector().getIntelManager().addIntel(this, false, this.text);
        Global.getSector().getListenerManager().addListener(this);
        Misc.makeImportant(this.entity, this.getClass().getSimpleName());
        CargoAPI cargo = Global.getFactory().createCargo(true);
        this.addItemToCargo(cargo);
        BaseSalvageSpecial.addExtraSalvage(cargo, this.entity.getMemoryWithoutUpdate(), -1.0f);
    }

    @Override
    public void reportExtraSalvageShown(SectorEntityToken entity) {
        if (this.entity != entity) {
            return;
        }
        Misc.makeUnimportant(entity, this.getClass().getSimpleName());
        this.endIntel();
    }

    protected void endIntel() {
        this.endAfterDelay();
        Global.getSector().addScript(this);
        if (Misc.random.nextFloat() < 0.5f) {
            return;
        }
        if (this instanceof WeaponBlueprintOffer) {
            return;
        }
        if (this instanceof FighterBlueprintOffer) {
            return;
        }
        DelayedFleetEncounter e = new DelayedFleetEncounter(null, "hist");
        e.setDelayNone();
        e.setLocationAnywhere(true, "luddic_path");
        e.beginCreate();
        e.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGE, HubMissionWithTriggers.FleetQuality.DEFAULT, "luddic_path", "patrolLarge", new Vector2f());
        float q = 0.0f;
        if (this instanceof ShipBlueprintOffer) {
            ShipHullSpecAPI spec = Global.getSettings().getHullSpec(((ShipBlueprintOffer)this).data);
            if (spec != null) {
                q = Math.min(1.0f, (float)spec.getFleetPoints() / 20.0f);
            }
        } else if (this instanceof SpecialItemOffer) {
            q = 1.0f;
        }
        e.triggerSetAdjustStrengthBasedOnQuality(true, q);
        e.triggerSetStandardAggroInterceptFlags();
        e.triggerSetFleetGenericHailPermanent("HistorianPatherHail");
        e.triggerFleetPatherNoDefaultTithe();
        e.endCreate();
    }

    protected abstract void addItemToCargo(CargoAPI var1);

    @Override
    public abstract String getName();

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        if (!this.entity.isAlive()) {
            this.endIntel();
        }
        Color c = this.getTitleColor(mode);
        info.addPara(this.getName(), c, 0.0f);
        this.addBulletPoints(info, mode);
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        HistorianData hd = HistorianData.getInstance();
        info.addPara("\u5386\u53f2\u5b66\u5bb6 " + hd.getPerson().getNameString() + " \u7ed9\u4f60\u63d0\u4f9b\u4e86\u4e00\u4e2a" + "\u73cd\u8d35\u5236\u54c1\u7684\u4f4d\u7f6e\u4fe1\u606f\u3002", opad);
        info.addSectionHeading("\u5236\u54c1", Alignment.MID, opad);
        CargoAPI cargo = Global.getFactory().createCargo(true);
        this.addItemToCargo(cargo);
        info.showCargo(cargo, 10, true, opad);
        info.addSectionHeading("\u4f4d\u7f6e", Alignment.MID, opad);
        if (this.isEnding()) {
            info.addPara("\u4f60\u5df2\u7ecf\u627e\u5230\u5236\u54c1\u3002", opad);
        } else {
            String located = BreadcrumbSpecial.getLocatedString(this.entity, true);
            if (this.entity instanceof PlanetAPI) {
                PlanetAPI planet = (PlanetAPI)this.entity;
                info.addPara("\u8be5\u5236\u54c1\u53ef\u80fd\u5728 " + planet.getTypeNameWithLowerCaseWorld().toLowerCase() + " " + located + ".", opad);
                info.addPara("\u5728\u63a2\u7d22\u9057\u8ff9\u524d\uff0c\u9700\u8fdb\u884c\u5168\u9762\u7684\u8c03\u67e5\u3002", opad);
                info.showFullSurveyReqs(planet, true, opad);
            } else if (this.entity.getCustomEntitySpec() != null) {
                info.addPara("\u91cc\u9762\u7684\u5236\u54c1\u53ef\u80fd\u5728 " + this.entity.getCustomEntitySpec().getAOrAn() + " " + this.entity.getCustomEntitySpec().getNameInText() + " " + located + ".", opad);
            } else {
                info.addPara("\u91cc\u9762\u7684\u5236\u54c1\u53ef\u80fd\u5728 " + this.entity.getName() + " " + located + ".", opad);
            }
        }
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Exploration");
        tags.add("Accepted");
        return tags;
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        if (this.entity != null && this.entity.isDiscoverable() && this.entity.getStarSystem() != null) {
            return this.entity.getStarSystem().getCenter();
        }
        return this.entity;
    }
}

