/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events.historian;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.BaseHistorianOffer;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.HistorianData;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.util.Misc;

public class DonationOffer
extends BaseHistorianOffer {
    protected int credits;

    public DonationOffer() {
        HistorianData hd = HistorianData.getInstance();
        int tier = hd.getTier();
        if (tier == 0) {
            this.credits = 20000;
        } else if (tier == 1) {
            this.credits = 50000;
        } else if (tier >= 2) {
            this.credits = 250000;
        }
    }

    public void addPromptAndOption(InteractionDialogAPI dialog) {
        HistorianData hd = HistorianData.getInstance();
        dialog.getOptionPanel().addOption("... \u4e00\u4e9b\u6709\u8da3\u7684\u7ebf\u7d22\uff0c\u770b\u6765 " + Misc.getDGSCredits(this.credits) + " \u7684\u6350\u6b3e\u5e94\u8be5\u53ef\u4ee5\u8ba9" + hd.getHimOrHer() + "\u7ee7\u7eed\u8fd9\u9879\u7814\u7a76", this);
    }

    public void init(InteractionDialogAPI dialog) {
        super.init(dialog);
        this.setEndConversationOnReturning(false);
        this.options.clearOptions();
        this.options.addOption("\u6350\u6b3e", (Object)OptionId.DONATE);
        this.options.addOption("\u628a\u8bdd\u9898\u5f15\u5411\u5176\u4ed6\u4e3b\u9898\u4e0a", (Object)OptionId.NEVER_MIND);
        CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
        String c = Misc.getDGSCredits(cargo.getCredits().get());
        String d = Misc.getDGSCredits(this.credits);
        if (cargo.getCredits().get() < (float)this.credits) {
            this.text.addPara("\u8981\u6c42\u6350\u8d60 %s, \u800c\u4f60\u53ea\u6709 %s \u53ef\u7528\u3002", Misc.getHighlightColor(), d, c);
            this.options.setEnabled((Object)OptionId.DONATE, false);
            this.options.setTooltip((Object)OptionId.DONATE, "\u6ca1\u6709\u8db3\u591f\u7684\u661f\u5e01\u3002");
        } else {
            this.text.addPara("\u8981\u6c42\u6350\u8d60 %s, \u800c\u4f60\u6709 %s \u53ef\u7528\u3002", Misc.getHighlightColor(), d, c);
        }
    }

    public void optionSelected(String optionText, Object optionData) {
        HistorianData hd = HistorianData.getInstance();
        if (optionData == OptionId.DONATE) {
            this.setDone(true);
            this.setRemove(true);
            hd.incrTier();
            hd.setRecentlyDonated();
            Global.getSector().getPlayerFleet().getCargo().getCredits().subtract(this.credits);
            AddRemoveCommodity.addCreditsLossText(this.credits, this.text);
            CoreReputationPlugin.CustomRepImpact impact = new CoreReputationPlugin.CustomRepImpact();
            impact.limit = RepLevel.COOPERATIVE;
            impact.delta = 0.1f;
            Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, null, this.dialog.getTextPanel(), true), hd.getPerson());
            this.dialog.getTextPanel().addPara("\u5386\u53f2\u5b66\u5bb6\u5bf9\u4f60\u7684\u5e2e\u52a9\u800c\u8868\u793a\u8bda\u631a\u7684\u8c22\u610f\u3002");
            return;
        }
        if (optionData == OptionId.NEVER_MIND) {
            this.setDone(true);
            this.dialog.getTextPanel().addPara("\u5386\u53f2\u5b66\u5bb6\u77e5\u8da3\u7684\u5f00\u59cb\u8ba8\u8bba\u7740\u53e6\u4e00\u4e2a\u8bdd\u9898\u3002");
            return;
        }
    }

    public int getSortOrder() {
        return 1000;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OptionId {
        DONATE,
        NEVER_MIND;

    }
}

