/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events.historian;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.BarEventManager;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.BaseBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.HistorianData;
import com.fs.starfarer.api.impl.campaign.plog.PLIntel;
import com.fs.starfarer.api.impl.campaign.plog.PlaythroughLog;
import com.fs.starfarer.api.impl.campaign.rulecmd.FireBest;
import com.fs.starfarer.api.impl.campaign.shared.SharedData;
import com.fs.starfarer.api.util.Misc;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistorianBarEvent
extends BaseBarEvent {
    public static int MIN_SNAPSHOTS_TO_SHOW_PLOG = 60;
    public static float PROB_TO_SHOW = 0.5f;
    protected long seed = Misc.random.nextLong();
    protected MarketAPI market = null;
    protected transient Random random;
    protected transient List<HistorianData.HistorianOffer> offers = null;
    protected transient HistorianData.HistorianOffer currentOffer = null;

    @Override
    public boolean shouldShowAtMarket(MarketAPI market) {
        this.regen(market);
        if (this.random.nextFloat() > PROB_TO_SHOW) {
            return false;
        }
        return super.shouldShowAtMarket(market);
    }

    protected void regen(MarketAPI market) {
        this.market = market;
        this.done = false;
        this.random = new Random(this.seed + (long)market.getId().hashCode());
    }

    @Override
    public void addPromptAndOption(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        super.addPromptAndOption(dialog, memoryMap);
        this.regen(dialog.getInteractionTarget().getMarket());
        TextPanelAPI text = dialog.getTextPanel();
        text.addPara(this.getPrompt());
        dialog.getOptionPanel().addOption(this.getOptionText(), this);
    }

    protected String getOptionText() {
        HistorianData hd = HistorianData.getInstance();
        return "\u95ee\u8fd9\u540d\u62ff\u7740\u7eb8\u8d28\u4e66\u7684" + hd.getManOrWoman() + ", \u770b\u770b" + hd.getHeOrShe() + "\u7a76\u7adf\u60f3\u8981\u4ec0\u4e48";
    }

    protected String getPrompt() {
        HistorianData hd = HistorianData.getInstance();
        return "\u4e00\u540d" + hd.getManOrWoman() + "\u6b63\u72ec\u81ea\u5750\u5728\u684c\u524d\uff0c" + "\u624b\u4e2d\u5219\u4e0d\u7d27\u4e0d\u6162\u7684\u7ffb\u9605\u7740\u4e00\u672c\u770b\u8d77\u6765\u662f\u771f\u8d27\u7684\u7cbe\u88c5\u7eb8\u8d28\u4e66\u3002\u5f53\u4f60\u4ece\u5176\u8eab\u8fb9\u8d70\u8fc7\u65f6\uff0c" + hd.getHeOrShe() + "\u7f13\u7f13\u62ac\u8d77\u5934\uff0c\u5e76\u4f18\u96c5\u5730\u5c06" + hd.getHimOrHer() + "\u5bf9\u9762\u7684\u5ea7\u4f4d\u8ba9\u7ed9\u4e86\u4f60\u3002";
    }

    @Override
    public void init(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        super.init(dialog, memoryMap);
        HistorianData hd = HistorianData.getInstance();
        dialog.getVisualPanel().showPersonInfo(hd.getPerson(), true, true);
        if (dialog.getInteractionTarget() != null && hd.getPerson() != null) {
            this.memoryMap = new LinkedHashMap<String, MemoryAPI>(memoryMap);
            memoryMap = this.memoryMap;
            dialog.getInteractionTarget().setActivePerson(hd.getPerson());
            MemoryAPI memory = hd.getPerson().getMemory();
            memoryMap.put("local", memory);
            memoryMap.put("personFaction", hd.getPerson().getFaction().getMemory());
            memoryMap.put("entity", dialog.getInteractionTarget().getMemory());
        }
        if (!hd.isIntroduced()) {
            this.optionSelected(null, (Object)OptionId.GREETING);
        } else {
            boolean shouldShow;
            boolean hasLog = Global.getSector().getIntelManager().hasIntelOfClass(PLIntel.class);
            boolean bl = shouldShow = PlaythroughLog.getInstance().getData().size() >= MIN_SNAPSHOTS_TO_SHOW_PLOG;
            if (!hasLog && shouldShow) {
                this.optionSelected(null, (Object)OptionId.GREETNG_PLOG);
            } else {
                this.optionSelected(null, (Object)OptionId.GREETNG_ALREADY_INTRODUCED);
            }
        }
    }

    @Override
    public void optionSelected(String optionText, Object optionData) {
        HistorianData hd = HistorianData.getInstance();
        if (optionData == OptionId.GREETNG_PLOG) {
            this.text.addPara("\"\u6b22\u8fce\uff01\u6211\u8fd9\u91cc\u6b63\u597d\u6709\u4e00\u4e9b\u6211\u89c9\u5f97\u4f60\u4f1a\u975e\u5e38\u611f\u5174\u8da3\u7684\u4e1c\u897f\u3002\u4f60\u7684\u884c\u52a8\u5728\u4e0a\u51e0\u4e2a\u661f\u5386\u5e74\u91cc\u8fd8\u771f\u662f\u628a\u4e00\u4e9b\u5c0f\u5730\u65b9\u6405\u5f97\u5929\u7ffb\u5730\u8986\uff0c\u60f9\u5f97\u6211\u548c\u4e4b\u524d\u4e00\u6837\u90fd\u5fcd\u4e0d\u4f4f\u53bb\u4eb2\u81ea\u8c03\u67e5\u4e86\u4f60\u7684\u8fc7\u5f80\u3002\u6765\uff0c\u8ba9\u6211\u628a\u6458\u8981\u8f6c\u7ed9\u4f60\u3002\"");
            this.text.addPara("\u968f\u7740\u4f60\u624b\u4e2d\u7684 TriPad \u53d1\u51fa\u7684\u67d4\u548c\u94c3\u58f0\uff0c\u4ee3\u8868\u7740\u4e00\u4e2a\u65b0\u7684\u5b89\u88c5\u7a0b\u5e8f\u5df2\u7ecf\u5c31\u7eea\u3002");
            PLIntel intel = new PLIntel();
            Global.getSector().getIntelManager().addIntel(intel, false, this.dialog.getTextPanel());
            this.options.clearOptions();
            this.options.addOption("\"\u8c22\u8c22\uff01\u591a\u4e48\u4ee4\u4eba\u7740\u8ff7\uff0c\u800c\u4e14\u53ef\u771f\u662f\u4e00\u70b9\u90fd\u4e0d\u5510\u7a81\u3002\u90a3\u4e48\u4f60\u8fd8\u6709\u4ec0\u4e48\u8981\u7ed9\u6211\u7684\u5417\uff1f\"", (Object)OptionId.WHAT_DO_YOU_HAVE);
            return;
        }
        if (optionData == OptionId.GREETING) {
            this.text.addPara("\"\u6b22\u8fce\uff0c\u6b22\u8fce\uff0c\u8bf7\u5750\uff01\" \u6211\u60f3\u4f60\u4e00\u5b9a\u975e\u5e38\u597d\u5947\u6211\u53eb\u4f60\u8fc7\u6765\u7684\u76ee\u7684\u3002\"\n\n" + hd.getUCHeOrShe() + "\u7a81\u7136\u503e\u8eab\u5411\u524d\uff0c\u5e76\u5982\u540c\u5bc6\u8c0b\u822c\u7684\u653e\u4f4e\u4e86\u97f3\u91cf\u3002" + "\"\u6211\u60f3\u6211\u4eec\u5e94\u8be5\u80fd\u4e92\u76f8\u5e2e\u52a9\uff0c\u5bf9\uff01\u5c31\u4f60\u548c\u6211\uff0c\u4f60\u770b\uff0c\u6211\u6709\u77e5\u8bc6\uff0c\" " + hd.getHeOrShe() + "\u8f7b\u6572\u7740\u624b\u4e2d\u7684\u4e66\u672c\u3002" + "\"\u800c\u4f60...\u6709\u529e\u6cd5\uff01\"");
            this.text.addPara("\"\u6211\u53ef\u80fd\u7b97\u662f\u4e2a\u5386\u53f2\u5b66\u5bb6\u517c\u5192\u9669\u5bb6\uff1b\u4e00\u4e2a\u4e0d\u987e\u8fd9\u4e2a\u7279\u6b8a\u65f6\u4ee3\u7684\u5371\u9669\uff0c\u63ed\u9732\u661f\u57df\u5386\u53f2\u7684\u6e38\u8361\u8003\u53e4\u5b66\u5bb6\u3002\u5728\u6211\u7684\u7814\u7a76\u8fc7\u7a0b\u4e2d\uff0c\u6211\u7ecf\u5e38\u5076\u7136\u53d1\u73b0\u4e00\u4e9b\u5173\u4e8e\u67d0\u4e9b\u6280\u672f\u9057\u8ff9\u6240\u5728\u4e4b\u5904\u7684\u7ebf\u7d22\u3002\u5f53\u7136\uff0c\u627e\u56de\u8fd9\u4e9b\u9057\u7269\u662f\u4f60\u5728\u6211\u4eec\u534f\u8bae\u4e2d\u7684\u804c\u8d23\u3002...\u5f53\u7136\uff0c\u524d\u63d0\u662f\u4f60\u611f\u5174\u8da3 \u2014\u2014 \u4f46\u6211\u5df2\u7ecf\u7814\u7a76\u8fc7\u4f60\u7684\u4e8b\u8ff9\u4e86\uff0c\u6211\u786e\u4fe1\u4f60\u4f1a\u611f\u5174\u8da3\u7684\u3002\"\n\n\u6f14\u8bb2\u7ed3\u675f\u3002" + hd.getHeOrShe() + "\u5411\u540e\u9760\u4e86\u9760\uff0c\u4e14\u770b\u4e0a\u53bb\u9887\u4e3a\u81ea\u4fe1\u3002");
            this.options.clearOptions();
            this.options.addOption("\"\u6211\u731c\u4f60\u60f3\u7528\u8fd9\u4e9b\u4fe1\u606f\u6765\u6362\u53d6\u62a5\u916c\u5427\uff1f\"", (Object)OptionId.GREETNG_CONTINUE_1);
            return;
        }
        if (optionData == OptionId.GREETNG_CONTINUE_1) {
            this.text.addPara("\u75b2\u60eb\u7684\u8868\u60c5\u4ec5\u5728" + hd.getManOrWoman() + "\u7684\u8138\u4e0a\u6d41\u9732\u4e86\u7247\u523b\uff0c\u5c31\u7acb\u523b\u6062\u590d\u4e86" + hd.getHeOrShe() + "\u66fe\u6d3b\u529b\u56db\u5c04\u7684\u6a21\u6837\u3002");
            this.text.addPara("\"\u6211\u7406\u89e3\u4f60\u505a\u51fa\u7684\u5047\u8bbe\u3002\u8fd9\u786e\u5b9e\u662f\u4e00\u4e2a\u96c7\u4f63\u5175\u7684\u65f6\u4ee3\uff1b\u4f46\u4e0d\uff0c\u6ca1\u90a3\u4e48\u529f\u5229\u3002\u5386\u53f2\u662f\u4e00\u95e8\u4e0d\u786e\u5b9a\u7684\u884c\u5f53\uff0c\u8fd9\u6837\u7684\u505a\u6cd5\u4f1a\u5bfc\u81f4\u5e0c\u671b\u3001\u5931\u671b\u548c\u6307\u8d23\u3002\u6211\u5f88\u5e0c\u671b\u907f\u514d\u8fd9\u4e9b\uff0c\u5c24\u5176\u662f\u6700\u540e\u4e00\u9879\u3002\" \u8fd9\u4e48\u8bf4\u7740\u7684\u540c\u65f6" + hd.getHisOrHer() + "\u8138\u4e0a\u4eff\u4f5b\u53c8\u591a\u4e86\u9053\u76b1\u7eb9\u3002");
            this.text.addPara("\"\u7136\u800c\uff0c\u5982\u679c\u4f60\u8ba4\u4e3a\u6211\u7684\u4fe1\u606f\u6709\u4ef7\u503c\uff0c\u6211\u4f1a\u5f88\u4e50\u610f\u63a5\u53d7...\u6350\u8d60\u3002\u628a\u5b83\u5f53\u6210\u5bf9\u6211\u7684\u7814\u7a76\u7684\u8d5e\u52a9\uff0c\u8fd9\u53cd\u8fc7\u6765\u53c8\u4f1a\u4ea7\u751f\u6709\u4ef7\u503c\u7684\u7ebf\u7d22\u3002\u6216\u8005\uff0c\u628a\u5b83\u60f3\u8c61\u6210\u4e00\u79cd\u6295\u8d44\u4e5f\u8bb8\u4f1a\u66f4\u5bb9\u6613\uff0c\u4f46\u53cc\u65b9\u90fd\u4e0d\u627f\u62c5\u4efb\u4f55\u4e49\u52a1\u3002\u60f3\u60f3\u770b \u2014\u2014 \u4f60\u65e2\u80fd\u4e30\u5bcc\u81ea\u5df1\u7684\u4e8b\u4e1a\uff0c\u53c8\u80fd\u4e3a\u5168\u4eba\u7c7b\u7684\u77e5\u8bc6\u50a8\u5907\u6dfb\u7816\u52a0\u74e6\uff01\"");
            hd.setIntroduced(true);
            hd.setRecentlyDonated();
            this.options.clearOptions();
            this.options.addOption("\"\u90a3\u4e48\u4f60\u80fd\u63d0\u4f9b\u4e9b\u4ec0\u4e48\u5462\uff1f\"", (Object)OptionId.WHAT_DO_YOU_HAVE);
            return;
        }
        if (optionData == OptionId.GREETNG_ALREADY_INTRODUCED) {
            this.text.addPara("\"\u5f88\u9ad8\u5174\u518d\u6b21\u89c1\u5230\u4f60\uff0c" + Global.getSector().getPlayerPerson().getNameString() + "!\"");
            this.text.addPara("\u4f60\u4eec\u82b1\u4e86\u51e0\u5206\u949f\u7684\u65f6\u95f4\u4e00\u8d77\u559d\u4e86\u676f\u9152\uff0c\u5e76\u4e14\u804a\u4e86\u804a\u6700\u8fd1\u4e1a\u5185\u6240\u53d1\u751f\u7684\u8da3\u4e8b\u3002\u4e0d\u4e45\u540e\uff0c\u4f60\u4eec\u5c31\u5f00\u59cb\u8c08\u6b63\u4e8b\u4e86\u3002");
            this.optionSelected(null, (Object)OptionId.WHAT_DO_YOU_HAVE);
            return;
        }
        if (optionData == OptionId.WHAT_DO_YOU_HAVE) {
            this.text.addPara("\u5386\u53f2\u5b66\u5bb6\u5f00\u59cb\u4f83\u4f83\u800c\u8c08...");
            if (this.offers == null) {
                if (this.random == null) {
                    this.random = new Random(this.seed + (long)this.market.getId().hashCode());
                }
                this.offers = HistorianData.getInstance().getOffers(this.random, this.dialog);
            }
            this.options.clearOptions();
            if (this.offers != null) {
                for (HistorianData.HistorianOffer offer : this.offers) {
                    offer.addPromptAndOption(this.dialog);
                }
            }
            this.options.addOption("... \u5f88\u6709\u8da3\uff0c\u4f46\u6211\u60f3\u542c\u4e9b\u522b\u7684\u4e1c\u897f", (Object)OptionId.BACKSTORY_BIT);
            return;
        }
        boolean forceEnd = false;
        if (optionData == OptionId.BACKSTORY_BIT) {
            Random currRandom = Misc.getRandom(this.seed, 11);
            Global.getSector().getRules().setRandomForNextRulePick(currRandom);
            boolean shown = FireBest.fire(null, this.dialog, this.memoryMap, "HistorianBackstoryBlurb");
            if (!shown) {
                SharedData.getData().getUniqueEncounterData().historianBlurbsShown.clear();
                currRandom = Misc.getRandom(this.seed, 11);
                Global.getSector().getRules().setRandomForNextRulePick(currRandom);
                shown = FireBest.fire(null, this.dialog, this.memoryMap, "HistorianBackstoryBlurb");
            }
            this.options.clearOptions();
            this.options.addOption("\u7ed3\u675f\u8c08\u8bdd", (Object)OptionId.END_CONVERSATION);
        }
        if (optionData == OptionId.END_CONVERSATION || forceEnd) {
            this.text.addPara("\u4f60\u611f\u8c22\u4e86" + hd.getHimOrHer() + "\u6240\u63d0\u4f9b\u7684\u4fe1\u606f\uff0c\u5e76\u5728" + hd.getHisOrHer() + "\u7684\u76ee\u89c6\u4e0b\u8f6c\u8eab\u79bb\u5f00\u3002");
            this.text.addPara("\"\u6211\u4eec\u5f88\u5feb\u5c31\u4f1a\u5728\u67d0\u4e2a\u5730\u65b9\u518d\u6b21\u76f8\u9047\u7684\uff01\" " + hd.getHeOrShe() + "\u7b11\u7740\u7ee7\u7eed\u8bf4\u9053\uff1a\"\u5e72\u6211\u4eec\u8fd9\u884c\u7684\uff0c" + "\u5c31\u8fde\u6211\u4e5f\u4e0d\u77e5\u9053\u51e0\u4e2a\u6708\u540e\u4f1a\u5728\u54ea\u843d\u811a\u3002\"");
            this.done = true;
            if (this.dialog.getInteractionTarget() != null) {
                this.dialog.getInteractionTarget().setActivePerson(null);
            }
            return;
        }
        boolean initedOffer = false;
        if (optionData instanceof HistorianData.HistorianOffer) {
            this.currentOffer = (HistorianData.HistorianOffer)optionData;
            this.currentOffer.init(this.dialog);
            initedOffer = true;
        }
        if (this.currentOffer != null) {
            if (!initedOffer) {
                this.currentOffer.optionSelected(optionText, optionData);
            }
            if (this.currentOffer.isInteractionFinished()) {
                if (this.currentOffer.shouldRemoveOffer()) {
                    this.offers.remove(this.currentOffer);
                    BarEventManager.getInstance().notifyWasInteractedWith(this);
                }
                this.currentOffer.notifyAccepted();
                if (this.currentOffer.shouldEndConversationOnReturning()) {
                    this.currentOffer = null;
                    this.optionSelected(null, (Object)OptionId.END_CONVERSATION);
                } else {
                    this.currentOffer = null;
                    this.optionSelected(null, (Object)OptionId.WHAT_DO_YOU_HAVE);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OptionId {
        GREETING,
        GREETNG_CONTINUE_1,
        GREETNG_ALREADY_INTRODUCED,
        GREETNG_PLOG,
        WHAT_DO_YOU_HAVE,
        BACKSTORY_BIT,
        END_CONVERSATION;

    }
}

