/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bases;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.PersonImportance;
import com.fs.starfarer.api.campaign.ReputationActionResponsePlugin;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.EconomyAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.FleetEventListener;
import com.fs.starfarer.api.campaign.listeners.ListenerUtil;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.ids.MemFlags;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.intel.PersonBountyIntel;
import com.fs.starfarer.api.impl.campaign.intel.bar.PortsideBarData;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.LuddicPathBaseBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathBaseManager;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathCellsIntel;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseIntel;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseManager;
import com.fs.starfarer.api.impl.campaign.intel.raid.RaidIntel;
import com.fs.starfarer.api.impl.campaign.procgen.MarkovNames;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseThemeGenerator;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuddicPathBaseIntel
extends BaseIntelPlugin
implements EveryFrameScript,
FleetEventListener,
EconomyAPI.EconomyUpdateListener,
RaidIntel.RaidDelegate {
    public static final String PATHER_BASE_COMMANDER = "$patherBaseCommander";
    public static String MEM_FLAG = "$core_luddicPathBase";
    public static Object BOUNTY_EXPIRED_PARAM = new Object();
    public static Object DISCOVERED_PARAM = new Object();
    public static Logger log = Global.getLogger(LuddicPathBaseIntel.class);
    protected PersonAPI baseCommander;
    protected StarSystemAPI system;
    protected MarketAPI market;
    protected SectorEntityToken entity;
    protected float elapsedDays = 0.0f;
    protected float duration = 45.0f;
    protected PirateBaseIntel.BaseBountyData bountyData = null;
    protected IntervalUtil monthlyInterval = new IntervalUtil(20.0f, 40.0f);
    protected int monthsNoBounty = 0;
    protected boolean large = false;
    protected Random random = new Random();
    protected CampaignFleetAPI addedListenerTo = null;
    protected PersonBountyIntel.BountyResult result = null;
    protected boolean sentBountyUpdate = false;

    public static LuddicPathBaseIntel getIntelFor(StarSystemAPI system) {
        for (IntelInfoPlugin intel : Global.getSector().getIntelManager().getIntel(LuddicPathBaseIntel.class)) {
            if (((LuddicPathBaseIntel)intel).getSystem() != system) continue;
            return (LuddicPathBaseIntel)intel;
        }
        return null;
    }

    public static LuddicPathBaseIntel getIntelFor(MarketAPI market) {
        for (IntelInfoPlugin p : Global.getSector().getIntelManager().getIntel(LuddicPathBaseIntel.class)) {
            LuddicPathBaseIntel intel = (LuddicPathBaseIntel)p;
            if (intel.getMarket() != market) continue;
            return intel;
        }
        return null;
    }

    public LuddicPathBaseIntel(StarSystemAPI system, String factionId) {
        this.system = system;
        this.market = Global.getFactory().createMarket(Misc.genUID(), "\u5362\u5fb7\u5de6\u5f84\u57fa\u5730", 3);
        this.market.setSize(3);
        this.market.setHidden(true);
        this.market.getMemoryWithoutUpdate().set(MEM_FLAG, true);
        this.market.getMemoryWithoutUpdate().set(MemFlags.HIDDEN_BASE_MEM_FLAG, true);
        this.market.setFactionId("luddic_path");
        this.market.setSurveyLevel(MarketAPI.SurveyLevel.FULL);
        this.market.setFactionId(factionId);
        this.market.addCondition("population_3");
        this.market.addIndustry("population");
        this.market.addIndustry("spaceport");
        this.market.addIndustry("militarybase");
        this.market.addSubmarket("open_market");
        this.market.addSubmarket("black_market");
        this.market.getTariff().modifyFlat("default_tariff", this.market.getFaction().getTariffFraction());
        LinkedHashMap<BaseThemeGenerator.LocationType, Float> weights = new LinkedHashMap<BaseThemeGenerator.LocationType, Float>();
        weights.put(BaseThemeGenerator.LocationType.IN_ASTEROID_BELT, Float.valueOf(10.0f));
        weights.put(BaseThemeGenerator.LocationType.IN_ASTEROID_FIELD, Float.valueOf(10.0f));
        weights.put(BaseThemeGenerator.LocationType.IN_RING, Float.valueOf(10.0f));
        weights.put(BaseThemeGenerator.LocationType.IN_SMALL_NEBULA, Float.valueOf(10.0f));
        weights.put(BaseThemeGenerator.LocationType.GAS_GIANT_ORBIT, Float.valueOf(10.0f));
        weights.put(BaseThemeGenerator.LocationType.PLANET_ORBIT, Float.valueOf(10.0f));
        WeightedRandomPicker<BaseThemeGenerator.EntityLocation> locs = BaseThemeGenerator.getLocations(null, system, null, 100.0f, weights);
        BaseThemeGenerator.EntityLocation loc = locs.pick();
        if (loc == null) {
            this.endImmediately();
            return;
        }
        BaseThemeGenerator.AddedEntity added = BaseThemeGenerator.addNonSalvageEntity(system, loc, "makeshift_station", factionId);
        if (added == null || added.entity == null) {
            this.endImmediately();
            return;
        }
        this.entity = added.entity;
        String name = this.generateName();
        if (name == null) {
            this.endImmediately();
            return;
        }
        this.market.setName(name);
        this.entity.setName(name);
        BaseThemeGenerator.convertOrbitWithSpin(this.entity, -5.0f);
        this.market.setPrimaryEntity(this.entity);
        this.entity.setMarket(this.market);
        this.entity.setSensorProfile(Float.valueOf(1.0f));
        this.entity.setDiscoverable(true);
        this.entity.getDetectedRangeMod().modifyFlat("gen", 5000.0f);
        this.market.setEconGroup(this.market.getId());
        this.market.getMemoryWithoutUpdate().set("$core_noDeciv", true);
        this.market.reapplyIndustries();
        Global.getSector().getEconomy().addMarket(this.market, true);
        this.baseCommander = this.market.getFaction().createRandomPerson(Misc.random);
        this.baseCommander.setRankId(Ranks.SPACE_CAPTAIN);
        this.baseCommander.setPostId(Ranks.POST_STATION_COMMANDER);
        this.baseCommander.setImportanceAndVoice(PersonImportance.HIGH, Misc.random);
        this.baseCommander.addTag("military");
        this.baseCommander.getMemoryWithoutUpdate().set(PATHER_BASE_COMMANDER, true);
        this.baseCommander.setImportance(PersonImportance.VERY_HIGH);
        this.market.getCommDirectory().addPerson(this.baseCommander);
        Global.getSector().getIntelManager().addIntel(this, true);
        if (!DebugFlags.PATHER_BASE_DEBUG) {
            this.timestamp = null;
        }
        Global.getSector().getListenerManager().addListener(this);
        Global.getSector().getEconomy().addUpdateListener(this);
        this.large = this.random.nextFloat() > 0.5f;
        this.updateStationIfNeeded(this.large);
        PortsideBarData.getInstance().addEvent(new LuddicPathBaseBarEvent(this));
        log.info((Object)String.format("Added luddic path base in [%s], isLarge: %s", system.getName(), "" + this.large));
    }

    @Override
    public boolean isHidden() {
        if (super.isHidden()) {
            return true;
        }
        return this.timestamp == null;
    }

    @Override
    public void notifyRaidEnded(RaidIntel raid, RaidIntel.RaidStageStatus status) {
    }

    public StarSystemAPI getSystem() {
        return this.system;
    }

    protected String pickStationType(boolean large) {
        WeightedRandomPicker<String> stations = new WeightedRandomPicker<String>();
        try {
            JSONObject json = this.getFactionForUIColors().getCustom().getJSONObject("patherBaseTypesSmall");
            if (large) {
                json = this.getFactionForUIColors().getCustom().getJSONObject("patherBaseTypesLarge");
            }
            String[] stringArray = JSONObject.getNames((JSONObject)json);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                stations.add(key, (float)json.optDouble(key, 0.0));
                ++n2;
            }
            if (stations.isEmpty()) {
                stations.add("orbitalstation", 5.0f);
            }
        }
        catch (JSONException e) {
            stations.clear();
        }
        return (String)stations.pick();
    }

    protected Industry getStationIndustry() {
        for (Industry curr : this.market.getIndustries()) {
            if (!curr.getSpec().hasTag("station")) continue;
            return curr;
        }
        return null;
    }

    protected void updateStationIfNeeded(boolean large) {
        Industry stationInd = this.getStationIndustry();
        String currIndId = null;
        if (stationInd != null) {
            currIndId = stationInd.getId();
            this.market.removeIndustry(stationInd.getId(), null, false);
            stationInd = null;
        }
        if (currIndId == null) {
            currIndId = this.pickStationType(large);
        }
        if (currIndId == null) {
            return;
        }
        this.market.addIndustry(currIndId);
        stationInd = this.getStationIndustry();
        if (stationInd == null) {
            return;
        }
        stationInd.finishBuildingOrUpgrading();
        CampaignFleetAPI fleet = Misc.getStationFleet(this.entity);
        if (fleet == null) {
            return;
        }
        List<FleetMemberAPI> members = fleet.getFleetData().getMembersListCopy();
        if (members.size() < 1) {
            return;
        }
        fleet.inflateIfNeeded();
    }

    @Override
    protected void advanceImpl(float amount) {
        CampaignFleetAPI fleet;
        float days = Global.getSector().getClock().convertToDays(amount);
        if (this.getPlayerVisibleTimestamp() == null && this.entity.isInCurrentLocation() && this.isHidden()) {
            this.makeKnown();
            this.sendUpdateIfPlayerHasIntel(DISCOVERED_PARAM, false);
        }
        if (!this.sentBountyUpdate && this.bountyData != null && (Global.getSector().getIntelManager().isPlayerInRangeOfCommRelay() || !this.isHidden() && DebugFlags.SEND_UPDATES_WHEN_NO_COMM)) {
            this.makeKnown();
            this.sendUpdateIfPlayerHasIntel((Object)this.bountyData, false);
            this.sentBountyUpdate = true;
        }
        if ((fleet = Misc.getStationFleet(this.market)) != null && this.addedListenerTo != fleet) {
            if (this.addedListenerTo != null) {
                this.addedListenerTo.removeEventListener(this);
            }
            fleet.addEventListener(this);
            this.addedListenerTo = fleet;
        }
        this.monthlyInterval.advance(days);
        if (this.monthlyInterval.intervalElapsed()) {
            if (this.bountyData == null && this.random.nextFloat() < Math.min(0.3f, (float)this.monthsNoBounty * 0.02f)) {
                this.setBounty();
            } else {
                ++this.monthsNoBounty;
            }
        }
        if (this.bountyData != null) {
            boolean canEndBounty = !this.entity.isInCurrentLocation();
            this.bountyData.bountyElapsedDays += days;
            if (this.bountyData.bountyElapsedDays > this.bountyData.bountyDuration && canEndBounty) {
                this.endBounty();
            }
        }
    }

    public void makeKnown() {
        this.makeKnown(null);
    }

    public void makeKnown(TextPanelAPI text) {
        if (this.getPlayerVisibleTimestamp() == null) {
            Global.getSector().getIntelManager().removeIntel(this);
            Global.getSector().getIntelManager().addIntel(this, text == null, text);
        }
    }

    @Override
    public float getTimeRemainingFraction() {
        float f = 1.0f - this.elapsedDays / this.duration;
        return f;
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
        log.info((Object)String.format("Removing luddic path base at [%s]", this.system.getName()));
        Global.getSector().getListenerManager().removeListener(this);
        Global.getSector().getEconomy().removeMarket(this.market);
        Global.getSector().getEconomy().removeUpdateListener(this);
        Misc.removeRadioChatter(this.market);
        this.market.advance(0.0f);
    }

    @Override
    protected void notifyEnded() {
        super.notifyEnded();
    }

    @Override
    public void reportFleetDespawnedToListener(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
        if (this.isEnding()) {
            return;
        }
        if (this.addedListenerTo != null && fleet == this.addedListenerTo) {
            BattleAPI battle;
            Misc.fadeAndExpire(this.entity);
            this.endAfterDelay();
            this.result = new PersonBountyIntel.BountyResult(PersonBountyIntel.BountyResultType.END_OTHER, 0, null);
            if (reason == CampaignEventListener.FleetDespawnReason.DESTROYED_BY_BATTLE && param instanceof BattleAPI && (battle = (BattleAPI)param).isPlayerInvolved()) {
                int payment = 0;
                if (this.bountyData != null) {
                    payment = (int)(this.bountyData.baseBounty * battle.getPlayerInvolvementFraction());
                }
                if (payment > 0) {
                    Global.getSector().getPlayerFleet().getCargo().getCredits().add(payment);
                    CoreReputationPlugin.CustomRepImpact impact = new CoreReputationPlugin.CustomRepImpact();
                    impact.delta = this.bountyData.repChange * battle.getPlayerInvolvementFraction();
                    if (impact.delta < 0.01f) {
                        impact.delta = 0.01f;
                    }
                    ReputationActionResponsePlugin.ReputationAdjustmentResult rep = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, null, null, false, true), this.bountyData.bountyFaction.getId());
                    this.result = new PersonBountyIntel.BountyResult(PersonBountyIntel.BountyResultType.END_PLAYER_BOUNTY, payment, rep);
                } else {
                    this.result = new PersonBountyIntel.BountyResult(PersonBountyIntel.BountyResultType.END_PLAYER_NO_REWARD, 0, null);
                }
            }
            boolean sendUpdate = DebugFlags.SEND_UPDATES_WHEN_NO_COMM || this.result.type != PersonBountyIntel.BountyResultType.END_OTHER || Global.getSector().getIntelManager().isPlayerInRangeOfCommRelay();
            sendUpdate = true;
            if (sendUpdate) {
                this.sendUpdateIfPlayerHasIntel((Object)this.result, false);
            }
            for (LuddicPathCellsIntel cell : LuddicPathCellsIntel.getCellsForBase(this, false)) {
                cell.makeSleeper(Global.getSettings().getFloat("patherCellDisruptionDuration"));
                if (cell.getMarket().isPlayerOwned() || DebugFlags.PATHER_BASE_DEBUG) {
                    cell.sendUpdateIfPlayerHasIntel(LuddicPathCellsIntel.UPDATE_DISRUPTED, false);
                }
                ListenerUtil.reportCellDisrupted(cell);
            }
            PirateBaseManager.markRecentlyUsedForBase(this.system);
            LuddicPathBaseManager.getInstance().incrDestroyed();
        }
    }

    @Override
    public void reportBattleOccurred(CampaignFleetAPI fleet, CampaignFleetAPI primaryWinner, BattleAPI battle) {
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        boolean isUpdate;
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        boolean bl = isUpdate = this.getListInfoParam() != null;
        if (this.bountyData != null && this.result == null && this.getListInfoParam() != BOUNTY_EXPIRED_PARAM) {
            if (isUpdate || mode != IntelInfoPlugin.ListInfoMode.IN_DESC) {
                FactionAPI faction = this.bountyData.bountyFaction;
                info.addPara("\u53d1\u5e03\u65b9\uff1a{" + faction.getDisplayName(), initPad, tc, faction.getBaseUIColor(), faction.getDisplayName());
                initPad = 0.0f;
            }
            info.addPara("%s \u5956\u52b1", initPad, tc, h, Misc.getDGSCredits(this.bountyData.baseBounty));
            this.addDays(info, "\u671f\u9650", this.bountyData.bountyDuration - this.bountyData.bountyElapsedDays, tc);
        }
        if (this.result != null && this.bountyData != null) {
            switch (this.result.type) {
                case END_PLAYER_BOUNTY: {
                    info.addPara("%s \u5df2\u6536\u5230", initPad, tc, h, Misc.getDGSCredits(this.result.payment));
                    CoreReputationPlugin.addAdjustmentMessage(this.result.rep.delta, this.bountyData.bountyFaction, null, null, null, info, tc, isUpdate, 0.0f);
                    break;
                }
                case END_TIME: {
                    break;
                }
            }
        }
        this.unindent(info);
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color c = this.getTitleColor(mode);
        info.addPara(this.getName(), c, 0.0f);
        this.addBulletPoints(info, mode);
    }

    @Override
    public String getSortString() {
        String base = Misc.ucFirst(this.getFactionForUIColors().getPersonNamePrefix());
        return String.valueOf(base) + " \u57fa\u5730";
    }

    @Override
    public String getName() {
        String base = Misc.ucFirst(this.getFactionForUIColors().getPersonNamePrefix());
        if (this.getListInfoParam() == this.bountyData && this.bountyData != null) {
            return String.valueOf(base) + " \u57fa\u5730 - \u8d4f\u91d1\u53d1\u5e03";
        }
        if (this.getListInfoParam() == BOUNTY_EXPIRED_PARAM) {
            return String.valueOf(base) + " \u57fa\u5730 - \u8d4f\u91d1\u8fc7\u671f";
        }
        if (this.result != null) {
            if (this.result.type == PersonBountyIntel.BountyResultType.END_PLAYER_BOUNTY) {
                return String.valueOf(base) + " \u57fa\u5730 - \u8d4f\u91d1\u5b8c\u6210";
            }
            if (this.result.type == PersonBountyIntel.BountyResultType.END_PLAYER_NO_REWARD) {
                return String.valueOf(base) + " \u57fa\u5730 - \u5df2\u6467\u6bc1";
            }
        }
        String name = this.market.getName();
        if (this.isEnding()) {
            return String.valueOf(base) + " \u57fa\u5730 - \u4efb\u52a1\u653e\u5f03";
        }
        if (this.getListInfoParam() == DISCOVERED_PARAM) {
            return String.valueOf(base) + " \u57fa\u5730 - \u5df2\u53d1\u73b0";
        }
        if (this.entity.isDiscoverable()) {
            return String.valueOf(base) + " \u57fa\u5730 - \u786e\u5207\u4fe1\u606f\u4e0d\u8be6";
        }
        return String.valueOf(base) + " \u57fa\u5730 - " + name;
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return this.market.getFaction();
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        FactionAPI faction = this.market.getFaction();
        info.addImage(faction.getLogo(), width, 128.0f, opad);
        String has = faction.getDisplayNameHasOrHave();
        info.addPara(String.valueOf(Misc.ucFirst(faction.getDisplayNameWithArticle())) + " " + has + " \u5728 " + this.market.getContainingLocation().getNameWithLowercaseType() + ". " + "\u8be5\u57fa\u5730\u80fd\u4e3a\u9644\u8fd1\u6b96\u6c11\u5730\u5185\u90a3\u4e9b\u6d3b\u8dc3\u7684\u5de6\u5f84\u72c2\u4fe1\u5f92\u63d0\u4f9b \u7269\u8d28\u652f\u6301\uff0c" + "\u6765\u8ba9\u4ed6\u4eec\u80fd\u987a\u5229\u9020\u6210\u5927\u8303\u56f4\u6076\u6027\u7834\u574f\u4e8b\u4ef6\u3002", opad, faction.getBaseUIColor(), faction.getDisplayNameWithArticleWithoutArticle());
        if (!this.entity.isDiscoverable()) {
            if (this.large) {
                info.addPara("\u5b83\u4e0d\u4ec5\u62e5\u6709\u975e\u5e38\u5f3a\u7684\u9632\u5fa1\u80fd\u529b\uff0c\u8fd8\u53d7\u5230\u5927\u91cf\u8230\u961f\u7684\u4fdd\u62a4\u3002", opad);
            } else {
                info.addPara("\u5b83\u4e0d\u4ec5\u62e5\u6709\u5f3a\u5927\u7684\u9632\u5fa1\u80fd\u529b\uff0c\u8fd8\u53d7\u5230\u5927\u91cf\u8230\u961f\u7684\u4fdd\u62a4\u3002", opad);
            }
        } else {
            info.addPara("\u4f60\u76ee\u524d\u5c1a\u4e0d\u6e05\u695a\u8fd9\u5904\u57fa\u5730\u7684\u786e\u5207\u4f4d\u7f6e\u4e0e\u9632\u5fa1\u6218\u529b\u3002", opad);
        }
        info.addSectionHeading("\u8fd1\u671f\u4e8b\u4ef6", faction.getBaseUIColor(), faction.getDarkUIColor(), Alignment.MID, opad);
        List<LuddicPathCellsIntel> cells = LuddicPathCellsIntel.getCellsForBase(this, false);
        if (!cells.isEmpty()) {
            float initPad = opad;
            info.addPara("\u5df2\u77e5\u8be5\u57fa\u5730\u6b63\u4e3a\u4e0b\u5217\u6b96\u6c11\u5730\u5185\u7684\u5de6\u5f84\u72c2\u4fe1\u5f92\u63d0\u4f9b\u652f\u6301\uff1a", opad);
            for (LuddicPathCellsIntel intel : cells) {
                LuddicPathBaseIntel.addMarketToList(info, intel.getMarket(), initPad, tc);
                initPad = 0.0f;
            }
            initPad = 0.0f;
        } else {
            info.addPara("\u76ee\u524d\u5c1a\u4e0d\u6e05\u695a\u8be5\u6b96\u6c11\u5730\u6b63\u4e3a\u54ea\u4e9b\u5de6\u5f84\u72c2\u4fe1\u5f92\u63d0\u4f9b\u652f\u6301\u3002", opad);
        }
        if (this.bountyData != null) {
            info.addPara(String.valueOf(Misc.ucFirst(this.bountyData.bountyFaction.getDisplayNameWithArticle())) + " " + this.bountyData.bountyFaction.getDisplayNameHasOrHave() + "\u53d1\u5e03\u4e86\u6467\u6bc1\u8be5\u57fa\u5730\u7684\u8d4f\u91d1\u3002", opad, this.bountyData.bountyFaction.getBaseUIColor(), this.bountyData.bountyFaction.getDisplayNameWithArticleWithoutArticle());
            if (this.result != null && this.result.type == PersonBountyIntel.BountyResultType.END_PLAYER_BOUNTY) {
                info.addPara("\u4f60\u5df2\u7ecf\u6210\u529f\u5b8c\u6210\u4e86\u8fd9\u7b14\u8d4f\u91d1\u3002", opad);
            }
            this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
        }
        if (this.result != null) {
            if (this.result.type == PersonBountyIntel.BountyResultType.END_PLAYER_NO_REWARD) {
                info.addPara("\u4f60\u6467\u6bc1\u4e86\u8fd9\u5904\u57fa\u5730\u3002", opad);
            } else if (this.result.type == PersonBountyIntel.BountyResultType.END_OTHER) {
                info.addPara("\u6709\u4f20\u8a00\u79f0\u8fd9\u5904\u57fa\u5730\u5df2\u7ecf\u505c\u6b62\u8fd0\u4f5c\u4e86\u3002", opad);
            }
        }
    }

    @Override
    public String getIcon() {
        return Global.getSettings().getSpriteName("intel", "pather_base");
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        if (this.bountyData != null) {
            tags.add("Bounties");
        }
        tags.add("Exploration");
        for (LuddicPathCellsIntel cell : LuddicPathCellsIntel.getCellsForBase(this, true)) {
            if (!cell.getMarket().isPlayerOwned() || cell.isSleeper()) continue;
            tags.add("Colony threats");
            break;
        }
        tags.add(this.market.getFactionId());
        if (this.bountyData != null) {
            tags.add(this.bountyData.bountyFaction.getId());
        }
        return tags;
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        if (this.market.getPrimaryEntity().isDiscoverable()) {
            return this.system.getCenter();
        }
        return this.market.getPrimaryEntity();
    }

    protected String generateName() {
        MarkovNames.loadIfNeeded();
        MarkovNames.MarkovNameResult gen = null;
        int i = 0;
        while (i < 10) {
            String test;
            gen = MarkovNames.generate(null);
            if (gen != null && !(test = gen.name).toLowerCase().startsWith("the ")) {
                String p = this.pickPostfix();
                if (p != null && !p.isEmpty()) {
                    test = String.valueOf(test) + " " + p;
                }
                if (test.length() <= 22) {
                    return test;
                }
            }
            ++i;
        }
        return null;
    }

    private String pickPostfix() {
        WeightedRandomPicker<String> post = new WeightedRandomPicker<String>();
        post.add("\u5e87\u62a4\u6240");
        post.add("\u907f\u96be\u5904");
        post.add("\u5ba1\u5224\u5723\u6bbf");
        post.add("\u907f\u96be\u6240");
        post.add("\u907f\u98ce\u6e2f");
        post.add("\u636e\u70b9");
        post.add("\u7a9d\u70b9");
        post.add("\u8054\u7edc\u70b9");
        post.add("\u907f\u96be\u6240");
        post.add("\u907f\u96be\u6240");
        post.add("\u5723\u6bbf");
        post.add("\u9690\u853d\u5904");
        post.add("\u5e87\u62a4\u6240");
        post.add("\u5e87\u62a4\u6240");
        post.add("\u603b\u90e8");
        post.add("\u539f\u521d\u5723\u6bbf");
        post.add("\u732e\u796d\u5723\u6bbf");
        post.add("\u727a\u7272\u5723\u6bbf");
        post.add("\u8d4e\u7f6a\u5723\u6bbf");
        post.add("\u51c0\u5316\u5723\u6bbf");
        post.add("\u5949\u732e\u5723\u6bbf");
        post.add("\u5723\u9910\u6240");
        return (String)post.pick();
    }

    @Override
    public void commodityUpdated(String commodityId) {
        CommodityOnMarketAPI com = this.market.getCommodityData(commodityId);
        int curr = 0;
        String modId = this.market.getId();
        MutableStat.StatMod mod = com.getAvailableStat().getFlatStatMod(modId);
        if (mod != null) {
            curr = Math.round(mod.value);
        }
        int a = com.getAvailable() - curr;
        int d = com.getMaxDemand();
        if (d > a) {
            com.getAvailableStat().modifyFlat(modId, d - a, "\u7531\u8d70\u79c1\u8005\u5e26\u5165");
        }
    }

    @Override
    public void economyUpdated() {
        float qualityBonus = 0.0f;
        int light = 0;
        int medium = 0;
        int heavy = 0;
        if (this.large) {
            qualityBonus = 0.5f;
            light = 4;
            medium = 4;
            heavy = 3;
        } else {
            qualityBonus = 0.0f;
            light = 3;
            medium = 2;
            heavy = 1;
        }
        this.market.getStats().getDynamic().getMod("fleet_quality_mod").modifyFlatAlways(this.market.getId(), qualityBonus, "\u53d1\u5c55\u6c34\u5e73");
        float fleetSizeBonus = 0.5f;
        if (this.large) {
            fleetSizeBonus = 1.0f;
        }
        this.market.getStats().getDynamic().getMod("combat_fleet_size_mult").modifyFlatAlways(this.market.getId(), fleetSizeBonus, "\u53d1\u5c55\u6c34\u5e73");
        String modId = this.market.getId();
        this.market.getStats().getDynamic().getMod("patrol_num_light_mod").modifyFlat(modId, light);
        this.market.getStats().getDynamic().getMod("patrol_num_medium_mod").modifyFlat(modId, medium);
        this.market.getStats().getDynamic().getMod("patrol_num_heavy_mod").modifyFlat(modId, heavy);
    }

    @Override
    public boolean isEconomyListenerExpired() {
        return this.isEnded();
    }

    public MarketAPI getMarket() {
        return this.market;
    }

    protected void setBounty() {
        List<IntelInfoPlugin> bases = Global.getSector().getIntelManager().getIntel(LuddicPathBaseIntel.class);
        for (IntelInfoPlugin curr : bases) {
            LuddicPathBaseIntel intel = (LuddicPathBaseIntel)curr;
            if (intel == this || intel.bountyData == null) continue;
            return;
        }
        this.bountyData = new PirateBaseIntel.BaseBountyData();
        float base = 100000.0f;
        if (this.large) {
            base = Global.getSettings().getFloat("luddicPathBaseBountyLarge");
            this.bountyData.repChange = 0.05f;
        } else {
            base = Global.getSettings().getFloat("luddicPathBaseBountySmall");
            this.bountyData.repChange = 0.1f;
        }
        this.bountyData.baseBounty = base * (0.9f + (float)Math.random() * 0.2f);
        this.bountyData.baseBounty = (int)(this.bountyData.baseBounty / 10000.0f) * 10000;
        WeightedRandomPicker<FactionAPI> picker = new WeightedRandomPicker<FactionAPI>();
        for (LuddicPathCellsIntel cell : LuddicPathCellsIntel.getCellsForBase(this, false)) {
            FactionAPI faction = cell.getMarket().getFaction();
            picker.add(faction, (float)Math.pow(2.0, cell.getMarket().getSize()));
        }
        FactionAPI faction = (FactionAPI)picker.pick();
        if (faction == null || faction.isPlayerFaction()) {
            this.bountyData = null;
            return;
        }
        this.bountyData.bountyFaction = faction;
        this.bountyData.bountyDuration = 180.0f;
        this.bountyData.bountyElapsedDays = 0.0f;
        this.monthsNoBounty = 0;
        Misc.makeImportant(this.entity, "baseBounty");
        this.sentBountyUpdate = false;
    }

    protected void endBounty() {
        this.sendUpdateIfPlayerHasIntel(BOUNTY_EXPIRED_PARAM, false);
        this.bountyData = null;
        this.monthsNoBounty = 0;
        Misc.makeUnimportant(this.entity, "baseBounty");
        this.sentBountyUpdate = false;
    }

    @Override
    public List<IntelInfoPlugin.ArrowData> getArrowData(SectorMapAPI map) {
        return null;
    }

    public SectorEntityToken getEntity() {
        return this.entity;
    }

    public boolean isLarge() {
        return this.large;
    }

    public PersonAPI getBaseCommander() {
        return this.baseCommander;
    }

    public void setBaseCommander(PersonAPI baseCommander) {
        this.baseCommander = baseCommander;
    }
}

