/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bases;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.FleetEventListener;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.econ.RecentUnrest;
import com.fs.starfarer.api.impl.campaign.fleets.EconomyFleetAssignmentAI;
import com.fs.starfarer.api.impl.campaign.fleets.EconomyFleetRouteManager;
import com.fs.starfarer.api.impl.campaign.fleets.RouteLocationCalculator;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathBaseIntel;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathBaseManager;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathCells;
import com.fs.starfarer.api.impl.campaign.rulecmd.HA_CMD;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuddicPathCellsIntel
extends BaseIntelPlugin
implements RouteManager.RouteFleetSpawner,
FleetEventListener {
    public static String USED_PLANETBUSTER_KEY = "$core_lpUsedPlanetbuster";
    public static float INCIDENT_PROB = Global.getSettings().getFloat("luddicPathCellsIncidentProbabilityPerMonth");
    public static float MIN_WARNING_DAYS = Global.getSettings().getFloat("luddicPathCellsIncidentWarningMinDays");
    public static float MIN_SABOTAGE = Global.getSettings().getFloatFromArray("luddicPathSabotageDays", 0);
    public static float MAX_SABOTAGE = Global.getSettings().getFloatFromArray("luddicPathSabotageDays", 1);
    public static Object UPDATE_DISSOLVED = new Object();
    public static Object UPDATE_DISRUPTED = new Object();
    public static Object INCIDENT_PREP = new Object();
    public static Object INCIDENT_PREVENTED = new Object();
    public static Object INCIDENT_HAPPENED = new Object();
    protected boolean sleeper = false;
    protected float sleeperTimeout = 0.0f;
    protected MarketAPI market;
    protected IntervalUtil incidentTracker = new IntervalUtil(20.0f, 40.0f);
    protected Random random = new Random();
    protected int numIncidentAttempts = 0;
    protected float incidentDelay = 0.0f;
    protected IncidentType incidentType = null;
    protected RouteManager.RouteData smuggler = null;
    protected IncidentType prevIncident = null;
    protected boolean prevIncidentSucceeded = false;
    protected float sincePrevIncident = 0.0f;
    protected Object prevIncidentData = null;
    protected float inertiaTime = 0.0f;

    public LuddicPathCellsIntel(MarketAPI market, boolean sleeper) {
        this.market = market;
        this.sleeper = sleeper;
        if (!market.isPlayerOwned()) {
            this.setPostingLocation(market.getPrimaryEntity());
        }
        if (!market.hasCondition("pather_cells")) {
            market.addCondition("pather_cells", this);
        }
        Global.getSector().addScript(this);
        if (market.isPlayerOwned() || DebugFlags.PATHER_BASE_DEBUG) {
            Global.getSector().getIntelManager().addIntel(this);
        } else {
            Global.getSector().getIntelManager().queueIntel(this);
        }
    }

    public static LuddicPathBaseIntel getClosestBase(MarketAPI market) {
        List<IntelInfoPlugin> bases = Global.getSector().getIntelManager().getIntel(LuddicPathBaseIntel.class);
        float minDist = Float.MAX_VALUE;
        LuddicPathBaseIntel closest = null;
        for (IntelInfoPlugin curr : bases) {
            LuddicPathBaseIntel intel = (LuddicPathBaseIntel)curr;
            float dist = Misc.getDistance(intel.getMarket().getLocationInHyperspace(), market.getLocationInHyperspace());
            if (!(dist < minDist)) continue;
            minDist = dist;
            closest = intel;
        }
        return closest;
    }

    public static List<LuddicPathCellsIntel> getCellsForBase(LuddicPathBaseIntel base, boolean includeSleeper) {
        ArrayList<LuddicPathCellsIntel> result = new ArrayList<LuddicPathCellsIntel>();
        List<IntelInfoPlugin> cells = Global.getSector().getIntelManager().getIntel(LuddicPathCellsIntel.class);
        for (IntelInfoPlugin curr : cells) {
            LuddicPathCellsIntel intel = (LuddicPathCellsIntel)curr;
            if (!includeSleeper && intel.isSleeper() || LuddicPathCellsIntel.getClosestBase(intel.getMarket()) != base) continue;
            result.add(intel);
        }
        return result;
    }

    public static LuddicPathCellsIntel getCellsForMarket(MarketAPI market) {
        if (market == null) {
            return null;
        }
        List<IntelInfoPlugin> cells = Global.getSector().getIntelManager().getIntel(LuddicPathCellsIntel.class);
        for (IntelInfoPlugin curr : cells) {
            LuddicPathCellsIntel intel = (LuddicPathCellsIntel)curr;
            if (intel.getMarket() != market) continue;
            return intel;
        }
        return null;
    }

    public MarketAPI getMarket() {
        return this.market;
    }

    @Override
    public boolean canMakeVisibleToPlayer(boolean playerInRelayRange) {
        return super.canMakeVisibleToPlayer(playerInRelayRange);
    }

    @Override
    protected void notifyEnded() {
        super.notifyEnded();
        Global.getSector().removeScript(this);
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
        if (this.market.hasCondition("pather_cells")) {
            this.market.removeCondition("pather_cells");
        }
    }

    public void makeSleeper() {
        this.makeSleeper(-1.0f);
    }

    public void makeSleeper(float sleeperTimeout) {
        if (sleeperTimeout >= 0.0f) {
            this.sleeperTimeout = sleeperTimeout;
        }
        this.sleeper = true;
    }

    public void makeActiveIfPossible() {
        if (this.sleeperTimeout <= 0.0f) {
            this.sleeper = false;
        }
    }

    @Override
    protected void advanceImpl(float amount) {
        super.advanceImpl(amount);
        float days = Misc.getDays(amount);
        this.inertiaTime += days;
        if (this.sleeperTimeout > 0.0f) {
            this.sleeperTimeout -= days;
            if (this.sleeperTimeout < 0.0f) {
                this.sleeperTimeout = 0.0f;
            }
        }
        if (!this.market.isInEconomy()) {
            this.endImmediately();
            return;
        }
        if (this.isSleeper()) {
            return;
        }
        if (DebugFlags.PATHER_BASE_DEBUG) {
            days *= 200.0f;
        }
        if (this.prevIncident != null) {
            float mult = 1.0f;
            if (DebugFlags.PATHER_BASE_DEBUG) {
                mult = 0.05f;
            }
            this.sincePrevIncident += days * mult;
            if (this.sincePrevIncident >= 180.0f) {
                this.sincePrevIncident = 0.0f;
                this.prevIncident = null;
                this.prevIncidentData = null;
                this.prevIncidentSucceeded = false;
            }
        }
        if (this.incidentType == null && this.prevIncident == null) {
            this.incidentTracker.advance(days);
            if (this.incidentTracker.intervalElapsed() && this.random.nextFloat() < INCIDENT_PROB) {
                this.prepareIncident();
                ++this.numIncidentAttempts;
            }
        } else if (this.incidentType != null) {
            RouteManager.RouteSegment segment;
            if (this.incidentDelay > 0.0f && this.smuggler == null) {
                this.incidentDelay -= days;
            }
            if (this.smuggler == null && this.incidentDelay <= 0.0f) {
                this.beginIncident();
            }
            if (this.smuggler != null && (segment = this.smuggler.getCurrent()) != null && segment.getId() == EconomyFleetRouteManager.ROUTE_TRAVEL_SRC.intValue()) {
                this.doIncident();
            }
        }
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        boolean isUpdate;
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        boolean bl = isUpdate = this.getListInfoParam() != null;
        if (mode != IntelInfoPlugin.ListInfoMode.IN_DESC) {
            LuddicPathCellsIntel.addMarketToList(info, this.market, initPad, tc);
            initPad = 0.0f;
        }
        if (isUpdate && this.getListInfoParam() == INCIDENT_HAPPENED) {
            if (!this.prevIncidentSucceeded) {
                info.addPara("\u53cd\u6050\u884c\u52a8", initPad);
            } else {
                switch (this.prevIncident) {
                    case INDUSTRY_SABOTAGE: {
                        Industry ind = (Industry)this.prevIncidentData;
                        String days = this.getDays(ind.getDisruptedDays());
                        String daysStr = LuddicPathCellsIntel.getDaysString(ind.getDisruptedDays());
                        info.addPara(String.valueOf(ind.getCurrentName()) + " \u88ab\u762b\u75ea\u4e86 %s " + daysStr, initPad, tc, h, days);
                        break;
                    }
                    case REDUCED_STABILITY: {
                        info.addPara("\u7a33\u5b9a\u6027\u964d\u4f4e %s", initPad, tc, h, "" + (Integer)this.prevIncidentData);
                        break;
                    }
                    case PLANETBUSTER: {
                        info.addPara("\u8be5\u6b96\u6c11\u5730\u5df2\u88ab\u884c\u661f\u6740\u624b\u6467\u6bc1", initPad, tc, new String[0]);
                    }
                }
            }
        }
        this.unindent(info);
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color c = this.getTitleColor(mode);
        info.addPara(this.getName(), c, 0.0f);
        this.addBulletPoints(info, mode);
    }

    public void addInterestInfo(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        float opad = 10.0f;
        info.addSectionHeading("\u53d7\u5a01\u80c1\u7684\u8bbe\u65bd", this.getFactionForUIColors().getBaseUIColor(), this.getFactionForUIColors().getDarkUIColor(), Alignment.MID, opad);
        info.addPara("\u65e0\u8bba\u662f\u7f6a\u6076\u7684 AI \u6838\u5fc3\u8fd8\u662f\u8fdd\u80cc\u5362\u5fb7\u6559\u4e49\u7684\u5de5\u4e1a\u751f\u4ea7\uff0c\u4ee5\u4e0b\u8bbe\u65bd\u5c06\u5fc5\u5b9a\u53d7\u5230\u5362\u5fb7\u5de6\u5f84\u7684\u5236\u88c1\uff1a", opad);
        ArrayList<Industry> industries = new ArrayList<Industry>(this.market.getIndustries());
        Iterator iter = industries.iterator();
        while (iter.hasNext()) {
            if (!((Industry)iter.next()).isHidden()) continue;
            iter.remove();
        }
        Collections.sort(industries, new Comparator<Industry>(){

            @Override
            public int compare(Industry o1, Industry o2) {
                float s1 = o1.getPatherInterest();
                float s2 = o2.getPatherInterest();
                return (int)Math.signum(s2 - s1);
            }
        });
        String indent = "    ";
        float initPad = 5.0f;
        boolean added = false;
        String aiCoreId = this.market.getAdmin().getAICoreId();
        if (aiCoreId != null) {
            int s = Math.round(LuddicPathBaseManager.AI_CORE_ADMIN_INTEREST);
            if (this.market.getAdmin().getMemoryWithoutUpdate().getBoolean("$suspectedAI")) {
                info.addPara(String.valueOf(indent) + "\u7591\u4f3c AI \u884c\u653f\u5b98 (%s) ", initPad, h, "" + s);
            } else {
                info.addPara(String.valueOf(indent) + "AI \u884c\u653f\u5b98 (%s) ", initPad, h, "" + s);
            }
            initPad = 3.0f;
            added = true;
        }
        for (Industry ind : industries) {
            float score = ind.getPatherInterest();
            if (!(score > 0.0f)) continue;
            int s = Math.round(score);
            info.addPara(String.valueOf(indent) + ind.getCurrentName() + " (%s)", initPad, h, "" + s);
            initPad = 3.0f;
            added = true;
        }
        if (!added) {
            info.addPara(String.valueOf(indent) + "\u65e0", initPad);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        block31: {
            block33: {
                float opad;
                block32: {
                    String days;
                    Color h = Misc.getHighlightColor();
                    Color g = Misc.getGrayColor();
                    Color tc = Misc.getTextColor();
                    float pad = 3.0f;
                    opad = 10.0f;
                    if (width > 0.0f) {
                        info.addImage(this.getFactionForUIColors().getLogo(), width, 128.0f, opad);
                    }
                    if (this.isEnding()) {
                        info.addPara("\u5de6\u5f84\u72c2\u4fe1\u5f92\u5df2\u88ab" + this.market.getOnOrAt() + " " + this.market.getName() + " \u7684\u5b89\u5168\u90e8\u95e8\u94f2\u9664\u3002", opad);
                    } else if (this.isSleeper() && this.sleeperTimeout <= 0.0f) {
                        info.addPara("\u8ff9\u8c61\u8868\u660e\uff0c\u6f5c\u4f0f\u4e2d\u7684\u5de6\u5f84\u72c2\u4fe1\u5f92\u6b63\u88ab\u6709\u9884\u8c0b\u7684\u7ec4\u7ec7\u8d77\u6765\uff0c\u5e76\u8bd5\u56fe\u7834\u574f" + this.market.getOnOrAt() + " " + this.market.getName() + "\u3002", opad);
                        info.addPara("\u5de6\u5f84\u6559\u5f92\u8fd8\u6ca1\u6709\u505a\u51fa\u4efb\u4f55\u5927\u52a8\u4f5c\uff0c\u4f46\u662f\u5982\u679c\u4efb\u4f55\u4ed6\u4eec\u6240\u53cd\u5bf9\u7684\u6d3b\u52a8 - \u4f8b\u5982\u53d1\u5c55\u5de5\u4e1a\u6216\u8005 AI \u6838\u5fc3 \u7684\u4f7f\u7528\u7b49\u7c7b\u4f3c\u6d3b\u52a8 - \u6301\u7eed\u4e0b\u53bb\uff0c\u4ed6\u4eec\u663e\u7136\u505a\u597d\u4e86\u52a8\u624b\u7684\u51c6\u5907\u3002", opad);
                    } else {
                        info.addPara("\u6709\u6d3b\u8dc3\u7684\u5de6\u5f84\u72c2\u4fe1\u5f92\u6b63\u8bd5\u56fe\u7834\u574f" + this.market.getOnOrAt() + " " + this.market.getName() + "\u3002", opad);
                        info.addPara("\u4ed6\u4eec\u6b63\u5728\u7b56\u5212\u6050\u6016\u88ad\u51fb\u548c\u5de5\u4e1a\u7834\u574f\u6d3b\u52a8\uff0c\u4f46\u9664\u975e\u661f\u7cfb\u5185\u7684\u654c\u5bf9\u52bf\u529b\u6d3b\u8dc3\u5230\u80fd\u63d0\u4f9b\u8db3\u591f\u7684\u63a9\u62a4\uff0c\u4ed6\u4eec\u4e0d\u592a\u53ef\u80fd\u5b9e\u65bd\u8fd9\u4e9b\u8ba1\u5212\u3002\u8fd9\u4e9b\u7ec4\u7ec7\u4e5f\u5411\u5728\u661f\u7cfb\u5185\u6d3b\u52a8\u7684 \u5de6\u5f84\u5206\u5b50 \u8230\u961f\u63d0\u4f9b\u60c5\u62a5\u3002", opad);
                        if (this.sleeperTimeout > 0.0f) {
                            int daysNum = Math.round(this.sleeperTimeout);
                            if (daysNum < 1) {
                                daysNum = 1;
                            }
                            days = LuddicPathCellsIntel.getDaysString(daysNum);
                            info.addPara("\u7136\u800c\uff0c\u652f\u63f4\u8fd9\u4e9b\u72c2\u4fe1\u5f92\u7684\u57fa\u5730\u5df2\u7ecf\u4e0d\u518d\u8fd0\u4f5c\u3002\u9884\u8ba1\u5efa\u7acb\u4e00\u5904\u65b0\u7684\u636e\u70b9\u81f3\u5c11\u9700\u8981 %s " + days + "\uff0c\u524d\u63d0\u662f\u5b58\u5728\u53e6\u4e00\u5904\u5de6\u5f84\u57fa\u5730\u3002", opad, h, "" + daysNum);
                        } else {
                            LuddicPathBaseIntel base = LuddicPathCellsIntel.getClosestBase(this.market);
                            if (base != null) {
                                if (base.isPlayerVisible()) {
                                    info.addPara("\u5de6\u5f84\u57fa\u5730\u4f4d\u4e8e " + base.getMarket().getStarSystem().getNameWithLowercaseType() + " \u5e76\u6b63\u4e3a\u72c2\u4fe1\u5f92\u4eec\u63d0\u4f9b\u652f\u63f4\u3002", opad);
                                } else {
                                    info.addPara("\u4f60\u5c1a\u672a\u83b7\u6089\u4e3a\u8fd9\u4e9b\u72c2\u4fe1\u5f92\u63d0\u4f9b\u652f\u6301\u7684\u5de6\u5f84\u57fa\u5730\u4f4d\u7f6e\u3002", opad);
                                }
                                info.addPara("\u5982\u679c\u8be5\u57fa\u5730\u88ab\u6467\u6bc1\uff0c\u5c31\u80fd\u5728\u5176\u4ed6\u57fa\u5730\u53d1\u8d77\u652f\u63f4\u4e4b\u524d\u4e89\u53d6\u5230\u4e00\u4e9b\u65f6\u95f4\uff0c\u4f7f\u8230\u961f\u548c\u5730\u9762\u4f5c\u6218\u884c\u52a8\u6682\u65f6\u88ab\u74e6\u89e3\u3002", opad);
                            }
                        }
                    }
                    if (!this.isEnding()) {
                        info.addSectionHeading("\u5f71\u54cd", this.getFactionForUIColors().getBaseUIColor(), this.getFactionForUIColors().getDarkUIColor(), Alignment.MID, opad);
                        if (!this.isSleeper()) {
                            float stability = LuddicPathCells.STABLITY_PENALTY;
                            info.addPara("%s \u7a33\u5b9a\u6027\u3002", opad, h, "-" + (int)stability);
                        } else if (this.sleeperTimeout <= 0.0f) {
                            info.addPara("\u8fc4\u4eca\u4e3a\u6b62\u5c1a\u672a\u9020\u6210\u660e\u663e\u5f71\u54cd\u3002", opad);
                        } else {
                            info.addPara("\u56e0\u7f3a\u4e4f\u7269\u8d28\u652f\u6301\uff0c\u6240\u4ee5\u672a\u5bf9\u8be5\u5e02\u573a\u9020\u6210\u5f71\u54cd\u3002", opad);
                        }
                    }
                    if (this.prevIncident == null && this.incidentType != IncidentType.PLANETBUSTER) break block31;
                    info.addSectionHeading("\u8fd1\u671f\u4e8b\u4ef6", this.getFactionForUIColors().getBaseUIColor(), this.getFactionForUIColors().getDarkUIColor(), Alignment.MID, opad);
                    if (!this.prevIncidentSucceeded) break block32;
                    if (this.incidentType == IncidentType.PLANETBUSTER) {
                        info.addPara("\u8ff9\u8c61\u8868\u660e\uff0c\u5de6\u5f84\u72c2\u4fe1\u5f92\u6b63\u51c6\u5907\u5c06\u4e00\u9897\u884c\u661f\u6740\u624b\u5077\u8fd0\u81f3" + this.market.getName() + "\u3002" + "\u5982\u679c\u4ed6\u4eec\u6210\u529f\u4e86\uff0c\u8be5\u6b96\u6c11\u5730\u5c06\u906d\u5230\u91cd\u521b\u76f4\u81f3\u6467\u6bc1\u3002", opad);
                        break block33;
                    } else if (this.prevIncident != null) {
                        switch (this.prevIncident) {
                            case INDUSTRY_SABOTAGE: {
                                Industry ind;
                                if (!(this.prevIncidentData instanceof Industry) || !((ind = (Industry)this.prevIncidentData).getDisruptedDays() > 2.0f)) break;
                                days = this.getDays(ind.getDisruptedDays());
                                String daysStr = LuddicPathCellsIntel.getDaysString(ind.getDisruptedDays());
                                info.addPara("\u5de6\u5f84\u72c2\u4fe1\u5f92\u6210\u529f\u7834\u574f\u5e76\u762b\u75ea\u4e86" + ind.getCurrentName() + " \u7684\u8fd0\u4f5c %s " + daysStr + "\u3002", opad, h, days);
                                break;
                            }
                            case REDUCED_STABILITY: {
                                info.addPara("\u7531\u4e8e\u5de6\u5f84\u72c2\u4fe1\u5f92\u5bf9\u5404\u79cd\u5de5\u4e1a\uff0c\u519b\u4e8b\u4ee5\u53ca\u6c11\u7528\u76ee\u6807\u8fdb\u884c\u4e86 \u5c0f\u89c4\u6a21\u7684\u88ad\u51fb\uff0c\u800c\u5bfc\u81f4\u7a33\u5b9a\u6027\u964d\u4f4e\u4e86 %s.", opad, h, "" + (Integer)this.prevIncidentData);
                                break;
                            }
                            case PLANETBUSTER: {
                                info.addPara("\u5de6\u5f84\u72c2\u4fe1\u5f92\u5df2\u7ecf\u6210\u529f\u5c06\u4e00\u9897\u884c\u661f\u6740\u624b\u5077\u8fd0\u81f3 " + this.market.getName() + " \u5e76\u5f15\u7206\u5b83\u3002\u8be5\u6b96\u6c11\u5730\u5b9e\u9645\u4e0a\u5df2\u7ecf\u88ab\u6467\u6bc1\u4e86\u3002", opad);
                            }
                            default: {
                                break;
                            }
                        }
                    }
                    break block33;
                }
                if (this.prevIncident != null) {
                    switch (this.prevIncident) {
                        case INDUSTRY_SABOTAGE: {
                            if (!(this.prevIncidentData instanceof Industry)) break;
                            Industry ind = (Industry)this.prevIncidentData;
                            info.addPara("\u5f53\u5730\u5b89\u5168\u90e8\u95e8\u6210\u529f\u963b\u6b62\u4e86\u9488\u5bf9 " + ind.getCurrentName() + " \u7684\u84c4\u610f\u7834\u574f\u884c\u52a8\u3002", opad);
                            break;
                        }
                        case REDUCED_STABILITY: {
                            info.addPara("\u5f53\u5730\u5b89\u4fdd\u6210\u529f\u963b\u6b62\u4e86\u9488\u5bf9\u5404\u79cd\u5de5\u4e1a\uff0c\u519b\u4e8b\u548c\u6c11\u7528\u76ee\u6807\u7684\u591a\u8d77\u6709\u9884\u8c0b\u7684\u88ad\u51fb\u3002", opad);
                            break;
                        }
                        case PLANETBUSTER: {
                            info.addPara("\u5de6\u5f84\u72c2\u4fe1\u5f92\u5df2\u7ecf\u6210\u529f\u5c06\u4e00\u9897\u884c\u661f\u6740\u624b\u5077\u8fd0\u81f3 " + this.market.getName() + "\uff0c\u4f46\u88ab\u5f53\u5730\u5b89\u5168\u90e8\u95e8\u622a\u83b7\u5e76\u59a5\u5584\u5904\u7406\uff0c" + "\u4ece\u800c\u9003\u8fc7\u4e00\u52ab\u3002", opad);
                            break;
                        }
                    }
                }
            }
            this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
        }
        if (!this.isEnding()) {
            this.addInterestInfo(info, width, height);
        }
    }

    @Override
    public List<IntelInfoPlugin.ArrowData> getArrowData(SectorMapAPI map) {
        SectorEntityToken iconEntity;
        if (this.sleeperTimeout > 0.0f) {
            return null;
        }
        LuddicPathBaseIntel base = LuddicPathCellsIntel.getClosestBase(this.market);
        if (base == null || !base.isPlayerVisible()) {
            return null;
        }
        ArrayList<IntelInfoPlugin.ArrowData> result = new ArrayList<IntelInfoPlugin.ArrowData>();
        SectorEntityToken entityFrom = base.getMapLocation(map);
        if (map != null && (iconEntity = map.getIntelIconEntity(base)) != null) {
            entityFrom = iconEntity;
        }
        IntelInfoPlugin.ArrowData arrow = new IntelInfoPlugin.ArrowData(entityFrom, this.market.getPrimaryEntity());
        arrow.color = this.getFactionForUIColors().getBaseUIColor();
        result.add(arrow);
        return result;
    }

    @Override
    public String getIcon() {
        if (this.isSleeper()) {
            return Global.getSettings().getSpriteName("intel", "sleeper_cells");
        }
        return Global.getSettings().getSpriteName("intel", "active_cells");
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("luddic_path");
        if (this.market.isPlayerOwned() && !this.isSleeper()) {
            tags.add("Colony threats");
        }
        return tags;
    }

    @Override
    public String getSortString() {
        String base = Misc.ucFirst(this.getFactionForUIColors().getPersonNamePrefix());
        if (this.sleeper) {
            return String.valueOf(base) + " D";
        }
        return String.valueOf(base) + " C";
    }

    @Override
    public String getName() {
        String base = "\u5de6\u5f84\u72c2\u4fe1\u5f92";
        if (this.isSendingUpdate() && this.getListInfoParam() == INCIDENT_HAPPENED) {
            if (this.prevIncidentSucceeded) {
                return String.valueOf(base) + " - \u9a9a\u4e71";
            }
            return String.valueOf(base) + " - \u904f\u5236";
        }
        if (this.isEnding()) {
            return String.valueOf(base) + " - \u89e3\u6563";
        }
        if (this.sleeperTimeout > 0.0f) {
            return String.valueOf(base) + " - \u762b\u75ea";
        }
        if (this.isSleeper()) {
            return String.valueOf(base) + " - \u6f5c\u4f0f";
        }
        return String.valueOf(base) + " - \u6d3b\u8dc3";
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return Global.getSector().getFaction("luddic_path");
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        return this.market.getPrimaryEntity();
    }

    @Override
    public String getCommMessageSound() {
        return super.getCommMessageSound();
    }

    public boolean isSleeper() {
        if ("player".equals(this.market.getFactionId()) && HA_CMD.playerHasPatherAgreement()) {
            return true;
        }
        return this.sleeper;
    }

    public void setSleeper(boolean sleeper) {
        this.sleeper = sleeper;
    }

    public float getSleeperTimeout() {
        return this.sleeperTimeout;
    }

    public void setSleeperTimeout(float sleeperTimeout) {
        this.sleeperTimeout = sleeperTimeout;
    }

    public String getRouteSourceId() {
        return "econ";
    }

    public void prepareIncident() {
        this.abortIncident();
        LuddicPathBaseIntel base = LuddicPathCellsIntel.getClosestBase(this.getMarket());
        if (base == null) {
            return;
        }
        WeightedRandomPicker<IncidentType> types = new WeightedRandomPicker<IncidentType>(this.random);
        types.add(IncidentType.REDUCED_STABILITY, 10.0f);
        if (this.numIncidentAttempts >= 3 || !this.market.isPlayerOwned()) {
            types.add(IncidentType.INDUSTRY_SABOTAGE, 10.0f);
        }
        this.incidentType = (IncidentType)((Object)types.pick());
        this.incidentDelay = MIN_WARNING_DAYS + this.random.nextFloat() * MIN_WARNING_DAYS;
        if (this.incidentType == IncidentType.PLANETBUSTER) {
            this.incidentDelay = MIN_WARNING_DAYS * 4.0f + this.random.nextFloat() * 30.0f;
            Global.getSector().getMemoryWithoutUpdate().set(USED_PLANETBUSTER_KEY, true, 1500.0f);
        }
    }

    public void beginIncident() {
        LuddicPathBaseIntel base = LuddicPathCellsIntel.getClosestBase(this.getMarket());
        if (base == null) {
            this.abortIncident();
            return;
        }
        this.sendSmuggler(base);
    }

    public void abortIncident() {
        this.incidentDelay = 0.0f;
        this.incidentType = null;
        if (this.smuggler != null && this.smuggler.getActiveFleet() != null) {
            this.smuggler.getActiveFleet().removeEventListener(this);
        }
        this.smuggler = null;
    }

    protected boolean checkSuccess() {
        float pSuccess = 1.0f - this.market.getStabilityValue() * 0.075f;
        return this.random.nextFloat() < pSuccess;
    }

    public void doIncident() {
        if (this.incidentType == null) {
            return;
        }
        this.prevIncidentData = null;
        boolean success = this.checkSuccess();
        if (this.incidentType == IncidentType.REDUCED_STABILITY) {
            if (success) {
                RecentUnrest.get(this.market).add(3, String.valueOf(Misc.ucFirst(Global.getSector().getFaction("luddic_path").getPersonNamePrefix())) + " \u7834\u574f");
                this.prevIncidentData = 3;
            }
        } else if (this.incidentType == IncidentType.INDUSTRY_SABOTAGE) {
            WeightedRandomPicker<Industry> picker = new WeightedRandomPicker<Industry>(this.random);
            for (Industry ind : this.market.getIndustries()) {
                if (!ind.canBeDisrupted()) continue;
                picker.add(ind, ind.getPatherInterest());
            }
            Industry target = (Industry)picker.pick();
            if (target == null) {
                this.abortIncident();
                return;
            }
            this.prevIncidentData = target;
            if (success) {
                float disruptionDur = MIN_SABOTAGE + this.random.nextFloat() * (MAX_SABOTAGE - MIN_SABOTAGE);
                target.setDisrupted(disruptionDur, true);
            }
        }
        this.prevIncident = this.incidentType;
        this.sincePrevIncident = 0.0f;
        this.prevIncidentSucceeded = success;
        if ((DebugFlags.SEND_UPDATES_WHEN_NO_COMM || Global.getSector().getIntelManager().isPlayerInRangeOfCommRelay() || this.market.isPlayerOwned()) && (this.market.isPlayerOwned() || this.incidentType == IncidentType.INDUSTRY_SABOTAGE || this.incidentType == IncidentType.PLANETBUSTER)) {
            this.sendUpdateIfPlayerHasIntel(INCIDENT_HAPPENED, false);
        }
        this.abortIncident();
    }

    protected void sendSmuggler(LuddicPathBaseIntel base) {
        String sid = this.getRouteSourceId();
        SectorEntityToken from = base.getMarket().getPrimaryEntity();
        SectorEntityToken to = this.getMarket().getPrimaryEntity();
        EconomyFleetAssignmentAI.EconomyRouteData data = new EconomyFleetAssignmentAI.EconomyRouteData();
        data.from = base.getMarket();
        data.to = this.market;
        data.smuggling = true;
        data.cargoCap = 400.0f;
        data.fuelCap = 200.0f;
        RouteManager.OptionalFleetData extra = new RouteManager.OptionalFleetData(data.from);
        extra.fleetType = "tradeSmuggler";
        RouteManager.RouteData route = RouteManager.getInstance().addRoute(sid, base.getMarket(), Misc.genRandomSeed(), extra, this, data);
        extra.strength = Float.valueOf(50.0f);
        extra.strength = Float.valueOf(Misc.getAdjustedStrength(extra.strength.floatValue(), base.getMarket()));
        float orbitDays = 3.0f + this.random.nextFloat() * 3.0f;
        float travelDays = RouteLocationCalculator.getTravelDays(from, to);
        if (DebugFlags.PATHER_BASE_DEBUG) {
            travelDays *= 0.1f;
        }
        route.addSegment(new RouteManager.RouteSegment(EconomyFleetRouteManager.ROUTE_SRC_LOAD, orbitDays, from));
        route.addSegment(new RouteManager.RouteSegment(EconomyFleetRouteManager.ROUTE_TRAVEL_DST, travelDays, from, to));
        route.addSegment(new RouteManager.RouteSegment(EconomyFleetRouteManager.ROUTE_DST_UNLOAD, orbitDays * 0.5f, to));
        route.addSegment(new RouteManager.RouteSegment(EconomyFleetRouteManager.ROUTE_DST_LOAD, orbitDays * 0.5f, to));
        route.addSegment(new RouteManager.RouteSegment(EconomyFleetRouteManager.ROUTE_TRAVEL_SRC, travelDays, to, from));
        route.addSegment(new RouteManager.RouteSegment(EconomyFleetRouteManager.ROUTE_SRC_UNLOAD, orbitDays, from));
        this.smuggler = route;
    }

    @Override
    public void reportAboutToBeDespawnedByRouteManager(RouteManager.RouteData route) {
    }

    @Override
    public boolean shouldCancelRouteAfterDelayCheck(RouteManager.RouteData route) {
        return false;
    }

    @Override
    public boolean shouldRepeat(RouteManager.RouteData route) {
        return false;
    }

    @Override
    public CampaignFleetAPI spawnFleet(RouteManager.RouteData route) {
        CampaignFleetAPI fleet;
        Random random = new Random();
        if (route.getSeed() != null) {
            random = new Random(route.getSeed());
        }
        if ((fleet = EconomyFleetRouteManager.createTradeRouteFleet(route, random)) == null) {
            return null;
        }
        fleet.getMemoryWithoutUpdate().set("$cfai_doNotIgnorePlayer", true);
        fleet.getMemoryWithoutUpdate().set("$cfai_ignoreOtherFleets", true);
        fleet.addEventListener(this);
        fleet.addScript(new EconomyFleetAssignmentAI(fleet, route));
        return fleet;
    }

    @Override
    public void reportBattleOccurred(CampaignFleetAPI fleet, CampaignFleetAPI primaryWinner, BattleAPI battle) {
        if (this.smuggler == null || this.smuggler.getActiveFleet() == null) {
            return;
        }
        CampaignFleetAPI active = this.smuggler.getActiveFleet();
        if (!battle.isInvolved(active)) {
            return;
        }
        if (battle.getSideFor(active) != battle.getSideFor(primaryWinner)) {
            this.abortIncident();
        }
    }

    @Override
    public void reportFleetDespawnedToListener(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
        if (this.smuggler != null && fleet == this.smuggler.getActiveFleet()) {
            this.abortIncident();
        }
    }

    public float getInertiaTime() {
        return this.inertiaTime;
    }

    public void setInertiaTime(float inertiaTime) {
        this.inertiaTime = inertiaTime;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IncidentType {
        REDUCED_STABILITY,
        INDUSTRY_SABOTAGE,
        PLANETBUSTER;

    }
}

