/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bases;

import com.fs.starfarer.api.impl.campaign.econ.BaseMarketConditionPlugin;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseIntel;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PirateActivity
extends BaseMarketConditionPlugin {
    protected PirateBaseIntel intel;

    @Override
    public void setParam(Object param) {
        this.intel = (PirateBaseIntel)param;
    }

    @Override
    public void apply(String id) {
        float accessibility = this.intel.getAccessibilityPenalty();
        float stability = this.intel.getStabilityPenalty();
        String name = "\u6d77\u76d7\u88ad\u51fb";
        if (accessibility != 0.0f) {
            this.market.getAccessibilityMod().modifyFlat(id, -accessibility, name);
        }
        if (stability != 0.0f) {
            this.market.getStability().modifyFlat(id, -stability, name);
        }
    }

    @Override
    public void unapply(String id) {
        this.market.getAccessibilityMod().unmodifyFlat(id);
        this.market.getStability().unmodifyFlat(id);
    }

    @Override
    public void advance(float amount) {
        if (!this.intel.getMarket().isInEconomy()) {
            this.market.removeSpecificCondition(this.condition.getIdForPluginModifications());
        }
    }

    @Override
    public Map<String, String> getTokenReplacements() {
        return super.getTokenReplacements();
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public void createTooltipAfterDescription(TooltipMakerAPI tooltip, boolean expanded) {
        Color h = Misc.getHighlightColor();
        Color n = Misc.getNegativeHighlightColor();
        float pad = 3.0f;
        float small = 5.0f;
        float opad = 10.0f;
        float accessibility = this.intel.getAccessibilityPenalty();
        float stability = this.intel.getStabilityPenalty();
        if (stability != 0.0f && accessibility != 0.0f) {
            tooltip.addPara("%s \u7a33\u5b9a\u6027\uff0c%s \u6d41\u901a\u6027\u3002", opad, h, "-" + (int)stability, "-" + Math.round(accessibility * 100.0f) + "%");
        } else if (stability != 0.0f) {
            tooltip.addPara("%s \u7a33\u5b9a\u6027\u3002", opad, h, "-" + (int)stability);
        } else if (accessibility != 0.0f) {
            tooltip.addPara("%s \u6d41\u901a\u6027\u3002", opad, h, "-" + Math.round(accessibility * 100.0f) + "%");
        } else {
            tooltip.addPara("\u8fc4\u4eca\u4e3a\u6b62\u5c1a\u672a\u9020\u6210\u660e\u663e\u5f71\u54cd\u3002", opad);
        }
    }

    @Override
    public float getTooltipWidth() {
        return super.getTooltipWidth();
    }

    @Override
    public boolean hasCustomTooltip() {
        return true;
    }

    @Override
    public boolean isTooltipExpandable() {
        return super.isTooltipExpandable();
    }

    public PirateBaseIntel getIntel() {
        return this.intel;
    }
}

