/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bases;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionPlugin;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateActivity;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.PiracyRespiteScript;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PirateActivityIntel
extends BaseIntelPlugin {
    protected StarSystemAPI system;
    protected PirateBaseIntel source;

    public PirateActivityIntel(StarSystemAPI system, PirateBaseIntel source) {
        this.system = system;
        this.source = source;
        boolean hasPlayerMarkets = false;
        for (MarketAPI curr : Global.getSector().getEconomy().getMarkets(system)) {
            hasPlayerMarkets |= curr.isPlayerOwned();
        }
        if (!hasPlayerMarkets) {
            this.setPostingLocation(system.getCenter());
        }
        Global.getSector().addScript(this);
        if (!Misc.getMarketsInLocation(system, "player").isEmpty()) {
            Global.getSector().getIntelManager().addIntel(this);
        } else {
            Global.getSector().getIntelManager().queueIntel(this);
        }
    }

    @Override
    public boolean canMakeVisibleToPlayer(boolean playerInRelayRange) {
        if (DebugFlags.SEND_UPDATES_WHEN_NO_COMM && this.source.isPlayerVisible()) {
            return true;
        }
        return super.canMakeVisibleToPlayer(playerInRelayRange);
    }

    public PirateBaseIntel getSource() {
        return this.source;
    }

    @Override
    protected void notifyEnded() {
        super.notifyEnded();
        Global.getSector().removeScript(this);
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
        for (MarketAPI curr : this.source.getAffectedMarkets(this.system)) {
            if (!curr.hasCondition("pirate_activity")) continue;
            curr.removeCondition("pirate_activity");
        }
    }

    @Override
    protected void advanceImpl(float amount) {
        super.advanceImpl(amount);
        if (this.source.isEnding() || this.source.getTarget() != this.system) {
            this.endAfterDelay();
            if (DebugFlags.SEND_UPDATES_WHEN_NO_COMM || Global.getSector().getIntelManager().isPlayerInRangeOfCommRelay()) {
                this.sendUpdateIfPlayerHasIntel(new Object(), false);
            }
            return;
        }
        for (MarketAPI curr : this.source.getAffectedMarkets(this.system)) {
            if (curr.isPlayerOwned() && PiracyRespiteScript.get() != null || curr.hasCondition("pirate_activity")) continue;
            curr.addCondition("pirate_activity", this.source);
        }
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        boolean isUpdate = this.getListInfoParam() != null;
        this.unindent(info);
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color c = this.getTitleColor(mode);
        info.addPara(this.getName(), c, 0.0f);
        this.addBulletPoints(info, mode);
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        info.addImage(this.getFactionForUIColors().getLogo(), width, 128.0f, opad);
        info.addPara("\u5e38\u5e74\u88ad\u6270\u6b96\u6c11\u5730\u548c\u8d38\u6613\u822a\u7ebf\u7684\u6d77\u76d7\uff0c\u7ec8\u4e8e\u5c06\u76ee\u6807\u6295\u5411\u4e86 " + this.system.getNameWithLowercaseType() + ".", opad);
        if (this.source.isPlayerVisible()) {
            info.addPara("\u7b56\u5212\u8fd9\u573a\u88ad\u51fb\u7684\u6d77\u76d7\u57fa\u5730\u4f4d\u7f6e\u5728 " + this.source.getMarket().getName() + ", \u800c\u6b64\u5904\u4f4d\u4e8e " + this.source.getSystem().getNameWithLowercaseType() + ".", opad);
        } else {
            float distLY = Misc.getDistanceLY(this.system.getLocation(), this.source.getSystem().getLocation());
            if (distLY < 10.0f) {
                info.addPara("\u5c3d\u7ba1\u7b56\u5212\u8fd9\u573a\u88ad\u51fb\u7684\u6d77\u76d7\u57fa\u5730\u4f4d\u7f6e\u5c1a\u4e0d\u660e\u786e\uff0c\u4f46\u8ff9\u8c61\u8868\u660e\u5b83\u5e94\u8be5\u5c31\u5728\u9644\u8fd1\u3002", opad);
            } else {
                info.addPara("\u5c3d\u7ba1\u7b56\u5212\u8fd9\u573a\u88ad\u51fb\u7684\u6d77\u76d7\u57fa\u5730\u4f4d\u7f6e\u5c1a\u4e0d\u660e\u786e\uff0c\u4f46\u8ff9\u8c61\u8868\u660e\u5b83\u5e94\u8be5\u76f8\u5f53\u9065\u8fdc\u3002", opad);
            }
        }
        info.addSectionHeading("\u6b96\u6c11\u5730\u53d7\u5230\u7684\u5f71\u54cd", this.getFactionForUIColors().getBaseUIColor(), this.getFactionForUIColors().getDarkUIColor(), Alignment.MID, opad);
        MarketConditionAPI condition = null;
        float initPad = opad;
        for (MarketAPI curr : this.source.getAffectedMarkets(this.system)) {
            if (condition == null) {
                condition = curr.getCondition("pirate_activity");
            }
            PirateActivityIntel.addMarketToList(info, curr, initPad, tc);
            initPad = 0.0f;
        }
        if (condition != null) {
            MarketConditionPlugin plugin = condition.getPlugin();
            ((PirateActivity)plugin).createTooltipAfterDescription(info, true);
        }
    }

    public StarSystemAPI getSystem() {
        return this.system;
    }

    @Override
    public String getIcon() {
        return Global.getSettings().getSpriteName("intel", "pirate_activity");
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("pirates");
        if (!Misc.getMarketsInLocation(this.system, "player").isEmpty()) {
            tags.add("Colony threats");
        }
        return tags;
    }

    @Override
    public String getSortString() {
        String base = Misc.ucFirst(this.getFactionForUIColors().getPersonNamePrefix());
        return String.valueOf(base) + " C";
    }

    @Override
    public String getName() {
        String base = "\u6d77\u76d7\u88ad\u51fb";
        if (this.isEnding()) {
            return String.valueOf(base) + " - \u7ed3\u675f";
        }
        return String.valueOf(base) + " - " + this.system.getBaseName();
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return this.source.getFactionForUIColors();
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        return this.system.getCenter();
    }

    @Override
    public String getCommMessageSound() {
        return PirateActivityIntel.getSoundMinorMessage();
    }
}

