/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bases;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.PersonImportance;
import com.fs.starfarer.api.campaign.ReputationActionResponsePlugin;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.EconomyAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.FleetEventListener;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.Tuning;
import com.fs.starfarer.api.impl.campaign.fleets.RouteLocationCalculator;
import com.fs.starfarer.api.impl.campaign.ids.MemFlags;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.intel.PersonBountyIntel;
import com.fs.starfarer.api.impl.campaign.intel.bar.PortsideBarData;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.PirateBaseRumorBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateActivityIntel;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseManager;
import com.fs.starfarer.api.impl.campaign.intel.events.PirateBasePirateActivityCause2;
import com.fs.starfarer.api.impl.campaign.intel.raid.PirateRaidActionStage;
import com.fs.starfarer.api.impl.campaign.intel.raid.PirateRaidAssembleStage;
import com.fs.starfarer.api.impl.campaign.intel.raid.RaidIntel;
import com.fs.starfarer.api.impl.campaign.intel.raid.ReturnStage;
import com.fs.starfarer.api.impl.campaign.intel.raid.TravelStage;
import com.fs.starfarer.api.impl.campaign.procgen.MarkovNames;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseThemeGenerator;
import com.fs.starfarer.api.impl.campaign.rulecmd.HA_CMD;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PirateBaseIntel
extends BaseIntelPlugin
implements EveryFrameScript,
FleetEventListener,
EconomyAPI.EconomyUpdateListener,
RaidIntel.RaidDelegate {
    public static final String PIRATE_BASE_COMMANDER = "$pirateBaseCommander";
    public static final String HAS_DEAL_WITH_BASE_COMMANDER = "$playerHasDealWithPirateBaseCommander";
    public static String MEM_FLAG = "$core_pirateBase";
    public static Object DEAL_MADE_PARAM = new Object();
    public static Object DEAL_BROKEN_PARAM = new Object();
    public static Object DEAL_CANCELLED_PARAM = new Object();
    public static Object BOUNTY_EXPIRED_PARAM = new Object();
    public static Object DISCOVERED_PARAM = new Object();
    public static Logger log = Global.getLogger(PirateBaseIntel.class);
    protected StarSystemAPI system;
    protected MarketAPI market;
    protected PersonAPI baseCommander;
    protected SectorEntityToken entity;
    protected float elapsedDays = 0.0f;
    protected float duration = 45.0f;
    protected BaseBountyData bountyData = null;
    protected PirateBaseTier tier;
    protected PirateBaseTier matchedStationToTier = null;
    protected IntervalUtil monthlyInterval = new IntervalUtil(20.0f, 40.0f);
    protected int raidTimeoutMonths = 0;
    protected CampaignFleetAPI addedListenerTo = null;
    protected PersonBountyIntel.BountyResult result = null;
    protected boolean sentBountyUpdate = false;
    protected int monthsWithSameTarget = 0;
    protected int monthsAtCurrentTier = 0;
    protected StarSystemAPI target = null;
    protected boolean targetPlayerColoniesOnly = false;
    protected StarSystemAPI forceTarget = null;

    public static PirateBaseIntel getIntelFor(StarSystemAPI system) {
        for (IntelInfoPlugin intel : Global.getSector().getIntelManager().getIntel(PirateBaseIntel.class)) {
            if (((PirateBaseIntel)intel).getSystem() != system) continue;
            return (PirateBaseIntel)intel;
        }
        return null;
    }

    public static PirateBaseIntel getIntelFor(SectorEntityToken station) {
        for (IntelInfoPlugin intel : Global.getSector().getIntelManager().getIntel(PirateBaseIntel.class)) {
            if (((PirateBaseIntel)intel).getEntity() != station) continue;
            return (PirateBaseIntel)intel;
        }
        return null;
    }

    public static PirateBaseIntel getIntelFor(MarketAPI market) {
        for (IntelInfoPlugin p : Global.getSector().getIntelManager().getIntel(PirateBaseIntel.class)) {
            PirateBaseIntel intel = (PirateBaseIntel)p;
            if (intel.getMarket() != market) continue;
            return intel;
        }
        return null;
    }

    public boolean playerHasDealWithBaseCommander() {
        return this.baseCommander != null && this.baseCommander.getMemoryWithoutUpdate().getBoolean(HAS_DEAL_WITH_BASE_COMMANDER);
    }

    public void setPlayerHasDealWithBaseCommander(boolean hasDeal) {
        if (this.baseCommander == null) {
            return;
        }
        this.baseCommander.getMemoryWithoutUpdate().set(HAS_DEAL_WITH_BASE_COMMANDER, hasDeal);
    }

    public PirateBaseIntel(StarSystemAPI system, String factionId, PirateBaseTier tier) {
        this.system = system;
        this.tier = tier;
        this.raidTimeoutMonths = Tuning.PIRATE_RAID_MIN_TIMEOUT_MONTHS + Misc.random.nextInt(Tuning.PIRATE_RAID_MAX_TIMEOUT_MONTHS - Tuning.PIRATE_RAID_MIN_TIMEOUT_MONTHS + 1);
        this.market = Global.getFactory().createMarket(Misc.genUID(), "\u6d77\u76d7\u57fa\u5730", 3);
        this.market.setSize(3);
        this.market.setHidden(true);
        this.market.getMemoryWithoutUpdate().set(MEM_FLAG, true);
        this.market.getMemoryWithoutUpdate().set(MemFlags.HIDDEN_BASE_MEM_FLAG, true);
        this.market.setFactionId("pirates");
        this.market.setSurveyLevel(MarketAPI.SurveyLevel.FULL);
        this.market.setFactionId(factionId);
        this.market.addCondition("population_3");
        this.market.addIndustry("population");
        this.market.addIndustry("spaceport");
        this.market.addIndustry("militarybase");
        this.market.addSubmarket("open_market");
        this.market.addSubmarket("black_market");
        this.market.getTariff().modifyFlat("default_tariff", this.market.getFaction().getTariffFraction());
        LinkedHashMap<BaseThemeGenerator.LocationType, Float> weights = new LinkedHashMap<BaseThemeGenerator.LocationType, Float>();
        weights.put(BaseThemeGenerator.LocationType.IN_ASTEROID_BELT, Float.valueOf(10.0f));
        weights.put(BaseThemeGenerator.LocationType.IN_ASTEROID_FIELD, Float.valueOf(10.0f));
        weights.put(BaseThemeGenerator.LocationType.IN_RING, Float.valueOf(10.0f));
        weights.put(BaseThemeGenerator.LocationType.IN_SMALL_NEBULA, Float.valueOf(10.0f));
        weights.put(BaseThemeGenerator.LocationType.GAS_GIANT_ORBIT, Float.valueOf(10.0f));
        weights.put(BaseThemeGenerator.LocationType.PLANET_ORBIT, Float.valueOf(10.0f));
        WeightedRandomPicker<BaseThemeGenerator.EntityLocation> locs = BaseThemeGenerator.getLocations(null, system, null, 100.0f, weights);
        BaseThemeGenerator.EntityLocation loc = locs.pick();
        if (loc == null) {
            this.endImmediately();
            return;
        }
        BaseThemeGenerator.AddedEntity added = BaseThemeGenerator.addNonSalvageEntity(system, loc, "makeshift_station", factionId);
        if (added == null || added.entity == null) {
            this.endImmediately();
            return;
        }
        this.entity = added.entity;
        String name = this.generateName();
        if (name == null) {
            this.endImmediately();
            return;
        }
        this.market.setName(name);
        this.entity.setName(name);
        BaseThemeGenerator.convertOrbitWithSpin(this.entity, -5.0f);
        this.market.setPrimaryEntity(this.entity);
        this.entity.setMarket(this.market);
        this.entity.setSensorProfile(Float.valueOf(1.0f));
        this.entity.setDiscoverable(true);
        this.entity.getDetectedRangeMod().modifyFlat("gen", 5000.0f);
        this.market.setEconGroup(this.market.getId());
        this.market.getMemoryWithoutUpdate().set("$core_noDeciv", true);
        this.market.reapplyIndustries();
        Global.getSector().getEconomy().addMarket(this.market, true);
        this.baseCommander = this.market.getFaction().createRandomPerson(Misc.random);
        this.baseCommander.setRankId(Ranks.SPACE_CAPTAIN);
        this.baseCommander.setPostId(Ranks.POST_STATION_COMMANDER);
        this.baseCommander.setImportanceAndVoice(PersonImportance.HIGH, Misc.random);
        this.baseCommander.addTag("underworld");
        this.baseCommander.getMemoryWithoutUpdate().set(PIRATE_BASE_COMMANDER, true);
        this.market.getCommDirectory().addPerson(this.baseCommander);
        log.info((Object)String.format("Added pirate base in [%s], tier: %s", system.getName(), tier.name()));
        Global.getSector().getIntelManager().addIntel(this, true);
        this.timestamp = null;
        Global.getSector().getListenerManager().addListener(this);
        Global.getSector().getEconomy().addUpdateListener(this);
        this.updateTarget();
        PortsideBarData.getInstance().addEvent(new PirateBaseRumorBarEvent(this));
    }

    @Override
    public boolean isHidden() {
        if (super.isHidden()) {
            return true;
        }
        return this.timestamp == null;
    }

    public float getRaidFP() {
        float base = this.getBaseRaidFP();
        return base * (0.75f + (float)Math.random() * 0.5f);
    }

    public float getBaseRaidFP() {
        float base = 100.0f;
        switch (this.tier) {
            case TIER_1_1MODULE: {
                base = 100.0f;
                break;
            }
            case TIER_2_1MODULE: {
                base = 150.0f;
                break;
            }
            case TIER_3_2MODULE: {
                base = 250.0f;
                break;
            }
            case TIER_4_3MODULE: {
                base = 300.0f;
                break;
            }
            case TIER_5_3MODULE: {
                base = 450.0f;
            }
        }
        return base * (0.75f + (float)Math.random() * 0.5f);
    }

    @Override
    public void notifyRaidEnded(RaidIntel raid, RaidIntel.RaidStageStatus status) {
        if (status == RaidIntel.RaidStageStatus.SUCCESS) {
            this.raidTimeoutMonths = Math.max(this.raidTimeoutMonths, Tuning.PIRATE_RAID_MIN_TIMEOUT_MONTHS + Misc.random.nextInt(Tuning.PIRATE_RAID_MAX_TIMEOUT_MONTHS - Tuning.PIRATE_RAID_MIN_TIMEOUT_MONTHS + 1));
        } else {
            float base = this.getBaseRaidFP();
            float raidFP = raid.getAssembleStage().getOrigSpawnFP();
            this.raidTimeoutMonths += Math.min(Math.round(raidFP / base) * 2, Tuning.PIRATE_RAID_DEFEATED_TIMEOUT_MONTHS);
        }
    }

    public void startRaid(StarSystemAPI target, float raidFP) {
        if (target != null && !Misc.getMarketsInLocation(target, "player").isEmpty()) {
            return;
        }
        boolean hasTargets = false;
        for (MarketAPI curr : Misc.getMarketsInLocation(target)) {
            if (!curr.getFaction().isHostileTo(this.getFactionForUIColors())) continue;
            hasTargets = true;
            break;
        }
        if (!hasTargets) {
            return;
        }
        RaidIntel raid = new RaidIntel(target, this.getFactionForUIColors(), this);
        float successMult = 0.5f;
        JumpPointAPI gather = null;
        List points = this.system.getEntities(JumpPointAPI.class);
        float min = Float.MAX_VALUE;
        for (JumpPointAPI curr : points) {
            float dist = Misc.getDistance(this.entity.getLocation(), curr.getLocation());
            if (!(dist < min)) continue;
            min = dist;
            gather = curr;
        }
        JumpPointAPI raidJump = RouteLocationCalculator.findJumpPointToUse(this.getFactionForUIColors(), target.getCenter());
        if (gather == null || raidJump == null) {
            return;
        }
        PirateRaidAssembleStage assemble = new PirateRaidAssembleStage(raid, gather, this);
        assemble.addSource(this.market);
        assemble.setSpawnFP(raidFP);
        assemble.setAbortFP(raidFP * successMult);
        raid.addStage(assemble);
        TravelStage travel = new TravelStage(raid, gather, raidJump, false);
        travel.setAbortFP(raidFP * successMult);
        raid.addStage(travel);
        PirateRaidActionStage action = new PirateRaidActionStage(raid, target);
        action.setAbortFP(raidFP * successMult);
        raid.addStage(action);
        raid.addStage(new ReturnStage(raid));
        boolean shouldNotify = raid.shouldSendUpdate();
        Global.getSector().getIntelManager().addIntel(raid, !shouldNotify);
    }

    public StarSystemAPI getSystem() {
        return this.system;
    }

    protected String pickStationType() {
        WeightedRandomPicker<String> stations = new WeightedRandomPicker<String>();
        if (this.getFactionForUIColors().getCustom().has("pirateBaseStationTypes")) {
            try {
                JSONObject json = this.getFactionForUIColors().getCustom().getJSONObject("pirateBaseStationTypes");
                String[] stringArray = JSONObject.getNames((JSONObject)json);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    stations.add(key, (float)json.optDouble(key, 0.0));
                    ++n2;
                }
            }
            catch (JSONException e) {
                stations.clear();
            }
        }
        if (stations.isEmpty()) {
            stations.add("orbitalstation", 5.0f);
            stations.add("orbitalstation_mid", 3.0f);
            stations.add("orbitalstation_high", 1.0f);
        }
        return (String)stations.pick();
    }

    protected Industry getStationIndustry() {
        for (Industry curr : this.market.getIndustries()) {
            if (!curr.getSpec().hasTag("station")) continue;
            return curr;
        }
        return null;
    }

    protected void updateStationIfNeeded() {
        if (this.matchedStationToTier == this.tier) {
            return;
        }
        this.matchedStationToTier = this.tier;
        this.monthsAtCurrentTier = 0;
        Industry stationInd = this.getStationIndustry();
        String currIndId = null;
        if (stationInd != null) {
            currIndId = stationInd.getId();
            this.market.removeIndustry(stationInd.getId(), null, false);
            stationInd = null;
        }
        if (currIndId == null) {
            currIndId = this.pickStationType();
        }
        if (currIndId == null) {
            return;
        }
        this.market.addIndustry(currIndId);
        stationInd = this.getStationIndustry();
        if (stationInd == null) {
            return;
        }
        stationInd.finishBuildingOrUpgrading();
        CampaignFleetAPI fleet = Misc.getStationFleet(this.entity);
        if (fleet == null) {
            return;
        }
        List<FleetMemberAPI> members = fleet.getFleetData().getMembersListCopy();
        if (members.size() < 1) {
            return;
        }
        fleet.inflateIfNeeded();
        FleetMemberAPI station = members.get(0);
        WeightedRandomPicker<Integer> picker = new WeightedRandomPicker<Integer>();
        int index = 1;
        for (String slotId : station.getVariant().getModuleSlots()) {
            ShipVariantAPI mv = station.getVariant().getModuleVariant(slotId);
            if (Misc.isActiveModule(mv)) {
                picker.add(index, 1.0f);
            }
            ++index;
        }
        float removeMult = 0.0f;
        switch (this.tier) {
            case TIER_1_1MODULE: 
            case TIER_2_1MODULE: {
                removeMult = 0.67f;
                break;
            }
            case TIER_3_2MODULE: {
                removeMult = 0.33f;
                break;
            }
            case TIER_4_3MODULE: 
            case TIER_5_3MODULE: {
                removeMult = 0.0f;
            }
        }
        int remove = Math.round((float)picker.getItems().size() * removeMult);
        if (remove < 1 && removeMult > 0.0f) {
            remove = 1;
        }
        if (remove >= picker.getItems().size() - 1) {
            remove = picker.getItems().size() - 2;
        }
        int i = 0;
        while (i < remove) {
            Integer pick = (Integer)picker.pickAndRemove();
            if (pick != null) {
                station.getStatus().setHullFraction(pick, 0.0f);
                station.getStatus().setDetached(pick, true);
                station.getStatus().setPermaDetached(pick, true);
            }
            ++i;
        }
        if (this.tier == PirateBaseTier.TIER_5_3MODULE || this.tier == PirateBaseTier.TIER_4_3MODULE) {
            this.baseCommander.setImportance(PersonImportance.VERY_HIGH);
        } else {
            this.baseCommander.setImportance(PersonImportance.HIGH);
        }
    }

    public CampaignFleetAPI getAddedListenerTo() {
        return this.addedListenerTo;
    }

    @Override
    protected void advanceImpl(float amount) {
        CampaignFleetAPI fleet;
        float days = Global.getSector().getClock().convertToDays(amount);
        if (this.getPlayerVisibleTimestamp() == null && this.entity.isInCurrentLocation() && this.isHidden()) {
            this.makeKnown();
            this.sendUpdateIfPlayerHasIntel(DISCOVERED_PARAM, false);
        }
        if (!this.sentBountyUpdate && this.bountyData != null && (Global.getSector().getIntelManager().isPlayerInRangeOfCommRelay() || !this.isHidden() && DebugFlags.SEND_UPDATES_WHEN_NO_COMM)) {
            this.makeKnown();
            this.sendUpdateIfPlayerHasIntel((Object)this.bountyData, false);
            this.sentBountyUpdate = true;
        }
        if ((fleet = Misc.getStationFleet(this.market)) != null && this.addedListenerTo != fleet) {
            if (this.addedListenerTo != null) {
                this.addedListenerTo.removeEventListener(this);
            }
            fleet.addEventListener(this);
            this.addedListenerTo = fleet;
        }
        if (this.target != null && this.getAffectedMarkets(this.target).isEmpty()) {
            this.clearTarget();
        }
        if (DebugFlags.RAID_DEBUG) {
            days *= 100.0f;
        }
        this.monthlyInterval.advance(days);
        if (this.monthlyInterval.intervalElapsed()) {
            boolean allowRandomRaids;
            ++this.monthsWithSameTarget;
            --this.raidTimeoutMonths;
            if (this.raidTimeoutMonths < 0) {
                this.raidTimeoutMonths = 0;
            }
            if (this.monthsWithSameTarget > 6 && (float)Math.random() < 0.2f || this.target == null) {
                this.updateTarget();
            }
            if (this.target != null && (float)Math.random() < (float)this.monthsWithSameTarget * 0.05f && this.bountyData == null) {
                this.setBounty();
            }
            boolean bl = allowRandomRaids = PirateBaseManager.getInstance().getDaysSinceStart() > Tuning.NO_PIRATE_RAID_DAYS_FROM_GAME_START;
            if (this.target != null && ((float)Math.random() < 0.2f && allowRandomRaids || this.targetPlayerColoniesOnly) && this.raidTimeoutMonths <= 0) {
                this.startRaid(this.target, this.getRaidFP());
                this.raidTimeoutMonths = Tuning.PIRATE_RAID_MIN_TIMEOUT_MONTHS + Misc.random.nextInt(Tuning.PIRATE_RAID_MAX_TIMEOUT_MONTHS - Tuning.PIRATE_RAID_MIN_TIMEOUT_MONTHS + 1);
            }
            this.checkForTierChange();
        }
        if (this.bountyData != null) {
            boolean canEndBounty = !this.entity.isInCurrentLocation();
            this.bountyData.bountyElapsedDays += days;
            if (this.bountyData.bountyElapsedDays > this.bountyData.bountyDuration && canEndBounty) {
                this.endBounty();
            }
        }
        this.updateStationIfNeeded();
    }

    protected void checkForTierChange() {
        if (this.bountyData != null) {
            return;
        }
        if (this.entity.isInCurrentLocation()) {
            return;
        }
        float minMonths = Global.getSettings().getFloat("pirateBaseMinMonthsForNextTier");
        if ((float)this.monthsAtCurrentTier > minMonths) {
            PirateBaseTier next;
            float prob = ((float)this.monthsAtCurrentTier - minMonths) * 0.1f;
            if ((float)Math.random() < prob && (next = this.getNextTier(this.tier)) != null) {
                this.tier = next;
                this.updateStationIfNeeded();
                this.monthsAtCurrentTier = 0;
                return;
            }
        }
        ++this.monthsAtCurrentTier;
    }

    protected PirateBaseTier getNextTier(PirateBaseTier tier) {
        switch (tier) {
            case TIER_1_1MODULE: {
                return PirateBaseTier.TIER_2_1MODULE;
            }
            case TIER_2_1MODULE: {
                return PirateBaseTier.TIER_3_2MODULE;
            }
            case TIER_3_2MODULE: {
                return PirateBaseTier.TIER_4_3MODULE;
            }
            case TIER_4_3MODULE: {
                return PirateBaseTier.TIER_5_3MODULE;
            }
            case TIER_5_3MODULE: {
                return null;
            }
        }
        return null;
    }

    protected PirateBaseTier getPrevTier(PirateBaseTier tier) {
        switch (tier) {
            case TIER_1_1MODULE: {
                return null;
            }
            case TIER_2_1MODULE: {
                return PirateBaseTier.TIER_1_1MODULE;
            }
            case TIER_3_2MODULE: {
                return PirateBaseTier.TIER_2_1MODULE;
            }
            case TIER_4_3MODULE: {
                return PirateBaseTier.TIER_3_2MODULE;
            }
            case TIER_5_3MODULE: {
                return PirateBaseTier.TIER_4_3MODULE;
            }
        }
        return null;
    }

    public void makeKnown() {
        this.makeKnown(null);
    }

    public void makeKnown(TextPanelAPI text) {
        if (this.getPlayerVisibleTimestamp() == null) {
            Global.getSector().getIntelManager().removeIntel(this);
            Global.getSector().getIntelManager().addIntel(this, text == null, text);
        }
    }

    @Override
    public float getTimeRemainingFraction() {
        float f = 1.0f - this.elapsedDays / this.duration;
        return f;
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
        log.info((Object)String.format("Removing pirate base at [%s]", this.system.getName()));
        Global.getSector().getListenerManager().removeListener(this);
        this.clearTarget();
        Global.getSector().getEconomy().removeMarket(this.market);
        Global.getSector().getEconomy().removeUpdateListener(this);
        Misc.removeRadioChatter(this.market);
        this.market.advance(0.0f);
    }

    @Override
    protected void notifyEnded() {
        super.notifyEnded();
    }

    @Override
    public void reportFleetDespawnedToListener(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
        if (this.isEnding()) {
            return;
        }
        if (this.addedListenerTo != null && fleet == this.addedListenerTo) {
            BattleAPI battle;
            Misc.fadeAndExpire(this.entity);
            this.endAfterDelay();
            this.result = new PersonBountyIntel.BountyResult(PersonBountyIntel.BountyResultType.END_OTHER, 0, null);
            if (reason == CampaignEventListener.FleetDespawnReason.DESTROYED_BY_BATTLE && param instanceof BattleAPI && (battle = (BattleAPI)param).isPlayerInvolved()) {
                int payment = 0;
                if (this.bountyData != null) {
                    payment = (int)(this.bountyData.baseBounty * battle.getPlayerInvolvementFraction());
                }
                if (payment > 0) {
                    Global.getSector().getPlayerFleet().getCargo().getCredits().add(payment);
                    CoreReputationPlugin.CustomRepImpact impact = new CoreReputationPlugin.CustomRepImpact();
                    impact.delta = this.bountyData.repChange * battle.getPlayerInvolvementFraction();
                    if (impact.delta < 0.01f) {
                        impact.delta = 0.01f;
                    }
                    ReputationActionResponsePlugin.ReputationAdjustmentResult rep = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, null, null, false, true), this.bountyData.bountyFaction.getId());
                    this.result = new PersonBountyIntel.BountyResult(PersonBountyIntel.BountyResultType.END_PLAYER_BOUNTY, payment, rep);
                } else {
                    this.result = new PersonBountyIntel.BountyResult(PersonBountyIntel.BountyResultType.END_PLAYER_NO_REWARD, 0, null);
                }
            }
            boolean sendUpdate = DebugFlags.SEND_UPDATES_WHEN_NO_COMM || this.result.type != PersonBountyIntel.BountyResultType.END_OTHER || Global.getSector().getIntelManager().isPlayerInRangeOfCommRelay();
            sendUpdate = true;
            if (sendUpdate) {
                this.sendUpdateIfPlayerHasIntel((Object)this.result, false);
            }
            PirateBaseManager.getInstance().incrDestroyed();
            PirateBaseManager.markRecentlyUsedForBase(this.system);
        }
    }

    @Override
    public void reportBattleOccurred(CampaignFleetAPI fleet, CampaignFleetAPI primaryWinner, BattleAPI battle) {
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        boolean isUpdate;
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        boolean bl = isUpdate = this.getListInfoParam() != null;
        if (this.getListInfoParam() == DEAL_BROKEN_PARAM) {
            info.addPara("\u534f\u8bae\u7834\u88c2", initPad, tc, Misc.getNegativeHighlightColor(), "\u534f\u8bae\u7834\u88c2");
            initPad = 0.0f;
        } else if (this.getListInfoParam() == DEAL_CANCELLED_PARAM) {
            info.addPara("\u534f\u8bae\u89e3\u9664", tc, initPad);
            initPad = 0.0f;
        } else if ((mode == IntelInfoPlugin.ListInfoMode.INTEL || this.getListInfoParam() == DEAL_MADE_PARAM) && this.playerHasDealWithBaseCommander()) {
            info.addPara("\u4e0e\u57fa\u5730\u6307\u6325\u5b98\u8fbe\u6210\u534f\u8bae", initPad, tc, Misc.getPositiveHighlightColor(), "\u534f\u8bae");
            initPad = 0.0f;
        }
        if (this.bountyData != null && this.result == null && this.getListInfoParam() != BOUNTY_EXPIRED_PARAM) {
            if (isUpdate || mode != IntelInfoPlugin.ListInfoMode.IN_DESC) {
                FactionAPI faction = this.bountyData.bountyFaction;
                info.addPara("\u53d1\u5e03\u65b9\uff1a{" + faction.getDisplayName(), initPad, tc, faction.getBaseUIColor(), faction.getDisplayName());
                initPad = 0.0f;
            }
            info.addPara("%s \u5956\u52b1", initPad, tc, h, Misc.getDGSCredits(this.bountyData.baseBounty));
            this.addDays(info, "\u671f\u9650", this.bountyData.bountyDuration - this.bountyData.bountyElapsedDays, tc);
        }
        if (this.result != null && this.bountyData != null) {
            switch (this.result.type) {
                case END_PLAYER_BOUNTY: {
                    info.addPara("%s \u5df2\u6536\u5230", initPad, tc, h, Misc.getDGSCredits(this.result.payment));
                    CoreReputationPlugin.addAdjustmentMessage(this.result.rep.delta, this.bountyData.bountyFaction, null, null, null, info, tc, isUpdate, 0.0f);
                    break;
                }
                case END_TIME: {
                    break;
                }
            }
        }
        this.unindent(info);
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color c = this.getTitleColor(mode);
        info.addPara(this.getName(), c, 0.0f);
        this.addBulletPoints(info, mode);
    }

    @Override
    public String getSortString() {
        String base = Misc.ucFirst(this.getFactionForUIColors().getPersonNamePrefix());
        return String.valueOf(base) + " \u57fa\u5730";
    }

    @Override
    public String getName() {
        String base = Misc.ucFirst(this.getFactionForUIColors().getPersonNamePrefix());
        if (this.getListInfoParam() == this.bountyData && this.bountyData != null) {
            return String.valueOf(base) + " \u57fa\u5730 - \u8d4f\u91d1\u53d1\u5e03";
        }
        if (this.getListInfoParam() == BOUNTY_EXPIRED_PARAM) {
            return String.valueOf(base) + " \u57fa\u5730 - \u8d4f\u91d1\u8fc7\u671f";
        }
        if (this.result != null) {
            if (this.result.type == PersonBountyIntel.BountyResultType.END_PLAYER_BOUNTY) {
                return String.valueOf(base) + " \u57fa\u5730 - \u8d4f\u91d1\u5b8c\u6210";
            }
            if (this.result.type == PersonBountyIntel.BountyResultType.END_PLAYER_NO_REWARD) {
                return String.valueOf(base) + " \u57fa\u5730 - \u5df2\u6467\u6bc1";
            }
        }
        String name = this.market.getName();
        if (this.isEnding()) {
            return String.valueOf(base) + " \u57fa\u5730 - \u4efb\u52a1\u653e\u5f03";
        }
        if (this.getListInfoParam() == DISCOVERED_PARAM) {
            return String.valueOf(base) + " \u57fa\u5730 - \u5df2\u53d1\u73b0";
        }
        if (this.entity.isDiscoverable()) {
            return String.valueOf(base) + " \u57fa\u5730 - \u786e\u5207\u4fe1\u606f\u4e0d\u8be6";
        }
        return String.valueOf(base) + " \u57fa\u5730 - " + name;
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return this.market.getFaction();
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        FactionAPI faction = this.market.getFaction();
        info.addImage(faction.getLogo(), width, 128.0f, opad);
        String has = faction.getDisplayNameHasOrHave();
        info.addPara(String.valueOf(Misc.ucFirst(faction.getDisplayNameWithArticle())) + " " + has + "\u5728 " + this.market.getContainingLocation().getNameWithLowercaseType() + "\u3002" + "\u5efa\u7acb\u4e86\u7528\u4ee5 \u88ad\u51fb\u9644\u8fd1 \u6b96\u6c11\u5730\u7684\u57fa\u5730\u3002", opad, faction.getBaseUIColor(), faction.getDisplayNameWithArticleWithoutArticle());
        if (!this.entity.isDiscoverable()) {
            switch (this.tier) {
                case TIER_1_1MODULE: {
                    info.addPara("\u5b83\u4e0d\u4ec5\u9632\u5fa1\u80fd\u529b\u6709\u9650\uff0c\u4e14\u4ec5\u53d7\u5230\u6781\u5c11\u91cf\u8230\u961f\u7684\u4fdd\u62a4\u3002", opad);
                    break;
                }
                case TIER_2_1MODULE: {
                    info.addPara("\u5b83\u4e0d\u4ec5\u9632\u5fa1\u80fd\u529b\u6709\u9650\uff0c\u4e14\u4ec5\u53d7\u5230\u5c11\u91cf\u8230\u961f\u7684\u4fdd\u62a4\u3002", opad);
                    break;
                }
                case TIER_3_2MODULE: {
                    info.addPara("\u5b83\u4e0d\u4ec5\u62e5\u6709\u5f3a\u5927\u7684\u9632\u5fa1\u80fd\u529b\uff0c\u8fd8\u53d7\u5230\u5927\u91cf\u8230\u961f\u7684\u4fdd\u62a4\u3002", opad);
                    break;
                }
                case TIER_4_3MODULE: {
                    info.addPara("\u5b83\u4e0d\u4ec5\u62e5\u6709\u975e\u5e38\u5f3a\u7684\u9632\u5fa1\u80fd\u529b\uff0c\u8fd8\u53d7\u5230\u5927\u91cf\u8230\u961f\u7684\u4fdd\u62a4\u3002", opad);
                    break;
                }
                case TIER_5_3MODULE: {
                    info.addPara("\u5b83\u5177\u5907\u6781\u9ad8\u6c34\u5e73\u7684\u9632\u5fa1\u80fd\u529b\uff0c\u53d7\u5230\u5927\u91cf\u8230\u961f\u7684\u4fdd\u62a4\u3002\u4ee5\u6d77\u76d7\u7684\u6807\u51c6\u6765\u770b\uff0c\u57fa\u5730\u548c\u8230\u961f\u7684\u88c5\u5907\u90fd\u5c5e\u4e8e\u7cbe\u82f1\u7ea7\u522b\u3002", opad);
                }
            }
        } else {
            info.addPara("\u4f60\u76ee\u524d\u5c1a\u4e0d\u6e05\u695a\u8fd9\u5904\u57fa\u5730\u7684\u786e\u5207\u4f4d\u7f6e\u4e0e\u9632\u5fa1\u6218\u529b\u3002", opad);
        }
        boolean deal = this.playerHasDealWithBaseCommander();
        if (deal) {
            float feeFraction = Global.getSettings().getFloat("pirateProtectionPaymentFraction");
            String fee = Misc.getDGSCredits(HA_CMD.computePirateProtectionPaymentPerMonth(this));
            LabelAPI label = info.addPara("\u4f60\u8ddf\u57fa\u5730\u6307\u6325\u5b98\u6709\u4e2a %s}\u3002\u8fd9\u4e2a\u57fa\u5730\u7684\u8230\u961f\u539f\u5219\u4e0a\u4e0d\u4f1a\u9a9a\u6270\u4f60\u7684\u6b96\u6c11\u5730\u548c\u8239\u8fd0\u3002\u4f60\u9700\u8981\u4ea4\u7684\u4fdd\u62a4\u8d39\u7b49\u540c\u4e8e\u6240\u6709\u53d7\u5f71\u54cd\u6b96\u6c11\u5730\u603b\u6536\u5165\u7684 %s}\u3002\u5728\u5f53\u524d\u6536\u5165\u4e0b\uff0c\u8fd9\u7b49\u4e8e\u6bcf\u6708 %s}\u3002", opad, Misc.getPositiveHighlightColor(), "agreement", Math.round(feeFraction * 100.0f) + "%", fee);
            label.setHighlightColors(Misc.getPositiveHighlightColor(), h, h);
            label.setHighlight("agreement", Math.round(feeFraction * 100.0f) + "%", fee);
        }
        info.addSectionHeading("\u8fd1\u671f\u4e8b\u4ef6", faction.getBaseUIColor(), faction.getDarkUIColor(), Alignment.MID, opad);
        if (this.target != null && !this.getAffectedMarkets(this.target).isEmpty() && !this.isEnding()) {
            info.addPara("\u8be5\u57fa\u5730\u7684\u6d77\u76d7\u4eec\u76ee\u524d\u6b63\u5728\u5411 " + this.target.getNameWithLowercaseType() + " \u53d1\u52a8\u88ad\u51fb\u3002", opad);
        }
        if (this.bountyData != null) {
            info.addPara(String.valueOf(Misc.ucFirst(this.bountyData.bountyFaction.getDisplayNameWithArticle())) + " " + this.bountyData.bountyFaction.getDisplayNameHasOrHave() + "\u53d1\u5e03\u4e86\u6467\u6bc1\u8be5\u57fa\u5730\u7684\u8d4f\u91d1\u3002", opad, this.bountyData.bountyFaction.getBaseUIColor(), this.bountyData.bountyFaction.getDisplayNameWithArticleWithoutArticle());
            if (this.result != null && this.result.type == PersonBountyIntel.BountyResultType.END_PLAYER_BOUNTY) {
                info.addPara("\u4f60\u5df2\u7ecf\u6210\u529f\u5b8c\u6210\u4e86\u8fd9\u7b14\u8d4f\u91d1\u3002", opad);
            }
            this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
        }
        if (this.result != null) {
            if (this.result.type == PersonBountyIntel.BountyResultType.END_PLAYER_NO_REWARD) {
                info.addPara("\u4f60\u6467\u6bc1\u4e86\u8fd9\u5904\u57fa\u5730\u3002", opad);
            } else if (this.result.type == PersonBountyIntel.BountyResultType.END_OTHER) {
                info.addPara("\u6709\u4f20\u8a00\u79f0\u8fd9\u5904\u57fa\u5730\u5df2\u7ecf\u505c\u6b62\u8fd0\u4f5c\u4e86\u3002", opad);
            }
        }
    }

    @Override
    public String getIcon() {
        return Global.getSettings().getSpriteName("intel", "pirate_base");
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        if (this.bountyData != null) {
            tags.add("Bounties");
        }
        tags.add("Exploration");
        if (this.target != null && !Misc.getMarketsInLocation(this.target, "player").isEmpty()) {
            tags.add("Colony threats");
        }
        if (!PirateBasePirateActivityCause2.getColoniesAffectedBy(this).isEmpty()) {
            tags.add("Colony threats");
        }
        tags.add(this.market.getFactionId());
        if (this.bountyData != null) {
            tags.add(this.bountyData.bountyFaction.getId());
        }
        return tags;
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        if (this.market.getPrimaryEntity().isDiscoverable()) {
            return this.system.getCenter();
        }
        return this.market.getPrimaryEntity();
    }

    protected String generateName() {
        MarkovNames.loadIfNeeded();
        MarkovNames.MarkovNameResult gen = null;
        int i = 0;
        while (i < 10) {
            String test;
            gen = MarkovNames.generate(null);
            if (gen != null && !(test = gen.name).toLowerCase().startsWith("the ")) {
                String p = this.pickPostfix();
                if (p != null && !p.isEmpty()) {
                    test = String.valueOf(test) + " " + p;
                }
                if (test.length() <= 22) {
                    return test;
                }
            }
            ++i;
        }
        return null;
    }

    protected String pickPostfix() {
        WeightedRandomPicker<String> post = new WeightedRandomPicker<String>();
        post.add("\u5e87\u62a4\u6240");
        post.add("\u7a7a\u95f4\u7ad9");
        post.add("\u8fb9\u9632\u7ad9");
        post.add("\u636e\u70b9");
        post.add("\u8425\u5730");
        post.add("\u7a9d\u85cf\u70b9");
        post.add("\u907f\u96be\u5904");
        post.add("\u7a9d\u70b9");
        post.add("\u8981\u585e");
        post.add("\u8865\u7ed9\u7ad9");
        post.add("\u5821\u5792");
        post.add("\u8425\u5730");
        post.add("\u81ea\u7531\u6e2f");
        post.add("\u81ea\u7531\u6e2f");
        post.add("\u8f68\u9053\u7ad9");
        post.add("\u7a9d\u70b9");
        post.add("\u8981\u585e");
        post.add("\u907f\u96be\u6240");
        post.add("\u907f\u98ce\u6e2f");
        post.add("\u603b\u90e8");
        post.add("\u85cf\u8eab\u5904");
        post.add("\u9690\u533f\u5904");
        post.add("\u636e\u70b9");
        post.add("\u8eb2\u85cf\u5904");
        post.add("\u7a9d\u70b9");
        post.add("\u8425\u5730");
        post.add("\u77ff\u573a");
        post.add("\u8054\u7edc\u70b9");
        post.add("\u8f68\u9053\u7ad9");
        post.add("\u6e2f\u53e3");
        post.add("\u636e\u70b9");
        post.add("\u8981\u585e");
        post.add("\u76d1\u72f1");
        post.add("\u5e73\u53f0");
        post.add("\u636e\u70b9");
        post.add("\u907f\u96be\u6240");
        post.add("\u9690\u533f\u5904");
        post.add("\u70bc\u6cb9\u5382");
        post.add("\u9690\u853d\u5904");
        post.add("\u5e87\u62a4\u6240");
        post.add("\u907f\u96be\u6240");
        post.add("\u661f\u9645\u6e2f");
        post.add("\u9020\u8239\u5382");
        post.add("\u907f\u96be\u6240");
        post.add("\u9a7b\u5730");
        post.add("\u8239\u575e");
        post.add("\u4e09\u7ea7\u91c7\u77ff\u7ad9");
        post.add("\u603b\u90e8");
        post.add("\u6e2f\u53e3");
        post.add("\u636e\u70b9");
        post.add("\u76d1\u89c6\u6240");
        post.add("\u7a9d\u70b9");
        return (String)post.pick();
    }

    @Override
    public void commodityUpdated(String commodityId) {
        CommodityOnMarketAPI com = this.market.getCommodityData(commodityId);
        int curr = 0;
        String modId = this.market.getId();
        MutableStat.StatMod mod = com.getAvailableStat().getFlatStatMod(modId);
        if (mod != null) {
            curr = Math.round(mod.value);
        }
        int avWithoutPenalties = Math.round(com.getAvailableStat().getBaseValue());
        for (MutableStat.StatMod m : com.getAvailableStat().getFlatMods().values()) {
            if (m.value < 0.0f) continue;
            avWithoutPenalties += Math.round(m.value);
        }
        int a = com.getAvailable() - curr;
        a = avWithoutPenalties - curr;
        int d = com.getMaxDemand();
        if (d > a) {
            int supply = Math.max(1, d - a);
            com.getAvailableStat().modifyFlat(modId, supply, "\u7531\u52ab\u63a0\u8005\u5e26\u5165");
        }
    }

    @Override
    public void economyUpdated() {
        float fleetSizeBonus = 1.0f;
        float qualityBonus = 0.0f;
        int light = 0;
        int medium = 0;
        int heavy = 0;
        switch (this.tier) {
            case TIER_1_1MODULE: {
                qualityBonus = 0.0f;
                fleetSizeBonus = 0.2f;
                break;
            }
            case TIER_2_1MODULE: {
                qualityBonus = 0.2f;
                fleetSizeBonus = 0.3f;
                light = 2;
                break;
            }
            case TIER_3_2MODULE: {
                qualityBonus = 0.3f;
                fleetSizeBonus = 0.4f;
                light = 2;
                medium = 1;
                break;
            }
            case TIER_4_3MODULE: {
                qualityBonus = 0.4f;
                fleetSizeBonus = 0.5f;
                light = 2;
                medium = 2;
                break;
            }
            case TIER_5_3MODULE: {
                qualityBonus = 0.5f;
                fleetSizeBonus = 0.75f;
                light = 2;
                medium = 2;
                heavy = 2;
            }
        }
        this.market.getStats().getDynamic().getMod("fleet_quality_mod").modifyFlatAlways(this.market.getId(), qualityBonus, "\u53d1\u5c55\u6c34\u5e73");
        this.market.getStats().getDynamic().getMod("combat_fleet_size_mult").modifyFlatAlways(this.market.getId(), fleetSizeBonus, "\u53d1\u5c55\u6c34\u5e73");
        String modId = this.market.getId();
        this.market.getStats().getDynamic().getMod("patrol_num_light_mod").modifyFlat(modId, light);
        this.market.getStats().getDynamic().getMod("patrol_num_medium_mod").modifyFlat(modId, medium);
        this.market.getStats().getDynamic().getMod("patrol_num_heavy_mod").modifyFlat(modId, heavy);
    }

    @Override
    public boolean isEconomyListenerExpired() {
        return this.isEnded();
    }

    public MarketAPI getMarket() {
        return this.market;
    }

    protected void setBounty() {
        this.bountyData = new BaseBountyData();
        float base = 100000.0f;
        switch (this.tier) {
            case TIER_1_1MODULE: {
                base = Global.getSettings().getFloat("pirateBaseBounty1");
                this.bountyData.repChange = 0.02f;
                break;
            }
            case TIER_2_1MODULE: {
                base = Global.getSettings().getFloat("pirateBaseBounty2");
                this.bountyData.repChange = 0.05f;
                break;
            }
            case TIER_3_2MODULE: {
                base = Global.getSettings().getFloat("pirateBaseBounty3");
                this.bountyData.repChange = 0.06f;
                break;
            }
            case TIER_4_3MODULE: {
                base = Global.getSettings().getFloat("pirateBaseBounty4");
                this.bountyData.repChange = 0.07f;
                break;
            }
            case TIER_5_3MODULE: {
                base = Global.getSettings().getFloat("pirateBaseBounty5");
                this.bountyData.repChange = 0.1f;
            }
        }
        this.bountyData.baseBounty = base * (0.9f + (float)Math.random() * 0.2f);
        this.bountyData.baseBounty = (int)(this.bountyData.baseBounty / 10000.0f) * 10000;
        WeightedRandomPicker<FactionAPI> picker = new WeightedRandomPicker<FactionAPI>();
        for (MarketAPI curr : Global.getSector().getEconomy().getMarkets(this.target)) {
            if (curr.getFaction().isPlayerFaction() || curr.getFaction().getCustom().optBoolean("postsNoBounties") || !this.affectsMarket(curr)) continue;
            picker.add(curr.getFaction(), (float)Math.pow(2.0, curr.getSize()));
        }
        FactionAPI faction = (FactionAPI)picker.pick();
        if (faction == null) {
            this.bountyData = null;
            return;
        }
        this.bountyData.bountyFaction = faction;
        this.bountyData.bountyDuration = 180.0f;
        this.bountyData.bountyElapsedDays = 0.0f;
        Misc.makeImportant(this.entity, "baseBounty");
        this.sentBountyUpdate = false;
    }

    protected void endBounty() {
        this.sendUpdateIfPlayerHasIntel(BOUNTY_EXPIRED_PARAM, false);
        this.bountyData = null;
        this.sentBountyUpdate = false;
        Misc.makeUnimportant(this.entity, "baseBounty");
    }

    public void updateTarget() {
        StarSystemAPI newTarget = this.pickTarget();
        if (newTarget == this.target) {
            return;
        }
        this.clearTarget();
        this.target = newTarget;
        this.monthsWithSameTarget = 0;
        if (this.target != null) {
            new PirateActivityIntel(this.target, this);
        }
    }

    public StarSystemAPI getTarget() {
        return this.target;
    }

    protected void clearTarget() {
        if (this.target != null) {
            this.target = null;
            this.monthsWithSameTarget = 0;
        }
    }

    public List<MarketAPI> getAffectedMarkets(StarSystemAPI system) {
        ArrayList<MarketAPI> result = new ArrayList<MarketAPI>();
        for (MarketAPI curr : Global.getSector().getEconomy().getMarkets(system)) {
            if (!this.affectsMarket(curr)) continue;
            result.add(curr);
        }
        return result;
    }

    public boolean affectsMarket(MarketAPI market) {
        if (market.isHidden()) {
            return false;
        }
        if (market.getFaction() == this.market.getFaction()) {
            return false;
        }
        return !market.getFaction().isPlayerFaction() || !this.playerHasDealWithBaseCommander();
    }

    public void setTargetPlayerColoniesOnly(boolean targetPlayerColonies) {
        this.targetPlayerColoniesOnly = targetPlayerColonies;
    }

    public boolean isTargetPlayerColoniesOnly() {
        return this.targetPlayerColoniesOnly;
    }

    public StarSystemAPI getForceTarget() {
        return this.forceTarget;
    }

    public void setForceTarget(StarSystemAPI forceTarget) {
        this.forceTarget = forceTarget;
    }

    protected StarSystemAPI pickTarget() {
        WeightedRandomPicker<StarSystemAPI> picker = new WeightedRandomPicker<StarSystemAPI>();
        boolean forceTargetIsValid = false;
        for (StarSystemAPI system : Global.getSector().getEconomy().getStarSystemsWithMarkets()) {
            float score = 0.0f;
            for (MarketAPI curr : Global.getSector().getEconomy().getMarkets(system)) {
                if (!this.affectsMarket(curr) || this.targetPlayerColoniesOnly && !curr.getFaction().isPlayerFaction()) continue;
                if (system == this.forceTarget) {
                    forceTargetIsValid = true;
                }
                if (curr.hasCondition("pirate_activity")) continue;
                float w = curr.getSize();
                float dist = Misc.getDistanceLY(curr.getLocationInHyperspace(), this.market.getLocationInHyperspace());
                float mult = 1.0f - Math.max(0.0f, dist - 10.0f) / 10.0f;
                if (mult < 0.1f) {
                    mult = 0.1f;
                }
                if (mult > 1.0f) {
                    mult = 1.0f;
                }
                if (!this.targetPlayerColoniesOnly && curr.getFaction().isPlayerFaction() && dist > 15.0f) continue;
                score += w * mult;
            }
            picker.add(system, score);
        }
        if (forceTargetIsValid) {
            return this.forceTarget;
        }
        return (StarSystemAPI)picker.pick();
    }

    @Override
    public List<IntelInfoPlugin.ArrowData> getArrowData(SectorMapAPI map) {
        SectorEntityToken iconEntity;
        if (this.target == null || this.target == this.entity.getContainingLocation()) {
            return null;
        }
        ArrayList<IntelInfoPlugin.ArrowData> result = new ArrayList<IntelInfoPlugin.ArrowData>();
        SectorEntityToken entityFrom = this.entity;
        if (map != null && (iconEntity = map.getIntelIconEntity(this)) != null) {
            entityFrom = iconEntity;
        }
        IntelInfoPlugin.ArrowData arrow = new IntelInfoPlugin.ArrowData(entityFrom, this.target.getCenter());
        arrow.color = this.getFactionForUIColors().getBaseUIColor();
        result.add(arrow);
        return result;
    }

    public float getAccessibilityPenalty() {
        switch (this.tier) {
            case TIER_1_1MODULE: {
                return 0.1f;
            }
            case TIER_2_1MODULE: {
                return 0.2f;
            }
            case TIER_3_2MODULE: {
                return 0.3f;
            }
            case TIER_4_3MODULE: {
                return 0.4f;
            }
            case TIER_5_3MODULE: {
                return 0.5f;
            }
        }
        return 0.0f;
    }

    public float getStabilityPenalty() {
        switch (this.tier) {
            case TIER_1_1MODULE: {
                return 1.0f;
            }
            case TIER_2_1MODULE: {
                return 1.0f;
            }
            case TIER_3_2MODULE: {
                return 2.0f;
            }
            case TIER_4_3MODULE: {
                return 2.0f;
            }
            case TIER_5_3MODULE: {
                return 3.0f;
            }
        }
        return 0.0f;
    }

    public PirateBaseTier getTier() {
        return this.tier;
    }

    public SectorEntityToken getEntity() {
        return this.entity;
    }

    public PersonAPI getBaseCommander() {
        return this.baseCommander;
    }

    public void setBaseCommander(PersonAPI baseCommander) {
        this.baseCommander = baseCommander;
    }

    public static class BaseBountyData {
        public float bountyElapsedDays = 0.0f;
        public float bountyDuration = 0.0f;
        public float baseBounty = 0.0f;
        public float repChange = 0.0f;
        public FactionAPI bountyFaction = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PirateBaseTier {
        TIER_1_1MODULE,
        TIER_2_1MODULE,
        TIER_3_2MODULE,
        TIER_4_3MODULE,
        TIER_5_3MODULE;

    }
}

