/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bases;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseIntel;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseManager;
import com.fs.starfarer.api.impl.campaign.intel.events.PiracyRespiteScript;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;

public class PlayerRelatedPirateBaseManager
implements EveryFrameScript {
    public static final String KEY = "$core_PR_pirateBaseManager";
    public static int MIN_TIMEOUT = Global.getSettings().getIntFromArray("playerRelatedPirateBaseCreationTimeoutMonths", 0);
    public static int MAX_TIMEOUT = Global.getSettings().getIntFromArray("playerRelatedPirateBaseCreationTimeoutMonths", 1);
    public static int MIN_TIMEOUT_DESTROYED = Global.getSettings().getIntFromArray("playerRelatedPirateBaseCreationTimeoutExtraAfterBaseDestroyed", 0);
    public static int MAX_TIMEOUT_DESTROYED = Global.getSettings().getIntFromArray("playerRelatedPirateBaseCreationTimeoutExtraAfterBaseDestroyed", 1);
    protected long start = 0L;
    protected IntervalUtil monthlyInterval = new IntervalUtil(20.0f, 40.0f);
    protected int monthsPlayerColoniesExist = 0;
    protected int baseCreationTimeout = 0;
    protected Random random = new Random();
    protected List<PirateBaseIntel> bases = new ArrayList<PirateBaseIntel>();

    public static PlayerRelatedPirateBaseManager getInstance() {
        Object test = Global.getSector().getMemoryWithoutUpdate().get(KEY);
        return (PlayerRelatedPirateBaseManager)test;
    }

    public PlayerRelatedPirateBaseManager() {
        Global.getSector().getMemoryWithoutUpdate().set(KEY, this);
        this.start = Global.getSector().getClock().getTimestamp();
    }

    public void advance(float amount) {
        for (PirateBaseIntel intel : this.bases) {
            intel.advance(amount);
        }
        float days = Misc.getDays(amount);
        if (DebugFlags.RAID_DEBUG) {
            days *= 100.0f;
        }
        this.monthlyInterval.advance(days);
        if (this.monthlyInterval.intervalElapsed()) {
            this.removeDestroyedBases();
            FactionAPI player = Global.getSector().getPlayerFaction();
            List<MarketAPI> markets = Misc.getFactionMarkets(player);
            Iterator<MarketAPI> iter = markets.iterator();
            while (iter.hasNext()) {
                if (!iter.next().isHidden()) continue;
                iter.remove();
            }
            if (markets.isEmpty()) {
                return;
            }
            ++this.monthsPlayerColoniesExist;
            if (this.baseCreationTimeout > 0) {
                --this.baseCreationTimeout;
            } else if (this.random.nextFloat() > 0.5f && PiracyRespiteScript.get() == null) {
                this.addBasesAsNeeded();
            }
        }
    }

    protected void removeDestroyedBases() {
        Iterator<PirateBaseIntel> iter = this.bases.iterator();
        while (iter.hasNext()) {
            PirateBaseIntel intel = iter.next();
            if (!intel.isEnded() || intel.getMarket().isInEconomy()) continue;
            iter.remove();
            this.baseCreationTimeout += MIN_TIMEOUT_DESTROYED + this.random.nextInt(MAX_TIMEOUT_DESTROYED - MIN_TIMEOUT_DESTROYED + 1);
        }
    }

    protected void addBasesAsNeeded() {
        FactionAPI player = Global.getSector().getPlayerFaction();
        List<MarketAPI> markets = Misc.getFactionMarkets(player);
        LinkedHashSet<StarSystemAPI> systems = new LinkedHashSet<StarSystemAPI>();
        for (MarketAPI curr : markets) {
            StarSystemAPI system = curr.getStarSystem();
            if (system == null) continue;
            systems.add(system);
        }
        if (systems.isEmpty()) {
            return;
        }
        float marketTotal = markets.size();
        int numBases = (int)(marketTotal / 2.0f);
        if (numBases < 1) {
            numBases = 1;
        }
        if (numBases > 2) {
            numBases = 2;
        }
        if (this.bases.size() >= numBases) {
            return;
        }
        StarSystemAPI initialTarget = null;
        float bestWeight = 0.0f;
        block1: for (StarSystemAPI curr : systems) {
            float w = 0.0f;
            for (MarketAPI m : Global.getSector().getEconomy().getMarkets(curr)) {
                if (m.hasCondition("pirate_activity")) continue block1;
                if (!m.getFaction().isPlayerFaction()) continue;
                w += (float)(m.getSize() * m.getSize());
            }
            if (!(w > bestWeight)) continue;
            bestWeight = w;
            initialTarget = curr;
        }
        if (initialTarget == null) {
            return;
        }
        StarSystemAPI target = this.pickSystemForPirateBase(initialTarget);
        if (target == null) {
            return;
        }
        PirateBaseIntel.PirateBaseTier tier = this.pickTier(target);
        String factionId = this.pickPirateFaction();
        if (factionId == null) {
            return;
        }
        PirateBaseIntel intel = new PirateBaseIntel(target, factionId, tier);
        if (intel.isDone()) {
            intel = null;
            return;
        }
        intel.updateTarget();
        this.bases.add(intel);
        this.baseCreationTimeout = MIN_TIMEOUT + this.random.nextInt(MAX_TIMEOUT - MIN_TIMEOUT + 1);
    }

    public String pickPirateFaction() {
        WeightedRandomPicker<String> picker = new WeightedRandomPicker<String>(this.random);
        for (FactionAPI faction : Global.getSector().getAllFactions()) {
            if (!faction.isHostileTo("player") || !faction.getCustomBoolean("makesPirateBases")) continue;
            picker.add(faction.getId(), 1.0f);
        }
        return (String)picker.pick();
    }

    protected PirateBaseIntel.PirateBaseTier pickTier(StarSystemAPI system) {
        float max = 0.0f;
        for (MarketAPI m : Global.getSector().getEconomy().getMarkets(system)) {
            if (!m.getFaction().isPlayerFaction()) continue;
            max = Math.max((float)m.getSize(), max);
        }
        if (max >= 7.0f) {
            return PirateBaseIntel.PirateBaseTier.TIER_5_3MODULE;
        }
        if (max >= 6.0f) {
            return PirateBaseIntel.PirateBaseTier.TIER_4_3MODULE;
        }
        if (max >= 5.0f) {
            return PirateBaseIntel.PirateBaseTier.TIER_3_2MODULE;
        }
        if (max >= 4.0f) {
            return PirateBaseIntel.PirateBaseTier.TIER_2_1MODULE;
        }
        return PirateBaseIntel.PirateBaseTier.TIER_1_1MODULE;
    }

    protected StarSystemAPI pickSystemForPirateBase(StarSystemAPI initialTarget) {
        WeightedRandomPicker<StarSystemAPI> veryFar = new WeightedRandomPicker<StarSystemAPI>(this.random);
        WeightedRandomPicker<StarSystemAPI> far = new WeightedRandomPicker<StarSystemAPI>(this.random);
        WeightedRandomPicker<StarSystemAPI> picker = new WeightedRandomPicker<StarSystemAPI>(this.random);
        for (StarSystemAPI system : Global.getSector().getStarSystems()) {
            float usefulStuff;
            float days;
            if (system.hasPulsar() || (days = Global.getSector().getClock().getElapsedDaysSince(system.getLastPlayerVisitTimestamp())) < 180.0f || system.getCenter().getMemoryWithoutUpdate().contains(PirateBaseManager.RECENTLY_USED_FOR_BASE)) continue;
            float weight = 0.0f;
            if (system.hasTag("theme_misc_skip")) {
                weight = 1.0f;
            } else if (system.hasTag("theme_misc")) {
                weight = 3.0f;
            } else if (system.hasTag("theme_remnant_no_fleets")) {
                weight = 3.0f;
            } else if (system.hasTag("theme_remnant_destroyed")) {
                weight = 3.0f;
            } else if (system.hasTag("theme_ruins")) {
                weight = 5.0f;
            } else if (system.hasTag("theme_core_unpopulated")) {
                weight = 0.0f;
            }
            if (weight <= 0.0f || (usefulStuff = (float)(system.getCustomEntitiesWithTag("objective").size() + system.getCustomEntitiesWithTag("stable_location").size())) <= 0.0f || Misc.getMarketsInLocation(system).size() > 0) continue;
            float dist = Misc.getDistance(initialTarget.getLocation(), system.getLocation());
            float distMult = 100000.0f / dist;
            distMult *= distMult;
            if (dist > 30000.0f) {
                veryFar.add(system, weight * usefulStuff * distMult);
                continue;
            }
            if (dist > 10000.0f) {
                far.add(system, weight * usefulStuff * distMult);
                continue;
            }
            picker.add(system, weight * usefulStuff * distMult);
        }
        if (picker.isEmpty()) {
            picker.addAll(far);
        }
        if (picker.isEmpty()) {
            picker.addAll(veryFar);
        }
        return (StarSystemAPI)picker.pick();
    }

    public boolean isDone() {
        return false;
    }

    public boolean runWhilePaused() {
        return false;
    }
}

