/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.contacts;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.PersonImportance;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StoryPointActionDelegate;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.ids.Sounds;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseMissionHub;
import com.fs.starfarer.api.impl.campaign.rulecmd.SetStoryOption;
import com.fs.starfarer.api.ui.ButtonAPI;
import com.fs.starfarer.api.ui.IntelUIAPI;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.ui.UIComponentAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.Random;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContactIntel
extends BaseIntelPlugin {
    public static String NO_CONTACTS_ON_MARKET = "$core_noContactsOnMarket";
    public static float MAX_NUM_MISSIONS_BONUS = Global.getSettings().getFloat("priorityContactMaxNumMissionsBonus");
    public static float MAX_MISSION_QUALITY_BONUS = Global.getSettings().getFloat("priorityContactMaxMissionQualityBonus");
    public static float DEFAULT_POTENTIAL_CONTACT_PROB = Global.getSettings().getFloat("defaultPotentialContactProbability");
    public static float ADD_PER_FAIL = Global.getSettings().getFloat("potentialContactProbabilityAddPerFail");
    public static float DAYS_AT_PRIORITY_FOR_FULL_EFFECT = 30.0f;
    public static String UPDATE_RELOCATED_CONTACT = "update_relocated_contact";
    public static String UPDATE_LOST_CONTACT = "update_lost_contact";
    public static String BUTTON_DEVELOP = "button_develop";
    public static String BUTTON_SUSPEND = "button_suspend";
    public static String BUTTON_DELETE = "button_delete";
    public static String BUTTON_PRIORITY = "button_priority";
    public static float DURATION = 30.0f;
    public static boolean POTENTIAL_EXPIRES = false;
    protected ContactState state = ContactState.POTENTIAL;
    protected PersonAPI person;
    protected MarketAPI market;
    protected FactionAPI marketFaction;
    protected Boolean wasAddedToCommDirectory = null;
    protected Boolean wasAddedToMarket = null;
    protected boolean hadMissionHub;
    protected boolean marketWasDeciv;
    protected IntervalUtil tracker = new IntervalUtil(0.75f, 1.25f);
    protected int numPriorityInARow = 0;
    public static float TOOLTIP_WIDTH = 400.0f;

    public ContactIntel(PersonAPI person, MarketAPI market) {
        this.person = person;
        this.market = market;
        this.marketFaction = market.getFaction();
        this.marketWasDeciv = market.hasCondition("\u8352\u86ee\u4e4b\u5730");
        if (!Global.getSector().getScripts().contains(this)) {
            Global.getSector().addScript(this);
        }
        this.setImportant(true);
    }

    protected void ensureHasMissionHub() {
        boolean bl = this.hadMissionHub = BaseMissionHub.get(this.person) != null;
        if (BaseMissionHub.get(this.person) == null) {
            BaseMissionHub.set(this.person, new BaseMissionHub(this.person));
        }
    }

    protected void ensureIsInCommDirectory() {
        if (this.market == null) {
            return;
        }
        if (this.market.getCommDirectory() == null) {
            return;
        }
        if (this.market.getCommDirectory().getEntryForPerson(this.person) != null) {
            return;
        }
        this.market.getCommDirectory().addPerson(this.person);
        this.wasAddedToCommDirectory = true;
    }

    @Override
    public void advanceImpl(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        this.tracker.advance(days);
        if (this.tracker.intervalElapsed()) {
            this.doPeriodicCheck();
        }
    }

    @Override
    public void notifyPlayerAboutToOpenIntelScreen() {
        this.doPeriodicCheck();
    }

    protected MarketAPI findMarketToRelocateTo() {
        if (this.market == null) {
            return null;
        }
        if (this.person.getImportance() == PersonImportance.VERY_LOW) {
            return null;
        }
        Random random = new Random(Misc.getSalvageSeed(this.market.getPrimaryEntity()));
        WeightedRandomPicker<MarketAPI> picker = new WeightedRandomPicker<MarketAPI>(random);
        for (MarketAPI curr : Global.getSector().getEconomy().getMarketsInGroup(this.market.getEconGroup())) {
            if (curr == this.market || !curr.getFactionId().equals(this.market.getFactionId()) || curr.hasCondition("\u8352\u86ee\u4e4b\u5730")) continue;
            picker.add(curr, this.market.getSize());
        }
        return (MarketAPI)picker.pick();
    }

    protected void unsetFlags() {
        MemoryAPI memory = this.person.getMemoryWithoutUpdate();
        memory.unset(BaseMissionHub.NUM_BONUS_MISSIONS);
        memory.unset(BaseMissionHub.MISSION_QUALITY_BONUS);
        memory.unset(BaseMissionHub.CONTACT_SUSPENDED);
    }

    public void loseContact(InteractionDialogAPI dialog) {
        this.state = ContactState.LOST_CONTACT;
        if (dialog != null) {
            this.sendUpdate(UPDATE_LOST_CONTACT, dialog.getTextPanel());
        } else {
            this.sendUpdateIfPlayerHasIntel((Object)UPDATE_LOST_CONTACT, false);
        }
        this.endImmediately();
    }

    public void doPeriodicCheck() {
        float bonusQuality;
        if (this.isEnded() || this.isEnding()) {
            return;
        }
        MemoryAPI memory = this.person.getMemoryWithoutUpdate();
        this.unsetFlags();
        if (!(this.state == ContactState.LOST_CONTACT_DECIV || this.state == ContactState.LOST_CONTACT || this.market == null || this.marketWasDeciv || !this.market.hasCondition("\u8352\u86ee\u4e4b\u5730") && this.market.isInEconomy())) {
            MarketAPI other = this.findMarketToRelocateTo();
            if (other == null) {
                this.endAfterDelay();
                this.state = ContactState.LOST_CONTACT_DECIV;
                this.sendUpdateIfPlayerHasIntel((Object)UPDATE_LOST_CONTACT, false);
            } else {
                this.relocateToMarket(other, true);
            }
            return;
        }
        if (this.state == ContactState.LOST_CONTACT) {
            return;
        }
        if (this.state == ContactState.POTENTIAL) {
            return;
        }
        if (this.state == ContactState.SUSPENDED) {
            memory.set(BaseMissionHub.CONTACT_SUSPENDED, true);
            return;
        }
        this.numPriorityInARow = this.state == ContactState.PRIORITY ? ++this.numPriorityInARow : --this.numPriorityInARow;
        if (this.numPriorityInARow < 0) {
            this.numPriorityInARow = 0;
        } else if ((float)this.numPriorityInARow > DAYS_AT_PRIORITY_FOR_FULL_EFFECT) {
            this.numPriorityInARow = (int)DAYS_AT_PRIORITY_FOR_FULL_EFFECT;
        }
        float bonusMissions = this.getPriorityMult() * MAX_NUM_MISSIONS_BONUS;
        if (bonusMissions > 0.0f) {
            memory.set(BaseMissionHub.NUM_BONUS_MISSIONS, Float.valueOf(bonusMissions));
        }
        if ((bonusQuality = this.getPriorityMult() * MAX_MISSION_QUALITY_BONUS) > 0.0f) {
            memory.set(BaseMissionHub.MISSION_QUALITY_BONUS, Float.valueOf(bonusMissions));
        }
    }

    public void relocateToMarket(MarketAPI other, boolean withIntelUpdate) {
        if (this.wasAddedToCommDirectory != null && this.wasAddedToCommDirectory.booleanValue() && this.market != null && this.market.getCommDirectory() != null) {
            this.market.getCommDirectory().removePerson(this.person);
            this.wasAddedToCommDirectory = null;
        }
        this.market = other;
        this.person.setMarket(other);
        this.marketWasDeciv = other.hasCondition("\u8352\u86ee\u4e4b\u5730");
        this.ensureIsInCommDirectory();
        this.ensureIsAddedToMarket();
        this.person.setImportance(this.person.getImportance().prev());
        if (withIntelUpdate) {
            this.sendUpdateIfPlayerHasIntel((Object)UPDATE_RELOCATED_CONTACT, false);
        }
    }

    public float getPriorityMult() {
        float priority = ContactIntel.getPriorityContacts();
        if (priority < 1.0f) {
            priority = 1.0f;
        }
        return (float)this.numPriorityInARow / DAYS_AT_PRIORITY_FOR_FULL_EFFECT / priority;
    }

    @Override
    public void reportPlayerClickedOn() {
        super.reportPlayerClickedOn();
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
        if (this.wasAddedToCommDirectory != null && this.wasAddedToCommDirectory.booleanValue() && this.market != null && this.market.getCommDirectory() != null) {
            this.market.getCommDirectory().removePerson(this.person);
            this.wasAddedToCommDirectory = null;
        }
        if (this.wasAddedToMarket != null && this.wasAddedToMarket.booleanValue()) {
            this.market.removePerson(this.person);
        }
        if (!this.hadMissionHub) {
            BaseMissionHub.set(this.person, null);
        }
        this.unsetFlags();
    }

    @Override
    public void reportRemovedIntel() {
        super.reportRemovedIntel();
        Global.getSector().removeScript(this);
    }

    @Override
    public boolean shouldRemoveIntel() {
        if (this.isEnded()) {
            return true;
        }
        if (this.state != ContactState.POTENTIAL) {
            return false;
        }
        float days = this.getDaysSincePlayerVisible();
        if (days >= DURATION && POTENTIAL_EXPIRES) {
            this.ended = true;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        if (this.state == ContactState.LOST_CONTACT_DECIV) {
            return "\u5931\u53bb\u7684\u8054\u7edc\u4eba\uff1a" + this.person.getNameString();
        }
        if (this.state == ContactState.LOST_CONTACT) {
            return "\u5931\u53bb\u7684\u8054\u7edc\u4eba\uff1a" + this.person.getNameString();
        }
        if (this.state == ContactState.POTENTIAL) {
            return "\u6f5c\u5728\u8054\u7edc\u4eba\uff1a" + this.person.getNameString();
        }
        if (this.state == ContactState.SUSPENDED) {
            return "\u5c4f\u853d\u7684\u8054\u7edc\u4eba\uff1a" + this.person.getNameString();
        }
        if (this.state == ContactState.PRIORITY) {
            return "\u5e38\u7528\u8054\u7edc\u4eba\uff1a" + this.person.getNameString();
        }
        return "\u8054\u7edc\u4eba\uff1a" + this.person.getNameString();
    }

    @Override
    public String getSortString() {
        if (this.state == ContactState.POTENTIAL) {
            return "Contact2";
        }
        if (this.state == ContactState.SUSPENDED) {
            return "Contact3";
        }
        if (this.state == ContactState.PRIORITY) {
            return "Contact0";
        }
        return "Contact1";
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color c = this.getTitleColor(mode);
        info.addPara(this.getName(), c, 0.0f);
        this.addBulletPoints(info, mode);
    }

    protected void addTypePara(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        String[] tags = this.person.getSortedContactTagStrings().toArray(new String[0]);
        if (tags.length <= 0) {
            return;
        }
        String str = "\u7c7b\u578b\uff1a";
        String[] stringArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            str = String.valueOf(str) + tag + ", ";
            ++n2;
        }
        if (tags.length > 0) {
            str = str.substring(0, str.length() - 2);
        }
        info.addPara(str, pad, tc, h, tags);
    }

    protected void addFactionPara(TooltipMakerAPI info, Color tc, float pad) {
        String faction = this.person.getFaction().getDisplayName();
        String str = "\u6240\u5c5e\u65b9\uff1a{" + faction;
        info.addPara(str, pad, tc, this.person.getFaction().getBaseUIColor(), faction);
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = this.getBulletColorForMode(mode);
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        this.bullet(info);
        if (this.getListInfoParam() == UPDATE_RELOCATED_CONTACT) {
            info.addPara("\u5df2\u7ecf\u8fc1\u81f3 " + this.market.getName(), tc, initPad);
            initPad = 0.0f;
            info.addPara("\u5730\u4f4d\u964d\u81f3\uff1a%s", initPad, tc, h, this.person.getImportance().getDisplayName());
            initPad = 0.0f;
            this.unindent(info);
            return;
        }
        if (this.state == ContactState.LOST_CONTACT_DECIV) {
            if (mode != IntelInfoPlugin.ListInfoMode.IN_DESC) {
                info.addPara(String.valueOf(this.market.getName()) + " \u5df2\u8352\u5e9f", tc, initPad);
                initPad = 0.0f;
            }
            this.unindent(info);
            return;
        }
        if (this.state == ContactState.LOST_CONTACT) {
            this.unindent(info);
            return;
        }
        this.addFactionPara(info, tc, initPad);
        initPad = 0.0f;
        this.addTypePara(info, tc, initPad);
        initPad = 0.0f;
        if (mode != IntelInfoPlugin.ListInfoMode.IN_DESC) {
            long ts;
            info.addPara("\u5730\u4f4d\uff1a%s", initPad, tc, h, this.person.getImportance().getDisplayName());
            initPad = 0.0f;
            if ((this.state == ContactState.PRIORITY || this.state == ContactState.NON_PRIORITY || this.state == ContactState.SUSPENDED) && (ts = BaseMissionHub.getLastOpenedTimestamp(this.person)) > Long.MIN_VALUE) {
                info.addPara("\u6700\u540e\u4e00\u6b21\u8054\u7cfb\u4e8e\uff1a%s}\u3002", initPad, tc, h, Misc.getDetailedAgoString(ts));
                initPad = 0.0f;
            }
        }
        if (this.state == ContactState.POTENTIAL && POTENTIAL_EXPIRES && mode != IntelInfoPlugin.ListInfoMode.IN_DESC) {
            float days = DURATION - this.getDaysSincePlayerVisible();
            info.addPara("%s " + ContactIntel.getDaysString(days) + "\u53d1\u5c55", initPad, tc, h, this.getDays(days));
            initPad = 0.0f;
        }
        this.unindent(info);
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        long ts;
        float relBarWidth;
        String pName = Misc.getPersonalityName(this.person);
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        FactionAPI faction = this.person.getFaction();
        info.addImages(width, 128.0f, opad, opad, this.person.getPortraitSprite(), faction.getCrest());
        float importanceBarWidth = relBarWidth = 266.0f;
        float indent = 25.0f;
        info.addSpacer(0.0f).getPosition().setXAlignOffset(indent);
        relBarWidth = (relBarWidth - 10.0f) / 2.0f;
        info.addRelationshipBar(this.person, relBarWidth, opad);
        float barHeight = info.getPrev().getPosition().getHeight();
        info.addRelationshipBar(this.person.getFaction(), relBarWidth, 0.0f);
        UIComponentAPI prev = info.getPrev();
        prev.getPosition().setYAlignOffset(barHeight);
        prev.getPosition().setXAlignOffset(relBarWidth + 10.0f);
        info.addSpacer(0.0f);
        info.getPrev().getPosition().setXAlignOffset(-(relBarWidth + 10.0f));
        info.addImportanceIndicator(this.person.getImportance(), importanceBarWidth, opad);
        this.addImportanceTooltip(info);
        info.addSpacer(0.0f).getPosition().setXAlignOffset(-indent);
        if (this.state == ContactState.NON_PRIORITY || this.state == ContactState.PRIORITY) {
            faction = Global.getSector().getPlayerFaction();
            ButtonAPI button = info.addAreaCheckbox("\u5e38\u7528\u8054\u7edc\u4eba", BUTTON_PRIORITY, faction.getBaseUIColor(), faction.getDarkUIColor(), faction.getBrightUIColor(), width, 25.0f, opad);
            button.setChecked(this.state == ContactState.PRIORITY);
            this.addPriorityTooltip(info);
            faction = this.person.getFaction();
        }
        if (this.market != null && this.state == ContactState.LOST_CONTACT_DECIV) {
            info.addPara(String.valueOf(this.person.getNameString()) + " \u5c31\u5728 " + this.person.getPostArticle() + " " + this.person.getPost().toLowerCase() + " " + this.market.getOnOrAt() + " " + this.market.getName() + "\uff0c\u5176\u76ee\u524d\u7684\u63a7\u5236\u65b9\u4e3a " + this.marketFaction.getDisplayNameWithArticle() + ".", opad, this.marketFaction.getBaseUIColor(), Misc.ucFirst(this.marketFaction.getDisplayNameWithArticleWithoutArticle()));
            info.addPara("\u7531\u4e8e\u8be5\u6b96\u6c11\u5730\u5df2\u88ab\u8352\u5e9f\uff0c\u5bfc\u81f4\u4f60\u65e0\u6cd5\u8054\u7cfb" + this.person.getHimOrHer() + ".", opad);
        } else if (this.state == ContactState.LOST_CONTACT) {
            info.addPara("\u4f60\u5931\u53bb\u4e86\u8fd9\u4e00\u8054\u7edc\u4eba\u3002", opad);
        } else if (this.market != null) {
            LabelAPI label = info.addPara(String.valueOf(this.person.getNameString()) + ", " + this.person.getPostArticle() + " " + this.person.getPost().toLowerCase() + " \u7684\u5b9a\u5c45\u5730\u4f4d\u4e8e " + this.market.getOnOrAt() + " " + this.market.getName() + "\uff0c\u662f\u89c4\u6a21\u4e3a{%s}\u7684\u6b96\u6c11\u5730\uff0c\u5176\u76ee\u524d\u7684\u63a7\u5236\u65b9\u4e3a " + this.market.getFaction().getDisplayNameWithArticle() + ".", opad, this.market.getFaction().getBaseUIColor(), "" + this.market.getSize(), this.market.getFaction().getDisplayNameWithArticleWithoutArticle());
            label.setHighlightColors(h, this.market.getFaction().getBaseUIColor());
        }
        if (this.state == ContactState.POTENTIAL) {
            info.addPara("\u5982\u679c\u8ba9\u5176\u52a0\u5165\u4f60\u7684\u8054\u7edc\u4eba\uff0c" + this.person.getHeOrShe() + " \u5c06\u4f1a\u5b9a\u671f\u7ed9\u4f60\u53d1\u5e03\u4efb\u52a1\u3002" + "\u4e14\u968f\u7740\u53cc\u65b9\u5173\u7cfb\u7684\u6539\u5584\uff0c" + "\u4f60\u5c06\u6709\u53ef\u80fd\u83b7\u5f97\u66f4\u4f18\u8d28\u7684\u4efb\u52a1\u3002", opad);
        } else if (this.state == ContactState.SUSPENDED) {
            info.addPara("\u4f60\u4e0e " + this.person.getNameString() + " \u7684\u8054\u7cfb\u76ee\u524d\u6682\u65f6\u5df2\u88ab\u4e2d\u6b62\u3002", Misc.getNegativeHighlightColor(), opad);
        }
        this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
        if ((this.state == ContactState.PRIORITY || this.state == ContactState.NON_PRIORITY || this.state == ContactState.SUSPENDED) && (ts = BaseMissionHub.getLastOpenedTimestamp(this.person)) > Long.MIN_VALUE) {
            info.addPara("\u6700\u540e\u4e00\u6b21\u8054\u7cfb\u4e8e\uff1a%s}\u3002", opad, h, Misc.getDetailedAgoString(ts));
        }
        Color color = Misc.getStoryOptionColor();
        Color dark = Misc.getStoryDarkColor();
        TooltipMakerAPI.TooltipCreator noDeleteTooltip = new TooltipMakerAPI.TooltipCreator(){

            public boolean isTooltipExpandable(Object tooltipParam) {
                return false;
            }

            public float getTooltipWidth(Object tooltipParam) {
                return TOOLTIP_WIDTH;
            }

            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                tooltip.addPara("\u6b64\u65f6\u4e0d\u80fd\u5220\u9664\u6216\u6682\u505c\u4e0e\u8054\u7edc\u4eba\u7684\u6765\u5f80\u3002", 0.0f);
            }
        };
        if (this.state == ContactState.POTENTIAL || this.state == ContactState.SUSPENDED) {
            if (this.state == ContactState.POTENTIAL && POTENTIAL_EXPIRES) {
                float days = DURATION - this.getDaysSincePlayerVisible();
                info.addPara("\u52a0\u6df1\u8054\u7edc\u4eba\u5173\u7cfb\u7684\u673a\u4f1a\u5c06\u6709 %s \u591a" + ContactIntel.getDaysString(days) + ".", opad, tc, h, this.getDays(days));
            }
            int max = ContactIntel.getMaxContacts();
            int curr = ContactIntel.getCurrentContacts();
            info.addPara("\u6d3b\u8dc3\u7684\u8054\u7edc\u4eba\uff1a%s %s %s", opad, h, "" + curr, "/", "" + max);
            ButtonAPI develop = null;
            String developText = "\u5efa\u7acb\u8054\u7edc";
            if (this.state == ContactState.SUSPENDED) {
                developText = "\u6062\u590d\u8054\u7edc";
            }
            if (curr >= max) {
                develop = this.addGenericButton(info, width, color, dark, developText, BUTTON_DEVELOP);
                this.addDevelopTooltip(info);
            } else {
                develop = this.addGenericButton(info, width, developText, BUTTON_DEVELOP);
            }
            develop.setShortcut(20, true);
        } else if (this.state == ContactState.NON_PRIORITY || this.state == ContactState.PRIORITY) {
            ButtonAPI suspend = this.addGenericButton(info, width, color, dark, "\u6682\u505c\u8054\u7edc", BUTTON_SUSPEND);
            suspend.setShortcut(22, true);
            if (Global.getSector().getIntel().isInShowMap()) {
                suspend.setEnabled(false);
                info.addTooltipToPrevious(noDeleteTooltip, TooltipMakerAPI.TooltipLocation.LEFT);
            }
        }
        info.addSpacer(-10.0f);
        ButtonAPI delete = this.addGenericButton(info, width, "\u4e2d\u6b62\u8054\u7edc", BUTTON_DELETE);
        if (Global.getSector().getIntel().isInShowMap()) {
            delete.setEnabled(false);
            info.addTooltipToPrevious(noDeleteTooltip, TooltipMakerAPI.TooltipLocation.LEFT);
        }
        delete.setShortcut(34, true);
    }

    @Override
    public void buttonPressConfirmed(Object buttonId, IntelUIAPI ui) {
        if (buttonId == BUTTON_DEVELOP) {
            this.develop(ui);
            Global.getSoundPlayer().playUISound("ui_contact_developed", 1.0f, 1.0f);
        } else if (buttonId == BUTTON_PRIORITY) {
            if (this.state == ContactState.NON_PRIORITY) {
                this.state = ContactState.PRIORITY;
            } else if (this.state == ContactState.PRIORITY) {
                this.state = ContactState.NON_PRIORITY;
            }
            ui.updateUIForItem(this);
        } else if (buttonId == BUTTON_DELETE) {
            this.endImmediately();
            ui.recreateIntelUI();
        }
    }

    @Override
    public void storyActionConfirmed(Object buttonId, IntelUIAPI ui) {
        if (buttonId == BUTTON_DEVELOP) {
            this.develop(ui);
        } else if (buttonId == BUTTON_SUSPEND) {
            this.state = ContactState.SUSPENDED;
            this.person.getMemoryWithoutUpdate().set(BaseMissionHub.CONTACT_SUSPENDED, true);
            ui.updateUIForItem(this);
        }
    }

    public void ensureIsAddedToMarket() {
        boolean hadPerson;
        if (this.market == null) {
            return;
        }
        boolean bl = hadPerson = this.market.getPeopleCopy().contains(this.person) || this.market == this.person.getMarket();
        if (this.person.getMarket() != null) {
            this.person.getMarket().removePerson(this.person);
        }
        if (this.market.getPeopleCopy().contains(this.person)) {
            return;
        }
        this.market.addPerson(this.person);
        if (!hadPerson) {
            this.wasAddedToMarket = true;
        }
    }

    public void develop(IntelUIAPI ui) {
        this.ensureIsInCommDirectory();
        this.ensureHasMissionHub();
        this.ensureIsAddedToMarket();
        this.state = ContactState.NON_PRIORITY;
        if (ui != null) {
            ui.updateUIForItem(this);
        }
        this.person.getMemoryWithoutUpdate().unset(BaseMissionHub.CONTACT_SUSPENDED);
    }

    @Override
    public void createConfirmationPrompt(Object buttonId, TooltipMakerAPI prompt) {
        prompt.setParaInsigniaLarge();
        if (buttonId == BUTTON_DELETE) {
            if (this.state == ContactState.POTENTIAL) {
                prompt.addPara("\u4f60\u786e\u5b9a\u5417\uff1f\u5220\u9664\u4e00\u4e2a\u6f5c\u5728\u8054\u7edc\u4eba\u5c06\u65e0\u6cd5\u633d\u56de\u3002", 0.0f);
            } else if (this.state == ContactState.SUSPENDED) {
                prompt.addPara("\u4f60\u786e\u5b9a\u5417\uff1f\u5220\u9664\u8be5\u8054\u7edc\u4eba\u5c06\u65e0\u6cd5\u633d\u56de\u3002", 0.0f);
            } else {
                prompt.addPara("\u4f60\u786e\u5b9a\u5417\uff1f\u5220\u9664\u8054\u7edc\u64cd\u4f5c\u65e0\u6cd5\u64a4\u9500\u3002\u5982\u9700\u6682\u505c\u63a5\u6536\u6b64\u6765\u6e90\u4efb\u52a1\uff0c\u800c\u4e0d\u662f\u6c38\u4e45\u5220\u9664\u8be5\u8054\u7edc\u4eba\uff0c\u4f60\u53ef\u4ee5\u9009\u62e9 \"\u6682\u505c\" \u548c\u6b64\u8054\u7edc\u4eba\u7684\u6765\u5f80\u3002", 0.0f);
            }
            return;
        }
        if (buttonId == BUTTON_DEVELOP) {
            prompt.addPara("\u4e0e\u8be5\u4eba\u5efa\u7acb\u8054\u7edc\uff1f", 0.0f);
            return;
        }
        super.createConfirmationPrompt(buttonId, prompt);
    }

    @Override
    public boolean doesButtonHaveConfirmDialog(Object buttonId) {
        if (buttonId == BUTTON_DELETE) {
            return true;
        }
        if (buttonId == BUTTON_DEVELOP) {
            return true;
        }
        return super.doesButtonHaveConfirmDialog(buttonId);
    }

    @Override
    public StoryPointActionDelegate getButtonStoryPointActionDelegate(Object buttonId) {
        if (buttonId == BUTTON_DEVELOP && this.developRequiresStoryPoint()) {
            SetStoryOption.StoryOptionParams params = new SetStoryOption.StoryOptionParams(null, 1, "developContactOverMax", Sounds.STORY_POINT_SPEND, "\u63d0\u9ad8\u4e86\u66f4\u591a\u7684\u8054\u7edc\u4eba (" + this.person.getNameString() + ")");
            return new SetStoryOption.BaseOptionStoryPointActionDelegate(null, params){

                public void confirm() {
                }

                public String getTitle() {
                    return null;
                }

                public void createDescription(TooltipMakerAPI info) {
                    super.createDescription(info);
                }
            };
        }
        if (buttonId == BUTTON_SUSPEND) {
            SetStoryOption.StoryOptionParams params = new SetStoryOption.StoryOptionParams(null, 1, "suspendContact", Sounds.STORY_POINT_SPEND, "\u6682\u505c\u8054\u7edc (" + this.person.getNameString() + ")");
            return new SetStoryOption.BaseOptionStoryPointActionDelegate(null, params){

                public void confirm() {
                }

                public String getTitle() {
                    return null;
                }

                public void createDescription(TooltipMakerAPI info) {
                    info.setParaInsigniaLarge();
                    info.addPara("\u5982\u679c\u6682\u505c\u63a5\u6536\uff0c\u6b64\u8054\u7edc\u5bf9\u8c61\u5c06\u505c\u6b62\u5411\u4f60\u53d1\u5e03\u4efb\u52a1\u4e14\u4e0d\u8ba1\u5165\u8054\u7edc\u4e0a\u9650\u3002\u4f60\u53ef\u4ee5\u968f\u65f6\u91cd\u65b0\u542f\u7528\u6b64\u8054\u7edc\u4eba\u3002", -10.0f);
                    info.addSpacer(20.0f);
                    super.createDescription(info);
                }
            };
        }
        return null;
    }

    @Override
    public String getIcon() {
        return this.person.getPortraitSprite();
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Contacts");
        return tags;
    }

    @Override
    public String getCommMessageSound() {
        return super.getCommMessageSound();
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return this.person.getFaction();
    }

    public PersonAPI getPerson() {
        return this.person;
    }

    public void setPerson(PersonAPI person) {
        this.person = person;
    }

    public ContactState getState() {
        return this.state;
    }

    public void setState(ContactState state) {
        this.state = state;
    }

    protected boolean developRequiresStoryPoint() {
        return ContactIntel.getCurrentContacts() >= ContactIntel.getMaxContacts();
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        if (this.market != null) {
            return this.market.getPrimaryEntity();
        }
        return null;
    }

    protected void addImportanceTooltip(TooltipMakerAPI info) {
        info.addTooltipToPrevious(new TooltipMakerAPI.TooltipCreator(){

            public boolean isTooltipExpandable(Object tooltipParam) {
                return false;
            }

            public float getTooltipWidth(Object tooltipParam) {
                return TOOLTIP_WIDTH;
            }

            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                tooltip.addPara("\u6b64\u4eba\u5728\u4ed6\u6240\u5c5e\u7684\u7b49\u7ea7\u5236\u5ea6\u6216\u793e\u4f1a\u4e2d\u7684\u5730\u4f4d\u3002\u5730\u4f4d\u66f4\u9ad8\u6216\u5173\u7cfb\u66f4\u5bc6\u5207\u7684\u4eba\u5f80\u5f80\u4f1a\u80fd\u63d0\u4f9b\u66f4\u56f0\u96be\u540c\u65f6\u4e5f\u66f4\u6709\u5229\u53ef\u56fe\u7684\u4efb\u52a1\u6216\u8005\u673a\u4f1a\u3002", 0.0f);
            }
        }, TooltipMakerAPI.TooltipLocation.LEFT);
    }

    protected void addPriorityTooltip(TooltipMakerAPI info) {
        info.addTooltipToPrevious(new TooltipMakerAPI.TooltipCreator(){

            public boolean isTooltipExpandable(Object tooltipParam) {
                return false;
            }

            public float getTooltipWidth(Object tooltipParam) {
                return TOOLTIP_WIDTH;
            }

            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                float opad = 10.0f;
                tooltip.addPara("\u548c\u8fd9\u4e2a\u8054\u7edc\u5bf9\u8c61\u5efa\u7acb\u5173\u7cfb\u662f\u4f60\u7684\u9996\u8981\u76ee\u6807\u3002\u548c\u4f60\u5173\u7cfb\u5bc6\u5207\u7684\u8054\u7edc\u5bf9\u8c61\u4f1a\u6709\u66f4\u591a\u7684\u4efb\u52a1\u7ed9\u4f60\uff0c\u800c\u4e14\u62a5\u916c\u66f4\u4e30\u539a\u3002", 0.0f);
                tooltip.addPara("\u4f60\u7684\u5e38\u7528\u8054\u7edc\u4eba\u8d8a\u591a\uff0c\u5bf9\u6bcf\u4e2a\u5355\u72ec\u8054\u7edc\u4eba\u7684\u5f71\u54cd\u4e5f\u5c31\u8d8a\u5c0f\u3002", opad);
                tooltip.addPara("\u5e38\u7528\u72b6\u6001\u7684\u6539\u53d8\u9700\u8981\u4e00\u4e2a\u6708\u5de6\u53f3\u7684\u65f6\u95f4\u624d\u80fd\u5b8c\u5168\u751f\u6548\u3002", opad);
            }
        }, TooltipMakerAPI.TooltipLocation.LEFT);
    }

    protected void addDevelopTooltip(TooltipMakerAPI info) {
        info.addTooltipToPrevious(new TooltipMakerAPI.TooltipCreator(){

            public boolean isTooltipExpandable(Object tooltipParam) {
                return false;
            }

            public float getTooltipWidth(Object tooltipParam) {
                return TOOLTIP_WIDTH;
            }

            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                tooltip.addPara("\u5f53\u8054\u7edc\u4eba\u6570\u91cf\u8d85\u8fc7\u6700\u5927\u4e0a\u9650\u65f6\uff0c\u6bcf\u63d0\u9ad8\u4e00\u540d\u8054\u7edc\u4eba\u5c31\u9700\u8981\u4e00\u4e2a\u6545\u4e8b\u70b9\u3002", 0.0f, Misc.getStoryOptionColor(), "\u6545\u4e8b\u70b9");
            }
        }, TooltipMakerAPI.TooltipLocation.LEFT);
    }

    public static int getMaxContacts() {
        int base = Global.getSettings().getInt("maxContacts");
        int max = (int)Global.getSector().getPlayerStats().getDynamic().getMod("num_max_contacts_mod").computeEffective(base);
        return max;
    }

    public static int getCurrentContacts() {
        int count = 0;
        for (IntelInfoPlugin intel : Global.getSector().getIntelManager().getIntel(ContactIntel.class)) {
            if (intel.isEnding() || intel.isEnded() || ((ContactIntel)intel).getState() == ContactState.POTENTIAL || ((ContactIntel)intel).getState() == ContactState.SUSPENDED || ((ContactIntel)intel).getState() == ContactState.LOST_CONTACT_DECIV || ((ContactIntel)intel).getState() == ContactState.LOST_CONTACT) continue;
            ++count;
        }
        return count;
    }

    public static int getPriorityContacts() {
        int count = 0;
        for (IntelInfoPlugin intel : Global.getSector().getIntelManager().getIntel(ContactIntel.class)) {
            if (intel.isEnding() || intel.isEnded() || ((ContactIntel)intel).getState() != ContactState.PRIORITY) continue;
            ++count;
        }
        return count;
    }

    public static boolean playerHasIntelItemForContact(PersonAPI person) {
        for (IntelInfoPlugin intel : Global.getSector().getIntelManager().getIntel(ContactIntel.class)) {
            if (((ContactIntel)intel).getPerson() != person) continue;
            return true;
        }
        return false;
    }

    public static boolean playerHasContact(PersonAPI person, boolean includePotential) {
        for (IntelInfoPlugin intel : Global.getSector().getIntelManager().getIntel(ContactIntel.class)) {
            ContactState state;
            if (((ContactIntel)intel).getPerson() != person || (state = ((ContactIntel)intel).getState()) == ContactState.POTENTIAL && !includePotential || state == ContactState.LOST_CONTACT || state == ContactState.LOST_CONTACT_DECIV) continue;
            return true;
        }
        return false;
    }

    public static ContactIntel getContactIntel(PersonAPI person) {
        for (IntelInfoPlugin intel : Global.getSector().getIntelManager().getIntel(ContactIntel.class)) {
            if (((ContactIntel)intel).getPerson() != person) continue;
            return (ContactIntel)intel;
        }
        return null;
    }

    public static void removeContact(PersonAPI person, InteractionDialogAPI dialog) {
        if (person == null) {
            return;
        }
        ContactIntel intel = ContactIntel.getContactIntel(person);
        if (intel != null) {
            intel.loseContact(dialog);
        }
    }

    public static void addPotentialContact(PersonAPI contact, MarketAPI market, TextPanelAPI text) {
        ContactIntel.addPotentialContact(DEFAULT_POTENTIAL_CONTACT_PROB, contact, market, text);
    }

    public static void addPotentialContact(float probability, PersonAPI contact, MarketAPI market, TextPanelAPI text) {
        if (ContactIntel.playerHasIntelItemForContact(contact)) {
            return;
        }
        if (contact.getFaction().isPlayerFaction()) {
            return;
        }
        if (market == null) {
            return;
        }
        if (market != null && market.getMemoryWithoutUpdate().getBoolean(NO_CONTACTS_ON_MARKET)) {
            return;
        }
        if (contact != null && contact.getFaction().getCustomBoolean("no_contacts")) {
            return;
        }
        Random random = new Random(ContactIntel.getContactRandomSeed(contact));
        probability += contact.getRelToPlayer().getRel();
        String key = "$potentialContactRollFails";
        MemoryAPI mem = Global.getSector().getMemoryWithoutUpdate();
        float fails = mem.getInt(key);
        probability += ADD_PER_FAIL * fails;
        if (random.nextFloat() >= probability && !DebugFlags.ALWAYS_ADD_POTENTIAL_CONTACT) {
            mem.set(key, Float.valueOf(fails += 1.0f));
            return;
        }
        mem.set(key, 0);
        ContactIntel intel = new ContactIntel(contact, market);
        Global.getSector().getIntelManager().addIntel(intel, false, text);
    }

    public static long getContactRandomSeed(PersonAPI person) {
        String id = person.getId();
        if (id == null) {
            id = Misc.genUID();
        }
        long seed = Misc.seedUniquifier() ^ (long)(person.getId().hashCode() * 17000);
        Random r = new Random(seed);
        int i = 0;
        while (i < 5) {
            r.nextLong();
            ++i;
        }
        return r.nextLong();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContactState {
        POTENTIAL,
        NON_PRIORITY,
        PRIORITY,
        SUSPENDED,
        LOST_CONTACT_DECIV,
        LOST_CONTACT;

    }
}

