/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.deciv;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecivIntel
extends BaseIntelPlugin {
    protected SectorEntityToken primary;
    protected String name;
    protected FactionAPI faction;
    protected boolean destroyed;
    protected boolean warning;

    public DecivIntel(MarketAPI market, SectorEntityToken primary, boolean destroyed, boolean warning) {
        this.primary = primary;
        this.destroyed = destroyed;
        this.warning = warning;
        this.faction = market.getFaction();
        this.name = market.getName();
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        boolean isUpdate = this.getListInfoParam() != null;
        this.unindent(info);
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color c = this.getTitleColor(mode);
        info.addPara(this.getName(), c, 0.0f);
        this.addBulletPoints(info, mode);
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        info.addImage(this.getFactionForUIColors().getLogo(), width, 128.0f, opad);
        if (this.warning) {
            info.addPara("\u8be5 " + this.name + "\uff0c\u8fd9\u5904\u73b0\u5c5e\u4e8e " + this.faction.getDisplayNameWithArticle() + " \u7684\u6b96\u6c11\u5730\uff0c\u56e0\u5f53\u5730\u60c5\u51b5\u6b63\u9010\u6b65\u6076\u5316\u3002\u9664\u975e\u80fd\u91cd\u65b0\u7a33\u5b9a\uff0c" + "\u5426\u5219\u5b83\u5c06 \u5f88\u53ef\u80fd\u5206\u5d29\u79bb\u6790\u76f4\u81f3\u8d70\u5411\u706d\u4ea1\u3002", opad, this.faction.getBaseUIColor(), this.faction.getDisplayNameWithArticleWithoutArticle());
        } else if (this.destroyed) {
            info.addPara(String.valueOf(this.name) + "\uff0c\u8fd9\u5904\u539f\u5c5e\u4e8e " + this.faction.getDisplayNameWithArticle() + " \u7684\u6b96\u6c11\u5730\u5df2\u88ab\u6467\u6bc1\u3002", opad, this.faction.getBaseUIColor(), this.faction.getDisplayNameWithArticleWithoutArticle());
        } else {
            info.addPara(String.valueOf(this.name) + "\uff0c\u8fd9\u5904\u539f\u5c5e\u4e8e " + this.faction.getDisplayNameWithArticle() + " \u7684\u6b96\u6c11\u5730\uff0c" + "\u56e0\u5176\u5730\u65b9\u653f\u5e9c\u5b8c\u5168\u5012\u53f0\uff0c\u4e14\u4e0d\u53ef\u9006\u8f6c\uff0c" + "\u5982\u4eca\u8fd9\u5904\u5e9f\u571f \u53ea\u5269\u4e0b\u6323\u624e\u6c42\u751f\u4e14\u75db\u82e6\u4e0d\u582a\u7684\u96be\u6c11\u4eec\u3002", opad, this.faction.getBaseUIColor(), this.faction.getDisplayNameWithArticleWithoutArticle());
        }
        this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
    }

    @Override
    public String getIcon() {
        return Global.getSettings().getSpriteName("intel", "deciv");
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Decivilized");
        return tags;
    }

    @Override
    public String getSortString() {
        return "\u6587\u660e\u4e27\u5931 " + this.name;
    }

    @Override
    public String getName() {
        if (this.warning) {
            return String.valueOf(this.name) + " - \u9010\u6b65\u6076\u5316";
        }
        if (this.destroyed) {
            return String.valueOf(this.name) + " - \u5df2\u88ab\u6467\u6bc1";
        }
        return String.valueOf(this.name) + " - \u6587\u660e\u4e27\u5931";
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return this.faction;
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        return this.primary;
    }

    @Override
    public boolean shouldRemoveIntel() {
        return false;
    }

    @Override
    public String getCommMessageSound() {
        return super.getCommMessageSound();
    }
}

