/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.deciv;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionAPI;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.campaign.listeners.ListenerUtil;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.intel.deciv.DecivIntel;
import com.fs.starfarer.api.impl.campaign.population.CoreImmigrationPluginImpl;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.TimeoutTracker;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;

public class DecivTracker
implements EveryFrameScript {
    public static final String KEY = "$core_decivTracker";
    public static final String NO_DECIV_KEY = "$core_noDeciv";
    protected LinkedHashMap<MarketAPI, MarketDecivData> decivData = new LinkedHashMap();
    protected IntervalUtil sampler = new IntervalUtil(20.0f, 40.0f);
    protected IntervalUtil checker = new IntervalUtil(5.0f, 15.0f);
    protected TimeoutTracker<String> sentWarning = new TimeoutTracker();
    protected Random random = new Random();

    public static DecivTracker getInstance() {
        Object test = Global.getSector().getMemoryWithoutUpdate().get(KEY);
        return (DecivTracker)test;
    }

    public DecivTracker() {
        Global.getSector().getMemoryWithoutUpdate().set(KEY, this);
    }

    protected Object readResolve() {
        if (this.sentWarning == null) {
            this.sentWarning = new TimeoutTracker();
        }
        return this;
    }

    public void advance(float amount) {
        float days = Misc.getDays(amount);
        if (DebugFlags.DECIV_DEBUG) {
            days *= 1000.0f;
        }
        this.sentWarning.advance(days);
        this.sampler.advance(days);
        if (this.sampler.intervalElapsed()) {
            this.updateSamples();
        }
        this.checker.advance(days);
        if (this.checker.intervalElapsed()) {
            this.checkDeciv();
        }
    }

    public MarketDecivData getDataFor(MarketAPI market) {
        MarketDecivData data = this.decivData.get(market);
        if (data == null) {
            data = new MarketDecivData();
            data.market = market;
            this.decivData.put(market, data);
        }
        return data;
    }

    public static int getMaxMonths() {
        return Global.getSettings().getInt("decivSamplingMonths");
    }

    public static int getMinStreak() {
        return Global.getSettings().getInt("decivMinStreak");
    }

    public static float getProbPerMonth() {
        return Global.getSettings().getFloat("decivProbPerMonthOverStreak");
    }

    public static float getMinFraction() {
        return Global.getSettings().getFloat("decivZeroStabilityMinFraction");
    }

    protected void updateSamples() {
        for (MarketAPI market : new ArrayList<MarketAPI>(this.decivData.keySet())) {
            if (market.isInEconomy()) continue;
            this.decivData.remove(market);
        }
        int maxSamples = DecivTracker.getMaxMonths();
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            MarketDecivData data = this.getDataFor(market);
            data.stabilityHistory.add(Float.valueOf(market.getStabilityValue()));
            while (data.stabilityHistory.size() > maxSamples && !data.stabilityHistory.isEmpty()) {
                data.stabilityHistory.remove(0);
            }
        }
    }

    protected void checkDeciv() {
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (this.checkDeciv(market)) break;
        }
    }

    protected boolean checkDeciv(MarketAPI market) {
        MarketDecivData data = this.getDataFor(market);
        int max = DecivTracker.getMaxMonths();
        int min = DecivTracker.getMinStreak();
        float per = DecivTracker.getProbPerMonth();
        float fraction = DecivTracker.getMinFraction();
        if (data.stabilityHistory.size() < max) {
            return false;
        }
        if (data.stabilityHistory.get(0).floatValue() > 0.0f || market.getStabilityValue() > 0.0f) {
            return false;
        }
        float streak = 0.0f;
        float zeroCount = 0.0f;
        boolean streakEnded = false;
        int i = data.stabilityHistory.size() - 1;
        while (i >= 0) {
            Float curr = data.stabilityHistory.get(i);
            if (curr.floatValue() <= 0.0f) {
                zeroCount += 1.0f;
                if (!streakEnded) {
                    streak += 1.0f;
                }
            } else {
                streakEnded = true;
            }
            --i;
        }
        if (streak < (float)min) {
            return false;
        }
        if (zeroCount / (float)max < fraction) {
            return false;
        }
        if (Misc.isStoryCritical(market)) {
            return false;
        }
        float prob = (streak - (float)min) * per;
        String id = market.getId();
        if (!this.sentWarning.contains(id)) {
            DecivTracker.sendWarning(market);
            this.sentWarning.add(id, 180.0f);
            return false;
        }
        if (this.random.nextFloat() >= prob) {
            return false;
        }
        DecivTracker.decivilize(market, false);
        return true;
    }

    public static void decivilize(MarketAPI market, boolean fullDestroy) {
        DecivTracker.decivilize(market, fullDestroy, true);
    }

    public static void decivilize(MarketAPI market, boolean fullDestroy, boolean withIntel) {
        MarketConditionAPI ruins;
        if (market.getMemoryWithoutUpdate().getBoolean(NO_DECIV_KEY) && !fullDestroy) {
            return;
        }
        if (market.getPrimaryEntity().isDiscoverable()) {
            return;
        }
        ListenerUtil.reportColonyAboutToBeDecivilized(market, fullDestroy);
        if (withIntel) {
            DecivIntel intel = new DecivIntel(market, market.getPrimaryEntity(), fullDestroy, false);
            Global.getSector().getIntelManager().addIntel(intel);
        }
        market.setAdmin(null);
        for (SectorEntityToken entity : market.getConnectedEntities()) {
            entity.setFaction("neutral");
        }
        market.setPlanetConditionMarketOnly(true);
        market.setFactionId("neutral");
        market.getCommDirectory().clear();
        for (PersonAPI person : market.getPeopleCopy()) {
            market.removePerson(person);
        }
        market.clearCommodities();
        for (MarketConditionAPI mc : new ArrayList<MarketConditionAPI>(market.getConditions())) {
            if (!mc.getSpec().isDecivRemove()) continue;
            market.removeSpecificCondition(mc.getIdForPluginModifications());
        }
        for (Industry ind : new ArrayList<Industry>(market.getIndustries())) {
            market.removeIndustry(ind.getId(), null, false);
        }
        if (!fullDestroy && !market.hasCondition("decivilized")) {
            market.addCondition("decivilized");
        }
        int size = market.getSize();
        market.removeCondition("ruins_scattered");
        market.removeCondition("ruins_widespread");
        market.removeCondition("ruins_extensive");
        market.removeCondition("ruins_vast");
        String id = null;
        id = size <= 3 ? market.addCondition("ruins_scattered") : (size <= 4 ? market.addCondition("ruins_widespread") : (size <= 6 ? market.addCondition("ruins_extensive") : market.addCondition("ruins_vast")));
        if (id != null && (ruins = market.getSpecificCondition(id)) != null) {
            ruins.setSurveyed(true);
        }
        market.getMemoryWithoutUpdate().set("$wasCivilized", true);
        market.setSize(1);
        market.getPopulation().setWeight(CoreImmigrationPluginImpl.getWeightForMarketSizeStatic(market.getSize()));
        market.getPopulation().normalize();
        for (SubmarketAPI sub : market.getSubmarketsCopy()) {
            market.removeSubmarket(sub.getSpecId());
        }
        for (SectorEntityToken entity : market.getConnectedEntities()) {
            if (entity instanceof PlanetAPI) continue;
            Misc.setAbandonedStationMarket(String.valueOf(market.getId()) + "_deciv", entity);
        }
        SectorEntityToken primary = market.getPrimaryEntity();
        market.getConnectedEntities().clear();
        market.setPrimaryEntity(primary);
        market.setPlayerOwned(false);
        Global.getSector().getEconomy().removeMarket(market);
        Misc.removeRadioChatter(market);
        market.advance(0.0f);
        ListenerUtil.reportColonyDecivilized(market, fullDestroy);
    }

    public static void removeColony(MarketAPI market, boolean withRuins) {
        market.setAdmin(null);
        for (SectorEntityToken entity : market.getConnectedEntities()) {
            entity.setFaction("neutral");
        }
        market.setPlanetConditionMarketOnly(true);
        market.setFactionId("neutral");
        market.getCommDirectory().clear();
        for (PersonAPI person : market.getPeopleCopy()) {
            market.removePerson(person);
        }
        market.clearCommodities();
        for (MarketConditionAPI mc : new ArrayList<MarketConditionAPI>(market.getConditions())) {
            if (!mc.getSpec().isDecivRemove()) continue;
            market.removeSpecificCondition(mc.getIdForPluginModifications());
        }
        for (Industry ind : new ArrayList<Industry>(market.getIndustries())) {
            market.removeIndustry(ind.getId(), null, false);
        }
        if (withRuins) {
            int size = market.getSize();
            market.removeCondition("ruins_scattered");
            market.removeCondition("ruins_widespread");
            market.removeCondition("ruins_extensive");
            market.removeCondition("ruins_vast");
            if (size <= 3) {
                market.addCondition("ruins_scattered");
            } else if (size <= 4) {
                market.addCondition("ruins_widespread");
            } else if (size <= 6) {
                market.addCondition("ruins_extensive");
            } else {
                market.addCondition("ruins_vast");
            }
        }
        market.getMemoryWithoutUpdate().set("$wasCivilized", true);
        market.setSize(1);
        market.getPopulation().setWeight(CoreImmigrationPluginImpl.getWeightForMarketSizeStatic(market.getSize()));
        market.getPopulation().normalize();
        for (SubmarketAPI sub : market.getSubmarketsCopy()) {
            market.removeSubmarket(sub.getSpecId());
        }
        for (SectorEntityToken entity : market.getConnectedEntities()) {
            if (entity instanceof PlanetAPI) continue;
            Misc.setAbandonedStationMarket(String.valueOf(market.getId()) + "_deciv", entity);
        }
        market.setIncentiveCredits(0.0f);
        SectorEntityToken primary = market.getPrimaryEntity();
        market.getConnectedEntities().clear();
        market.setPrimaryEntity(primary);
        market.setPlayerOwned(false);
        Global.getSector().getEconomy().removeMarket(market);
        Misc.removeRadioChatter(market);
        market.advance(0.0f);
    }

    public static void sendWarning(MarketAPI market) {
        if (market.getMemoryWithoutUpdate().getBoolean(NO_DECIV_KEY)) {
            return;
        }
        DecivIntel intel = new DecivIntel(market, market.getPrimaryEntity(), false, true);
        Global.getSector().getIntelManager().addIntel(intel);
    }

    public boolean isDone() {
        return false;
    }

    public boolean runWhilePaused() {
        return false;
    }

    public static class MarketDecivData {
        MarketAPI market;
        List<Float> stabilityHistory = new ArrayList<Float>();
    }
}

