/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.listeners.EconomyTickListener;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.EventFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.CustomPanelAPI;
import com.fs.starfarer.api.ui.EventProgressBarAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.ui.UIComponentAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseEventIntel
extends BaseIntelPlugin
implements EconomyTickListener {
    public static final String RANDOM_EVENT_NONE = "random_event_none";
    protected int progress = 0;
    protected int maxProgress = 1000;
    protected List<EventStageData> stages = new ArrayList<EventStageData>();
    protected IntelInfoPlugin.IntelSortTier sortTier;
    protected List<EventFactor> factors = new ArrayList<EventFactor>();
    protected Random random = new Random();
    protected float progressDeltaRemainder = 0.0f;
    protected transient float uiWidth;
    protected transient InteractionDialogAPI addingFactorDialog = null;
    protected transient boolean prevProgressDeltaWasPositive = false;

    public BaseEventIntel() {
        this.setSortTier(IntelInfoPlugin.IntelSortTier.TIER_2);
        Global.getSector().addScript(this);
        Global.getSector().getListenerManager().addListener(this);
    }

    @Override
    protected void advanceImpl(float amount) {
        super.advanceImpl(amount);
        ArrayList<EventFactor> remove = new ArrayList<EventFactor>();
        for (EventFactor curr : this.factors) {
            if (curr.isExpired()) {
                remove.add(curr);
                continue;
            }
            curr.advance(amount);
            if (!curr.isExpired()) continue;
            remove.add(curr);
        }
        this.factors.removeAll(remove);
        for (EventFactor factor : remove) {
            factor.notifyFactorRemoved();
        }
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color c = this.getTitleColor(mode);
        boolean large = true;
        if (large) {
            info.setParaSmallInsignia();
        }
        info.addPara(this.getName(), c, 0.0f);
        if (large) {
            info.setParaFontDefault();
        }
        this.addBulletPoints(info, mode);
    }

    protected boolean addEventFactorBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        if (isUpdate && this.getListInfoParam() instanceof EventFactor) {
            EventFactor factor = (EventFactor)this.getListInfoParam();
            if (factor.isOneTime()) {
                factor.addBulletPointForOneTimeFactor(this, info, tc, initPad);
            }
            return true;
        }
        return false;
    }

    @Override
    public void createLargeDescription(CustomPanelAPI panel, float width, float height) {
        float opad = 10.0f;
        this.uiWidth = width;
        TooltipMakerAPI main = panel.createUIElement(width, height, true);
        main.setTitleOrbitronVeryLarge();
        main.addTitle(this.getName(), Misc.getBasePlayerColor());
        EventProgressBarAPI bar = main.addEventProgressBar(this, 100.0f);
        TooltipMakerAPI.TooltipCreator barTC = this.getBarTooltip();
        if (barTC != null) {
            main.addTooltipToPrevious(barTC, TooltipMakerAPI.TooltipLocation.BELOW, false);
        }
        for (EventStageData curr : this.stages) {
            if (curr.progress <= 0 || RANDOM_EVENT_NONE.equals(curr.rollData) || curr.wasEverReached && curr.isOneOffEvent && !curr.isRepeatable || curr.hideIconWhenPastStageUnlessLastActive && curr.progress <= this.progress && this.getLastActiveStage(true) != curr) continue;
            EventStageDisplayData data = this.createDisplayData(curr.id);
            UIComponentAPI marker = main.addEventStageMarker(data);
            float xOff = bar.getXCoordinateForProgress(curr.progress) - bar.getPosition().getX();
            marker.getPosition().aboveLeft(bar, data.downLineLength).setXAlignOffset(xOff - data.size / 2.0f - 1.0f);
            TooltipMakerAPI.TooltipCreator tc = this.getStageTooltip(curr.id);
            if (tc == null) continue;
            main.addTooltipTo(tc, marker, TooltipMakerAPI.TooltipLocation.LEFT, false);
        }
        UIComponentAPI marker = main.addEventProgressMarker(this);
        float xOff = bar.getXCoordinateForProgress(this.progress) - bar.getPosition().getX();
        marker.getPosition().belowLeft(bar, -this.getBarProgressIndicatorHeight() * 0.5f - 2.0f).setXAlignOffset(xOff - this.getBarProgressIndicatorWidth() / 2.0f - 1.0f);
        main.addSpacer(opad);
        main.addSpacer(opad);
        for (EventStageData curr : this.stages) {
            if (curr.wasEverReached && curr.isOneOffEvent && !curr.isRepeatable) continue;
            this.addStageDescriptionWithImage(main, curr.id);
        }
        float barW = this.getBarWidth();
        float factorWidth = (barW - opad) / 2.0f;
        if (this.withMonthlyFactors() != this.withOneTimeFactors()) {
            factorWidth = (int)(barW * 0.6f);
        }
        TooltipMakerAPI mFac = main.beginSubTooltip(factorWidth);
        Color c = this.getFactionForUIColors().getBaseUIColor();
        Color bg = this.getFactionForUIColors().getDarkUIColor();
        mFac.addSectionHeading("\u6bcf\u6708\u56e0\u7d20", c, bg, Alignment.MID, opad).getPosition().setXAlignOffset(0.0f);
        float strW = 40.0f;
        float rh = 20.0f;
        mFac.beginTable2(this.getFactionForUIColors(), rh, false, false, "\u6bcf\u6708\u56e0\u7d20", Float.valueOf(factorWidth - strW - 3.0f), "\u8fdb\u5c55", Float.valueOf(strW));
        for (EventFactor factor : this.factors) {
            if (factor.isOneTime() || !factor.shouldShow(this)) continue;
            String desc = factor.getDesc(this);
            if (desc != null) {
                mFac.addRowWithGlow(new Object[]{Alignment.LMID, factor.getDescColor(this), desc, Alignment.RMID, factor.getProgressColor(this), factor.getProgressStr(this)});
                TooltipMakerAPI.TooltipCreator t = factor.getMainRowTooltip(this);
                if (t != null) {
                    mFac.addTooltipToAddedRow(t, TooltipMakerAPI.TooltipLocation.RIGHT, false);
                }
            }
            factor.addExtraRows(mFac, this);
        }
        mFac.addTable("\u65e0", -1, opad);
        mFac.getPrev().getPosition().setXAlignOffset(-5.0f);
        main.endSubTooltip();
        TooltipMakerAPI oFac = main.beginSubTooltip(factorWidth);
        oFac.addSectionHeading("\u8fd1\u671f\u4e00\u6b21\u6027\u56e0\u7d20", c, bg, Alignment.MID, opad).getPosition().setXAlignOffset(0.0f);
        oFac.beginTable2(this.getFactionForUIColors(), 20.0f, false, false, "\u4e00\u6b21\u6027\u56e0\u7d20", Float.valueOf(factorWidth - strW - 3.0f), "\u8fdb\u5c55", Float.valueOf(strW));
        ArrayList<EventFactor> reversed = new ArrayList<EventFactor>(this.factors);
        Collections.reverse(reversed);
        for (EventFactor factor : reversed) {
            if (!factor.isOneTime() || !factor.shouldShow(this)) continue;
            String desc = factor.getDesc(this);
            if (desc != null) {
                oFac.addRowWithGlow(new Object[]{Alignment.LMID, factor.getDescColor(this), desc, Alignment.RMID, factor.getProgressColor(this), factor.getProgressStr(this)});
                TooltipMakerAPI.TooltipCreator t = factor.getMainRowTooltip(this);
                if (t != null) {
                    oFac.addTooltipToAddedRow(t, TooltipMakerAPI.TooltipLocation.LEFT);
                }
            }
            factor.addExtraRows(oFac, this);
        }
        oFac.addTable("\u65e0", -1, opad);
        oFac.getPrev().getPosition().setXAlignOffset(-5.0f);
        main.endSubTooltip();
        float factorHeight = Math.max(mFac.getHeightSoFar(), oFac.getHeightSoFar());
        mFac.setHeightSoFar(factorHeight);
        oFac.setHeightSoFar(factorHeight);
        if (this.withMonthlyFactors() && this.withOneTimeFactors()) {
            main.addCustom(mFac, opad * 2.0f);
            main.addCustomDoNotSetPosition(oFac).getPosition().rightOfTop(mFac, opad);
        } else if (this.withMonthlyFactors()) {
            main.addCustom(mFac, opad * 2.0f);
        } else if (this.withOneTimeFactors()) {
            main.addCustom(oFac, opad * 2.0f);
        }
        panel.addUIElement(main).inTL(0.0f, 0.0f);
    }

    public TooltipMakerAPI.TooltipCreator getBarTooltip() {
        return new TooltipMakerAPI.TooltipCreator(){

            public boolean isTooltipExpandable(Object tooltipParam) {
                return false;
            }

            public float getTooltipWidth(Object tooltipParam) {
                return 450.0f;
            }

            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                float opad = 10.0f;
                Color h = Misc.getHighlightColor();
                tooltip.addPara("\u4e8b\u4ef6\u8fdb\u5c55: %s/%s \u70b9\u3002", 0.0f, h, "" + BaseEventIntel.this.progress, "" + BaseEventIntel.this.maxProgress);
                int p = BaseEventIntel.this.getMonthlyProgress();
                String pStr = "" + p;
                if (p > 0) {
                    pStr = "+" + p;
                }
                tooltip.addPara("\u9879\u76ee\u6bcf\u6708\u8fdb\u5ea6\u9884\u8ba1: %s \u70b9\u3002", opad, BaseEventIntel.this.getProgressColor(p), pStr);
                tooltip.addPara("\u4e8b\u4ef6\u7684\u8fdb\u5c55\u53d7\u591a\u79cd\u56e0\u7d20\u5f71\u54cd\u3002\u6709\u4e9b\u56e0\u7d20\u4f1a\u5728\u65f6\u95f4\u7684\u6d41\u901d\u4e2d\u4f53\u73b0\u51fa\u6765\uff0c\u800c\u6709\u4e9b\u53ea\u4f1a\u751f\u6548\u4e00\u6b21\u3002\u968f\u7740\u4e8b\u4ef6\u7684\u8fdb\u5c55\uff0c\u4e0d\u540c\u7684\u9636\u6bb5\u548c\u7ed3\u679c\u4f1a\u663e\u73b0\u51fa\u6765\u3002", opad);
            }
        };
    }

    public TooltipMakerAPI.TooltipCreator getStageTooltip(Object stageId) {
        final EventStageData esd = this.getDataFor(stageId);
        if (esd == null || esd.randomized && (esd.rollData == null || RANDOM_EVENT_NONE.equals(esd.rollData))) {
            return new TooltipMakerAPI.TooltipCreator(){

                public boolean isTooltipExpandable(Object tooltipParam) {
                    return false;
                }

                public float getTooltipWidth(Object tooltipParam) {
                    return BaseEventFactor.TOOLTIP_WIDTH;
                }

                public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                    float opad = 10.0f;
                    Color h = Misc.getHighlightColor();
                    tooltip.addPara("\u5f53\u4e8b\u4ef6\u8fdb\u5c55\u5230 %s \u70b9\u65f6\uff0c\u67d0\u4e9b\u4e8b\u60c5\u4f1a\u53d1\u751f\u3002\u5177\u4f53\u4e8b\u4ef6 (\u5982\u679c\u6709\u7684\u8bdd) \u4f1a\u5728\u8fdb\u5c55\u70b9\u6570\u8fbe\u5230\u65f6\u624d\u88ab\u786e\u5b9a\u3002", 0.0f, h, "" + esd.progress, "" + esd.progressToRollAt);
                    if (esd.isRepeatable) {
                        tooltip.addPara("\u6b64\u4e8b\u4ef6\u53ef\u91cd\u590d\u53d1\u751f\u3002", opad);
                    } else {
                        tooltip.addPara("\u6b64\u4e8b\u4ef6\u4e0d\u53ef\u91cd\u590d\u53d1\u751f\u3002", opad);
                    }
                }
            };
        }
        return this.getStageTooltipImpl(stageId);
    }

    public TooltipMakerAPI.TooltipCreator getStageTooltipImpl(Object stageId) {
        return null;
    }

    public float getImageSizeForStageDesc(Object stageId) {
        return 64.0f;
    }

    public float getImageIndentForStageDesc(Object stageId) {
        return 0.0f;
    }

    public void addStageDescriptionWithImage(TooltipMakerAPI main, Object stageId) {
        EventStageDisplayData data = this.createDisplayData(stageId);
        String icon = data != null ? data.icon : this.getIcon();
        float imageSize = this.getImageSizeForStageDesc(stageId);
        float opad = 10.0f;
        float indent = 0.0f;
        indent = 10.0f;
        float width = this.getBarWidth() - (indent += this.getImageIndentForStageDesc(stageId)) * 2.0f;
        TooltipMakerAPI info = main.beginImageWithText(icon, imageSize, width, true);
        this.addStageDescriptionText(info, width - imageSize - opad, stageId);
        if (info.getHeightSoFar() > 0.0f) {
            main.addImageWithText(opad).getPosition().setXAlignOffset(indent);
            main.addSpacer(0.0f).getPosition().setXAlignOffset(-indent);
        }
    }

    public void addStageDescriptionText(TooltipMakerAPI info, float width, Object stageId) {
    }

    public EventStageDisplayData createDisplayData(Object stageId) {
        EventStageDisplayData data = new EventStageDisplayData();
        data.size = this.getStageIconSize(stageId);
        data.downLineLength = this.getStageDownLineLength(stageId);
        data.color = this.getStageColor(stageId);
        data.icon = this.getStageIcon(stageId);
        data.iconColor = this.getStageIconColor(stageId);
        data.importance = this.getStageImportance(stageId);
        data.label = this.getStageLabel(stageId);
        data.labelColor = this.getStageLabelColor(stageId);
        return data;
    }

    protected String getStageIcon(Object stageId) {
        EventStageData esd = this.getDataFor(stageId);
        if (esd == null || esd.randomized && (esd.rollData == null || RANDOM_EVENT_NONE.equals(esd.rollData))) {
            if (esd.randomType == RandomizedStageType.GOOD) {
                return Global.getSettings().getSpriteName("events", "stage_unknown_good");
            }
            if (esd.randomType == RandomizedStageType.BAD) {
                return Global.getSettings().getSpriteName("events", "stage_unknown_bad");
            }
            return Global.getSettings().getSpriteName("events", "stage_unknown_neutral");
        }
        return this.getStageIconImpl(stageId);
    }

    protected String getStageIconImpl(Object stageId) {
        return Global.getSettings().getSpriteName("events", "stage_unknown");
    }

    protected float getStageIconSize(Object stageId) {
        EventStageData esd = this.getDataFor(stageId);
        if (esd != null && esd.iconSize == StageIconSize.SMALL) {
            return 32.0f;
        }
        if (esd != null && esd.iconSize == StageIconSize.LARGE) {
            return 48.0f;
        }
        return 40.0f;
    }

    protected float getStageDownLineLength(Object stageId) {
        EventStageData esd = this.getDataFor(stageId);
        if (esd != null && esd.iconSize == StageIconSize.SMALL) {
            return 48.0f;
        }
        if (esd != null && esd.iconSize == StageIconSize.LARGE) {
            return 40.0f;
        }
        return 32.0f;
    }

    public float getBarWidth() {
        return 750.0f;
    }

    public float getBarHeight() {
        return 20.0f;
    }

    public boolean putBarProgressIndicatorLabelOnRight() {
        float test = (float)this.progress / (float)this.maxProgress * this.getBarWidth();
        return test < 50.0f;
    }

    public float getBarProgressIndicatorHeight() {
        return 20.0f;
    }

    public float getBarProgressIndicatorWidth() {
        return 20.0f;
    }

    public Color getBarProgressIndicatorLabelColor() {
        return Misc.getHighlightColor();
    }

    public Color getBarProgressIndicatorColor() {
        return this.getBarColor();
    }

    public Color getBarBracketColor() {
        return Misc.getBasePlayerColor();
    }

    public Color getBarColor() {
        Color color = Misc.getBasePlayerColor();
        color = Misc.interpolateColor(color, Color.black, 0.25f);
        return color;
    }

    protected Color getBaseStageColor(Object stageId) {
        return this.getBarColor();
    }

    protected Color getDarkStageColor(Object stageId) {
        Color color = this.getBarColor();
        color = Misc.interpolateColor(color, Color.black, 0.5f);
        return color;
    }

    protected Color getStageColor(Object stageId) {
        int req = this.getRequiredProgress(stageId);
        EventStageData last = this.getLastActiveStage(false);
        EventStageData esd = this.getDataFor(stageId);
        boolean grayItOut = false;
        if (last != null && esd != null && last != esd && !esd.isOneOffEvent && !esd.keepIconBrightWhenLaterStageReached && esd.progress < last.progress) {
            grayItOut = true;
        }
        if (esd != null && esd.randomized && esd.rollData != null) {
            return this.getBaseStageColor(stageId);
        }
        if (req > this.progress || grayItOut) {
            return this.getDarkStageColor(stageId);
        }
        return this.getBaseStageColor(stageId);
    }

    protected Color getStageIconColor(Object stageId) {
        int req = this.getRequiredProgress(stageId);
        EventStageData last = this.getLastActiveStage(false);
        EventStageData esd = this.getDataFor(stageId);
        boolean grayItOut = false;
        if (last != null && esd != null && last != esd && !esd.isOneOffEvent && !esd.keepIconBrightWhenLaterStageReached && esd.progress < last.progress) {
            grayItOut = true;
        }
        if (esd != null && esd.randomized && esd.rollData != null) {
            return Color.white;
        }
        if (req > this.progress || grayItOut) {
            return new Color(255, 255, 255, 155);
        }
        return Color.white;
    }

    protected int getStageImportance(Object stageId) {
        return 0;
    }

    protected String getStageLabel(Object stageId) {
        Object least = null;
        int min = Integer.MAX_VALUE;
        for (EventStageData curr : this.stages) {
            int req = curr.progress;
            if (req <= this.progress || req >= min) continue;
            min = req;
            least = curr.id;
        }
        if (stageId.equals(least)) {
            return "" + this.getRequiredProgress(least);
        }
        return null;
    }

    protected Color getStageLabelColor(Object stageId) {
        return Misc.getHighlightColor();
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Major events");
        return tags;
    }

    @Override
    public boolean hasSmallDescription() {
        return false;
    }

    @Override
    public boolean hasLargeDescription() {
        return true;
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }

    public void setMaxProgress(int maxProgress) {
        this.maxProgress = maxProgress;
    }

    public List<EventStageData> getStages() {
        return this.stages;
    }

    public boolean isStageOrOneOffEventReached(Object stageId) {
        return this.progress >= this.getRequiredProgress(stageId);
    }

    public boolean isStageActiveAndLast(Object stageId) {
        return this.isStageActiveAndLast(stageId, false);
    }

    public boolean isStageActiveAndLast(Object stageId, boolean includeOneOffEvents) {
        EventStageData data = this.getLastActiveStage(includeOneOffEvents);
        if (data == null) {
            return false;
        }
        return data.id == stageId;
    }

    public void addStage(Object id, int progress) {
        this.addStage(id, progress, StageIconSize.MEDIUM);
    }

    public void addStage(Object id, int progress, StageIconSize iconSize) {
        this.addStage(id, progress, false, iconSize);
    }

    public void addStage(Object id, int progress, boolean isOneOffEvent) {
        this.addStage(id, progress, isOneOffEvent, StageIconSize.MEDIUM);
    }

    public void addStage(Object id, int progress, boolean isOneOffEvent, StageIconSize iconSize) {
        this.stages.add(new EventStageData(id, progress, isOneOffEvent, iconSize));
    }

    public boolean isStageActive(Object stageId) {
        EventStageData data = this.getDataFor(stageId);
        if (data == null) {
            return false;
        }
        return data.progress <= this.getProgress();
    }

    public EventStageData getLastActiveStage(boolean includeOneOffEvents) {
        EventStageData last = null;
        int max = Integer.MIN_VALUE;
        for (EventStageData curr : this.stages) {
            int req;
            if (!includeOneOffEvents && curr.isOneOffEvent || this.progress < (req = curr.progress) || req <= max) continue;
            max = req;
            last = curr;
        }
        return last;
    }

    public EventStageData getDataFor(Object stageId) {
        for (EventStageData curr : this.stages) {
            if (!stageId.equals(curr.id)) continue;
            return curr;
        }
        return null;
    }

    public int getRequiredProgress(Object stageId) {
        EventStageData data = this.getDataFor(stageId);
        return data == null ? 0 : data.progress;
    }

    public void setSortTier(IntelInfoPlugin.IntelSortTier sortTier) {
        this.sortTier = sortTier;
    }

    @Override
    public IntelInfoPlugin.IntelSortTier getSortTier() {
        if (this.sortTier == null || this.isEnding() || this.isEnded()) {
            return super.getSortTier();
        }
        return this.sortTier;
    }

    @Override
    protected void notifyEnded() {
        super.notifyEnded();
        Global.getSector().removeScript(this);
        for (EventFactor factor : this.factors) {
            factor.notifyEventEnded();
        }
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
        Global.getSector().getListenerManager().removeListener(this);
        for (EventFactor factor : this.factors) {
            factor.notifyEventEnding();
        }
    }

    public void addFactor(EventFactor factor) {
        this.addFactor(factor, null);
    }

    public void addFactor(EventFactor factor, InteractionDialogAPI dialog) {
        this.addingFactorDialog = dialog;
        this.factors.add(factor);
        if (factor.isOneTime()) {
            if (factor.getProgress(this) != 0) {
                TextPanelAPI textPanel = dialog == null ? null : dialog.getTextPanel();
                this.sendUpdateIfPlayerHasIntel((Object)factor, textPanel);
            }
            this.setProgress(this.getProgress() + factor.getProgress(this));
        }
        this.addingFactorDialog = null;
    }

    public TextPanelAPI getTextPanelForStageChange() {
        if (this.addingFactorDialog == null) {
            return null;
        }
        return this.addingFactorDialog.getTextPanel();
    }

    public List<EventFactor> getFactors() {
        return this.factors;
    }

    public EventFactor getFactorOfClass(Class c) {
        for (EventFactor f : this.getFactors()) {
            if (f.getClass() != c) continue;
            return f;
        }
        return null;
    }

    public void removeFactor(EventFactor factor) {
        this.factors.remove(factor);
        factor.notifyFactorRemoved();
    }

    public void removeFactorOfClass(Class<EventFactor> c) {
        ArrayList<EventFactor> remove = new ArrayList<EventFactor>();
        for (EventFactor curr : this.factors) {
            if (!c.isInstance(curr)) continue;
            remove.add(curr);
        }
        this.factors.removeAll(remove);
        for (EventFactor factor : remove) {
            factor.notifyFactorRemoved();
        }
    }

    public boolean isEventProgressANegativeThingForThePlayer() {
        return false;
    }

    public int getMaxMonthlyProgress() {
        return 1000000;
    }

    public int getMonthlyProgress() {
        float sign;
        int total = 0;
        float mult = 1.0f;
        for (EventFactor factor : this.factors) {
            if (factor.isOneTime()) continue;
            total += factor.getProgress(this);
            mult *= factor.getAllProgressMult(this);
        }
        if (total != 0 && (total = Math.round((sign = Math.signum(total)) * (float)Math.abs(total) * mult)) == 0) {
            total = Math.round(1.0f * sign);
        }
        total = Math.min(total, this.getMaxMonthlyProgress());
        return total;
    }

    @Override
    public void reportEconomyTick(int iterIndex) {
        float delta = this.getMonthlyProgress();
        if (delta <= 0.0f && this instanceof HostileActivityEventIntel) {
            this.setProgress(0);
            return;
        }
        float numIter = Global.getSettings().getFloat("economyIterPerMonth");
        float f = 1.0f / numIter;
        delta *= f;
        int apply = (int)(delta += this.progressDeltaRemainder);
        this.progressDeltaRemainder = delta - (float)apply;
        this.setProgress(this.progress + apply);
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        if (this.progress == progress) {
            return;
        }
        if (progress < 0) {
            progress = 0;
        }
        if (progress > this.maxProgress) {
            progress = this.maxProgress;
        }
        EventStageData prev = this.getLastActiveStage(true);
        this.prevProgressDeltaWasPositive = this.progress < progress;
        this.progress = progress;
        if (progress < 0) {
            progress = 0;
        }
        if (progress > this.getMaxProgress()) {
            progress = this.getMaxProgress();
        }
        for (EventStageData esd : this.getStages()) {
            if (esd.wasEverReached && esd.isOneOffEvent && !esd.isRepeatable || !esd.randomized) continue;
            if (esd.rollData != null && !esd.rollData.equals(RANDOM_EVENT_NONE) && progress <= esd.progressToResetAt) {
                this.resetRandomizedStage(esd);
            }
            if (esd.rollData != null && !esd.rollData.equals(RANDOM_EVENT_NONE) || progress < esd.progressToRollAt) continue;
            this.rollRandomizedStage(esd);
            if (esd.rollData != null) continue;
            esd.rollData = RANDOM_EVENT_NONE;
        }
        for (EventStageData curr : this.getStages()) {
            boolean laterThanPrev;
            if (curr.progress <= prev.progress && !prev.wasEverReached && (prev.rollData == null || prev.rollData.equals(RANDOM_EVENT_NONE)) || curr.progress > progress) continue;
            boolean bl = laterThanPrev = prev == null || ((Enum)prev.id).ordinal() < ((Enum)curr.id).ordinal();
            if (curr == null || !laterThanPrev && prev.wasEverReached) continue;
            if (curr.sendIntelUpdateOnReaching && curr.progress > 0 && (prev == null || prev.progress < curr.progress)) {
                this.sendUpdateIfPlayerHasIntel((Object)curr, this.getTextPanelForStageChange());
            }
            this.notifyStageReached(curr);
            curr.rollData = null;
            curr.wasEverReached = true;
            progress = this.getProgress();
        }
    }

    protected String getSoundForStageReachedUpdate(Object stageId) {
        return BaseEventIntel.getSoundMajorPosting();
    }

    protected String getSoundForOneTimeFactorUpdate(EventFactor factor) {
        return null;
    }

    protected String getSoundForOtherUpdate(Object param) {
        return null;
    }

    @Override
    public String getCommMessageSound() {
        if (this.isSendingUpdate()) {
            String sound;
            if (this.getListInfoParam() instanceof EventStageData) {
                EventStageData esd = (EventStageData)this.getListInfoParam();
                String sound2 = this.getSoundForStageReachedUpdate(esd.id);
                if (sound2 != null) {
                    return sound2;
                }
            } else if (this.getListInfoParam() instanceof EventFactor) {
                String sound3 = this.getSoundForOneTimeFactorUpdate((EventFactor)this.getListInfoParam());
                if (sound3 != null) {
                    return sound3;
                }
            } else if (this.getListInfoParam() != null && (sound = this.getSoundForOtherUpdate(this.getListInfoParam())) != null) {
                return sound;
            }
            return BaseEventIntel.getSoundStandardUpdate();
        }
        return BaseEventIntel.getSoundStandardPosting();
    }

    protected void notifyStageReached(EventStageData stage) {
    }

    @Override
    public void reportEconomyMonthEnd() {
    }

    public Color getProgressColor(int delta) {
        if (this.isEventProgressANegativeThingForThePlayer()) {
            if (delta < 0) {
                return Misc.getPositiveHighlightColor();
            }
        } else if (delta < 0) {
            return Misc.getNegativeHighlightColor();
        }
        return Misc.getHighlightColor();
    }

    public void setHideStageWhenPastIt(Object stageId) {
        EventStageData esd = this.getDataFor(stageId);
        if (esd == null) {
            return;
        }
        esd.hideIconWhenPastStageUnlessLastActive = true;
    }

    public void setRandomized(Object stageId, RandomizedStageType type, int resetAt, int rollAt, boolean sendUpdateWhenReached) {
        this.setRandomized(stageId, type, resetAt, rollAt, sendUpdateWhenReached, true);
    }

    public void setRandomized(Object stageId, RandomizedStageType type, int resetAt, int rollAt, boolean sendUpdateWhenReached, boolean repeatable) {
        EventStageData esd = this.getDataFor(stageId);
        if (esd == null) {
            return;
        }
        esd.sendIntelUpdateOnReaching = sendUpdateWhenReached;
        esd.isRepeatable = repeatable;
        esd.isOneOffEvent = true;
        esd.randomized = true;
        esd.rollData = null;
        esd.progressToResetAt = resetAt;
        esd.progressToRollAt = rollAt;
        esd.randomType = type;
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    public void resetRandomizedStage(EventStageData stage) {
        stage.rollData = null;
    }

    public void rollRandomizedStage(EventStageData stage) {
    }

    public float getProgressFraction() {
        float p = (float)this.progress / (float)this.maxProgress;
        if (p < 0.0f) {
            p = 0.0f;
        }
        if (p > 1.0f) {
            p = 1.0f;
        }
        return p;
    }

    public boolean withMonthlyFactors() {
        return true;
    }

    public boolean withOneTimeFactors() {
        return true;
    }

    public static class EventStageData {
        public Object id;
        public int progress;
        public boolean isOneOffEvent;
        public boolean wasEverReached = false;
        public boolean isRepeatable = true;
        public boolean sendIntelUpdateOnReaching = true;
        public boolean hideIconWhenPastStageUnlessLastActive = false;
        public boolean keepIconBrightWhenLaterStageReached = false;
        public StageIconSize iconSize = StageIconSize.MEDIUM;
        public boolean randomized = false;
        public RandomizedStageType randomType = RandomizedStageType.NEUTRAL;
        public int progressToResetAt;
        public int progressToRollAt;
        public Object rollData;

        public EventStageData(Object id, int progress, boolean isOneOffEvent) {
            this(id, progress, isOneOffEvent, StageIconSize.MEDIUM);
        }

        public EventStageData(Object id, int progress, boolean isOneOffEvent, StageIconSize iconSize) {
            this.id = id;
            this.progress = progress;
            this.isOneOffEvent = isOneOffEvent;
            this.iconSize = iconSize;
        }

        public void addProgressReq(TooltipMakerAPI tooltip, float pad) {
            tooltip.addPara("\u9700\u8981 %s \u8fdb\u5c55\u70b9\u6570\u3002", pad, Misc.getHighlightColor(), "" + this.progress);
        }

        public void addResetReq(TooltipMakerAPI tooltip, float pad) {
            this.addResetReq(tooltip, false, pad);
        }

        public void beginResetReqList(TooltipMakerAPI tooltip, boolean withAvertInfo, float initPad) {
            this.beginResetReqList(tooltip, withAvertInfo, "outcome", initPad);
        }

        public void beginResetReqList(TooltipMakerAPI tooltip, boolean withAvertInfo, String outcome, float initPad) {
            float opad = 10.0f;
            float pad = 3.0f;
            tooltip.addPara("\u8be5 " + outcome + " \u5c06\u5728\u8fbe\u6210\u4e0b\u5217\u6761\u4ef6\u540e\u88ab\u907f\u514d\uff1a", initPad);
            tooltip.setBulletedListMode("    - ");
            if (withAvertInfo) {
                tooltip.addPara("\u8fdb\u5c55\u70b9\u6570\u8dcc\u81f3 %s \u70b9\u6216\u66f4\u4f4e", pad, Misc.getHighlightColor(), "" + this.progressToResetAt);
            }
        }

        public void endResetReqList(TooltipMakerAPI tooltip, boolean withTriggeredResetInfo) {
            this.endResetReqList(tooltip, withTriggeredResetInfo, "outcome", -1, -1);
        }

        public void endResetReqList(TooltipMakerAPI tooltip, boolean withTriggeredResetInfo, String outcome, int min, int max) {
            tooltip.setBulletedListMode(null);
            if (withTriggeredResetInfo) {
                float opad = 10.0f;
                if (min < 0 || max < 0) {
                    tooltip.addPara("\u5982\u679c " + outcome + " \u53d1\u751f\uff0c\u8fdb\u5c55\u70b9\u6570\u4f1a\u5728\u6b64\u4e4b\u540e\u5927\u5e45\u964d\u4f4e\u5230\u66f4\u4f4e\u7684\u4f4d\u7f6e\u3002", opad);
                } else {
                    tooltip.addPara("\u5982\u679c " + outcome + " \u53d1\u751f\uff0c\u8fdb\u5c55\u70b9\u6570\u4f1a\u5728\u6b64\u4e4b\u540e\u964d\u4f4e %s \u81f3 %s \u4e4b\u95f4\u7684\u4f4d\u7f6e\u3002", opad, Misc.getHighlightColor(), "" + min, "" + max);
                }
            }
        }

        public void addResetReq(TooltipMakerAPI tooltip, boolean withResetIfTriggered, float pad) {
            this.addResetReq(tooltip, withResetIfTriggered, "outcome", -1, -1, pad);
        }

        public void addResetReq(TooltipMakerAPI tooltip, boolean withResetIfTriggered, String outcome, int min, int max, float pad) {
            if (withResetIfTriggered) {
                if (min < 0 || max < 0) {
                    tooltip.addPara("\u8be5 " + outcome + " \u5c06\u5728\u8fdb\u5c55\u70b9\u6570\u8dcc\u81f3 %s \u70b9\u6216\u66f4\u4f4e\u540e\u88ab\u907f\u514d\u3002" + "\u5982\u679c " + outcome + " \u53d1\u751f\uff0c\u4e8b\u4ef6\u8fdb\u5c55\u4f1a\u5728\u6b64\u4e4b\u540e\u88ab\u91cd\u7f6e\u5230\u4e00\u4e2a\u76f8\u5bf9\u8f83\u4f4e\u7684\u6570\u503c\u3002", pad, Misc.getHighlightColor(), "" + this.progressToResetAt);
                } else {
                    tooltip.addPara("\u8be5 " + outcome + " \u5c06\u5728\u8fdb\u5c55\u70b9\u6570\u8dcc\u81f3 %s \u70b9\u6216\u66f4\u4f4e\u540e\u88ab\u907f\u514d\u3002" + "\u5982\u679c " + outcome + " \u53d1\u751f\uff0c\u8fdb\u5c55\u70b9\u6570\u4f1a\u5728\u6b64\u4e4b\u540e\u964d\u4f4e %s \u81f3 %s \u4e4b\u95f4\u7684\u4f4d\u7f6e\u3002", pad, Misc.getHighlightColor(), "" + this.progressToResetAt, "" + min, "" + max);
                }
            } else {
                tooltip.addPara("\u8be5 " + outcome + " \u5c06\u5728\u8fdb\u5c55\u70b9\u6570\u964d\u4f4e\u5230 %s \u70b9\u4ee5\u4e0b\u540e\u88ab\u907f\u514d\u3002", pad, Misc.getHighlightColor(), "" + this.progressToResetAt);
            }
        }
    }

    public static class EventStageDisplayData {
        public float size;
        public float downLineLength;
        public String icon;
        public Color color;
        public Color iconColor = Color.white;
        public String label;
        public Color labelColor;
        public int importance = 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RandomizedStageType {
        GOOD,
        BAD,
        NEUTRAL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StageIconSize {
        SMALL,
        MEDIUM,
        LARGE;

    }
}

